var System = require("../../../system");
var settings = require("../../../../config/settings");
const querystring = require('querystring');
const ApiBase = require("../../api.base");

class ChinaPatentSearchApi extends ApiBase {
  constructor() {
    super();
    this.patentUrl = settings.reqEsAddrIc() + "bigdata_patent_op/_search";
  };
  buildDate(date) {
    var date = new Date(date);
    var time = Date.parse(date);
    time = time / 1000;
    return time;
  };
  async ObtainChinaPatentInfo(obj) {
    console.log("----------------api-ObtainChinaPatentInfo----------------");
    console.log(obj);

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
    };
    var applynum = obj.applynum == null ? "" : obj.applynum;//专利申请号
    if (applynum != null && applynum != "") {
      var param = {
        "term": {
          "filing_no": applynum
        }
      }
      params.query.bool.must.push(param)
    }
    var publishnum = obj.publishnum == null ? "" : obj.publishnum;//专利公开号
    if (publishnum != null && publishnum != "") {
      var arr = publishnum.split("");
      if (arr[arr.length - 1] == "A") {
        var param = {
          "term": {
            "pub_no": publishnum
          }
        };
      } else {
        var param = {
          "term": {
            "gr_no": publishnum
          }
        };
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits.hits
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null
      };
    }

  };

  async CommomSearchbyTitle(obj) {//根据标题查询聚合
    console.log("--------CommomSearchbyTitle----------");
    console.log(obj);
    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var title = obj.title == null ? "" : obj.title;
    if (title == "") {
      return { status: -1, msg: "传入标题信息为空", data: null, buckets: null };
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "match": {
        "filing_name": title
      }
    }
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CommomSearchbyFilingno(obj) {//根据申请号查询聚合

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var filingno = obj.filingno == null ? "" : obj.filingno;
    if (filingno == "") {
      return { status: -1, msg: "传入的申请号信息为空", data: null, buckets: null };
    }
    else {
      filingno = filingno.replace("CN", "").replace("cn", "").replace(".", "");
      if (filingno.length == 13) {
        filingno = filingno.substr(0, 12);
      }
      else if (filingno.length == 9) {
        filingno = filingno.substr(0, 8);
      }
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "wildcard": {
        "filing_no": "*" + filingno + "*"
      }
    }
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CommomSearchbyPubno(obj) {//根据公开号查询聚合

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var pubno = obj.pubno == null ? "" : obj.pubno;
    if (pubno == "") {
      return { status: -1, msg: "传入的公开号信息为空", data: null, buckets: null };
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "bool": {
        "should": [
        ]
      }
    }

    var parr = {
      "wildcard": {
        "pub_no": "*" + pubno + "*"
      }
    }
    param.bool.should.push(parr)

    parr = {
      "wildcard": {
        "gr_no": "*" + pubno + "*"
      }
    }
    param.bool.should.push(parr)
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CommomSearchbyApplicant(obj) {//根据申请人查询聚合

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var applicant = obj.applicant == null ? "" : obj.applicant;
    if (applicant == "") {
      return { status: -1, msg: "传入的申请人信息为空", data: null, buckets: null };
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "query_string": {
        "default_field": "applicant_name",
        "query": "\"" + applicant + "\""
      }
    }
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async CommomSearchbyInventor(obj) {//根据发明人查询聚合

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var inventor = obj.inventor == null ? "" : obj.inventor;
    if (inventor == "") {
      return { status: -1, msg: "传入的发明人信息为空", data: null, buckets: null };
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "query_string": {
        "default_field": "inventor_name",
        "query": "\"" + inventor + "\""
      }
    }
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async ChinaPatentSrearch(obj) {//根据条件查询
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      }
    };
    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null
      };
    }
  };

  async seniorSearch(obj) {//高级检索，根据用户输入的不同多条件进行检索
    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ]
    };

    var param = null;
    //对关键词
    var title = obj.title == null ? "" : obj.title;
    if (title != null && title != "") {
      param = {
        "match": {
          "filing_name": title
        }
      }
      params.query.bool.must.push(param)
    }

    var abstr = obj.abstr == null ? "" : obj.abstr;
    if (abstr != null && abstr != "") {
      param = {
        "match": {
          "abstr_text": abstr
        }
      }
      params.query.bool.must.push(param)
    }

    var filingno = obj.filingno == null ? "" : obj.filingno;
    if (filingno != null && filingno != "") {
      filingno = filingno.replace("CN", "").replace("cn", "").replace(".", "");
      if (filingno.length == 13) {
        filingno = filingno.substr(0, 12);
      }
      else if (filingno.length == 9) {
        filingno = filingno.substr(0, 8);
      }

      param = {
        "term": {
          "filing_no": filingno
        }
      }
      params.query.bool.must.push(param)
    }

    var pubno = obj.pubno == null ? "" : obj.pubno;
    if (pubno != null && pubno != "") {
      param = {
        "bool": {
          "should": [
          ]
        }
      }

      var parr = {
        "term": {
          "pub_no": pubno
        }
      }
      param.bool.should.push(parr)

      parr = {
        "term": {
          "gr_no": pubno
        }
      }
      param.bool.should.push(parr)
      params.query.bool.must.push(param);
    }

    var priorno = obj.priorno == null ? "" : obj.priorno;
    if (priorno != null && priorno != "") {
      param = {
        "nested": {
          "path": "prior_info",
          "query": {
            "bool": {
              "must": [
                { "term": { "prior_info.pri_no": priorno } }
              ]
            }
          }
        }
      };
      params.query.bool.must.push(param)
    }

    var appl = obj.applname == null ? "" : obj.applname;
    if (appl != null && appl != "") {
      param = {
        "term": {
          "applicant_name.raw": appl
        }
      }
      params.query.bool.must.push(param)
    }
    var inv = obj.invname == null ? "" : obj.invname;
    if (inv != null && inv != "") {
      param = {
        "term": {
          "inventor_name.raw": inv
        }
      }
      params.query.bool.must.push(param)
    }
    var ipc = obj.ipcno == null ? "" : obj.ipcno;
    if (ipc != null && ipc != "") {
      var param = {
        "term": {
          "other_ipc": ipc
        }
      }
      params.query.bool.must.push(param)
    }

    if (obj.filingdate1 != null && obj.filingdate1 != "") {
      var filingdate1 = obj.filingdate1;
    }
    else {
      var filingdate1 = "";
    }
    if (obj.filingdate2 != null && obj.filingdate2 != "") {
      var filingdate2 = obj.filingdate2;
    }
    else {
      var filingdate2 = "";
    }
    if (filingdate1 != "" || filingdate2 != "") {
      param = {
        "range": {
          "filing_time": {
          }
        }
      };
      if (filingdate1 != "") {
        param.range.filing_time["gte"] = filingdate1;
      }
      if (filingdate2 != "") {
        param.range.filing_time["lte"] = filingdate2;
      }
      params.query.bool.must.push(param);
    }

    if (obj.pubdate1 != null && obj.pubdate1 != "") {
      var pubdate1 = obj.pubdate1;
    }
    else {
      var pubdate1 = "";
    }
    if (obj.pubdate2 != null && obj.pubdate2 != "") {
      var pubdate2 = obj.pubdate2;
    }
    else {
      var pubdate2 = "";
    }
    if (pubdate1 != "" || pubdate2 != "") {
      param = {
        "range": {
          "pub_time": {

          }
        }
      };
      if (pubdate1 != "") {
        param.range.pub_time["gte"] = pubdate1;
      }
      if (pubdate2 != "") {
        param.range.pub_time["lte"] = pubdate2;
      }
      params.query.bool.must.push(param);
    }

    if (obj.grdate1 != null && obj.grdate1 != "") {
      var grdate1 = obj.grdate1;
    }
    else {
      var grdate1 = "";
    }
    if (obj.grdate2 != null && obj.grdate2 != "") {
      var grdate2 = obj.grdate2;
    }
    else {
      var grdate2 = "";
    }
    if (grdate1 != "" || grdate2 != "") {
      param = {
        "range": {
          "gr_time": {

          }
        }
      };
      if (grdate1 != "") {
        param.range.gr_time["gte"] = grdate1;
      }
      if (grdate2 != "") {
        param.range.gr_time["lte"] = grdate2;
      }
      params.query.bool.must.push(param);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult2(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };

  /*查询某一个公司名下有多少条专利(applicant_name:公司-精确)
auther:sy
{
    "status": 0,
    "msg": "操作成功",
    "total": 54,
    "data": [
        {
            "fm_count": 1,
            "wg_count": 1,
            "syxx_count": 1
        }
    ],
    "bizmsg": "empty"
}

返回值说明:status为0则为成功，否则为查询有误
*/
  async paCountByApplicantName(obj) {
    var applicantName = obj.applicant_name == null || obj.applicant_name == "" || obj.applicant_name == "undefined" ? "" : obj.applicant_name;
    if (applicantName == "") {
      return System.getResult2(null, "申请人不能为空");
    }
    applicantName = await this.getConvertSemiangleStr(applicantName);
    var params = {
      "size": 0,
      "query": {
        "bool": {
          "must": [
            {
              "term": {
                "applicant_name.raw": applicantName
              }
            }
          ]
        }
      }
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult2(j.hits.total, null);
    } catch (e) {
      return System.getResult2(null, "获取数据出错");
    }
  };

  /*查询某一个公司名下有专利列表(applicant_name:公司-精确)
  auther:sy
  返回值：
    {
      "status": 0,
      "msg": "操作成功",
      "total": 2,
      "data": [
          {
             "filing_name":"",
             "pub_status_now":"",
         "filing_no":"",
             "filing_date":"",
             "gr_date":"",
             "gr_no":"",
             "pub_date":"",
             "pub_no":"",
         "pa_type":""
          }
      ],
      "bizmsg": "empty"
  }
  返回值说明:status为0则为成功，否则为查询有误
     "filing_name",发明名称
     "pub_status_now",法律状态
     "filing_no",申请号
     "filing_date",申请日期
     "gr_date",授权日期
     "gr_no",授权公布号
     "pub_date",公开（公告）日期
     "pub_no",公开（公告）号
     "pa_type"专利类型
       "total"						  总条数
  */
  async paShortListByApplicantName(obj) {
    var applicantName = obj.applicant_name == null || obj.applicant_name == "" || obj.applicant_name == "undefined" ? "" : obj.applicant_name;
    //var paType = obj.pa_type == null || obj.pa_type == "" || obj.pa_type == "undefined" ? "" : obj.pa_type;
    if (applicantName == "") {
      return System.getResult2(null, "申请人不能为空");
    }
    var pagesize = obj.page_size == null || obj.page_size == "" || obj.page_size == "undefined" ? 20 : obj.page_size;
    var from = obj.current_page == null || obj.current_page == "" || obj.current_page == "undefined" ? 0 : Number((obj.current_page - 1) * pagesize);
    applicantName = await this.getConvertSemiangleStr(applicantName);
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "term": {
                "applicant_name.raw": applicantName
              }
            }
          ]
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_name",
        "pub_status_now",
        "filing_no",
        "filing_time",
        "gr_time",
        "gr_no",
        "pub_time",
        "pub_no",
        "agency_name",
        "applicant_name",
        "inventor_name",
        "main_ipc",
        "abstr_text",
        "pub_type"
      ],
      "sort": [
        {
          "filing_date": "desc"
        }
      ]
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      // console.log(rtn.stdout, "rtn.stdout........................############################");
      var res = {};
      res.total = 0;
      res.data = [];
      if (j.hits.total > 0) {
        res.total = j.hits.total;
        for (let index = 0; index < j.hits.hits.length; index++) {
          const element = j.hits.hits[index];
          if (element) {
            res.data.push(element["_source"]);
          }
        }
      }
      return System.getResult2(res, null);
    } catch (e) {
      return System.getResult2(null, "获取数据出错");
    }
  };


  /*查询某一个公司名下有多少条专利(pub_no:公开（公告）号-精确、gr_no:授权公布号-精确)
    auther:sy
    返回值：
      {
        "status": 0,
        "msg": "操作成功",
        "total": 2,
        "data": [
            {
               "filing_name":"",
               "pub_status_now":"",
           "filing_no":"",
               "filing_date":"",
               "gr_date":"",
               "gr_no":"",
               "pub_date":"",
               "pub_no":""
           "agency_name",
           "inventor_name",
           "main_ipc",
           "abstr_text",
           "pa_type":""
            }
        ],
        "bizmsg": "empty"
    }
    返回值说明:status为0则为成功，否则为查询有误
       "filing_name",发明名称
       "pub_status_now",法律状态
       "filing_no",申请号
       "filing_date",申请日期
       "gr_date",授权日期
       "gr_no",授权公布号
       "pub_date",公开（公告）日期
       "pub_no",公开（公告）号
       "agency_name",代理机构
       "inventor_name",发明人
       "main_ipc",主分类号
       "abstr_text",详情信息
       "pa_type",专利类型
         "total"						  总条数
    */
  async paDetailsBypubNo(obj) {
    var pubNo = obj.pub_no == null || obj.pub_no == "" || obj.pub_no == "undefined" || obj.pub_no == "null" ? "" : obj.pub_no;
    var grNo = obj.gr_no == null || obj.gr_no == "" || obj.gr_no == "undefined" || obj.gr_no == "null" ? "" : obj.gr_no;
    if (pubNo == "" && grNo == "") {
      return System.getResult2(null, "参数不能为空");
    }
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "_source": [
        "filing_name",
        "pub_status_now",
        "filing_no",
        "filing_time",
        "gr_time",
        "gr_no",
        "pub_time",
        "pub_no",
        "agency_name",
        "applicant_name",
        "inventor_name",
        "main_ipc",
        "abstr_text",
        "pub_type"
      ],
      "sort": [
        {
          "filing_date": "desc"
        }
      ]
    };
    if (pubNo != "") {
      var param = {
        "term": {
          "pub_no": pubNo
        }
      }
      params.query.bool.must.push(param)
    }
    if (grNo != "") {
      var param = {
        "term": {
          "gr_no": grNo
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      var res = {};
      res.total = 0;
      res.data = [];
      if (j.hits.total > 0) {
        res.total = j.hits.total;
        for (let index = 0; index < j.hits.hits.length; index++) {
          const element = j.hits.hits[index];
          if (element) {
            res.data.push(element["_source"]);
          }
        }
      }
      return System.getResult2(res, null);
    } catch (e) {
      return System.getResult2(null, "获取数据出错");
    }
  };

  async paDetailsByfilingNo(obj) {
    var filingNo = obj.filingNo == null || obj.filingNo == "" || obj.filingNo == "undefined" || obj.filingNo == "null" ? "" : obj.filingNo;
    if (filingNo == "") {
      return System.getResult2(null, "参数不能为空");
    }
    else {
      filingNo = filingNo.replace("CN", "").replace("cn", "").replace(".", "");
      if (filingNo.length == 13) {
        filingNo = filingNo.substr(0, 12);
      }
      else if (filingNo.length == 9) {
        filingNo = filingNo.substr(0, 8);
      }
    }
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "term": {
                "filing_no": filingNo
              }
            }
          ]
        }
      },
      "_source": [
        "filing_no",
        "pub_type",
        "filing_time",
        "pub_no",
        "gr_time",
        "gr_no",
        "pub_time",
        "agency_code",
        "agency_name",
        "agent_name1",
        "agent_name2",
        "applicant_name",
        "inventor_name",
        "country_code",
        "appl_zip",
        "appl_address",
        "main_ipc",
        "abstr_text",
        "filing_name",
        "pub_status",
        "pub_status_now",
        "ipc_version",
        "other_ipc",
        "prior_info",
        "pct_info",
        "img_path",
        "claim_text"
      ],
      "sort": [
        {
          "filing_time": "desc"
        }
      ]
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      var res = {};
      res.total = 0;
      res.data = [];
      if (j.hits.total > 0) {
        res.total = j.hits.total;
        for (let index = 0; index < j.hits.hits.length; index++) {
          const element = j.hits.hits[index];
          if (element) {
            res.data.push(element["_source"]);
          }
        }
      }
      return System.getResult2(res, null);
    } catch (e) {
      return System.getResult2(null, "获取数据出错");
    }
  };


  async getConvertSemiangleStr(str) {//半角转全角
    var result = "";
    var len = str.length;
    for (var i = 0; i < len; i++) {
      var cCode = str.charCodeAt(i);
      //全角与半角相差（除空格外）：65248（十进制）
      cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
      //处理空格
      cCode = (cCode == 0x03000) ? 0x0020 : cCode;
      result += String.fromCharCode(cCode);
    }
    return result;
  };

}
module.exports = ChinaPatentSearchApi;
