var System = require("../../../system");
var settings = require("../../../../config/settings");
const querystring = require('querystring');
const ApiBase = require("../../api.base");

class CopyRightSearchApi extends ApiBase {
    constructor() {
        super();
        this.softcopyrightUrl = settings.reqEsAddrIc() + "bigdata_software_copyright_op/_search";
        this.workcopyrightUrl = settings.reqEsAddrIc() + "bigdata_works_copyright_op/_search";

    };

    async getConvertSemiangleStr(str) {//半角转全角
        var result = "";
        var len = str.length;
        for (var i = 0; i < len; i++) {
            var cCode = str.charCodeAt(i);
            //全角与半角相差（除空格外）：65248（十进制）
            cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
            //处理空格
            cCode = (cCode == 0x03000) ? 0x0020 : cCode;
            result += String.fromCharCode(cCode);
        }
        return result;
    };

    /*查询某一个软件著作权人名下有多少条软件著作权(author:软件著作权人-精确)
    auther:sy
    返回值：
    {
        "status": 0,
        "msg": "操作成功",
        "total": 2,----总条数
        "data": [],
        "bizmsg": "empty"
    }
    */
    async softwareCountByAuthor(obj) {
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        if (author == "") {
            return System.getResult2(null, "软件著作权人不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var params = {
            "query": {
                "nested": {
                    "path": "author_nationality",
                    "query": {
                        "bool": {
                            "must": [
                                { "match": { "author_nationality.author_name.raw": author } }
                            ]
                        }
                    }
                }
            },
            "size": 0
        };

        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.softcopyrightUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            return System.getResult2(j.hits.total, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };

    };

    /*查询某一个软件著作权人名下软件著作权列表(author:软件著作权人-精确、page_size:每页大小、current_page:当前第几页，从1开始)
        auther:sy
  返回值：
  {
    "status": 0,
    "msg": "操作成功",
    "total": 2,
    "data": [
        {
            "full_name": "触宝软件",
            "simple_name": "图形",
            "reg_num": "T",
            "reg_time": 1387170000
        }
    ],
    "bizmsg": "empty"
}
返回值说明:status为0则为成功，否则为查询有误
        "ncl_one_codes"               名称
        "status"                      软件简介
    	"tm_regist_num"	              登记号
        "apply_day"                   登记批准日期----格式为时间戳，转换后的格式为2018-08-21
		"total"						  总条数
  */
    async softwareListByAuthor(obj) {
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        var pagesize = obj.page_size == null || obj.page_size == "" || obj.page_size == "undefined" ? 10 : obj.page_size;
        var from = obj.current_page == null || obj.current_page == "" || obj.current_page == "undefined" ? 0 : Number((obj.current_page - 1) * pagesize);

        if (author == "") {
            return System.getResult2(null, "软件著作权人不能为空");
        }
        var params = {
            "query": {
                "nested": {
                    "path": "author_nationality",
                    "query": {
                        "bool": {
                            "must": [
                                { "match": { "author_nationality.author_name.raw": author } }
                            ]
                        }
                    }
                }
            },
            "from": from,
            "size": pagesize,
            "_source": [
                "full_name",
                "simple_name",
                "reg_num",
                "cat_num",
                "reg_time",
                "reg_date",
                "publish_time",
                "publish_date",
                "software_version"
            ],
            "sort": [
                {
                    "reg_time": "desc"
                }
            ]
        };

        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.softcopyrightUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            var res = {};
            res.total =0;
            res.data = [];
            if (j.hits.total >0){
                res.total = j.hits.total;
                for (let index = 0; index < j.hits.hits.length; index++) {
                  const element = j.hits.hits[index];
                  if (element) {
                    res.data.push(element["_source"]);
                  }
                }
            }
            return System.getResult2(res, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };

    };

    /*查询某一个软件著作权人名下软件著作权列表(reg_num:登记号-精确)
  auther:sy
  返回值：
  {
    "status": 0,
    "msg": "操作成功",
    "total": 2,
    "data":{
		"reg_num": "2013SR027478",
		"cat_num": "30200-0000",
		"full_name": "触宝拨号软件",
		"simple_name": "TouchPal Dialer",
		"software_version": "V3.3",
		"author_nationality": [
		{
		"author_name": "上海触乐信息科技有限公司",
		"author_country": "中国"
		}
		],
		"publish_time": 1300593600,
		"reg_time": 1364184000
        },
    "bizmsg": "empty"
}
返回值说明:status为0则为成功，否则为查询有误
		"reg_num": "登记号",
		"cat_num": "30200-0000??",
		"full_name": "名称",
		"simple_name": "软件简介",
		"software_version": "版本号",
		"author_nationality": [
		{
		"author_name": "软件著作权人",
		"author_country": "软件著作权人国籍"
		}
		],
		"publish_time": 首次发布日期,
		"reg_time": 登记批准日期
  */
    async softwareDetailsByregNum(obj) {
        var regNum = obj.reg_num == null || obj.reg_num == "" || obj.reg_num == "undefined" ? "" : obj.reg_num;
        if (regNum == "") {
            return System.getResult2(null,"软件著作权号不能为空");
        }
        var params = {
            "query": {
                "term": {
                    "reg_num": regNum
                }
            },
            "from": 0,
            "size": 1
        };
        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.softcopyrightUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            var res = {};
            res.total =0;
            res.data = [];
            if (j.hits.total >0){
                res.total = j.hits.total;
                for (let index = 0; index < j.hits.hits.length; index++) {
                  const element = j.hits.hits[index];
                  if (element) {
                    res.data.push(element["_source"]);
                  }
                }
            }
            return System.getResult2(res, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };
    };

    //--------------------------------------------以下为作品著作权---------------------------------------------------------------

    /*查询某一个作品著作权人下有多少条作品著作权(author:作品著作权人-精确)
    auther:sy
  返回值：
  {
      "status": 0,
      "msg": "操作成功",
      "total": 2,----总条数
      "data": [],
      "bizmsg": "empty"
  }
    */
    async worksCountByAuthor(obj) {
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        if (author == "") {
            return System.getResult2(null, "作品著作权人不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var params = {
            "query": {
                "term": {
                    "works_author.raw": author
                }
            },
            "size": 0
        };

        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.workcopyrightUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            return System.getResult2(j.hits.total, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };

    };

    /*查询某一个作品著作权人名下作品著作权列表(author:作品著作权人-精确、page_size:每页大小、current_page:当前第几页，从1开始)
auther:sy
返回值：
{
  "status": 0,
  "msg": "操作成功",
  "total": 2,
  "data": [
      {
          "works_name": "触宝LoGO",
          "works_type": "图形",
          "reg_num": "T",
          "publish_time": 1387170000,
          "finish_time": 1387170000,
          "first_publish_time": 1387170000
      }
  ],
  "bizmsg": "empty"
}
返回值说明:status为0则为成功，否则为查询有误
      "works_name"                  名称
      "works_type"                  类型
      "reg_num"	                  登记号
      "publish_time"                登记日期----格式为时间戳，转换后的格式为2018-08-21
      "finish_time"                 完成日期----格式为时间戳，转换后的格式为2018-08-21
      "first_publish_time"          首次发表日期----格式为时间戳，转换后的格式为2018-08-21
      "total"						  总条数
*/
    async worksListByAuthor(obj) {
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        var pagesize = obj.page_size == null || obj.page_size == "" || obj.page_size == "undefined" ? 10 : obj.page_size;
        var from = obj.current_page == null || obj.current_page == "" || obj.current_page == "undefined" ? 0 : Number((obj.current_page - 1) * pagesize);

        if (author == "") {
            return System.getResult2(null, "作品著作权人不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var params = {
            "query": {
                "term": {
                    "works_author.raw": author
                }
            },
            "from": from,
            "size": pagesize,
            "_source": [
                "works_name",
                "works_type",
                "reg_num",
                "publish_time",
                "finish_time",
                "first_publish_time"
            ],
            "sort": [
                {
                    "first_publish_time": "desc"
                }
            ]
        };
        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.workcopyrightUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            var res = {};
            res.total =0;
            res.data = [];
            if (j.hits.total >0){
                res.total = j.hits.total;
                for (let index = 0; index < j.hits.hits.length; index++) {
                  const element = j.hits.hits[index];
                  if (element) {
                    res.data.push(element["_source"]);
                  }
                }
            }
            return System.getResult2(res, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };
    };

    /*查询某一个软件著作权人名下软件著作权列表(reg_num:登记号-精确)
auther:sy
返回值：
{
  "status": 0,
  "msg": "操作成功",
  "total": 2,
  "data":{
      "reg_num": "2013SR027478",
      "cat_num": "30200-0000",
      "full_name": "触宝拨号软件",
      "simple_name": "TouchPal Dialer",
      "software_version": "V3.3",
      "author_nationality": [
      {
      "author_name": "上海触乐信息科技有限公司",
      "author_country": "中国"
      }
      ],
      "publish_time": 1300593600,
      "reg_time": 1364184000
      },
  "bizmsg": "empty"
}
返回值说明:status为0则为成功，否则为查询有误
      "reg_num": "登记号",
      "cat_num": "30200-0000??",
      "full_name": "名称",
      "simple_name": "软件简介",
      "software_version": "版本号",
      "author_nationality": [
      {
      "author_name": "软件著作权人",
      "author_country": "软件著作权人国籍"
      }
      ],
      "publish_time": 首次发布日期,
      "reg_time": 登记批准日期
*/
    async worksDetailsByregNum(obj) {
        var regNum = obj.reg_num == null || obj.reg_num == "" || obj.reg_num == "undefined" ? "" : obj.reg_num;
        if (regNum == "") {
            return System.getResult2(null,"作品著作权登记号不能为空");
        }
        var params = {
            "query": {
                "term": {
                    "reg_num": regNum
                }
            },
            "from": 0,
            "size": 1
        };
        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.workcopyrightUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            var res = {};
            res.total =0;
            res.data = [];
            if (j.hits.total >0){
                res.total = j.hits.total;
                for (let index = 0; index < j.hits.hits.length; index++) {
                  const element = j.hits.hits[index];
                  if (element) {
                    res.data.push(element["_source"]);
                  }
                }
            }
            return System.getResult2(res, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };
    };
}
module.exports = CopyRightSearchApi;