var System = require("../../../system");
var settings = require("../../../../config/settings");
const ApiBase = require("../../api.base");
class ByTmSearchApi extends ApiBase {
  constructor() {
    super();
    this.cacheManager = System.getObject("db.common.cacheManager");
    this.tmncloneQueryUrl = settings.apiconfig.tmncloneQueryUrl();
    this.byslTmUrl = settings.apiconfig.byslTmUrl();
    this.tmSearchUrl = settings.apiconfig.tmSearchUrl();
    this.tmFlowUrl = settings.apiconfig.tmFlowUrl();
    this.tmNclUrl = settings.apiconfig.tmNclUrl();
    this.nclUrl = settings.apiconfig.nclUrl();
    this.utilstmSve = System.getObject("service.trademark.utilstmSve");
  };
  async getConvertSemiangleStr(str) {
    var result = "";
    var len = str.length;
    for (var i = 0; i < len; i++) {
      var cCode = str.charCodeAt(i);
      //全角与半角相差（除空格外）：65248（十进制）
      cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
      //处理空格
      cCode = (cCode == 0x03000) ? 0x0020 : cCode;
      result += String.fromCharCode(cCode);
    }
    return result;
  }
  async tmAccurateSearch(obj) {//根据商标名称进行精准查询
    var tmName = obj.tmName == null ? "" : obj.tmName;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var nclcode = obj.nclcode;
    var ncltwo = obj.ncltwo;
    var nclNumcode = obj.nclNumcode;
    var pagesize = obj.pagesize == null ? 15 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "tm_agency",
        "pic_url",
        "ncl_two_codes"
      ],
      "sort": {
        "apply_day_format": "desc"
      }
    };

    if (tmName != null && tmName != "") {
      var lowername = tmName.toLowerCase();
      var upname = tmName.toUpperCase();
      var param = {
        "terms": {
          "tm_name.raw": [lowername, upname, tmName]
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != "" && sqlbtabkey != null) {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param)
    }
    if (flzttabkey != "" && flzttabkey != null) {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param)
    }
    if (ncltwo.length > 0) {
      var param = {
        "terms": {
          "ncl_two_codes": ncltwo
        }
      }
      params.query.bool.must.push(param)
    }
    if (nclNumcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclNumcode
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmAccuratejuheSearch(obj) {//根据商标名称精准查询，对查询结果进行类别聚合
    var tmName = obj.tmName == null ? "" : obj.tmName;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var nclcode = obj.nclcode;
    var nclNumcode = obj.nclNumcode;
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "ncl_one_codes",
            "size": 45,
          }
        }
      }
    };
    if (tmName != null && tmName != "") {
      var lowername = tmName.toLowerCase();
      var upname = tmName.toUpperCase();
      var param = {
        "terms": {
          "tm_name.raw": [lowername, upname, tmName]
        }
      }
      params.query.bool.must.push(param)
    }
    // if(sqlbtabkey!=null&&sqlbtabkey!=""){
    //   var param={
    //     "term":{
    //       "ncl_one_codes":sqlbtabkey
    //     }
    //   }
    //   params.query.bool.must.push(param);
    // }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param)
    }
    if (nclNumcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclNumcode
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmAccuratejuheFlztSearch(obj) {//根据商标状态进行聚合
    var tmName = obj.tmName == null ? "" : obj.tmName;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var nclcode = obj.nclcode;
    var nclNumcode = obj.nclNumcode;
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "status",
            "size": 5,
          }
        }
      }
    };
    // if(tmName!=null && tmName!=""){
    //   var param=  {
    //     "term": {
    //       "tm_name.raw": tmName
    //     }
    //   }
    //   params.query.bool.must.push(param)
    // }
    if (tmName != null && tmName != "") {
      var lowername = tmName.toLowerCase();
      var upname = tmName.toUpperCase();
      var param = {
        "terms": {
          "tm_name.raw": [lowername, upname, tmName]
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != null && sqlbtabkey != "") {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param)
    }
    if (nclNumcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclNumcode
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tmAccuratejuheYearSearch(obj) {//根据商标year进行聚合
    var tmName = obj.tmName == null ? "" : obj.tmName;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var nclcode = obj.nclcode;
    var nclNumcode = obj.nclNumcode;
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [],
          "must_not": {
            "term": {
              "apply_year": 0
            }
          }
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "apply_year",
            "size": 52
          }
        }
      }
    };
    if (tmName != null && tmName != "") {
      var lowername = tmName.toLowerCase();
      var upname = tmName.toUpperCase();
      var param = {
        "terms": {
          "tm_name.raw": [lowername, upname, tmName]
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != null && sqlbtabkey != "") {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param)
    }
    if (nclNumcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclNumcode
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tmNameSearch(obj) {//根据商标名称模糊查询
    var tmName = obj.tmName == null ? "" : obj.tmName;
    tmName = tmName.toString();
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var pagesize = obj.pagesize == null ? 15 : obj.pagesize;
    var nclcode = obj.nclcode;
    var nclNumcode = obj.nclNumcode;
    var ncltwo = obj.ncltwo;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "tm_agency",
        "pic_url",
        "ncl_two_codes"
      ],
    };
    if (tmName != null && tmName != "") {
      if (obj.tyc == "" && obj.py == "" && obj.xjz == "" && obj.dx == "" && obj.js == "" && obj.contain == "" && obj.bz == "") {
        var param = {
          "term": {
            "tm_name.raw": tmName
          }
        }
        params.query.bool.must.push(param);
      }
    }
    if (sqlbtabkey != "" && sqlbtabkey != null) {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != "" && flzttabkey != null) {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclNumcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclNumcode
        }
      }
      params.query.bool.must.push(param)
    }
    if (ncltwo.length > 0) {
      var param = {
        "terms": {
          "ncl_two_codes": ncltwo
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }

    var tiiaojianparams = {
      "bool": {
        "should": []
      }
    };
    if (obj.js != "" && obj.js == "js" && tmName != null && tmName != "") {

      var len = 0;
      var en = "";
      var cn = "";
      for (var i = 0; i < tmName.length; i++) {
        var a = tmName.charAt(i);
        if (a.match(/[^\x00-\xff]/ig) != null) {
          len += 1;
          cn += a;
        } else {
          en += a;
        }
      }
      console.log("--------------------hanzi---------------------------");
      console.log(len);
      console.log(cn);
      console.log(en);
      if (len <= 2) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "100%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 2
                  }
                }
              }
            ]
          }
        });
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "query_string": {
                  "default_field": "tm_name",
                  "query": "\"" + tmName.split('').reverse().join('') + "\""
                }
              }, {
                "range": {
                  "cn_count": {
                    "lte": len + 2
                  }
                }
              }
            ]
          }
        });
      } else if (len == 3) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "75%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      } else if (len == 4) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "70%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      } else {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "50%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      }
    }

    if (obj.bz != "" && obj.bz == "bz") {
      tiiaojianparams.bool.should.push({
        "fuzzy": {
          "tm_name.raw": {
            "value": tmName,
            "fuzziness": "AUTO"
          }
        }
      });
    }
    // if(obj.js.length==1&&obj.js=="js"){
    //   tiiaojianparams.bool.should.push({
    //       "term": {
    //           "tm_name.raw":tmName
    //       }
    //    });
    // }
    if (obj.tyc != "" && obj.tyc == "tyc") {
      tiiaojianparams.bool.should.push({
        "terms": {
          "tm_name.raw": obj.tycdata
        }
      });
    }
    if (obj.py != "" && obj.py == "py") {
      tiiaojianparams.bool.should.push({
        "term": {
          "tm_name_py": obj.pyname
        }
      });
    }
    if (obj.xjz != "" && obj.xjz == "xjz") {
      tiiaojianparams.bool.should.push({
        "terms": {
          "tm_name.raw": obj.xjzdata
        }
      });
    }
    if (obj.dx != "" && obj.dx == "dx") {
      tiiaojianparams.bool.should.push({
        "term": {
          "tm_name.raw": tmName.split('').reverse().join('')
        }
      });
    }
    if (obj.contain != "" && obj.contain == "contain") {
      tiiaojianparams.bool.should.push({
        "query_string": {
          "default_field": "tm_name",
          "query": "\"" + tmName + "\""
        }
      });
    }
    //英文查询
    if (tmName != null && tmName != "") {
      var re = new RegExp("^[a-zA-Z0-9]+$");//要包含数字的话是 new RegExp("^[a-zA-Z0-9]+$");
      if (re.test(tmName)) {
        console.log(tmName.length);
        var tmNamelength = tmName.length;
        console.log("==============================english=============================================");
        var upname = tmName.toUpperCase();//英文转换大写
        if (tmNamelength <= 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": upname
                    }
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": tmNamelength - 2,
                      "lte": tmNamelength + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (4 < tmNamelength) {
          var prethreechart = upname.slice(0, 3);
          console.log("+++++++++++++++++++++++++++++++prefix3333333333333333333333+++++++++++++++++");
          console.log(prethreechart);
          var postfixthreechart = upname.substring(tmNamelength - 3);
          console.log("+++++++++++++++++++++++++++++++suffix3333333333333333333333+++++++++++++++++");
          console.log(postfixthreechart);
          var tmblankspace = upname.split("").join(" ");
          console.log(tmblankspace);
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": tmblankspace,
                      "minimum_should_match": "80%"
                    }
                  }
                },
                {
                  "prefix": {
                    "en_name.raw": prethreechart
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": tmNamelength - 2,
                      "lte": tmNamelength + 1
                    }
                  }
                }
              ]
            }
          });
        }
        tiiaojianparams.bool.should.push({
          "fuzzy": {
            "en_name.raw": {
              "value": upname,
              "fuzziness": "AUTO",
              "boost": 2
            }
          }
        });
      }
    }

    if (tmName != null && tmName != "") {
      var cnlen = 0;
      var enlen = 0;
      var en = "";
      var cn = "";
      for (var i = 0; i < tmName.length; i++) {
        var a = tmName.charAt(i);
        if (a.match(/[^\x00-\xff]/ig) != null) {
          cnlen += 1;
          cn += a;
        } else {
          en += a;
          enlen += 1;
        }
      }
      console.log("--------------------hanzi---------------------------");
      console.log(cnlen);
      console.log(cn);
      console.log(enlen);
      console.log(en);
      if (cnlen > 0 && enlen > 0) {
        if (cnlen <= 2) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "100%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 2
                    }
                  }
                }
              ]
            }
          });
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "query_string": {
                    "default_field": "tm_name",
                    "query": "\"" + cn.split('').reverse().join('') + "\""
                  }
                }, {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 2
                    }
                  }
                }
              ]
            }
          });
        } else if (cnlen == 3) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "75%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (cnlen == 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "70%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "50%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        }

        var upname = en.toUpperCase();//英文转换大写
        console.log("=========================================en==========================");
        console.log(upname);
        if (enlen <= 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": upname
                    }
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": enlen - 2,
                      "lte": enlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (4 < enlen) {
          var prethreechart = upname.slice(0, 3);
          console.log("+++++++++++++++++++++++++++++++prefix3333333333333333333333+++++++++++++++++");
          console.log(prethreechart);
          var postfixthreechart = upname.substring(tmNamelength - 3);
          console.log("+++++++++++++++++++++++++++++++suffix3333333333333333333333+++++++++++++++++");
          console.log(postfixthreechart);
          var tmblankspace = upname.split("").join(" ");
          console.log(tmblankspace);
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": tmblankspace,
                      "minimum_should_match": "80%"
                    }
                  }
                },
                {
                  "prefix": {
                    "en_name.raw": prethreechart
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": enlen - 2,
                      "lte": enlen + 1
                    }
                  }
                }
              ]
            }
          });
        }
        tiiaojianparams.bool.should.push({
          "fuzzy": {
            "en_name.raw": {
              "value": upname,
              "fuzziness": "AUTO",
              "boost": 2
            }
          }
        });
      }
    }

    if (tiiaojianparams.bool.should.length > 0) {
      params.query.bool.must.push(tiiaojianparams);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    // console.log("----------------------params.query.bool.should---tj=========================");
    // console.log(params.query.bool.must);
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmNamejuheSearch(obj) {//根据商标名称模糊查询，对查询结果进行类别聚合
    var tmName = obj.tmName == null ? "" : obj.tmName;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var nclcode = obj.nclcode;
    var nclNumcode = obj.nclNumcode;
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "ncl_one_codes",
            "size": 45,
          }
        }
      }
    };
    if (tmName != null && tmName != "") {
      if (obj.tyc == "" && obj.py == "" && obj.xjz == "" && obj.dx == "" && obj.js == "" && obj.contain == "" && obj.bz == "") {
        var param = {
          "term": {
            "tm_name.raw": tmName
          }
        }
        params.query.bool.must.push(param);
      }
    }
    // if(sqlbtabkey!="" && sqlbtabkey!=null){
    //   var param=  {
    //         "term": {
    //           "ncl_one_codes": sqlbtabkey
    //         }
    //   }
    //   params.query.bool.must.push(param);
    // }
    if (flzttabkey != "" && flzttabkey != null) {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclNumcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclNumcode
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }

    var tiiaojianparams = {
      "bool": {
        "should": []
      }
    };
    if (obj.js != "" && obj.js == "js" && tmName != null && tmName != "") {
      var len = 0;
      for (var i = 0; i < tmName.length; i++) {
        var a = tmName.charAt(i);
        if (a.match(/[^\x00-\xff]/ig) != null) {
          len += 1;
        }
      }
      console.log("hanzi---------------------------");
      console.log(len);
      if (len <= 2) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "100%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 2
                  }
                }
              }
            ]
          }
        });
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "query_string": {
                  "default_field": "tm_name",
                  "query": "\"" + tmName.split('').reverse().join('') + "\""
                }
              }, {
                "range": {
                  "cn_count": {
                    "lte": len + 2
                  }
                }
              }
            ]
          }
        });
      } else if (len == 3) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "75%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      } else if (len == 4) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "70%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      } else {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "50%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      }
    }
    if (obj.bz != "" && obj.bz == "bz") {
      tiiaojianparams.bool.should.push({
        "fuzzy": {
          "tm_name.raw": {
            "value": tmName,
            "fuzziness": "AUTO"
          }
        }
      });
    }
    if (obj.tyc != "" && obj.tyc == "tyc") {
      tiiaojianparams.bool.should.push({
        "terms": {
          "tm_name.raw": obj.tycdata
        }
      });
    }
    if (obj.py != "" && obj.py == "py") {
      tiiaojianparams.bool.should.push({
        "term": {
          "tm_name_py": obj.pyname
        }
      });
    }
    if (obj.xjz != "" && obj.xjz == "xjz") {
      tiiaojianparams.bool.should.push({
        "terms": {
          "tm_name.raw": obj.xjzdata
        }
      });
    }
    if (obj.dx != "" && obj.dx == "dx") {
      tiiaojianparams.bool.should.push({
        "term": {
          "tm_name.raw": tmName.split('').reverse().join('')
        }
      });
    }
    if (obj.contain != "" && obj.contain == "contain") {
      tiiaojianparams.bool.should.push({
        "query_string": {
          "default_field": "tm_name",
          "query": "\"" + tmName + "\""
        }
      });
    }
    //英文查询
    if (tmName != null && tmName != "") {
      var re = new RegExp("^[a-zA-Z]+$");//要包含数字的话是 new RegExp("^[a-zA-Z0-9]+$");
      if (re.test(tmName)) {
        console.log(tmName.length);
        var tmNamelength = tmName.length;
        console.log("==============================english=============================================");
        console.log(("是全英文"));
        var upname = tmName.toUpperCase();//英文转换大写
        if (tmNamelength <= 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": upname
                    }
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": tmNamelength - 2,
                      "lte": tmNamelength + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (4 < tmNamelength) {
          var prethreechart = upname.slice(0, 3);
          console.log("+++++++++++++++++++++++++++++++prefix3333333333333333333333+++++++++++++++++");
          console.log(prethreechart);
          var postfixthreechart = upname.substring(tmNamelength - 3);
          console.log("+++++++++++++++++++++++++++++++suffix3333333333333333333333+++++++++++++++++");
          console.log(postfixthreechart);
          var tmblankspace = upname.split("").join(" ");
          console.log(tmblankspace);
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": tmblankspace,
                      "minimum_should_match": "80%"
                    }
                  }
                },
                {
                  "prefix": {
                    "en_name.raw": prethreechart
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": tmNamelength - 2,
                      "lte": tmNamelength + 1
                    }
                  }
                }
              ]
            }
          });
        }
        tiiaojianparams.bool.should.push({
          "fuzzy": {
            "en_name.raw": {
              "value": upname,
              "fuzziness": "AUTO",
              "boost": 2
            }
          }
        });
      }
    }
    if (tmName != null && tmName != "") {//中英文混合查询
      var cnlen = 0;
      var enlen = 0;
      var en = "";
      var cn = "";
      for (var i = 0; i < tmName.length; i++) {
        var a = tmName.charAt(i);
        if (a.match(/[^\x00-\xff]/ig) != null) {
          cnlen += 1;
          cn += a;
        } else {
          en += a;
          enlen += 1;
        }
      }
      if (cnlen > 0 && enlen > 0) {
        if (cnlen <= 2) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "100%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 2
                    }
                  }
                }
              ]
            }
          });
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "query_string": {
                    "default_field": "tm_name",
                    "query": "\"" + cn.split('').reverse().join('') + "\""
                  }
                }, {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 2
                    }
                  }
                }
              ]
            }
          });
        } else if (cnlen == 3) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "75%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (cnlen == 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "70%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "50%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        }

        var upname = en.toUpperCase();//英文转换大写
        if (enlen <= 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": upname
                    }
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": enlen - 2,
                      "lte": enlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (4 < enlen) {
          var prethreechart = upname.slice(0, 3);
          console.log("+++++++++++++++++++++++++++++++prefix3333333333333333333333+++++++++++++++++");
          console.log(prethreechart);
          var postfixthreechart = upname.substring(tmNamelength - 3);
          console.log("+++++++++++++++++++++++++++++++suffix3333333333333333333333+++++++++++++++++");
          console.log(postfixthreechart);
          var tmblankspace = upname.split("").join(" ");
          console.log(tmblankspace);
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": tmblankspace,
                      "minimum_should_match": "80%"
                    }
                  }
                },
                {
                  "prefix": {
                    "en_name.raw": prethreechart
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": enlen - 2,
                      "lte": enlen + 1
                    }
                  }
                }
              ]
            }
          });
        }
        tiiaojianparams.bool.should.push({
          "fuzzy": {
            "en_name.raw": {
              "value": upname,
              "fuzziness": "AUTO",
              "boost": 2
            }
          }
        });
      }
    }

    if (tiiaojianparams.bool.should.length > 0) {
      params.query.bool.must.push(tiiaojianparams);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmNamejuheFlztSearch(obj) {//根据商标状态进行聚合
    var tmName = obj.tmName == null ? "" : obj.tmName;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var nclcode = obj.nclcode;
    var nclNumcode = obj.nclNumcode;
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "status",
            "size": 5,
          }
        }
      }
    };
    if (tmName != null && tmName != "") {
      if (obj.tyc == "" && obj.py == "" && obj.xjz == "" && obj.dx == "" && obj.js == "" && obj.contain == "" && obj.bz == "") {
        var param = {
          "term": {
            "tm_name.raw": tmName
          }
        }
        params.query.bool.must.push(param);
      }
    }
    if (sqlbtabkey != "" && sqlbtabkey != null) {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != "" && flzttabkey != null) {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclNumcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclNumcode
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }

    var tiiaojianparams = {
      "bool": {
        "should": []
      }
    };
    if (obj.js != "" && obj.js == "js" && tmName != null && tmName != "") {
      var len = 0;
      for (var i = 0; i < tmName.length; i++) {
        var a = tmName.charAt(i);
        if (a.match(/[^\x00-\xff]/ig) != null) {
          len += 1;
        }
      }
      console.log("hanzi---------------------------");
      console.log(len);
      if (len <= 2) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "100%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 2
                  }
                }
              }
            ]
          }
        });
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "query_string": {
                  "default_field": "tm_name",
                  "query": "\"" + tmName.split('').reverse().join('') + "\""
                }
              }, {
                "range": {
                  "cn_count": {
                    "lte": len + 2
                  }
                }
              }
            ]
          }
        });
      } else if (len == 3) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "75%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      } else if (len == 4) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "70%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      } else {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "50%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      }
    }
    if (obj.bz != "" && obj.bz == "bz") {
      tiiaojianparams.bool.should.push({
        "fuzzy": {
          "tm_name.raw": {
            "value": tmName,
            "fuzziness": "AUTO"
          }
        }
      });
    }
    if (obj.tyc != "" && obj.tyc == "tyc") {
      tiiaojianparams.bool.should.push({
        "terms": {
          "tm_name.raw": obj.tycdata
        }
      });
    }
    if (obj.py != "" && obj.py == "py") {
      tiiaojianparams.bool.should.push({
        "term": {
          "tm_name_py": obj.pyname
        }
      });
    }
    if (obj.xjz != "" && obj.xjz == "xjz") {
      tiiaojianparams.bool.should.push({
        "terms": {
          "tm_name.raw": obj.xjzdata
        }
      });
    }
    if (obj.dx != "" && obj.dx == "dx") {
      tiiaojianparams.bool.should.push({
        "term": {
          "tm_name.raw": tmName.split('').reverse().join('')
        }
      });
    }
    if (obj.contain != "" && obj.contain == "contain") {
      tiiaojianparams.bool.should.push({
        "query_string": {
          "default_field": "tm_name",
          "query": "\"" + tmName + "\""
        }
      });
    }
    //英文查询
    if (tmName != null && tmName != "") {
      var re = new RegExp("^[a-zA-Z]+$");//要包含数字的话是 new RegExp("^[a-zA-Z0-9]+$");
      if (re.test(tmName)) {
        console.log(tmName.length);
        var tmNamelength = tmName.length;
        console.log("==============================english=============================================");
        console.log(("是全英文"));
        var upname = tmName.toUpperCase();//英文转换大写
        if (tmNamelength <= 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": upname
                    }
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": tmNamelength - 2,
                      "lte": tmNamelength + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (4 < tmNamelength) {
          var prethreechart = upname.slice(0, 3);
          console.log("+++++++++++++++++++++++++++++++prefix3333333333333333333333+++++++++++++++++");
          console.log(prethreechart);
          var postfixthreechart = upname.substring(tmNamelength - 3);
          console.log("+++++++++++++++++++++++++++++++suffix3333333333333333333333+++++++++++++++++");
          console.log(postfixthreechart);
          var tmblankspace = upname.split("").join(" ");
          console.log(tmblankspace);
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": tmblankspace,
                      "minimum_should_match": "80%"
                    }
                  }
                },
                {
                  "prefix": {
                    "en_name.raw": prethreechart
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": tmNamelength - 2,
                      "lte": tmNamelength + 1
                    }
                  }
                }
              ]
            }
          });
        }
        tiiaojianparams.bool.should.push({
          "fuzzy": {
            "en_name.raw": {
              "value": upname,
              "fuzziness": "AUTO",
              "boost": 2
            }
          }
        });
      }
    }
    if (tmName != null && tmName != "") {//中英文混合查询
      var cnlen = 0;
      var enlen = 0;
      var en = "";
      var cn = "";
      for (var i = 0; i < tmName.length; i++) {
        var a = tmName.charAt(i);
        if (a.match(/[^\x00-\xff]/ig) != null) {
          cnlen += 1;
          cn += a;
        } else {
          en += a;
          enlen += 1;
        }
      }
      if (cnlen > 0 && enlen > 0) {
        if (cnlen <= 2) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "100%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 2
                    }
                  }
                }
              ]
            }
          });
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "query_string": {
                    "default_field": "tm_name",
                    "query": "\"" + cn.split('').reverse().join('') + "\""
                  }
                }, {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 2
                    }
                  }
                }
              ]
            }
          });
        } else if (cnlen == 3) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "75%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (cnlen == 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "70%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "50%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        }

        var upname = en.toUpperCase();//英文转换大写
        if (enlen <= 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": upname
                    }
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": enlen - 2,
                      "lte": enlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (4 < enlen) {
          var prethreechart = upname.slice(0, 3);
          console.log("+++++++++++++++++++++++++++++++prefix3333333333333333333333+++++++++++++++++");
          console.log(prethreechart);
          var postfixthreechart = upname.substring(tmNamelength - 3);
          console.log("+++++++++++++++++++++++++++++++suffix3333333333333333333333+++++++++++++++++");
          console.log(postfixthreechart);
          var tmblankspace = upname.split("").join(" ");
          console.log(tmblankspace);
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": tmblankspace,
                      "minimum_should_match": "80%"
                    }
                  }
                },
                {
                  "prefix": {
                    "en_name.raw": prethreechart
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": enlen - 2,
                      "lte": enlen + 1
                    }
                  }
                }
              ]
            }
          });
        }
        tiiaojianparams.bool.should.push({
          "fuzzy": {
            "en_name.raw": {
              "value": upname,
              "fuzziness": "AUTO",
              "boost": 2
            }
          }
        });
      }
    }

    if (tiiaojianparams.bool.should.length > 0) {
      params.query.bool.must.push(tiiaojianparams);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tmNamejuheYearSearch(obj) {//根据商标year进行聚合
    var tmName = obj.tmName == null ? "" : obj.tmName;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var nclcode = obj.nclcode;
    var nclNumcode = obj.nclNumcode;
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [],
          "must_not": {
            "term": {
              "apply_year": 0
            }
          }
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "apply_year",
            "size": 52
          }
        }
      }
    };
    if (tmName != null && tmName != "") {
      if (obj.tyc == "" && obj.py == "" && obj.xjz == "" && obj.dx == "" && obj.js == "" && obj.contain == "" && obj.bz == "") {
        var param = {
          "term": {
            "tm_name.raw": tmName
          }
        }
        params.query.bool.must.push(param);
      }
    }
    if (sqlbtabkey != "" && sqlbtabkey != null) {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != "" && flzttabkey != null) {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param);
    }
    if (nclNumcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclNumcode
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }

    var tiiaojianparams = {
      "bool": {
        "should": []
      }
    };
    // if(obj.js!=""&&obj.js=="js"){
    //   if(tmName.length<=2){
    //     tiiaojianparams.bool.should.push({
    //       "query_string": {
    //            "default_field": "tm_name",
    //            "query": "\""+tmName+"\""
    //         }
    //      });
    //      tiiaojianparams.bool.should.push({
    //         "query_string": {
    //             "default_field": "tm_name",
    //             "query": "\""+tmName.split('').reverse().join('')+"\""
    //         }
    //       });
    //   }else if(tmName.length==3){
    //     tiiaojianparams.bool.should.push({
    //            "match": {
    //                "tm_name_standard": {
    //                    "query": tmName
    //                }
    //            }
    //      });
    //   }else if(tmName.length==3){
    //     tiiaojianparams.bool.should.push({
    //            "match": {
    //                "tm_name_standard": {
    //                  "query": tmName,
    //                  "minimum_should_match": "100%"
    //                }
    //            }
    //      });
    //   }else if(tmName.length==3){
    //     tiiaojianparams.bool.should.push({
    //            "match": {
    //                "tm_name_standard": {
    //                  "query": tmName,
    //                  "minimum_should_match": "70%"
    //                }
    //            }
    //      });
    //   }else{
    //     tiiaojianparams.bool.should.push({
    //            "match": {
    //                "tm_name_standard": {
    //                  "query": tmName,
    //                  "minimum_should_match": "50%"
    //                }
    //            }
    //      });
    //   }
    //
    // }
    if (obj.js != "" && obj.js == "js" && tmName != null && tmName != "") {
      var len = 0;
      for (var i = 0; i < tmName.length; i++) {
        var a = tmName.charAt(i);
        if (a.match(/[^\x00-\xff]/ig) != null) {
          len += 1;
        }
      }
      console.log("hanzi---------------------------");
      console.log(len);
      if (len <= 2) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "100%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 2
                  }
                }
              }
            ]
          }
        });
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "query_string": {
                  "default_field": "tm_name",
                  "query": "\"" + tmName.split('').reverse().join('') + "\""
                }
              }, {
                "range": {
                  "cn_count": {
                    "lte": len + 2
                  }
                }
              }
            ]
          }
        });
      } else if (len == 3) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "75%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      } else if (len == 4) {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "70%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      } else {
        tiiaojianparams.bool.should.push({
          "bool": {
            "must": [
              {
                "match": {
                  "tm_name_standard": {
                    "query": tmName,
                    "minimum_should_match": "50%"
                  }
                }
              },
              {
                "range": {
                  "cn_count": {
                    "lte": len + 1
                  }
                }
              }
            ]
          }
        });
      }
    }
    if (obj.bz != "" && obj.bz == "bz") {
      tiiaojianparams.bool.should.push({
        "fuzzy": {
          "tm_name.raw": {
            "value": tmName,
            "fuzziness": "AUTO"
          }
        }
      });
    }
    if (obj.tyc != "" && obj.tyc == "tyc") {
      tiiaojianparams.bool.should.push({
        "terms": {
          "tm_name.raw": obj.tycdata
        }
      });
    }
    if (obj.py != "" && obj.py == "py") {
      tiiaojianparams.bool.should.push({
        "term": {
          "tm_name_py": obj.pyname
        }
      });
    }
    if (obj.xjz != "" && obj.xjz == "xjz") {
      tiiaojianparams.bool.should.push({
        "terms": {
          "tm_name.raw": obj.xjzdata
        }
      });
    }
    if (obj.dx != "" && obj.dx == "dx") {
      tiiaojianparams.bool.should.push({
        "term": {
          "tm_name.raw": tmName.split('').reverse().join('')
        }
      });
    }
    if (obj.contain != "" && obj.contain == "contain") {
      tiiaojianparams.bool.should.push({
        "query_string": {
          "default_field": "tm_name",
          "query": "\"" + tmName + "\""
        }
      });
    }
    //英文查询
    if (tmName != null && tmName != "") {
      var re = new RegExp("^[a-zA-Z]+$");//要包含数字的话是 new RegExp("^[a-zA-Z0-9]+$");
      if (re.test(tmName)) {
        console.log(tmName.length);
        var tmNamelength = tmName.length;
        console.log("==============================english=============================================");
        console.log(("是全英文"));
        var upname = tmName.toUpperCase();//英文转换大写
        if (tmNamelength <= 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": upname
                    }
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": tmNamelength - 2,
                      "lte": tmNamelength + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (4 < tmNamelength) {
          var prethreechart = upname.slice(0, 3);
          console.log("+++++++++++++++++++++++++++++++prefix3333333333333333333333+++++++++++++++++");
          console.log(prethreechart);
          var postfixthreechart = upname.substring(tmNamelength - 3);
          console.log("+++++++++++++++++++++++++++++++suffix3333333333333333333333+++++++++++++++++");
          console.log(postfixthreechart);
          var tmblankspace = upname.split("").join(" ");
          console.log(tmblankspace);
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": tmblankspace,
                      "minimum_should_match": "80%"
                    }
                  }
                },
                {
                  "prefix": {
                    "en_name.raw": prethreechart
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": tmNamelength - 2,
                      "lte": tmNamelength + 1
                    }
                  }
                }
              ]
            }
          });
        }
        tiiaojianparams.bool.should.push({
          "fuzzy": {
            "en_name.raw": {
              "value": upname,
              "fuzziness": "AUTO",
              "boost": 2
            }
          }
        });
      }
    }
    if (tmName != null && tmName != "") {//中英文混合查询
      var cnlen = 0;
      var enlen = 0;
      var en = "";
      var cn = "";
      for (var i = 0; i < tmName.length; i++) {
        var a = tmName.charAt(i);
        if (a.match(/[^\x00-\xff]/ig) != null) {
          cnlen += 1;
          cn += a;
        } else {
          en += a;
          enlen += 1;
        }
      }
      if (cnlen > 0 && enlen > 0) {
        if (cnlen <= 2) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "100%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 2
                    }
                  }
                }
              ]
            }
          });
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "query_string": {
                    "default_field": "tm_name",
                    "query": "\"" + cn.split('').reverse().join('') + "\""
                  }
                }, {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 2
                    }
                  }
                }
              ]
            }
          });
        } else if (cnlen == 3) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "75%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (cnlen == 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "70%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "tm_name_standard": {
                      "query": cn,
                      "minimum_should_match": "50%"
                    }
                  }
                },
                {
                  "range": {
                    "cn_count": {
                      "lte": cnlen + 1
                    }
                  }
                }
              ]
            }
          });
        }

        var upname = en.toUpperCase();//英文转换大写
        if (enlen <= 4) {
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": upname
                    }
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": enlen - 2,
                      "lte": enlen + 1
                    }
                  }
                }
              ]
            }
          });
        } else if (4 < enlen) {
          var prethreechart = upname.slice(0, 3);
          console.log("+++++++++++++++++++++++++++++++prefix3333333333333333333333+++++++++++++++++");
          console.log(prethreechart);
          var postfixthreechart = upname.substring(tmNamelength - 3);
          console.log("+++++++++++++++++++++++++++++++suffix3333333333333333333333+++++++++++++++++");
          console.log(postfixthreechart);
          var tmblankspace = upname.split("").join(" ");
          console.log(tmblankspace);
          tiiaojianparams.bool.should.push({
            "bool": {
              "must": [
                {
                  "match": {
                    "en_name_standard": {
                      "query": tmblankspace,
                      "minimum_should_match": "80%"
                    }
                  }
                },
                {
                  "prefix": {
                    "en_name.raw": prethreechart
                  }
                },
                {
                  "range": {
                    "en_name_count": {
                      "gte": enlen - 2,
                      "lte": enlen + 1
                    }
                  }
                }
              ]
            }
          });
        }
        tiiaojianparams.bool.should.push({
          "fuzzy": {
            "en_name.raw": {
              "value": upname,
              "fuzziness": "AUTO",
              "boost": 2
            }
          }
        });
      }
    }
    if (tiiaojianparams.bool.should.length > 0) {
      params.query.bool.must.push(tiiaojianparams);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tmzchSearch(obj) {//根据商标商标号精准查询
    var regNum = obj.regNum == null ? "" : obj.regNum;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var pagesize = obj.pagesize == null ? 15 : obj.pagesize;
    var ncltwo = obj.ncltwo;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }
    if (regNum == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "tm_agency",
        "pic_url",
        "ncl_two_codes"
      ],
    };

    if (regNum != "" && regNum != null) {
      var lastchar = regNum.split("");
      var last = lastchar[lastchar.length - 1];
      if (last == "A") {
        regNum = regNum.substring(0, regNum.length - 1);
      }
      var param = {
        "regexp": {
          "tm_regist_num": "[TG]{0,1}" + regNum + "[A]{0,1}"
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != "" && sqlbtabkey != null) {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param)
    }
    if (flzttabkey != "" && flzttabkey != null) {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (ncltwo.length > 0) {
      var param = {
        "terms": {
          "ncl_two_codes": ncltwo
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmzchjuheSearch(obj) {//根据商标商标号精准查询，对查询结果进行类别聚合
    var regNum = obj.regNum == null ? "" : obj.regNum;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    if (regNum == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "ncl_one_codes",
            "size": 45,
          }
        }
      }
    };
    if (regNum != null && regNum != "") {
      var lastchar = regNum.split("");
      var last = lastchar[lastchar.length - 1];
      if (last == "A") {
        regNum = regNum.substring(0, regNum.length - 1);
      }
      var param = {
        "regexp": {
          "tm_regist_num": "[TG]{0,1}" + regNum + "[A]{0,1}"
        }
      }
      params.query.bool.must.push(param)
    }
    // if(sqlbtabkey!=null&&sqlbtabkey!=""){
    //   var param={
    //     "term":{
    //       "ncl_one_codes":sqlbtabkey
    //     }
    //   }
    //   params.query.bool.must.push(param);
    // }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmzchjuheFlztSearch(obj) {//根据商标商标号精准查询，对查询结果进行flzt聚合
    var regNum = obj.regNum == null ? "" : obj.regNum;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    if (regNum == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "status",
            "size": 5,
          }
        }
      }
    };
    if (regNum != null && regNum != "") {
      var lastchar = regNum.split("");
      var last = lastchar[lastchar.length - 1];
      if (last == "A") {
        regNum = regNum.substring(0, regNum.length - 1);
      }
      var param = {
        "regexp": {
          "tm_regist_num": "[TG]{0,1}" + regNum + "[A]{0,1}"
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != null && sqlbtabkey != "") {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmzchjuheYearSearch(obj) {//根据商标商标号精准查询，对查询结果进行类别聚合
    var regNum = obj.regNum == null ? "" : obj.regNum;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    if (regNum == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [],
          "must_not": {
            "term": {
              "apply_year": 0
            }
          }
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "apply_year",
            "size": 52,
          }
        }
      }
    };
    if (regNum != null && regNum != "") {
      var lastchar = regNum.split("");
      var last = lastchar[lastchar.length - 1];
      if (last == "A") {
        regNum = regNum.substring(0, regNum.length - 1);
      }
      var param = {
        "regexp": {
          "tm_regist_num": "[TG]{0,1}" + regNum + "[A]{0,1}"
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != null && sqlbtabkey != "") {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmzcrSearch(obj) {//根据商标注册人模糊查询
    var applier = obj.applier == null ? "" : obj.applier;
    var zcrname = obj.zcrname == null ? "" : obj.zcrname;
    applier = await this.getConvertSemiangleStr(applier);
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var ncltwo = obj.ncltwo;
    var pagesize = obj.pagesize == null ? 15 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }
    if (applier == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "tm_agency",
        "pic_url",
        "ncl_two_codes"
      ],
      "sort": {
        "apply_day_format": "desc"
      }
    };

    if (applier != "" && applier != null) {
      var appliername = "";
      for (var i = 0; i < applier.length; i++) {
        var c = applier.charAt(i);
        // These characters are part of the query syntax and must be escaped
        if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':'
          || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~'
          || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
          appliername += "\\";
        }
        appliername += c;
      }
      var param = {
        "query_string": {
          "default_field": "applicant_cn",
          "query": "*" + appliername + "*"
        }
      }
      params.query.bool.must.push(param)
    }
    if (zcrname != "" && zcrname != null) {
      var param = {
        "term": {
          "applicant_cn": zcrname
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != "" && sqlbtabkey != null) {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param)
    }
    if (flzttabkey != "" && flzttabkey != null) {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (ncltwo.length > 0) {
      var param = {
        "terms": {
          "ncl_two_codes": ncltwo
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmzcrjuheSearch(obj) {//根据商标注册人模糊查询，对查询结果进行类别聚合
    var applier = obj.applier == null ? "" : obj.applier;
    var zcrname = obj.zcrname == null ? "" : obj.zcrname;
    applier = await this.getConvertSemiangleStr(applier);
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    if (applier == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "ncl_one_codes",
            "size": 45,
          }
        }
      }
    };
    if (applier != "" && applier != null) {
      var appliername = "";
      for (var i = 0; i < applier.length; i++) {
        var c = applier.charAt(i);
        // These characters are part of the query syntax and must be escaped
        if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':'
          || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~'
          || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
          appliername += "\\";
        }
        appliername += c;
      }
      var param = {
        "query_string": {
          "default_field": "applicant_cn",
          "query": "*" + appliername + "*"
        }
      }
      params.query.bool.must.push(param)
    }
    if (zcrname != "" && zcrname != null) {
      var param = {
        "term": {
          "applicant_cn": zcrname
        }
      }
      params.query.bool.must.push(param)
    }

    if (sqlbtabkey != "" && sqlbtabkey != null) {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param)
    }
    if (flzttabkey != "" && flzttabkey != null) {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async tmzcrjuheFlztSearch(obj) {//根据商标状态进行聚合
    var applier = obj.applier == null ? "" : obj.applier;
    var zcrname = obj.zcrname == null ? "" : obj.zcrname;
    applier = await this.getConvertSemiangleStr(applier);
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    if (applier == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "status",
            "size": 5,
          }
        }
      }
    };
    if (applier != "" && applier != null) {
      var appliername = "";
      for (var i = 0; i < applier.length; i++) {
        var c = applier.charAt(i);
        // These characters are part of the query syntax and must be escaped
        if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':'
          || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~'
          || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
          appliername += "\\";
        }
        appliername += c;
      }
      var param = {
        "query_string": {
          "default_field": "applicant_cn",
          "query": "*" + appliername + "*"
        }
      }
      params.query.bool.must.push(param)
    }
    if (zcrname != "" && zcrname != null) {
      var param = {
        "term": {
          "applicant_cn": zcrname
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != null && sqlbtabkey != "") {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tmzcrjuheYearSearch(obj) {//根据商标year进行聚合
    var applier = obj.applier == null ? "" : obj.applier;
    var zcrname = obj.zcrname == null ? "" : obj.zcrname;
    applier = await this.getConvertSemiangleStr(applier);
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    if (applier == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [],
          "must_not": {
            "term": {
              "apply_year": 0
            }
          }
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "apply_year",
            "size": 52
          }
        }
      }
    };
    if (applier != "" && applier != null) {
      var appliername = "";
      for (var i = 0; i < applier.length; i++) {
        var c = applier.charAt(i);
        // These characters are part of the query syntax and must be escaped
        if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':'
          || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~'
          || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
          appliername += "\\";
        }
        appliername += c;
      }
      var param = {
        "query_string": {
          "default_field": "applicant_cn",
          "query": "*" + appliername + "*"
        }
      }
      params.query.bool.must.push(param)
    }
    if (zcrname != "" && zcrname != null) {
      var param = {
        "term": {
          "applicant_cn": zcrname
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != null && sqlbtabkey != "") {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tmzcrjuheapplierSearch(obj) {//根据注册人聚合
    var applier = obj.applier == null ? "" : obj.applier;
    var zcrname = obj.zcrname == null ? "" : obj.zcrname;
    applier = await this.getConvertSemiangleStr(applier);
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    if (applier == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [],
          "must_not": {
            "term": {
              "apply_year": 0
            }
          }
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "applicant_cn",
            "size": 1000
          }
        }
      }
    };
    if (applier != "" && applier != null) {
      var appliername = "";
      for (var i = 0; i < applier.length; i++) {
        var c = applier.charAt(i);
        // These characters are part of the query syntax and must be escaped
        if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':'
          || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~'
          || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
          appliername += "\\";
        }
        appliername += c;
      }
      var param = {
        "query_string": {
          "default_field": "applicant_cn",
          "query": "*" + appliername + "*"
        }
      }
      params.query.bool.must.push(param)
    }
    // if(zcrname!=null&&zcrname!=""){
    //   var param={
    //     "term":{
    //       "applicant_cn":zcrname
    //     }
    //   }
    //   params.query.bool.must.push(param);
    // }
    if (sqlbtabkey != null && sqlbtabkey != "") {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }

  async tmSearchByRegNum(obj) {//商标查询(多注册号)-ok
    var reqUrl = this.tmSearchUrl;
    if (obj.regNums == null || obj.regNums.length < 1) {
      return System.getResult2(null, null);
    }
    var pagesize = obj.pagesize == null ? 15 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }
    var regNums = obj.regNums == null ? "" : obj.regNums;
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "exists": {
                "field": "ncl_one_codes"
              }
            },
            {
              "terms": {
                "tm_regist_num": regNums
              }
            }
          ]
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "tm_agency",
        "pic_url"
      ],
      "sort": [
        {
          "apply_day": "desc"
        },
        {
          "_id": "asc"
        }
      ]
    };

    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(JSON.parse(rtn.stdout).hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async imagesearch(obj) {//图像检索结果进行查询
    var tmRegistNum = obj.tmRegistNum == null ? "" : obj.tmRegistNum;
    // var sqlbtabkey = obj.sqlbtabkey==null?"":obj.sqlbtabkey;
    if (tmRegistNum == "" && tmRegistNum == null) {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "tm_agency",
        "pic_url"
      ],
    };
    if (tmRegistNum != "" && tmRegistNum != null) {
      var param = {
        "term": {
          "tm_regist_num": tmRegistNum
        }
      }
      params.query.bool.must.push(param)
    }
    // if(sqlbtabkey!="" && sqlbtabkey!=null){
    //   var param=  {
    //         "term": {
    //           "ncl_one_codes": sqlbtabkey
    //         }
    //   }
    //   params.query.bool.must.push(param)
    // }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async imagesearchbycode(obj) {//图像检索结果进行分类查询
    var tmRegistNumsAll = obj.tmRegistNumsAll == null ? "" : obj.tmRegistNumsAll;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var ncltwo = obj.ncltwo;
    var pagesize = obj.pagesize == null ? 15 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "tm_agency",
        "pic_url"
      ],
    };
    if (tmRegistNumsAll.length > 0 && tmRegistNumsAll != null) {
      var param = {
        "terms": {
          "tm_regist_num": tmRegistNumsAll
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != "" && sqlbtabkey != null) {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param)
    }
    if (flzttabkey != "" && flzttabkey != null) {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (ncltwo.length > 0) {
      var param = {
        "terms": {
          "ncl_two_codes": ncltwo
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async imagesearchjuheNcl(obj) {//图像检索结果进行ncl_one_codes聚合
    console.log("+++++++++++++++++++++++++++ncl+++++++++++++++++++++++++++++++++");
    // console.log(obj);
    var tmRegistNumsAll = obj.tmRegistNumsAll == null ? "" : obj.tmRegistNumsAll;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    console.log(sqlbtabkey, flzttabkey, sqnftabkey);
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "ncl_one_codes",
            "size": 45,
          }
        }
      }
    };
    if (tmRegistNumsAll.length > 0 && tmRegistNumsAll != null) {
      var param = {
        "terms": {
          "tm_regist_num": tmRegistNumsAll
        }
      }
      params.query.bool.must.push(param)
    }
    // if(sqlbtabkey!=null&&sqlbtabkey!=""){
    //   var param={
    //     "term":{
    //       "ncl_one_codes":sqlbtabkey
    //     }
    //   }
    //   params.query.bool.must.push(param);
    // }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    console.log(params);
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async imagesearchjuheStatus(obj) {//图像检索结果进行status聚合
    console.log("+++++++++++++++++++++++++++status+++++++++++++++++++++++++++++++++");
    console.log(obj);
    var tmRegistNumsAll = obj.tmRegistNumsAll == null ? "" : obj.tmRegistNumsAll;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    console.log(sqlbtabkey, flzttabkey, sqnftabkey);
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "status",
            "size": 5,
          }
        }
      }
    };
    if (tmRegistNumsAll.length > 0 && tmRegistNumsAll != null) {
      var param = {
        "terms": {
          "tm_regist_num": tmRegistNumsAll
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != null && sqlbtabkey != "") {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    console.log(params);
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async imagesearchjuheYear(obj) {//图像检索结果进行year聚合
    var tmRegistNumsAll = obj.tmRegistNumsAll == null ? "" : obj.tmRegistNumsAll;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    console.log(sqlbtabkey, flzttabkey, sqnftabkey);
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [],
          "must_not": {
            "term": {
              "apply_year": 0
            }
          }
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "apply_year",
            "size": 52,
          }
        }
      }
    };
    if (tmRegistNumsAll.length > 0 && tmRegistNumsAll != null) {
      var param = {
        "terms": {
          "tm_regist_num": tmRegistNumsAll
        }
      }
      params.query.bool.must.push(param)
    }
    if (sqlbtabkey != null && sqlbtabkey != "") {
      var param = {
        "term": {
          "ncl_one_codes": sqlbtabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (flzttabkey != null && flzttabkey != "") {
      var param = {
        "term": {
          "status": flzttabkey
        }
      }
      params.query.bool.must.push(param);
    }
    if (sqnftabkey != null && sqnftabkey != "") {
      var param = {
        "term": {
          "apply_year": sqnftabkey
        }
      }
      params.query.bool.must.push(param);
    }
    console.log(params);
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tmNmaeSearchByNcl(obj) {
    var tmName = obj.tmName == null ? "" : obj.tmName;
    var nclcode = obj.nclcode;
    var pagesize = obj.pagesize == null ? 15 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "tm_agency",
        "pic_url"
      ],
    };

    if (tmName != null && tmName != "") {
      var param = {
        "match": {
          "tm_name": tmName
        }
      }
      params.query.bool.must.push(param)
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tmNmaeSearchByNcljuhe(obj) {//根据尼斯分类进行聚合查询
    var tmName = obj.tmName == null ? "" : obj.tmName;
    var nclcode = obj.nclcode;
    if (tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "ncl_one_codes_count": {
          "terms": {
            "field": "ncl_one_codes",
            "size": 45,
          }
        }
      }
    };
    if (tmName != null && tmName != "") {
      var param = {
        "match": {
          "tm_name": tmName
        }
      }
      params.query.bool.must.push(param)
    }
    if (nclcode.length > 0) {
      var param = {
        "terms": {
          "ncl_one_codes": nclcode
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhe4(j, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tradeMarkDetailapi(obj) {
    var sbzch = obj.sbzch;
    var gjfl = obj.gjfl;
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "tm_agency",
        "pic_url"
      ],
    };

    if (sbzch != null && sbzch != "") {
      var param = {
        "term": {
          "tm_regist_num": sbzch
        }
      }
      params.query.bool.must.push(param)
    }
    if (gjfl != null && gjfl != "") {
      var param = {
        "term": {
          "ncl_one_codes": gjfl
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async getTmFlow(obj) {//商标流程
    var param = {
      reg_num: obj.regNum
    }
    return this.utilstmSve.getTmFlow(param, "ByTmSearchApi");
  }
  async getNcl(obj) {//尼斯数据
    var level = obj.level == null ? "" : obj.level;
    var reqUrl = this.nclUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "size": 1000,
      "_source": [
        "pid",
        "level",
        "code",
        "name"
      ],
      "sort": [
        {
          "code": "asc"
        }
      ]
    };
    if (level != null && level != "" && level != 'undefined') {
      var param = {
        "term": {
          "level": level
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };
  async getNclByLikeName(obj) {//尼斯数据
    console.log("----------------------------------------------");
    console.log(obj);
    var nclfuwu = obj.nclfuwu;
    var pagesize = obj.pagesize == null ? 20 : obj.pagesize;
    var nclcode = obj.nclcode;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }
    var reqUrl = this.nclUrl;
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "term": {
                "level": 3
              }
            }
          ]
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "pid",
        "level",
        "code",
        "name"
      ],
      "sort": [
        {
          "code": "desc"
        }
      ]
    };
    if (nclfuwu != null && nclfuwu != "") {
      var param = {
        "wildcard": {
          "name.raw": "*" + nclfuwu + "*"
        }
      };
      params.query.bool.must.push(param);
    }
    console.log(params);
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      console.log(rtn);
      var j = JSON.parse(rtn.stdout);
      console.log(j);
      return System.getResult3(j.hits, null);
    } catch (e) {
      console.log(e.stack);
      return rtn = System.getResult2(null, null);
    }
  }
  async gettwoNclList(obj) {//尼斯二类编号及名称
    var pid = obj.pid == null ? "" : obj.pid;
    var reqUrl = this.nclUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "size": 500,
      "_source": [
        "pid",
        "level",
        "code",
        "name"
      ],
      "sort": [
        {
          "code": "asc"
        }
      ]
    };
    if (pid != null && pid != "") {
      var param = {
        "term": {
          "pid": pid
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      console.log(e.stack);
      return rtn = System.getResult2(null, null);
    }

  }

  async noticeQueryTMZCSQ(obj) {//商标公告查询
    var noticetype = obj.noticetype;
    var reqUrl = this.tmFlowUrl;
    var params = {
      "size": 1,
      "aggregations": {
        "notice_count": {
          "terms": {
            "field": "notice_issue",
            "size": 12,
            "order": {
              "_term": "desc"
            }
          },
          "aggregations": {
            "date_max": {
              "max": {
                "field": "notice_data"
              }
            }
          }
        }
      }
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResultjuhetwo(j, null);
    } catch (e) {
      console.log(e.stack);
      return rtn = System.getResult2(null, null);
    }
  }

  async noticeQueryAPi(obj) {//商标公告查询
    console.log(obj);
    var noticenumber = obj.noticenumber;
    var applynumber = obj.applynumber;
    var tmname = obj.tmname;
    var applier = obj.applier;
    var noticetype = obj.noticetype;
    var nclNum = obj.nclNum;
    var reqUrl = this.tmFlowUrl;
    var pagesize = obj.pagesize == null ? 15 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "tm_regist_num",
        "notice_data",
        "notice_issue",
        "page_no",
        "notice_type_id",
        "notice_type_code",
        "notice_type_name",
        "proposer",
        "link_url",
        "tm_name",
        "pic_url",
        "ncl_ones"
      ], "sort": {
        "notice_issue": "desc"
      }
    }
    if (noticenumber != null && noticenumber != "") {
      var param = {
        "term": {
          "notice_issue": noticenumber
        }
      }
      params.query.bool.must.push(param);
    }
    if (applynumber != null && applynumber != "") {
      var param = {
        "term": {
          "tm_regist_num": applynumber
        }
      }
      params.query.bool.must.push(param);
    }
    if (applier != null && applier != "") {
      var param = {
        "term": {
          "proposer": applier
        }
      }
      params.query.bool.must.push(param);
    }
    if (tmname != null && tmname != "") {
      var param = {
        "term": {
          "tm_name": tmname
        }
      }
      params.query.bool.must.push(param);
    }
    if (noticetype != null && noticetype != "") {
      var param = {
        "term": {
          "notice_type_code": noticetype
        }
      }
      params.query.bool.must.push(param);
    }

    if (nclNum != null && nclNum != "") {
      if (nclNum != "all") {
        var param = {
          "term": {
            "ncl_ones": nclNum
          }
        }
        params.query.bool.must.push(param);
      }
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      console.log(e.stack);
      return rtn = System.getResult2(null, null);
    }
  }

  async getNclOne(obj) {
    var onecode = obj.onecode;
    var reqUrl = this.nclUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "_source": [
        "description",
        "code",
        "name"
      ]
    };
    if (onecode != null && onecode != "") {
      var param = {
        "term": {
          "code": onecode
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }

  async getthreeNclList(obj) {
    var twopid = obj.twopid;
    var reqUrl = this.nclUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "size": 1000,
      "_source": [
        "code",
        "name"
      ]
    };
    if (twopid != null && twopid != "") {
      var param = {
        "term": {
          "pid": twopid
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async tmncloneSearch(obj) {//计算通过率
    var nclonecode = obj.nclonecode == null ? "" : obj.nclonecode;
    var tmName = obj.tmName == null ? "" : obj.tmName;
    if (nclonecode == "" || tmName == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmncloneQueryUrl.replace("{nclonecode}", encodeURIComponent(nclonecode));
    reqUrl = reqUrl.replace("{tmName}", encodeURIComponent(tmName));
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      // rtn=await rc.execGetTimeOut({},reqUrl,this.reqTimeOut);
      rtn = await rc.execGet({}, reqUrl, this.reqTimeOut);
      var tmpResult = JSON.parse(rtn.stdout);
      if (tmpResult.status != 0) {
        //日志记录
        // this.logCtl.error({
        //    optitle:"计算通过率"+reqUrl+"异常",
        //    op:"base/api/impl/fqtmsearch/zntjSearch",
        //    content:"返回值："+rtn.stdout,
        //    clientIp:""
        //  });
        return System.getResult2(null, null, "other method fail");
      }
      return System.getResult2(tmpResult.data, null);
    } catch (e) {
      // //日志记录
      // this.logCtl.error({
      //    optitle:"计算通过率",
      //    op:"base/api/impl/fqtmsearch/tjdlSearch",
      //    content:e.stack,
      //    clientIp:""
      //  });
      return System.getResult2(null, null, "zntjSearch error;");
    }
  };
  async tmncloneSearchs(obj) {//计算通过率
    var tms = obj.tmlist;
    var self = this;
    var rtmlist = [];
    var ratetext0 = '此名称属于高危词汇 ，通过率低于50%';
    var ratetext1 = '已存在有相同或逆序的，通过率低于50%';
    var ratetext2 = '已存在有近似商标，建议谨慎尝试申请，通过率50%-60%';
    var ratetext3 = '无相同或高度近似，建议积极提交注册申请，通过率70%';
    for (var i = 0; i < tms.length; i++) {
      var pobj = {
        nclonecode: tms[i].ncl_type,
        tmName: tms[i].tm_name
      };
      var nclone = [];
      nclone.push(tms[i].ncl_type);
      var bobj = {
        nclcode: nclone,
        tmName: tms[i].tm_name,
        nclNumcode: [],
        ncltwo: '',
        bz: "bz",
        tyc: "tyc",
        py: "py",
        xjz: "xjz",
        tycdata: [],
        xjzdata: [],
        contain: '',
        pyname: '',
        dx: "dx"
      };
      var rate = await self.tmncloneSearch(pobj);
      var rateint = parseInt(rate.data);
      var jstms = await self.tmNameSearch(bobj);
      var jsl = jstms.data.length > 9 ? 10 : jstms.data.length;
      var tmnames = [];
      for (var j = 0; j < jsl; j++) {
        if (tmnames.findIndex(f => f == jstms.data[j].tm_name) < 0)
          tmnames.push(jstms.data[j].tm_name);
      }
      var ratetext = '';
      var level = 2;
      if (rateint == 0) {
        ratetext = ratetext0;
        level = 0;
      }
      if (rateint > 0 && rateint <= 50) {
        ratetext = ratetext1;
        level = 1;
      }
      if (rateint > 50 && rateint <= 60) {
        ratetext = ratetext2;
        level = 2;
      }
      if (rateint > 60) {
        ratetext = ratetext3;
        level = 3;
      }
      var source = {
        ncl_type: tms[i].ncl_type,
        tm_name: tms[i].tm_name,
        ratetext: ratetext,
        level: level,
        tmnames: tmnames
      }
      rtmlist.push(source);
    }
    return System.getResult2(rtmlist, null);
  };
  async noticeSearch(obj) { //商标公告查询
    console.log(obj);
    var sbzch = obj.sbzch;
    var csggqh = obj.csggqh;
    var reqUrl = this.tmFlowUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "size": 1,
      "_source": [
        "tm_regist_num",
        "notice_data",
        "notice_issue",
        "page_no",
        "notice_type_id",
        "notice_type_code",
        "notice_type_name",
        "proposer",
        "link_url",
        "tm_name",
        "pic_url"
      ]
    }
    if (csggqh != null && csggqh != "") {
      var param = {
        "term": {
          "notice_issue": csggqh
        }
      }
      params.query.bool.must.push(param);
    }
    if (sbzch != null && sbzch != "") {
      var param = {
        "term": {
          "tm_regist_num": sbzch
        }
      }
      params.query.bool.must.push(param);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      console.log(e.stack);
      return rtn = System.getResult2(null, null);
    }
  }
  async noticezcgg(obj) { //商标公告查询
    console.log(obj);
    var sbzch = obj.sbzch;
    var zcggqh = obj.zcggqh;
    var reqUrl = this.tmFlowUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "size": 1,
      "_source": [
        "tm_regist_num",
        "notice_data",
        "notice_issue",
        "page_no",
        "notice_type_id",
        "notice_type_code",
        "notice_type_name",
        "proposer",
        "link_url",
        "tm_name",
        "pic_url"
      ]
    }
    if (zcggqh != null && zcggqh != "") {
      var param = {
        "term": {
          "notice_issue": zcggqh
        }
      }
      params.query.bool.must.push(param);
    }
    if (sbzch != null && sbzch != "") {
      var param = {
        "term": {
          "tm_regist_num": sbzch
        }
      }
      params.query.bool.must.push(param);
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      console.log(e.stack);
      return rtn = System.getResult2(null, null);
    }
  }
  async opCache(obj) {
    // var tbDataList = await this.cacheManager["ApplistCache"].getListByCache();
    var list = [];
    var key = "byc_" + obj.openId;
    var mark = obj.mark;
    var tbDataList = await this.cacheManager["BycCache"].getBycListByCache(key);
    if (tbDataList && tbDataList != null && tbDataList != "null") {
      list = JSON.parse(tbDataList);
    }
    return { code: 1, data: list };
  }
  async redisInsert(obj) {
    var list = [];
    var key = "byc_" + obj.openId;
    var mark = obj.mark;
    var tbDataList = await this.cacheManager["BycCache"].getBycListByCache(key);
    if (tbDataList && tbDataList != null && tbDataList != "null") {
      list = JSON.parse(tbDataList);
      if (mark != "" && mark != null) {
        if (list.length < 10) {
          var delIndex = list.findIndex(v => v.value === mark);
          if (delIndex < 0) {
            list.push({ value: mark });
          }
        } else {
          var delIndex = list.findIndex(v => v.value === mark);
          if (delIndex < 0) {
            //移除单个数据
            list.splice(0, 1);
            list.push({ value: mark });
          }
        }
      }
    } else {
      if (mark != "" && mark != null) {
        var m = {
          value: mark
        };
        list.push(m);
      }
    }
    var stringStr = JSON.stringify(list);
    this.cacheManager["BycCache"].setBycList(key, stringStr);
    return { code: 1 };
  }
  async sbzuixinsearchapi() {//商标最新进度查询
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [

          ]
        }
      },
      "size": 1,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "apply_day_format",
        "tm_agency",
        "pic_url",
        "ncl_two_codes"
      ],
      "sort": {
        "apply_day_format": "desc"
      }
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async sbzuixinxiazheng() {//商标最新进度查询
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "term": {
                "status": 3
              }
            }
          ]
        }
      },
      "size": 1,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "apply_day_format",
        "tm_agency",
        "pic_url",
        "ncl_two_codes"
      ],
      "sort": {
        "apply_day_format": "desc"
      }
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
  async sbzuixinchushen() {//商标最新进度查询
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "term": {
                "status": 2
              }
            }
          ]
        }
      },
      "size": 1,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_type",
        "tm_regist_num",
        "tm_name",
        "tm_name_py",
        "tm_name_en",
        "apply_day",
        "first_notice_day",
        "original_regist_notice_day",
        "first_notice_issue",
        "first_notice_page_num",
        "regist_notice_issue",
        "regist_notice_page_num",
        "tm_end_day",
        "tm_end_day_format",
        "regist_notice_day_format",
        "applicant_cn",
        "original_applicant_cn",
        "applicant_cn_addr",
        "applicant_en",
        "applicant_en_addr",
        "apply_day_format",
        "tm_agency",
        "pic_url",
        "ncl_two_codes"
      ],
      "sort": {
        "apply_day_format": "desc"
      }
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }

  async tmzcroneSearch(obj) {//根据商标注册人精确查询
    var applier = obj.applier == null ? "" : obj.applier;
    var page = obj.page == null ? 0 : obj.page;
    applier = await this.getConvertSemiangleStr(applier);
    if (applier == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": page * 500,
      "size": 500,
      "_source": [
        "ncl_one_codes",
        "status",
        "tm_regist_num",
        "tm_name",
        "apply_day",
        "apply_year",
        "tm_end_day",
        "regist_notice_day"
      ],
      "sort": {
        "apply_day_format": "desc"
      }
    };

    if (applier != "" && applier != null) {
      var appliername = "";
      for (var i = 0; i < applier.length; i++) {
        var c = applier.charAt(i);
        // These characters are part of the query syntax and must be escaped
        if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':'
          || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~'
          || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
          appliername += "\\";
        }
        appliername += c;
      }
      var param = {
        "query_string": {
          "default_field": "applicant_cn",
          "query": appliername
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      // console.log(e);
      //日志记录
      this.logCtl.error({
        optitle: "商标申请人查询异常--error",
        op: "/igirl-web/app/base/api/impl/bytmsearch.js/tmzcroneSearch",
        content: e.stack,
        clientIp: ""
      });
      return rtn = System.getResult2(null, null);
    }
  };

  async tmzcraggsSearch(obj) {//根据商标注册人精确查询
    var applier = obj.applier == null ? "" : obj.applier;
    var type = obj.type == null ? 0 : obj.type;
    applier = await this.getConvertSemiangleStr(applier);
    if (applier == "") {
      return System.getResult2(null, null);
    }
    var reqUrl = this.tmSearchUrl;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 0,
      "aggregations": {
        "y_count": {
          "terms": {
            "field": "apply_year"
          }
        }
      }
    };

    if (applier != "" && applier != null) {
      var appliername = "";
      for (var i = 0; i < applier.length; i++) {
        var c = applier.charAt(i);
        // These characters are part of the query syntax and must be escaped
        if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':'
          || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~'
          || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
          appliername += "\\";
        }
        appliername += c;
      }
      var param = {
        "query_string": {
          "default_field": "applicant_cn",
          "query": appliername
        }
      }
      if (type == 1) {
        params.aggregations.y_count.terms.field = "status"
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult2(j.aggregations.y_count.buckets, null);
    } catch (e) {
      // console.log(e);
      //日志记录
      // this.logCtl.error({
      //   optitle: "商标申请人查询异常--error",
      //   op: "/igirl-web/app/base/api/impl/bytmsearch/tmzcraggsSearch",
      //   content: e.stack,
      //   clientIp: ""
      // });
      return rtn = System.getResult2(null, null);
    }
  };


  async provincePubstatusAggs(obj) {//根据传的省|市|县信息不同类型聚合
    console.log("apppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp");
    console.log(obj.params);
    obj.seltype = obj.seltype == null ? 0 : obj.seltype;
    obj.areaname = obj.areaname == null ? "" : obj.areaname;
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 0,
      "aggregations": {
        "agginfo": {
          "terms": {
            "field": "",
            "size": 50,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };
    // for (var x in obj.params) {
    //   params.query.bool.must.push(obj.params[x]);
    // }
    if(obj.params&&obj.params.length>0){
      for (var x=0;x<obj.params.length;x++) {
        params.query.bool.must.push(obj.params[x]);
      }
    }
    if (obj.seltype == 1) {
      params.aggregations.agginfo.terms.field = "apply_addr_province"
    }
    if (obj.seltype == 2) {
      if (obj.areaname == '北京市' || obj.areaname == '天津市' || obj.areaname == '重庆市' || obj.areaname == '上海市') {
        params.aggregations.agginfo.terms.field = "apply_addr_county";
      }
      else {
        params.aggregations.agginfo.terms.field = "apply_addr_city";
      }
    }
    else if (obj.seltype == 3) {
      params.aggregations.agginfo.terms.field = "ncl_one_codes";
    }
    else if (obj.seltype == 4) {
      params.aggregations.agginfo.terms.field = "tmreg_year";
    }
    else if (obj.seltype == 5) {
      params.aggregations.agginfo.terms.field = "apply_year";
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.tmSearchUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      // console.log(j)
      if(j){
        this.logCtl.info({
          optitle: "tmbigdata-provincePubstatusAggs--info",
          op: "/igirl-web/app/base/api/impl/bytmsearch.js/provincePubstatusAggs",
          content: JSON.stringify(j),
          clientIp: ""
        });
      }

      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations.agginfo.buckets
      };
    } catch (e) {
      console.log(e);
      this.logCtl.error({
        optitle: "tmbigdata-provincePubstatusAggs--error",
        op: "/igirl-web/app/base/api/impl/bytmsearch.js/provincePubstatusAggs",
        content: e.stack,
        clientIp: ""
      });
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async tmcompanyAggs(obj) {//根据传的省|市|县信息不同类型聚合
    obj.seltype = obj.seltype == null ? 0 : obj.seltype;
    obj.areaname = obj.areaname == null ? "" : obj.areaname;
    var params = {
      "size": 0,
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
        "tmcount": {
          "terms": {
            "field": "apply_addr_province",
            "size": 100,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "companycount": {
              "cardinality": {
                "field": "applicant_cn"
              }
            }
          }
        }
      }
    };
    // for (var x in obj.params) {
    //   params.query.bool.must.push(obj.params[x]);
    // }
    if(obj.params&&obj.params.length>0){
      for (var x=0;x<obj.params.length;x++) {
        params.query.bool.must.push(obj.params[x]);
      }
    }
    if (obj.seltype == 1) {
      params.aggregations.tmcount.terms.field = "apply_addr_province"
    }
    if (obj.seltype == 2) {
      if (obj.areaname == '北京市' || obj.areaname == '天津市' || obj.areaname == '重庆市' || obj.areaname == '上海市') {
        params.aggregations.tmcount.terms.field = "apply_addr_county";
      }
      else {
        params.aggregations.tmcount.terms.field = "apply_addr_city";
      }
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.tmSearchUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      // console.log(j.aggregations.tmcount.buckets)
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations.tmcount.buckets
      };
    } catch (e) {
      this.logCtl.error({
        optitle: "tmbigdata-tmcompanyAggs--error",
        op: "/igirl-web/app/base/api/impl/bytmsearch.js/tmcompanyAggs",
        content: e.stack,
        clientIp: ""
      });
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async tmcompanycountAggs(obj) {//根据传的省|市|县信息不同类型聚合
    obj.seltype = obj.seltype == null ? 0 : obj.seltype;
    obj.areaname = obj.areaname == null ? "" : obj.areaname;
    var params = {
      "size": 0,
      "query": {
        "bool": {
          "must": []
        }
      },
      "aggregations": {
            "companycount": {
              "cardinality": {
                "field": "applicant_cn"
              }
            }
          }
    };
    // for (var x in obj.params) {
    //   params.query.bool.must.push(obj.params[x]);
    // }
    if(obj.params&&obj.params.length>0){
      for (var x=0;x<obj.params.length;x++) {
        params.query.bool.must.push(obj.params[x]);
      }
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.tmSearchUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      console.log(j.aggregations.companycount)
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations.companycount
      };
    } catch (e) {
      this.logCtl.error({
        optitle: "tmbigdata-tmcompanycountAggs--error",
        op: "/igirl-web/app/base/api/impl/bytmsearch.js/tmcompanycountAggs",
        content: e.stack,
        clientIp: ""
      });
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async getNclLevel() {
    var reqUrl = this.nclUrl;
    var params = {
      "query": {
        "bool": {
          "must": [{
            "term":{
              "level":1
            }
          }]
        }
      },
      "size":45,
      "_source": [
        "description",
        "code",
        "name"
      ]
    };
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(params, reqUrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult3(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  }
}
module.exports = ByTmSearchApi;
