var System = require("../../../system");
var settings = require("../../../../config/settings");
const ApiBase = require("../../api.base");
var pinyin = require("pinyin");
class tmqueryApi extends ApiBase {
  constructor() {
    super();
    this.ichemingUrl = settings.apiconfig.ichemingUrl();
    this.GsbByTmSearchApi = System.getObject("api.trademark.tmsearch");
    this.utilstmSve = System.getObject("service.trademark.utilstmSve");
    this.utilscontent = System.getObject("service.trademark.utilscontentfilterSve");
    this.gsbicsearch = System.getObject("api.trademark.gsbicsearch");
    this.tmquerySve = System.getObject("service.trademark.tmquerySve");
    this.patentycSve = System.getObject("service.patent.patentycSve");
    this.tm_type = { P: "普通商标", J: "集体商标", Z: "证明商标", T: "特殊商标" };
    this.tm_status = { 1: "申请中", 2: "已初审", 3: "已注册", 4: "已无效", 5: "其他" };
    this.imageQueryUrl = settings.apiconfig.imageQueryUrl();
    this.tm_gjfl = {
      1: "01类 化学原料", 2: "02类 颜料油漆", 3: "03类 日化用品", 4: "04类 燃料油脂", 5: "05类 医药", 6: "06类 金属材料", 7: "07类 机械设备", 8: "08类 手工器械", 9: "09类 科学仪器",
      10: "10类 医疗器械", 11: "11类 灯具空调", 12: "12类 运输工具", 13: "13类 军火烟火", 14: "14类 珠宝钟表", 15: "15类 乐器", 16: "16类 办公用品", 17: "17类 橡胶制品", 18: "18类 皮革皮具", 19: "19类 建筑材料", 20: "20类 家具", 21: "21类 厨房洁具", 22: "22类 绳网袋蓬", 23: "23类 纱线丝", 24: "24类 布料床单",
      25: "25类 服装鞋帽", 26: "26类 钮扣拉链", 27: "27类 地毯席垫", 28: "28类 健身器材", 29: "29类 食品", 30: "30类 方便食品", 31: "31类 农林生鲜", 32: "32类 啤酒饮料", 33: "33类 酒", 34: "34类 烟草烟具", 35: "35类 广告销售", 36: "36类 金融物管", 37: "37类 建筑修理", 38: "38类 通讯服务",
      39: "39类 运输贮藏", 40: "40类 材料加工", 41: "41类 教育娱乐", 42: "42类 科技服务", 43: "43类 餐饮住宿", 44: "44类 医疗园艺", 45: "45类 社会服务"
    };
    this.province = ["安徽省", "福建省", "甘肃省", "广东省", "广西壮族自治区", "贵州省", "海南省", "河北省", "河南省", "黑龙江省", "湖北省", "湖南省", "吉林省", "江苏省", "江西省", "辽宁省", "内蒙古自治区", "宁夏回族自治区", "青海省", "山东省", "山西省",
      "陕西省", "四川省", "西藏自治区", "新疆维吾尔自治区", "云南省", "浙江省", "北京市", "天津市", "上海市", "重庆市","香港特别行政区","台湾省","澳门特别行政区"]
    this.provincecity={"安徽省":["六安市","淮北市","铜陵市","阜阳市","宣城市","黄山市","合肥市","芜湖市","宿州市","亳州市","滁州市","池州市","安庆市","淮南市","马鞍山市","蚌埠市"],"福建省":["宁德市","厦门市","福州市","莆田市","泉州市"
        ,"漳州市","龙岩市","三明市","南平市"],"甘肃省":["定西市","临夏回族自治州","嘉峪关市","白银市","酒泉市","平凉市","天水市","庆阳市","陇南市","金昌市","武威市","兰州市","张掖市","甘南藏族自治州"],
      "广东省":["佛山市","东莞市","揭阳市","河源市","肇庆市","梅州市","珠海市","韶关市","深圳市","云浮市","江门市","潮州市","阳江市","茂名市","汕头市","汕尾市","广州市","湛江市","惠州市","清远市","中山市"],
      "广西壮族自治区":["贺州市","来宾市","河池市","崇左市","防城港市","北海市","柳州市","钦州市","百色市","梧州市","桂林市","玉林市","南宁市","贵港市"],
      "贵州省":["黔西南布依族苗族自治州","黔东南苗族侗族自治州","黔南布依族苗族自治州","遵义市","安顺市","毕节市","六盘水市","贵阳市","铜仁市"],"海南省":["海口市","三亚市","儋州市","三沙市"],
      "河北省":["秦皇岛市","保定市","石家庄市","衡水市","沧州市","邢台市","邯郸市","承德市","廊坊市","唐山市","张家口市"],
      "河南省":["商丘市","信阳市","许昌市","郑州市","鹤壁市","三门峡市","平顶山市","周口市","南阳市","漯河市","驻马店市","开封市","焦作市","洛阳市","新乡市","安阳市","濮阳市"],
      "黑龙江省":["大兴安岭地区","七台河市","黑河市","大庆市","哈尔滨市","双鸭山市","佳木斯市","鹤岗市","绥化市","牡丹江市","鸡西市","伊春市","齐齐哈尔市"],
      "湖北省":["孝感市","荆州市","荆门市","宜昌市","襄阳市","随州市","黄冈市","武汉市","鄂州市","十堰市","黄石市","咸宁市","恩施土家族苗族自治州"],
      "湖南省":["怀化市","常德市","株洲市","湘西土家族苗族自治州","益阳市","邵阳市","衡阳市","张家界市","郴州市","岳阳市","湘潭市","长沙市","娄底市","永州市"],
      "吉林省":["松原市","白城市","延边朝鲜族自治州","长春市","通化市","辽源市","吉林市","四平市","白山市"],
      "江苏省":["泰州市","南京市","南通市","常州市","镇江市","连云港市","徐州市","苏州市","无锡市","盐城市","宿迁市","扬州市","淮安市"],
      "江西省":["九江市","吉安市","新余市","抚州市","赣州市","鹰潭市","宜春市","萍乡市","景德镇市","南昌市","上饶市"],
      "辽宁省":["营口市","本溪市","铁岭市","沈阳市","盘锦市","鞍山市","丹东市","朝阳市","抚顺市","辽阳市","阜新市","葫芦岛市","锦州市","大连市"],
      "内蒙古自治区":["通辽市","赤峰市","巴彦淖尔市","鄂尔多斯市","乌兰察布市","阿拉善盟","呼伦贝尔市","锡林郭勒盟","乌海市","包头市","呼和浩特市","兴安盟"],
      "宁夏回族自治区":["中卫市","固原市","石嘴山市","吴忠市","银川市"],"青海省":["海西蒙古族藏族自治州","西宁市","黄南藏族自治州","玉树藏族自治州","果洛藏族自治州","海北藏族自治州","海南藏族自治州","海东市"],
      "山东省":["枣庄市","济宁市","菏泽市","济南市","潍坊市","青岛市","东营市","滨州市","淄博市","泰安市","烟台市","莱芜市","聊城市","威海市","日照市","临沂市","德州市"],
      "山西省":["晋城市","临汾市","大同市","阳泉市","吕梁市","晋中市","运城市","忻州市","长治市","朔州市","太原市"],
      "陕西省":["渭南市","延安市","咸阳市","铜川市","汉中市","西安市","商洛市","安康市","榆林市","宝鸡市"],
      "四川省":["绵阳市","德阳市","泸州市","广元市","宜宾市","南充市","自贡市","乐山市","资阳市","甘孜藏族自治州","雅安市","内江市","广安市","阿坝藏族羌族自治州","达州市","巴中市","凉山彝族自治州","遂宁市","眉山市","成都市","攀枝花市"],
      "西藏自治区":["日喀则市","昌都市","那曲市","阿里地区","拉萨市","山南市","林芝市"],"新疆维吾尔自治区":["喀什地区","阿勒泰地区","哈密市","克拉玛依市","博尔塔拉蒙古自治州","吐鲁番市","和田地区","伊犁哈萨克自治州","巴音郭楞蒙古自治州","塔城地区","乌鲁木齐市","克孜勒苏柯尔克孜自治州","昌吉回族自治州","阿克苏地区"],
      "云南省":["楚雄彝族自治州","西双版纳傣族自治州","德宏傣族景颇族自治州","怒江傈僳族自治州","丽江市","红河哈尼族彝族自治州","大理白族自治州","迪庆藏族自治州","保山市","临沧市","文山壮族苗族自治州","昆明市","曲靖市","玉溪市","昭通市","普洱市"],
      "浙江省":["杭州市","丽水市","温州市","嘉兴市","宁波市","衢州市","金华市","台州市","湖州市","舟山市","绍兴市"],
      "北京市":["石景山区","房山区","海淀区","通州区","西城区","延庆区","丰台区","昌平区","东城区","门头沟区","怀柔区","顺义区","平谷区","大兴区","朝阳区","密云区"],
      "天津市":["滨海新区","河西区","河北区","南开区","津南区","静海区","蓟州区","河东区","红桥区","武清区","东丽区","西青区","宝坻区","和平区","宁河区","北辰区"],
      "上海市":["宝山区","嘉定区","闵行区","浦东新区","徐汇区","青浦区","长宁区","松江区","静安区","黄浦区","普陀区","奉贤区","崇明区","虹口区","杨浦区","金山区"],
      "重庆市":["巫溪县","涪陵区","南岸区","璧山区","渝中区","北碚区","奉节县","荣昌区","潼南区","铜梁区","彭水苗族土家族自治县","南川区","忠县","梁平区","九龙坡区","开州区","渝北区","大足区","合川区","垫江县","酉阳土家族苗族自治县","长寿区","云阳县","黔江区","巴南区","沙坪坝区","城口县","丰都县","江津区","大渡口区","永川区","石柱土家族自治县","武隆区","綦江区","秀山土家族苗族自治县","江北区","万州区","巫山县"]}
  }
  convertDate(time) {
    if (time == null) {
      return "";
    }
    var date = new Date(Number(time * 1000));
    var y = 1900 + date.getYear();
    var m = "0" + (date.getMonth() + 1);
    var d = "0" + date.getDate();
    return y + "-" + m.substring(m.length - 2, m.length) + "-" + d.substring(d.length - 2, d.length);
  }
  convertDate1(time) {
    if (time == null) {
      return "";
    }
    var date = new Date(Number(time * 1000));
    var y = 1900 + date.getYear();
    var m = "0" + (date.getMonth() + 4);
    if (date.getMonth() > 8) {
      y = y + 1;
      m = "0" + (date.getMonth() - 8);
    }
    var d = "0" + date.getDate();
    return y + "-" + m.substring(m.length - 2, m.length) + "-" + d.substring(d.length - 2, d.length);
  }
  //商标群组信息 参数：data = {reg_num：注册号-精确,nclone_code:大类号-精确}
  async getSbqz(data) {
    var tms = await this.utilstmSve.getGroupNclNumList(data);
    var that = this;
    var sbqz = "";
    if (tms.status == 0 && tms.data.exist.length > 0) {
      tms.data.exist.forEach(function (c) {
        sbqz += c.code + ";";
      });
    }
    return sbqz;
  }

  async findTrademarkNameIndex(query, obj) {//根据商标名称模糊查询,首次查询,
    var result = { rows: [], code_counts: [], count: 0 };
    var sources = [];
    var codes = [];
    var tmName = obj.tmName == null ? "" : obj.tmName;
    tmName = tmName.replace(/[&\|\\\*^%$#@\-]/g, "");
    var pageSize = obj.pageSize;
    var currentPage = obj.currentPage;
    var ncl = obj.ncl;
    var nclcode = [];
    if (ncl) {
      for (var i = 0; i < ncl.length; i++) {
        console.log(ncl[i]);
        var num = Number(ncl[i].slice(0, 2))
        console.log(num);
        nclcode.push(num);
      }
    }

    var data = {
      tmName: tmName,
      nclcode: nclcode,
      pagesize: pageSize,
      page: currentPage
    };
    var tms = await this.GsbByTmSearchApi.tmNmaeSearchByNcl(data);//获取查询结果
    var tmsjuhe = await this.GsbByTmSearchApi.tmNmaeSearchByNcljuhe(data);//获取聚合结果
    var that = this;
    if (tms.status == 0) {
      result.count = tms.total;
      tms.data.forEach(function (tm) {
        var source = {
          sbmc: tm.tm_name,//商标名称
          sbpy: tm.tm_name_py,//商标拼音
          sbyw: tm.tm_name_en,//商标英文
          gjfl: tm.ncl_one_codes,//国际分类
          gjflname: that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
          sbzch: tm.tm_regist_num,//商标注册号
          sblx: that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
          sbzt: that.tm_status[tm.status],//商标状态
          sqrq: that.convertDate(tm.apply_day),//申请日期
          csrq: that.convertDate(tm.first_notice_day),//初审日期
          zcrq: that.convertDate(tm.original_regist_notice_day),//注册日期
          csggym: tm.first_notice_page_num,//初审公告页码
          zcr: tm.applicant_cn,//申请人
          jzrq: that.convertDate(tm.tm_end_day),//截止日期
          csggqh: tm.first_notice_issue == null ? "" : "第" + tm.first_notice_issue + "期",//初审公告（期号）
          zcggqh: tm.regist_notice_issue == null ? "" : "第" + tm.regist_notice_issue + "期",//注册公告
          csgg: tm.first_notice_issue,//初审公告（期号）
          zcgg: tm.regist_notice_issue,//注册公告
          zcggym: tm.regist_notice_page_num,//注册公告页码
          yzcr: tm.original_applicant_cn,//原申请人
          zcdz: tm.applicant_cn_addr,//申请地址
          zcren: tm.applicant_en,//申请人enlish
          zcdzen: tm.applicant_en_addr,//申请地址enlish
          dljg: tm.tm_agency,//代理机构
          zxzt: "",//最新状态
          spfwxm: "",
          lcxx: "",
          logo: tm.pic_url,//商标图样
        };
        sources.push(source);

      });
      result.rows = sources;
    };
    if (tmsjuhe.status == 0) {
      tmsjuhe.buckets.sort(function (a, b) {
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function (buck) {
        var name = that.tm_gjfl[buck.key];
        var gjfl = {//国际分类
          "key": buck.key,
          "keyvalue": name,
          "keycount": buck.doc_count,
        };
        codes.push(gjfl);
      });
      result.code_counts = codes;
    }
    return System.getResult2(result, null);
  }

  async findTrademarkName(query, obj) {//根据商标名称模糊查询
    console.log(obj);
    var result = { rows: [], code_counts: [], status_counts: [], no_code_counts: [], year_counts: [], count: 0 };
    var sources = [];
    var codes = [];
    var no_code = [];
    var year_count = []
    var flztstatus = [];
    var tmName = obj.tmName == null ? "" : obj.tmName;
    tmName = tmName.replace(/[&\|\\\*^%$#@\-]/g, "");
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var pageSize = obj.pageSize;
    var currentPage = obj.currentPage;
    var ncl = obj.ncl;
    var nclcode = [];
    if (ncl) {
      for (var i = 0; i < ncl.length; i++) {
        var num = Number(ncl[i].slice(0, 2))
        nclcode.push(num);
      };
    }
    var nclNum = obj.nclNum;
    var nclNumcode = [];
    if (nclNum) {
      for (var i = 0; i < nclNum.length; i++) {
        var num = Number(nclNum[i])
        nclNumcode.push(num);
      }
    }

    var ncltwocodesearch = obj.xcl;
    var ncltwo = [];
    if (ncltwocodesearch) {
      for (var i = 0; i < ncltwocodesearch.length; i++) {
        var code = ncltwocodesearch[i].code;
        ncltwo.push(code);
      }
    }
    var js = "";
    var bz = "";
    var tyc = "";
    var py = "";
    var xjz = "";
    var dx = "";
    var tycdata = [];
    var xjzdata = [];
    var contain = "";
    //按商标检索条件进行参数---'拼音', '同义词', '形近字', '换序',"左匹配","右匹配"
    var sbtjdata = obj.sbtjdata;
    for (var i = 0; i < sbtjdata.length; i++) {
      var tmp = sbtjdata[i];
      if (tmp == "近似") {
        js = "js";
      } if (tmp == "变字") {
        bz = "bz";
      }
      if (tmp == "同义词") {
        tyc = "tyc";
        var objd = {
          name: tmName
        }
        var tms = await this.utilscontent.getSynonymsList(objd);
        if (tms.code == 1) {
          tycdata = tms.data;
        }
      }
      if (tmp == "拼音") {
        py = "py";
        var pynamelist = pinyin(tmName, {
          heteronym: true,
          style: pinyin.STYLE_NORMAL,
        });
        var pp = [];
        console.log(pynamelist);
        pynamelist.forEach(function (c) {
          pp.push(c[0]);
        });
        var pyname = pp.join("");
        // console.log("pppppppppppppppppppppppppppppppppppppppp");
        // console.log(pynamelist);
        // console.log(pyname);
      }
      if (tmp == "形近字") {
        xjz = "xjz";
        var objd = {
          name: tmName
        }
        var tms = await this.utilscontent.getSimilarList(objd);
        // console.log("--------------------------------------");
        // console.log(tms.data);
        if (tms.code == 1) {
          xjzdata = tms.data;
        }
      }
      if (tmp == "换序") {
        dx = "dx";
      }
      if (tmp == "包含该商标") {
        contain = "contain";
      }
    }
    var data = {
      tmName: tmName,
      sqlbtabkey: sqlbtabkey,
      flzttabkey: flzttabkey,
      sqnftabkey: sqnftabkey,
      pagesize: pageSize,
      page: currentPage,
      nclcode: nclcode,
      nclNumcode: nclNumcode,
      js: js,
      bz: bz,
      tyc: tyc,
      tycdata: tycdata,
      py: py,
      pyname: pyname,
      xjz: xjz,
      xjzdata: xjzdata,
      dx: dx,
      contain: contain,
      ncltwo: ncltwo
    };
    var tms = await this.GsbByTmSearchApi.tmNameSearch(data);//获取查询结果
    // console.log(tms);
    var tmsjuhe = await this.GsbByTmSearchApi.tmNamejuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmNamejuheFlztSearch(data);//根据商标状态聚合
    // console.log(tmsjuhestatus);
    var tmsjuheyear = await this.GsbByTmSearchApi.tmNamejuheYearSearch(data);//根据商标year聚合
    // console.log(tmsjuheyear);
    var that = this;
    if (tms.status == 0) {
      result.count = tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm = tms.data[i];
        if (tm != null) {
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var qunzutms=await this.utilstmSve.getGroupNclInfo(sbdata);
          // var spfwxmlist=[];
          // var codelist=[];
          // if(qunzutms.status==0){
          //   qunzutms.data.exist.forEach(function(c){
          //     if(spfwxmlist.findIndex(f => f == c.small_name) < 0){
          //       spfwxmlist.push(c.small_name)
          //     }
          //     if(codelist.findIndex(f => f ==c.code)<0){
          //       codelist.push(c.code)
          //     }
          //   });
          // }
          // var spfwxm=spfwxmlist.join(",");
          var sbqzlist = [];
          if (tm.ncl_two_codes && tm.ncl_two_codes.length > 0) {
            // console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function (c) {
              if (c) {
                sbqzlist.push(c)
              }
            });
          }
          var sbqz = sbqzlist.join(",");
          var source = {
            sbmc: tm.tm_name,//商标名称
            sbpy: tm.tm_name_py,//商标拼音
            sbyw: tm.tm_name_en,//商标英文
            gjfl: tm.ncl_one_codes,//国际分类
            gjflname: that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
            sbzch: tm.tm_regist_num,//商标注册号
            sblx: that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
            sbzt: that.tm_status[tm.status],//商标状态
            sqrq: that.convertDate(tm.apply_day),//申请日期
            csrq: that.convertDate(tm.first_notice_day),//初审日期
            zcrq: that.convertDate(tm.original_regist_notice_day),//注册日期
            csggym: tm.first_notice_page_num,//初审公告页码
            zcr: tm.applicant_cn,//申请人
            jzrq: that.convertDate(tm.tm_end_day),//截止日期
            csggqh: tm.first_notice_issue == null ? "" : "第" + tm.first_notice_issue + "期",//初审公告（期号）
            zcggqh: tm.regist_notice_issue == null ? "" : "第" + tm.regist_notice_issue + "期",//注册公告
            csgg: tm.first_notice_issue,//初审公告（期号）
            zcgg: tm.regist_notice_issue,//注册公告
            zcggym: tm.regist_notice_page_num,//注册公告页码
            yzcr: tm.original_applicant_cn,//原申请人
            zcdz: tm.applicant_cn_addr,//申请地址
            zcren: tm.applicant_en,//申请人enlish
            zcdzen: tm.applicant_en_addr,//申请地址enlish
            dljg: tm.tm_agency,//代理机构
            zxzt: "",//最新状态
            spfwxm: "",
            lcxx: "",
            sbqz: sbqz,
            logo: tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      result.rows = sources;
    }
    if (nclNum.length > 0 && nclNum.length < 45) {
      if (tmsjuhe.status == 0) {
        tmsjuhe.buckets.sort(function (a, b) {
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function (buck) {
          var name = that.tm_gjfl[buck.key];
          var gjfl = {//国际分类
            "key": buck.key,
            "keyvalue": name,
            "keycount": buck.doc_count,
          };
          codes.push(gjfl);
        });
        result.code_counts = codes;
        result.no_code_counts = no_code;
      }
    } else {
      if (tmsjuhe.status == 0) {
        tmsjuhe.buckets.sort(function (a, b) {
          return a.key - b.key;
        });
        Array.prototype.remove = function (val) {
          var index = this.indexOf(val);
          if (index > -1) {
            this.splice(index, 1);
          }
        };
        var num = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
          21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
        tmsjuhe.buckets.forEach(function (buck) {
          var name = that.tm_gjfl[buck.key];
          var gjfl = {//国际分类
            "key": buck.key,
            "keyvalue": name,
            "keycount": buck.doc_count,
          };
          codes.push(gjfl);
          num.remove(Number(buck.key));
        });
        result.code_counts = codes;
        num.forEach(function (n) {
          var name = that.tm_gjfl[n];
          var no_gjfl = {
            "name": name
          }
          no_code.push(no_gjfl);
        });
        result.no_code_counts = no_code;
      }
    }
    if (tmsjuhestatus.status == 0) {
      tmsjuhestatus.buckets.sort(function (a, b) {
        return a.key - b.key;
      });
      tmsjuhestatus.buckets.forEach(function (buck) {
        var name = that.tm_status[buck.key];
        var st = {
          "key": buck.key,
          "keyvalue": name,
          "keycount": buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts = flztstatus;
    }
    if (tmsjuheyear.status == 0) {
      tmsjuheyear.buckets.sort(function (a, b) {
        return b.key - a.key;
      });
      tmsjuheyear.buckets.forEach(function (buck) {
        var name = that.tm_status[buck.key];
        var year = {
          "key": buck.key,
          "keycount": buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts = year_count;
    }
    return System.getResult2(result, null);
  }

  async findTrademarkNameAccurate(query, obj) {//通过商标名来进行精准查询
    console.log(obj);
    var result = { rows: [], code_counts: [], status_counts: [], no_code_counts: [], year_counts: [], count: 0 };
    var sources = [];
    var codes = [];
    var no_code = [];
    var year_count = [];
    var flztstatus = [];
    var tmName = obj.tmName == null ? "" : obj.tmName;
    tmName = tmName.replace(/[&\|\\\*^%$#@\-]/g, "");
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var pageSize = obj.pageSize;
    var currentPage = obj.currentPage;
    var ncl = obj.ncl;
    var nclcode = [];
    for (var i = 0; i < ncl.length; i++) {
      console.log(ncl[i]);
      var num = Number(ncl[i].slice(0, 2))
      console.log(num);
      nclcode.push(num);
    };
    var nclNum = obj.nclNum;
    var nclNumcode = [];
    for (var i = 0; i < nclNum.length; i++) {
      var num = Number(nclNum[i])
      nclNumcode.push(num);
    }

    var ncltwocodesearch = obj.xcl;
    var ncltwo = [];
    for (var i = 0; i < ncltwocodesearch.length; i++) {
      console.log(ncltwocodesearch[i]);
      var code = ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var data = {
      tmName: tmName,
      sqlbtabkey: sqlbtabkey,
      flzttabkey: flzttabkey,
      sqnftabkey: sqnftabkey,
      nclcode: nclcode,
      nclNumcode: nclNumcode,
      ncltwo: ncltwo,
      pagesize: pageSize,
      page: currentPage
    };
    var tms = await this.GsbByTmSearchApi.tmAccurateSearch(data);//获取查询结果
    // console.log(tms);
    // console.log("++++++++++++++++++++++++++++++++++++++++++++++++");
    var tmsjuhe = await this.GsbByTmSearchApi.tmAccuratejuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmAccuratejuheFlztSearch(data);//根据商标状态聚合
    var tmsjuheyear = await this.GsbByTmSearchApi.tmAccuratejuheYearSearch(data);//根据商标year聚合
    var that = this;
    if (tms.status == 0) {
      result.count = tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm = tms.data[i];
        if (tm != null) {
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var qunzutms=await this.utilstmSve.getGroupNclInfo(sbdata);
          // var spfwxmlist=[];
          // var codelist=[];
          // if(qunzutms.status==0){
          //   qunzutms.data.exist.forEach(function(c){
          //     if(spfwxmlist.findIndex(f => f == c.small_name) < 0){
          //       spfwxmlist.push(c.small_name)
          //     }
          //     if(codelist.findIndex(f => f ==c.code)<0){
          //       codelist.push(c.code)
          //     }
          //   });
          // }
          // var spfwxm=spfwxmlist.join(",");
          var sbqzlist = [];
          if (tm.ncl_two_codes && tm.ncl_two_codes.length > 0) {
            // console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function (c) {
              if (c) {
                sbqzlist.push(c)
              }
            });
          }
          var sbqz = sbqzlist.join(",");
          var source = {
            sbmc: tm.tm_name,//商标名称
            sbpy: tm.tm_name_py,//商标拼音
            sbyw: tm.tm_name_en,//商标英文
            gjfl: tm.ncl_one_codes,//国际分类
            gjflname: that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
            sbzch: tm.tm_regist_num,//商标注册号
            sblx: that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
            sbzt: that.tm_status[tm.status],//商标状态
            sqrq: that.convertDate(tm.apply_day),//申请日期
            csrq: that.convertDate(tm.first_notice_day),//初审日期
            zcrq: that.convertDate(tm.original_regist_notice_day),//注册日期
            csggym: tm.first_notice_page_num,//初审公告页码
            zcr: tm.applicant_cn,//申请人
            jzrq: that.convertDate(tm.tm_end_day),//截止日期
            csggqh: tm.first_notice_issue == null ? "" : "第" + tm.first_notice_issue + "期",//初审公告（期号）
            zcggqh: tm.regist_notice_issue == null ? "" : "第" + tm.regist_notice_issue + "期",//注册公告
            csgg: tm.first_notice_issue,//初审公告（期号）
            zcgg: tm.regist_notice_issue,//注册公告
            zcggym: tm.regist_notice_page_num,//注册公告页码
            yzcr: tm.original_applicant_cn,//原申请人
            zcdz: tm.applicant_cn_addr,//申请地址
            zcren: tm.applicant_en,//申请人enlish
            zcdzen: tm.applicant_en_addr,//申请地址enlish
            dljg: tm.tm_agency,//代理机构
            zxzt: "",//最新状态
            spfwxm: "",
            lcxx: "",
            sbqz: sbqz,
            logo: tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      result.rows = sources;
    }
    if (nclNum.length > 0 && nclNum.length < 45) {
      if (tmsjuhe.status == 0) {
        tmsjuhe.buckets.sort(function (a, b) {
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function (buck) {
          var name = that.tm_gjfl[buck.key];
          var gjfl = {//国际分类
            "key": buck.key,
            "keyvalue": name,
            "keycount": buck.doc_count,
          };
          codes.push(gjfl);
        });
        result.code_counts = codes;
        result.no_code_counts = no_code;
      }
    } else {
      if (tmsjuhe.status == 0) {
        tmsjuhe.buckets.sort(function (a, b) {
          return a.key - b.key;
        });
        Array.prototype.remove = function (val) {
          var index = this.indexOf(val);
          if (index > -1) {
            this.splice(index, 1);
          }
        };
        var num = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
          21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
        tmsjuhe.buckets.forEach(function (buck) {
          var name = that.tm_gjfl[buck.key];
          var gjfl = {//国际分类
            "key": buck.key,
            "keyvalue": name,
            "keycount": buck.doc_count,
          };
          codes.push(gjfl);
          num.remove(Number(buck.key));
        });
        result.code_counts = codes;
        num.forEach(function (n) {
          var name = that.tm_gjfl[n];
          var no_gjfl = {
            "name": name
          }
          no_code.push(no_gjfl);
        });
        result.no_code_counts = no_code;
      }
    }
    if (tmsjuhestatus.status == 0) {
      tmsjuhestatus.buckets.sort(function (a, b) {
        return a.key - b.key;
      });
      tmsjuhestatus.buckets.forEach(function (buck) {
        var name = that.tm_status[buck.key];
        var st = {
          "key": buck.key,
          "keyvalue": name,
          "keycount": buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts = flztstatus;
    }
    if (tmsjuheyear.status == 0) {
      tmsjuheyear.buckets.sort(function (a, b) {
        return b.key - a.key;
      });
      tmsjuheyear.buckets.forEach(function (buck) {
        var year = {
          "key": buck.key,
          "keycount": buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts = year_count;
    }
    // var openId=obj.user.openId
    // var redisdata={
    //   openId:openId,
    //   mark:tmName
    // };
    // var rediscache =await this.GsbByTmSearchApi.redisInsert(redisdata);

    return System.getResult2(result, null);
  }

  async findTrademarkzchAccurate(query,obj) {//通过商标号来进行精准查询
    var result = { rows: [], code_counts: [], status_counts: [], year_counts: [], count: 0 };
    var sources = [];
    var codes = [];
    var flztstatus = [];
    var year_count = [];
    var regNum = obj.regNum == null ? "" : obj.regNum;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var pageSize = obj.pageSize;
    var currentPage = obj.currentPage;
    var ncltwocodesearch = obj.xcl;
    var ncltwo = [];
    for (var i = 0; i < ncltwocodesearch.length; i++) {
      var code = ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var data = {
      regNum: regNum,
      sqlbtabkey: sqlbtabkey,
      flzttabkey: flzttabkey,
      sqnftabkey: sqnftabkey,
      ncltwo: ncltwo,
      pagesize: pageSize,
      page: currentPage
    };
    var tms = await this.GsbByTmSearchApi.tmzchSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbByTmSearchApi.tmzchjuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmzchjuheFlztSearch(data);//根据商标状态聚合
    var tmsjuheyear = await this.GsbByTmSearchApi.tmzchjuheYearSearch(data);//根据商标year聚合
    var that = this;
    if (tms.status == 0) {
      result.count = tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm = tms.data[i];
        if (tm != null) {
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var qunzutms=await this.utilstmSve.getGroupNclInfo(sbdata);
          // var spfwxmlist=[];
          // var codelist=[];
          // if(qunzutms.status==0){
          //   qunzutms.data.exist.forEach(function(c){
          //     if(spfwxmlist.findIndex(f => f == c.small_name) < 0){
          //       spfwxmlist.push(c.small_name)
          //     }
          //     if(codelist.findIndex(f => f ==c.code)<0){
          //       codelist.push(c.code)
          //     }
          //   });
          // }
          // var spfwxm=spfwxmlist.join(",");
          var sbqzlist = [];
          if (tm.ncl_two_codes && tm.ncl_two_codes.length > 0) {
            // console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function (c) {
              if (c) {
                sbqzlist.push(c)
              }
            });
          }
          var sbqz = sbqzlist.join(",");
          var source = {
            sbmc: tm.tm_name,//商标名称
            sbpy: tm.tm_name_py,//商标拼音
            sbyw: tm.tm_name_en,//商标英文
            gjfl: tm.ncl_one_codes,//国际分类
            gjflname: that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
            sbzch: tm.tm_regist_num,//商标注册号
            sblx: that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
            sbzt: that.tm_status[tm.status],//商标状态
            sqrq: that.convertDate(tm.apply_day),//申请日期
            csrq: that.convertDate(tm.first_notice_day),//初审日期
            zcrq: that.convertDate(tm.original_regist_notice_day),//注册日期
            csggym: tm.first_notice_page_num,//初审公告页码
            zcr: tm.applicant_cn,//申请人
            jzrq: that.convertDate(tm.tm_end_day),//截止日期
            csggqh: tm.first_notice_issue == null ? "" : "第" + tm.first_notice_issue + "期",//初审公告（期号）
            zcggqh: tm.regist_notice_issue == null ? "" : "第" + tm.regist_notice_issue + "期",//注册公告
            csgg: tm.first_notice_issue,//初审公告（期号）
            zcgg: tm.regist_notice_issue,//注册公告
            zcggym: tm.regist_notice_page_num,//注册公告页码
            yzcr: tm.original_applicant_cn,//原申请人
            zcdz: tm.applicant_cn_addr,//申请地址
            zcren: tm.applicant_en,//申请人enlish
            zcdzen: tm.applicant_en_addr,//申请地址enlish
            dljg: tm.tm_agency,//代理机构
            zxzt: "",//最新状态
            spfwxm: "",
            lcxx: "",
            sbqz: sbqz,
            logo: tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      result.rows = sources;
    }
    if (tmsjuhe.status == 0) {
      tmsjuhe.buckets.sort(function (a, b) {
        return a.key - b.key;
      });
      tmsjuhe.buckets.forEach(function (buck) {
        var name = that.tm_gjfl[buck.key];
        var gjfl = {//国际分类
          "key": buck.key,
          "keyvalue": name,
          "keycount": buck.doc_count,
        };
        codes.push(gjfl);
      });
      result.code_counts = codes;
    }
    if (tmsjuhestatus.status == 0) {
      tmsjuhestatus.buckets.sort(function (a, b) {
        return b.key - a.key;
      });
      tmsjuhestatus.buckets.forEach(function (buck) {
        var name = that.tm_status[buck.key];
        var st = {
          "key": buck.key,
          "keyvalue": name,
          "keycount": buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts = flztstatus;
    }
    if (tmsjuheyear.status == 0) {
      tmsjuheyear.buckets.sort(function (a, b) {
        return a.key - b.key;
      });
      tmsjuheyear.buckets.forEach(function (buck) {
        var year = {
          "key": buck.key,
          "keycount": buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts = year_count;
    }
    return System.getResult2(result, null);
  }

  async findTrademarkzcr(query, obj) {//通过注册人模糊查询
    console.log(obj);
    var result = { rows: [], code_counts: [], status_counts: [], no_code_counts: [], year_counts: [], namecounts: [], count: 0 };
    var sources = [];
    var codes = [];
    var no_code = [];
    var year_count = [];
    var flztstatus = [];
    var namecount = [];
    var applier = obj.regMan == null ? "" : obj.regMan;
    var zcrname = obj.zcrname == null ? "" : obj.zcrname;
    applier = applier.replace(/[&\|\\\*^%$#@\-]/g, "");
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var pageSize = obj.pageSize;
    var currentPage = obj.currentPage;
    var ncltwocodesearch = obj.xcl;
    var ncltwo = [];
    for (var i = 0; i < ncltwocodesearch.length; i++) {
      var code = ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    var data = {
      applier: applier,
      sqlbtabkey: sqlbtabkey,
      flzttabkey: flzttabkey,
      sqnftabkey: sqnftabkey,
      ncltwo: ncltwo,
      zcrname: zcrname,
      pagesize: pageSize,
      page: currentPage
    };
    var tms = await this.GsbByTmSearchApi.tmzcrSearch(data);//获取查询结果
    var tmsjuhe = await this.GsbByTmSearchApi.tmzcrjuheSearch(data);//获取尼斯大类聚合结果
    var tmsjuhestatus = await this.GsbByTmSearchApi.tmzcrjuheFlztSearch(data);//根据商标状态聚合
    var tmsjuheyear = await this.GsbByTmSearchApi.tmzcrjuheYearSearch(data);//根据商标year聚合
    var tmszcrjuhe = await this.GsbByTmSearchApi.tmzcrjuheapplierSearch(data);//根据商标申请人聚合
    var that = this;
    if (tms.status == 0) {
      result.count = tms.total;
      for (var i = 0; i < tms.data.length; i++) {
        var tm = tms.data[i];
        if (tm != null) {
          // var sbdata={
          //   reg_num:tm.tm_regist_num,
          //   nclone_code:tm.ncl_one_codes
          // };
          // var qunzutms=await this.utilstmSve.getGroupNclInfo(sbdata);
          // var spfwxmlist=[];
          // var codelist=[];
          // if(qunzutms.status==0){
          //   qunzutms.data.exist.forEach(function(c){
          //     if(spfwxmlist.findIndex(f => f == c.small_name) < 0){
          //       spfwxmlist.push(c.small_name)
          //     }
          //     if(codelist.findIndex(f => f ==c.code)<0){
          //       codelist.push(c.code)
          //     }
          //   });
          // }
          // var spfwxm=spfwxmlist.join(",");
          var sbqzlist = [];
          if (tm.ncl_two_codes && tm.ncl_two_codes.length > 0) {
            // console.log(tm.ncl_two_codes);
            tm.ncl_two_codes.forEach(function (c) {
              if (c) {
                sbqzlist.push(c)
              }
            });
          }
          var sbqz = sbqzlist.join(",");
          var source = {
            sbmc: tm.tm_name,//商标名称
            sbpy: tm.tm_name_py,//商标拼音
            sbyw: tm.tm_name_en,//商标英文
            gjfl: tm.ncl_one_codes,//国际分类
            gjflname: that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
            sbzch: tm.tm_regist_num,//商标注册号
            sblx: that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
            sbzt: that.tm_status[tm.status],//商标状态
            sqrq: that.convertDate(tm.apply_day),//申请日期
            csrq: that.convertDate(tm.first_notice_day),//初审日期
            zcrq: that.convertDate(tm.original_regist_notice_day),//注册日期
            csggym: tm.first_notice_page_num,//初审公告页码
            zcr: tm.applicant_cn,//申请人
            jzrq: that.convertDate(tm.tm_end_day),//截止日期
            csggqh: tm.first_notice_issue == null ? "" : "第" + tm.first_notice_issue + "期",//初审公告（期号）
            zcggqh: tm.regist_notice_issue == null ? "" : "第" + tm.regist_notice_issue + "期",//注册公告
            csgg: tm.first_notice_issue,//初审公告（期号）
            zcgg: tm.regist_notice_issue,//注册公告
            zcggym: tm.regist_notice_page_num,//注册公告页码
            yzcr: tm.original_applicant_cn,//原申请人
            zcdz: tm.applicant_cn_addr,//申请地址
            zcren: tm.applicant_en,//申请人enlish
            zcdzen: tm.applicant_en_addr,//申请地址enlish
            dljg: tm.tm_agency,//代理机构
            zxzt: "",//最新状态
            spfwxm: "",
            lcxx: "",
            sbqz: sbqz,
            logo: tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      result.rows = sources;
    }
    if (tmsjuhe.status == 0) {
      tmsjuhe.buckets.sort(function (a, b) {
        return a.key - b.key;
      });
      Array.prototype.remove = function (val) {
        var index = this.indexOf(val);
        if (index > -1) {
          this.splice(index, 1);
        }
      };
      var num = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
        21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
      tmsjuhe.buckets.forEach(function (buck) {
        var name = that.tm_gjfl[buck.key];
        var gjfl = {//国际分类
          "key": buck.key,
          "keyvalue": name,
          "keycount": buck.doc_count,
        };
        codes.push(gjfl);
        num.remove(Number(buck.key));
      });
      result.code_counts = codes;
      num.forEach(function (n) {
        var name = that.tm_gjfl[n];
        var no_gjfl = {
          "name": name
        }
        no_code.push(no_gjfl);
      });
      result.no_code_counts = no_code;
    }
    if (tmsjuhestatus.status == 0) {
      tmsjuhestatus.buckets.sort(function (a, b) {
        return a.key - b.key;
      });
      tmsjuhestatus.buckets.forEach(function (buck) {
        var name = that.tm_status[buck.key];
        var st = {
          "key": buck.key,
          "keyvalue": name,
          "keycount": buck.doc_count,
        };
        flztstatus.push(st);
      });
      result.status_counts = flztstatus;
    }
    if (tmsjuheyear.status == 0) {
      tmsjuheyear.buckets.sort(function (a, b) {
        return b.key - a.key;
      });
      tmsjuheyear.buckets.forEach(function (buck) {
        var year = {
          "key": buck.key,
          "keycount": buck.doc_count,
        };
        year_count.push(year);
      });
      result.year_counts = year_count;
    }
    if (tmszcrjuhe.status == 0) {
      tmszcrjuhe.buckets.sort(function (a, b) {
        return b.key - a.key;
      });
      tmszcrjuhe.buckets.forEach(function (buck) {
        var name = {
          "key": buck.key,
          "keycount": buck.doc_count,
        };
        namecount.push(name);
      });
      result.namecounts = namecount;
    }
    console.log("*********************************************");
    console.log(tmszcrjuhe.buckets);
    return System.getResult2(result, null);
  }

  async imagequery(query, obj) {//图像检索
    var result = { rows: [], code_counts: [], status_counts: [], year_counts: [], count: 0 };
    var sources = [];
    var codes = [];
    var year_count = [];
    var flztstatus = [];
    var key = settings.apiconfig.imageQueryKey;
    var tmUrl = obj.imageUrl;
    var url = this.imageQueryUrl + "?imageurl=" + encodeURIComponent(tmUrl) + "&appkey=" + key;
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execGet({}, url);
      var data = JSON.parse(rtn.stdout);
      if (data[0].length && data[0].length > 0 && data[0] != undefined) {
        var d = data[0];
        result.rows = d;
        var RegistNumsAll = [];
        for (var i = 0; i < d.length; i++) {
          var regNum = d[i];
          RegistNumsAll.push(regNum.imageid);
        }
        var data = {
          tmRegistNumsAll: RegistNumsAll,
        };
        var tmsjuhe = await this.GsbByTmSearchApi.imagesearchjuheNcl(data);//获取ncl聚合结果
        var tmsjuhestatus = await this.GsbByTmSearchApi.imagesearchjuheStatus(data);//根据商标状态聚合
        var tmsjuheyear = await this.GsbByTmSearchApi.imagesearchjuheYear(data);//根据商标year聚合
        var that = this;
        if (tmsjuhe.status == 0) {
          tmsjuhe.buckets.sort(function (a, b) {
            return a.key - b.key;
          });
          tmsjuhe.buckets.forEach(function (buck) {
            var name = that.tm_gjfl[buck.key];
            var gjfl = {//国际分类
              "key": buck.key,
              "keyvalue": name,
              "keycount": buck.doc_count,
            };
            codes.push(gjfl);
          });
          result.code_counts = codes;
        }
        if (tmsjuhestatus.status == 0) {
          tmsjuhestatus.buckets.sort(function (a, b) {
            return a.key - b.key;
          });
          tmsjuhestatus.buckets.forEach(function (buck) {
            var name = that.tm_status[buck.key];
            var st = {
              "key": buck.key,
              "keyvalue": name,
              "keycount": buck.doc_count,
            };
            flztstatus.push(st);
          });
          result.status_counts = flztstatus;
        }
        if (tmsjuheyear.status == 0) {
          tmsjuheyear.buckets.sort(function (a, b) {
            return b.key - a.key;
          });
          tmsjuheyear.buckets.forEach(function (buck) {
            var year = {
              "key": buck.key,
              "keycount": buck.doc_count,
            };
            year_count.push(year);
          });
          result.year_counts = year_count;
        }
        result.count = d.length;
        return System.getResult2(result, null);
      }
      return System.getResult2(result, null);
    } catch (e) {
      console.log(e);
      return System.getResult2(result, null);
    }
    return System.getResult2(result, null);
  }
  async findImageSearch(query, obj) { //图像检索查询，
    var result = { rows: [], code_counts: [], status_counts: [], year_counts: [], count: 0 };
    var sources = [];
    var codes = [];
    var year_count = [];
    var flztstatus = [];
    var cp = obj.pageInfo.pageNo;
    var ps = obj.pageInfo.pageSize;
    var sqlbtabkey = obj.sqlbtabkey == null ? "" : obj.sqlbtabkey;
    var flzttabkey = obj.flzttabkey == null ? "" : obj.flzttabkey;
    var sqnftabkey = obj.sqnftabkey == null ? "" : obj.sqnftabkey;
    var tmRegistNumsAll = obj.tmRegistNumsAll == null ? "" : obj.tmRegistNumsAll;
    var RegistNumsAll = [];
    for (var i = 0; i < tmRegistNumsAll.length; i++) {
      var regNum = tmRegistNumsAll[i];
      RegistNumsAll.push(regNum.imageid);
    }
    var from = Number((cp - 1) * ps);
    var end = Number(from + ps);
    var tmRegistNums = RegistNumsAll.slice(from, end);
    var ncltwocodesearch = obj.xcl;
    var ncltwo = [];
    for (var i = 0; i < ncltwocodesearch.length; i++) {
      var code = ncltwocodesearch[i].code;
      ncltwo.push(code);
    }
    if (sqlbtabkey == "" && flzttabkey == "" && sqnftabkey == "") {
      console.log("---------------------------------=========================================");
      for (var i = 0; i < tmRegistNums.length; i++) {
        var regNum = tmRegistNums[i];
        var data1 = {
          tmRegistNum: regNum
        };
        var tms = await this.GsbByTmSearchApi.imagesearch(data1);
        if (tms.status == 0 && tms.data.length > 0) {
          var tm = tms.data[0];
          var source = {
            sbmc: tm.tm_name,//商标名称
            sbpy: tm.tm_name_py,//商标拼音
            sbyw: tm.tm_name_en,//商标英文
            gjfl: tm.ncl_one_codes,//国际分类
            gjflname: this.tm_gjfl[tm.ncl_one_codes],//国际分类名称
            sbzch: tm.tm_regist_num,//商标注册号
            sblx: this.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
            sbzt: this.tm_status[tm.status],//商标状态
            sqrq: this.convertDate(tm.apply_day),//申请日期
            csrq: this.convertDate(tm.first_notice_day),//初审日期
            zcrq: this.convertDate(tm.original_regist_notice_day),//注册日期
            csggym: tm.first_notice_page_num,//初审公告页码
            zcr: tm.applicant_cn,//申请人
            jzrq: this.convertDate(tm.tm_end_day),//截止日期
            csggqh: tm.first_notice_issue == null ? "" : "第" + tm.first_notice_issue + "期",//初审公告（期号）
            zcggqh: tm.regist_notice_issue == null ? "" : "第" + tm.regist_notice_issue + "期",//注册公告
            csgg: tm.first_notice_issue,//初审公告（期号）
            zcgg: tm.regist_notice_issue,//注册公告
            zcggym: tm.regist_notice_page_num,//注册公告页码
            yzcr: tm.original_applicant_cn,//原申请人
            zcdz: tm.applicant_cn_addr,//申请地址
            zcren: tm.applicant_en,//申请人enlish
            zcdzen: tm.applicant_en_addr,//申请地址enlish
            dljg: tm.tm_agency,//代理机构
            zxzt: "",//最新状态
            spfwxm: "",
            lcxx: "",
            logo: tm.pic_url,//商标图样
          };
          sources.push(source);
        }
      }
      var data = {
        tmRegistNumsAll: RegistNumsAll,
      };
      var tmsjuhe = await this.GsbByTmSearchApi.imagesearchjuheNcl(data);//获取ncl聚合结果
      var tmsjuhestatus = await this.GsbByTmSearchApi.imagesearchjuheStatus(data);//根据商标状态聚合
      var tmsjuheyear = await this.GsbByTmSearchApi.imagesearchjuheYear(data);//根据商标year聚合
      var that = this;
      if (tmsjuhe.status == 0) {
        tmsjuhe.buckets.sort(function (a, b) {
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function (buck) {
          var name = that.tm_gjfl[buck.key];
          var gjfl = {//国际分类
            "key": buck.key,
            "keyvalue": name,
            "keycount": buck.doc_count,
          };
          codes.push(gjfl);
        });
        result.code_counts = codes;
      }
      if (tmsjuhestatus.status == 0) {
        tmsjuhestatus.buckets.sort(function (a, b) {
          return a.key - b.key;
        });
        tmsjuhestatus.buckets.forEach(function (buck) {
          var name = that.tm_status[buck.key];
          var st = {
            "key": buck.key,
            "keyvalue": name,
            "keycount": buck.doc_count,
          };
          flztstatus.push(st);
        });
        result.status_counts = flztstatus;
      }
      if (tmsjuheyear.status == 0) {
        tmsjuheyear.buckets.sort(function (a, b) {
          return b.key - a.key;
        });
        tmsjuheyear.buckets.forEach(function (buck) {
          var year = {
            "key": buck.key,
            "keycount": buck.doc_count,
          };
          year_count.push(year);
        });
        result.year_counts = year_count;
      }
      result.rows = sources;
      result.count = tmRegistNumsAll.length;
      return System.getResult2(result, null);
    } else {
      console.log("0000000000000000000000000000000000000000000000000");
      var data = {
        tmRegistNumsAll: RegistNumsAll,
        sqlbtabkey: sqlbtabkey,
        flzttabkey: flzttabkey,
        sqnftabkey: sqnftabkey,
        ncltwo: ncltwo,
        pagesize: ps,
        page: cp
      };
      var tms = await this.GsbByTmSearchApi.imagesearchbycode(data);
      // console.log(tms);
      var tmsjuhe = await this.GsbByTmSearchApi.imagesearchjuheNcl(data);//获取ncl聚合结果
      var tmsjuhestatus = await this.GsbByTmSearchApi.imagesearchjuheStatus(data);//根据商标状态聚合
      // console.log(tmsjuhestatus);
      var tmsjuheyear = await this.GsbByTmSearchApi.imagesearchjuheYear(data);//根据商标year聚合
      // console.log(tmzchjuheyear);
      var that = this;
      if (tms.status == 0 && tms.data.length > 0) {
        result.count = tms.total;
        tms.data.forEach(function (tm) {
          var source = {
            sbmc: tm.tm_name,//商标名称
            sbpy: tm.tm_name_py,//商标拼音
            sbyw: tm.tm_name_en,//商标英文
            gjfl: tm.ncl_one_codes,//国际分类
            gjflname: that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
            sbzch: tm.tm_regist_num,//商标注册号
            sblx: that.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
            sbzt: that.tm_status[tm.status],//商标状态
            sqrq: that.convertDate(tm.apply_day),//申请日期
            csrq: that.convertDate(tm.first_notice_day),//初审日期
            zcrq: that.convertDate(tm.original_regist_notice_day),//注册日期
            csggym: tm.first_notice_page_num,//初审公告页码
            zcr: tm.applicant_cn,//申请人
            jzrq: that.convertDate(tm.tm_end_day),//截止日期
            csggqh: tm.first_notice_issue == null ? "" : "第" + tm.first_notice_issue + "期",//初审公告（期号）
            zcggqh: tm.regist_notice_issue == null ? "" : "第" + tm.regist_notice_issue + "期",//注册公告
            csgg: tm.first_notice_issue,//初审公告（期号）
            zcgg: tm.regist_notice_issue,//注册公告
            zcggym: tm.regist_notice_page_num,//注册公告页码
            yzcr: tm.original_applicant_cn,//原申请人
            zcdz: tm.applicant_cn_addr,//申请地址
            zcren: tm.applicant_en,//申请人enlish
            zcdzen: tm.applicant_en_addr,//申请地址enlish
            dljg: tm.tm_agency,//代理机构
            zxzt: "",//最新状态
            spfwxm: "",
            lcxx: "",
            logo: tm.pic_url,//商标图样
          };
          sources.push(source)
        });
        result.rows = sources;
      }
      if (tmsjuhe.status == 0) {
        tmsjuhe.buckets.sort(function (a, b) {
          return a.key - b.key;
        });
        tmsjuhe.buckets.forEach(function (buck) {
          var name = that.tm_gjfl[buck.key];
          var gjfl = {//国际分类
            "key": buck.key,
            "keyvalue": name,
            "keycount": buck.doc_count,
          };
          codes.push(gjfl);
        });
        result.code_counts = codes;
      }
      if (tmsjuhestatus.status == 0) {
        tmsjuhestatus.buckets.sort(function (a, b) {
          return a.key - b.key;
        });
        tmsjuhestatus.buckets.forEach(function (buck) {
          var name = that.tm_status[buck.key];
          var st = {
            "key": buck.key,
            "keyvalue": name,
            "keycount": buck.doc_count,
          };
          flztstatus.push(st);
        });
        result.status_counts = flztstatus;
      }
      if (tmsjuheyear.status == 0) {
        tmsjuheyear.buckets.sort(function (a, b) {
          return a.key - b.key;
        });
        tmsjuheyear.buckets.forEach(function (buck) {
          var year = {
            "key": buck.key,
            "keycount": buck.doc_count,
          };
          year_count.push(year);
        });
        result.year_counts = year_count;
      }
      console.log("--------------------------------------------------------------------");
      console.log(result);
      return System.getResult2(result, null);
    }
  }

  async tradeMarkDetail(query, obj) {//商标详情
    // console.log(obj);
    var result = { detaildata: [], nclexist: [], nclnotexist: [] };
    var sbzch = obj.sbzch;
    var gjfl = obj.gjfl;
    var sources = [];
    var data = {
      sbzch: sbzch,
      gjfl: gjfl,
    };
    var data1 = {
      regNum: sbzch
    };
    var detailtms = await this.GsbByTmSearchApi.tradeMarkDetailapi(data);
    // console.log("00000000000000000000000000000000000000000000000000000000");
    // console.log(detailtms);
    var data2 = {
      reg_num: sbzch,
      nclone_code: gjfl
    }
    var qunzutms = await this.utilstmSve.getGroupNclInfo(data2);
    // console.log("11111111111111111111111111111111111111111111111111111");
    // console.log(qunzutms.data);
    if (qunzutms.status == 0) {
      var qunzuexist = [];
      var qunzuexistnorepeat = []
      qunzutms.data.exist.forEach(function (c) {
        var name = c.code + " " + c.small_name;
        if (qunzuexist.indexOf(name) == -1) {
          var codejson = {
            code: c.code,
            small_name: c.small_name
          }
          qunzuexist.push(name)
          qunzuexistnorepeat.push(codejson)
        }

      });
      result.nclexist = qunzuexistnorepeat;
      result.nclnotexist = qunzutms.data.not_exist;
    }

    var tms = await this.GsbByTmSearchApi.getTmFlow(data1);
    var that = this;
    var lcxx = [];
    if (tms.status == 0) {
      tms.data.forEach(function (c) {
        console.log(c);
        var date = that.convertDate(c.notice_data)
        var lc = date + " " + c.notice_type_name
        var lcjson = {
          name: lc,
          link_url: c.link_url
        }
        lcxx.push(lcjson);
      });
    }
    // console.log("lcxx====================================");
    // console.log(lcxx);
    if (detailtms.status == 0 && detailtms.data.length > 0) {
      var tm = detailtms.data[0];
      var source = {
        sbmc: tm.tm_name,//商标名称
        sbpy: tm.tm_name_py,//商标拼音
        sbyw: tm.tm_name_en,//商标英文
        gjfl: tm.ncl_one_codes,//国际分类号
        gjflname: this.tm_gjfl[tm.ncl_one_codes],//国际分类名称
        sbzch: tm.tm_regist_num,//商标注册号
        sblx: this.tm_type[tm.tm_type],//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
        sbzt: this.tm_status[tm.status],//商标状态
        sqrq: this.convertDate(tm.apply_day),//申请日期
        csrq: this.convertDate(tm.first_notice_day),//初审日期
        zcrq: this.convertDate(tm.original_regist_notice_day),//注册日期
        csggym: tm.first_notice_page_num,//初审公告页码
        zcr: tm.applicant_cn,//申请人
        jzrq: this.convertDate(tm.tm_end_day),//截止日期
        csggqh: tm.first_notice_issue == null ? "" : "第" + tm.first_notice_issue + "期",//初审公告（期号）
        zcggqh: tm.regist_notice_issue == null ? "" : "第" + tm.regist_notice_issue + "期",//注册公告
        csgg: tm.first_notice_issue,//初审公告（期号）
        zcgg: tm.regist_notice_issue,//注册公告
        zcggym: tm.regist_notice_page_num,//注册公告页码
        yzcr: tm.original_applicant_cn,//原申请人
        zcdz: tm.applicant_cn_addr,//申请地址
        zcren: tm.applicant_en,//申请人enlish
        zcdzen: tm.applicant_en_addr,//申请地址enlish
        dljg: tm.tm_agency,//代理机构
        lcxx: lcxx,
        logo: tm.pic_url,//商标图样
      };
      sources.push(source);
    }
    // else{
    //   var source={
    //        sbmc:"",//商标名称
    //        sbpy:"",//商标拼音
    //        sbyw:"",//商标英文
    //        gjfl:"",//国际分类
    //        sbzch:sbzch,//商标注册号
    //        gjflname:"",//国际分类名称
    //        sblx:"",//商标类型  p普通商标、J集体商标、Z证明商标、T特殊商标
    //        sbzt:"",//商标状态
    //        sqrq:"",//申请日期
    //        csrq:"",//初审日期
    //        zcrq:"",//注册日期
    //        csggym:"",//初审公告页码
    //        zcr:"",//申请人
    //        jzrq:"",//截止日期
    //        csggqh:"",//初审公告（期号）
    //        zcggqh:"",//注册公告
    //        zcggym:"",//注册公告页码
    //        yzcr:"",//原申请人
    //        zcdz:"",//申请地址
    //        dljg:"",//代理机构
    //        zxzt:"",//最新状态
    //        spfwxm:"",
    //        lcxx:"",
    //        logo:"",//商标图样
    //   };
    //   sources.push(source);
    // }
    result.detaildata = sources;
    // console.log(result);
    return System.getResult2(result, null);
  }

  async nclFuwuSearch(query, obj) {
    var result = { rows: [], count: 0 };
    var nclfuwu = obj.nclfuwu;
    var pageSize = obj.pageSize;
    var currentPage = obj.currentPage;
    var sources = [];
    var data = {
      nclfuwu: nclfuwu,
      pagesize: pageSize,
      page: currentPage
    }
    var fuwutms = await this.GsbByTmSearchApi.getNclByLikeName(data);
    var ncltwo = {
      level: 2
    }
    var tmpGetTwoNclList = await this.GsbByTmSearchApi.getNcl(ncltwo);
    var getTwoNclList = tmpGetTwoNclList.data;
    console.log("00000000000000000000000000000000000000000000000000000000");
    // console.log(fuwutms);
    // console.log(tmpGetTwoNclList);
    var that = this;
    if (fuwutms.status == 0) {
      fuwutms.data.forEach(function (tm) {
        // console.log(tm);
        var tmpTwoNclFind = getTwoNclList.find(f => (f.code == tm.pid));
        // console.log(tmpTwoNclFind);
        // console.log("------------------------------------------");
        console.log(tm);
        console.log("+++++++++++++++++++++++++");
        console.log(tmpTwoNclFind);
        var source = {
          nclthreecode: tm.code,//三类尼斯编号
          nclthreename: tm.name,//三类尼斯名字
          ncltwocode: tmpTwoNclFind.code,//二类尼斯编号
          ncltwoname: tmpTwoNclFind.name,//三类尼斯名字
          nclonecode: tmpTwoNclFind.pid,//国际分类
          nclonename: that.tm_gjfl[Number(tmpTwoNclFind.pid)],//国际分类名称
        };
        sources.push(source);
      });
      result.count = fuwutms.total;
      result.rows = sources;
    }
    console.log(result);
    return System.getResult2(result, null);
  }

  async gettwoNcl(query, obj) {
    var result = { rows: [] };
    var pid = obj.code;
    console.log("-------------------------------");
    var sources = [];
    if (pid.length == 1) {
      pid = "0" + pid;
    }
    var data = {
      "pid": pid
    }
    var tmpGetTwoNclList = await this.GsbByTmSearchApi.gettwoNclList(data);
    var that = this;
    if (tmpGetTwoNclList.status == 0) {
      tmpGetTwoNclList.data.forEach(function (tm) {
        var source = {
          code: tm.code,//2类尼斯编号
          name: tm.name//2类尼斯名字
        };
        sources.push(source);
      });
      result.rows = sources;
    }
    return System.getResult2(result, null);
  }

  async noticequery(query, obj) {
    var result = { rows: [], count: "" };
    var sources = [];
    var noticenumber = obj.noticenumber;
    var applynumber = obj.applynumber;
    var tmname = obj.tmname;
    var applier = obj.applier;
    var noticetype = obj.noticetype;
    var nclNum = obj.nclNum;
    var pageSize = obj.pageSize;
    var currentPage = obj.currentPage;
    var data = {
      noticenumber: noticenumber,
      applynumber: applynumber,
      tmname: tmname,
      applier: applier,
      noticetype: noticetype,
      nclNum: nclNum,
      pagesize: pageSize,
      page: currentPage
    }

    var notice = await this.GsbByTmSearchApi.noticeQueryAPi(data);
    console.log(notice);
    if (notice.status == 0) {
      result.count = notice.total;
      for (var i = 0; i < notice.data.length; i++) {
        var tm = notice.data[i];
        var ncls = "";
        if (tm != null) {
          tm.ncl_ones.sort(function (a, b) {
            return a - b;
          });
          console.log(tm.ncl_ones);
          tm.ncl_ones.forEach(function (c) {
            ncls = ncls + c + " ";
          });
          var source = {
            sbmc: tm.tm_name,//商标名称
            sbzch: tm.tm_regist_num,//商标号
            sblb: ncls,//类别
            zcr: tm.proposer,//申请人
            ggqh: tm.notice_issue + "(" + this.convertDate(tm.notice_data) + ")",//公告期号
            pagenumber: tm.page_no,//公告页码
            gglx: tm.notice_type_name,//公告类型
            linkurl: tm.link_url,   //连接地址
            logo: tm.pic_url //图片地址
          };
        }
        sources.push(source);
      }
    }
    result.rows = sources;
    return System.getResult2(result, null);
  }

  async getNclDetail(query, obj) {
    var result = { classification: "", construction: "", data: [] };
    var onecode = obj.number;
    var sources = [];
    if (onecode.length == 1) {
      onecode = "0" + onecode;
    }
    var data = {
      onecode: onecode
    }
    var tmpGetOneNcl = await this.GsbByTmSearchApi.getNclOne(data);
    console.log("nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn");
    console.log(tmpGetOneNcl);
    if (tmpGetOneNcl.status == 0) {
      var tm = tmpGetOneNcl.data[0];
      result.classification = "第" + tm.code + "类-" + tm.name;
      result.construction = tm.description;
    }
    var data1 = {
      pid: onecode
    }
    var that = this;
    var tmpGetTwoNclList = await this.GsbByTmSearchApi.gettwoNclList(data1);
    console.log(tmpGetTwoNclList);
    if (tmpGetTwoNclList.status == 0) {
      for (var i = 0; i < tmpGetTwoNclList.data.length; i++) {
        var tm = tmpGetTwoNclList.data[i];
        if (tm != null) {
          var smallclassification = tm.code + " " + tm.name;
          console.log(tm);
          var piddata = {
            twopid: tm.code,
          };
          var threeNcllist = await that.GsbByTmSearchApi.getthreeNclList(piddata);
          console.log("------------------------------------------------------");
          // console.log(threeNcllist);
          var content = "";
          var xinzeng = "";
          if (threeNcllist.status == 0) {
            threeNcllist.data.forEach(function (t) {
              if (t.code) {
                content = t.name + t.code + "," + content;
              } else {
                xinzeng = t.name + "," + xinzeng;
              }
            });
          }
          var source = {
            smallclassification: smallclassification,
            content: content,
            xinzeng: xinzeng
          }
        }
        sources.push(source);
      }
    }
    console.log(sources);
    result.data = sources;
    return System.getResult2(result, null);
  }

  async aibynclone(obj, pobj) {
    var tmName = pobj.tmName;
    var nclonecode = pobj.nclonecode;
    var result = {};
    if (tmName == null || tmName == '' || tmName == 'undefined') {
      result = { code: -1, msg: "参数错误", data: null };
    }
    var rate = await this.GsbByTmSearchApi.tmncloneSearch(pobj);
    result = { code: 1, msg: "成功", data: rate };
    return System.getResult2(result, null);
  }

  async rediscache(query, obj) {
    var result = { redislist: [] };
    var openId = obj.user.openId
    var mark = obj.mark;
    var data = {
      openId: openId,
      mark: mark
    };
    var rediscache = await this.GsbByTmSearchApi.opCache(data);
    console.log(rediscache);
    if (rediscache.code == 1) {
      result.redislist = rediscache.data.reverse();
    }
    return System.getResult2(result, null);
  }

  async noticesearch(query, obj) {
    var result = { sbmc: "", linkurl: "" };
    var sbzch = obj.sbzch;
    var csggqh = obj.csggqh;

    var data = {
      sbzch: sbzch,
      csggqh: csggqh
    };
    var notice = await this.GsbByTmSearchApi.noticeSearch(data);
    console.log(notice);
    if (notice.status == 0) {
      if (notice.data.length > 0) {
        result.sbmc = notice.data[0].tm_name;
        result.linkurl = notice.data[0].link_url;
      }
    }
    return System.getResult2(result, null);
  }
  async noticezcggsearch(query, obj) {
    var result = { sbmc: "", linkurl: "" };
    var sbzch = obj.sbzch;
    var zcggqh = obj.zcggqh;

    var data = {
      sbzch: sbzch,
      zcggqh: zcggqh
    };
    var notice = await this.GsbByTmSearchApi.noticezcgg(data);
    console.log(notice);
    if (notice.status == 0) {
      if (notice.data.length > 0) {
        result.sbmc = notice.data[0].tm_name;
        result.linkurl = notice.data[0].link_url;
      }
    }
    return System.getResult2(result, null);
  }
  async sbzuixinsearch() {
    var result = { zuixinshouli: "", zuixinchushen: "", zuixinxiazheng: "" };
    var zuixinshouli = await this.GsbByTmSearchApi.sbzuixinsearchapi();
    var zuixinchushen = await this.GsbByTmSearchApi.sbzuixinchushen();
    var zuixinxiazheng = await this.GsbByTmSearchApi.sbzuixinxiazheng();
    console.log("============================");
    console.log(zuixinshouli);
    if (zuixinshouli.status == 0) {
      var shouli = zuixinshouli.data[0];
      result.zuixinshouli = shouli.apply_day_format;
    }
    if (zuixinchushen.status == 0) {
      var chushen = zuixinchushen.data[0];
      result.zuixinchushen = chushen.apply_day_format;
    }
    if (zuixinxiazheng.status == 0) {
      var xiazheng = zuixinxiazheng.data[0];
      result.zuixinxiazheng = xiazheng.apply_day_format;
    }
    console.log(result);
    return System.getResult2(result, null);
  }
  async noticequeryTMZCSQ(query, obj) {
    var result = { rows: [], selectdata: [] };
    var sources = [];
    var selects = []
    var data = {
      noticetype: "TMZCSQ"
    }
    var that = this;
    var notice = await this.GsbByTmSearchApi.noticeQueryTMZCSQ(data);
    console.log(notice);
    if (notice.status == 0) {
      notice.buckets.forEach(function (buck) {
        var notice_issue = buck.notice_issue;
        var date = that.convertDate(buck.date);
        var enddate = that.convertDate1(buck.date);
        var sdate = new Date();
        var now = new Date(enddate);
        var days = now.getTime() - sdate.getTime();
        var day = parseInt(days / (1000 * 60 * 60 * 24));
        var lastday = "";
        if (day > 0) {
          lastday = "剩余" + day + "天";
        } else {
          lastday = "已过期" + Math.abs(day) + "天";
        }
        var source = {
          "notice_issue": notice_issue,
          "date": date,
          "enddate": enddate,
          "lastday": lastday
        };
        sources.push(source);
        var select = {
          value: notice_issue,
          label: notice_issue + " (" + date + ")"
        };
        selects.push(select);
      });
    }
    result.rows = sources;
    result.selectdata = selects;
    console.log(result);
    return System.getResult2(result, null);
  }
  //企业核名
  async icheming(query, obj) {
    var result = {};
    var cityname = obj.cityname;
    var keyword = obj.keyword;
    var btname = obj.btname;
    var orgname = obj.orgname;
    var sitcity = obj.sitcity;
    var heming = {
      "cityname": cityname,
      "keyword": keyword,
      "btname": btname,
      "orgname": orgname,
      "sitcity": sitcity
    }
    var url = this.ichemingUrl;
    var rc = System.getObject("util.execClient");
    var rtn = null;
    try {
      rtn = await rc.execPost(heming, url);
      var data = JSON.parse(rtn.stdout);
      console.log("heming++++++++++++++++++++++++++++++++++++++++++++++++++++++");
      console.log(data);
      return System.getResult2(data, null);
    } catch (e) {
      console.log(e);
      return System.getResult2(result, null);
    }
    return System.getResult2(result, null);
  }

  async getCompanyInfoNoUser(queryobj, qobj, req) {
    var result = {
      code: 1,
      message: "success",
      data: null
    };
    try {
      var tCompanyName = qobj.company_name || "";
      if (!tCompanyName || tCompanyName == "undefined") {
        // result.code = -102;
        // result.message = "company_name参数有误";
        return System.getResultFail(-200, "company_name参数有误");
      }
      var query = { isVerify: -1, companyName: tCompanyName };
      var tResult = await this.gsbicsearch.companyonesearch(query);
      console.log("------------------------------");
      console.log(tResult);
      if (tResult.status == 0 && tResult.data.list.length > 0) {
        // result.data = tResult.data.list[0];
        return System.getResultSuccess(tResult.data.list[0], null);
      } else {
        return System.getResultFail(-100, "未知企业");
      }
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "获取标眼查商标监控工商信息Error",
        op: "base/controller/impl/bytmmonitCtl/getCompanyInfo",
        content: e.stack,
        clientIp: req.clientIp
      });
      return System.getResultFail(-201, "操作失败");
    }
  }

  //-------------------商标大数据聚合检索 start--------------------------//


  //商标统计接口总量、有效、申请
  async tmstatistics(query,obj){
    console.log("tttttttttttttttttmstatisticsttttttttttttttttttt");
    console.log(obj);
    var result ={tmtotal:"",tmzctotal:"",tmsqtotal:""};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.patentycSve.getprovincenameorder(apply_addr_province);
      this.logCtl.info({
        optitle: "商标统计接口总量、有效、申请返回信息----apply_addr_province",
        op: "",
        content: apply_addr_province,
        clientIp:  ""
      });
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    var tm =await this.tmquerySve.bigtmcount(tmobj);//商标总量接口
    this.logCtl.info({
      optitle: "商标统计接口总量、有效、申请返回信息----tm",
      op: "",
      content: JSON.stringify(tm),
      clientIp:  ""
    });
    // console.log(sqtm);
    if(tm.status==0){
      result.tmtotal=tm.data.tmtotal;
    }
    var zctm =await this.tmquerySve.bigtmregistcount(tmobj);//商标有效注册量
    this.logCtl.info({
      optitle: "商标统计接口总量、有效、申请返回信息----zctm",
      op: "",
      content: JSON.stringify(zctm),
      clientIp:  ""
    });
    // console.log(zctm);
    if(zctm.status==0){
      result.tmzctotal=zctm.data.tmregtotal;
    }
    var sqtm =await this.tmquerySve.bigtmapplicationcount(tmobj);//商标申请中总量
    this.logCtl.info({
      optitle: "商标统计接口总量、有效、申请返回信息----sqtm",
      op: "",
      content: JSON.stringify(sqtm),
      clientIp:  ""
    });
    // console.log(zctm);
    if(sqtm.status==0){
      result.tmsqtotal=sqtm.data.tmsqtotal;
    }
    console.log("================================");
    console.log(result);
    this.logCtl.info({
      optitle: "商标统计接口总量、有效、申请返回信息----result",
      op: "",
      content: JSON.stringify(result),
      clientIp:  ""
    });
    return System.getResult2(result,null);
  }

  //商标统计接口公司总量
  async tmcompanystatistics(query,obj){
    console.log("ttttttttttttttttttttttttttttttttttt");
    console.log(obj);
    var result ={tmgstotal:""};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.patentycSve.getprovincenameorder(apply_addr_province);
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    var gstm =await this.tmquerySve.bigtmcompanycount(tmobj);//商标企业总量
    if(gstm.status==0){
      result.tmgstotal=gstm.data.tmcompanytotal;
    }
    console.log("================================");
    console.log(result);
    return System.getResult2(result,null);
  }

  //商标地区分布统计排名
  async tmaddrstatisticsrank(query,obj){
    console.log("ttttttttttttttttttttttttttttttttttt");
    console.log(obj);
    var result ={maplist:[],tmaddrrank:[]};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.patentycSve.getprovincenameorder(apply_addr_province);
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    if(apply_addr_province!=""&&apply_addr_province!=null){
      var citys = this.provincecity[apply_addr_province];
      console.log(citys);
      //商标地区排名省份
      var tmaddr =await this.tmquerySve.bigtmaddrrank(tmobj);
      if(tmaddr.status==0){
        // console.log("ppppppppppppppppppppppppppppppppppppppp");
        // console.log(tmaddr.data.tmaddrrank);
        var maps=[];
        var sources =[];
        for(var i=0;i<tmaddr.data.tmaddrrank.length;i++){
          if(citys.indexOf(tmaddr.data.tmaddrrank[i].code)>=0){
            var ss = {
              "areaname":tmaddr.data.tmaddrrank[i].code,
              "areacount":tmaddr.data.tmaddrrank[i].count
            }
            var mp={
              "name":tmaddr.data.tmaddrrank[i].code,
              "value":tmaddr.data.tmaddrrank[i].count
            }
            maps.push(mp);
            sources.push(ss);
          }
        }
        var tk = [];
        if(sources.length>0){
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.maplist=maps;
          result.tmaddrrank=tk;
        }
      }
    }else{//全国查询
      //商标地区排名省份
      var tmaddr =await this.tmquerySve.bigtmaddrrank(tmobj);
      console.log(tmaddr);
      var sources =[];
      var maps=[];
      if(tmaddr.status==0){
        for(var i=0;i<tmaddr.data.tmaddrrank.length;i++){
          if(this.province.indexOf(tmaddr.data.tmaddrrank[i].code)>=0){
            var areaname = await this.patentycSve.getprovincename(tmaddr.data.tmaddrrank[i].code);
            var ss = {
              "areaname":tmaddr.data.tmaddrrank[i].code,
              "areacount":tmaddr.data.tmaddrrank[i].count
            }
            var mp={
              "name":areaname,
              "value":tmaddr.data.tmaddrrank[i].count
            }
            sources.push(ss);
            maps.push(mp);
          }
        }
        if(sources.length>0){
          var tk = [];
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.tmaddrrank=tk;
          result.maplist=maps;
        }
      }
    }
    console.log("================================");
    console.log(result);
    return System.getResult2(result,null);
  }

  //商标企业分布统计排名
  async tmcompanystatisticsrank(query,obj){
    console.log("ttttttttttttttttttttttttttttttttttt");
    console.log(obj);
    var result ={tmcompanyrank:[]};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.patentycSve.getprovincenameorder(apply_addr_province);
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    var citys = this.provincecity[apply_addr_province];
    if(apply_addr_province!=""&&apply_addr_province!=null){
      //商标企业排名
      var tmcompany =await this.tmquerySve.bigtmcompanyrank(tmobj);
      if(tmcompany.status==0){
        var sources =[];
        for(var i=0;i<tmcompany.data.tmcompanyrank.length;i++){
          if(citys.indexOf(tmcompany.data.tmcompanyrank[i].code)>=0){
            var ss = {
              "areaname":tmcompany.data.tmcompanyrank[i].code,
              "areacount":tmcompany.data.tmcompanyrank[i].count.value
            }
            sources.push(ss);
          }
        }
        if(sources.length>0){
          sources.sort(function(a,b){
            return b.areacount - a.areacount;
          });
          var tk = [];
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.tmcompanyrank=tk;
        }
      }
    }else{//全国查询
      //商标企业排名
      var tmcompany =await this.tmquerySve.bigtmcompanyrank(tmobj);
      if(tmcompany.status==0){
        var sources =[];
        for(var i=0;i<tmcompany.data.tmcompanyrank.length;i++){
          if(this.province.indexOf(tmcompany.data.tmcompanyrank[i].code)>=0){
            var areaname = await this.patentycSve.getprovincename(tmcompany.data.tmcompanyrank[i].code);
            var ss = {
              "areaname":areaname,
              "areacount":tmcompany.data.tmcompanyrank[i].count.value
            }
            sources.push(ss);
          }
        }
        if(sources.length>0){
          sources.sort(function(a,b){
            return b.areacount - a.areacount;
          });
          var tk = [];
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.tmcompanyrank=tk;
        }
      }
    }
    console.log("================================");
    console.log(result);
    return System.getResult2(result,null);
  }

  //商标类别申请排名
  async tmnclstatisticsrank(query,obj){
    console.log("ttttttttttttttttttttttttttttttttttt");
    console.log(obj);
    var result ={tmnclrank:[]};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.patentycSve.getprovincenameorder(apply_addr_province);
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    //商标大类排名
    var tmncl =await this.tmquerySve.bigtmnclrank(tmobj);
    var codes=["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13",
      "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
      "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
      "40", "41", "42", "43", "44", "45"];
    if(tmncl.status==0){
      var sources=[];
      for(var k=0;k<tmncl.data.tmnclrank.length;k++){
        if(codes.indexOf(tmncl.data.tmnclrank[k].code)>=0){
          // sqtotal.code=sqtm.data.tmcount[i].count;
          sources.push({
            "code":tmncl.data.tmnclrank[k].code,
            "count":tmncl.data.tmnclrank[k].count,
          });
        }
      }
      if(sources.length>0){
        var tk = [];
        var sum = sources[0].count;
        for(var i=0;i< sources.length;i++){
          var bf = parseInt(100*(sources[i].count/sum));
          var ss = {
            "code":sources[i].code,
            "count":sources[i].count,
            "hundred":bf
          }
          tk.push(ss);
        }
        result.tmnclrank=tk;
      }
    }
    console.log("================================");
    console.log(result);
    return System.getResult2(result,null);
  }

  //商标申请及注册趋势
  async tmtrend(query,obj){
    var result={sqtrend:{name:"商标申请",data:[]},zctrend:{name:"商标注册",data:[]}};
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.patentycSve.getprovincenameorder(apply_addr_province);
    }
    var sq2019=0;
    var sq2018=0;
    var sq2017=0;
    var sq2016=0;
    var sq2015=0;
    var sq2014=0;
    var sqobj={
      apply_addr_province:apply_addr_province,
      status:1,
      seltype:5
    };
    var sqtm =await this.tmquerySve.bigtmtrend(sqobj);//商标申请趋势
    if(sqtm.status==0){
      for(var i in sqtm.data.tmtrend){
        if(sqtm.data.tmtrend[i].code==2019){
          sq2019=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2018){
          sq2018=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2017){
          sq2017=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2016){
          sq2016=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2015){
          sq2015=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2014){
          sq2014=sqtm.data.tmtrend[i].count;
        }
      }
      result.sqtrend.data.push(sq2014);
      result.sqtrend.data.push(sq2015);
      result.sqtrend.data.push(sq2016);
      result.sqtrend.data.push(sq2017);
      result.sqtrend.data.push(sq2018);
      result.sqtrend.data.push(sq2019);
    }
    var zcobj={
      apply_addr_province:apply_addr_province,
      status:3,
      seltype:4
    };
    var zctm =await this.tmquerySve.bigtmtrend(zcobj);//商标注册趋势
    var zc2019=0;
    var zc2018=0;
    var zc2017=0;
    var zc2016=0;
    var zc2015=0;
    var zc2014=0;
    if(zctm.status==0){
      for(var j in zctm.data.tmtrend){
        if(zctm.data.tmtrend[j].code==2019){
          zc2019=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2018){
          zc2018=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2017){
          zc2017=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2016){
          zc2016=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2015){
          zc2015=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2014){
          zc2014=zctm.data.tmtrend[j].count;
        }
      }
      result.zctrend.data.push(zc2014);
      result.zctrend.data.push(zc2015);
      result.zctrend.data.push(zc2016);
      result.zctrend.data.push(zc2017);
      result.zctrend.data.push(zc2018);
      result.zctrend.data.push(zc2019);
    }
    return System.getResult2(result,null);
  }
}
module.exports = tmqueryApi;
