var System=require("../../../system");
var settings=require("../../../../config/settings");
const ApiBase = require("../../api.base");
var pinyin = require("pinyin");
class tmtransactionApi extends ApiBase{
  constructor(){
    super();
    this.GsbByTmSearchApi=System.getObject("api.trademark.tmsearch");
    this.utilstmSve=System.getObject("service.trademark.utilstmSve");
    this.utilstmTransactionSve = System.getObject("service.trademark.utilstmTransactionSve");
    this.tm_status={1:"申请中",2:"已初审",3:"已注册",4:"已无效",5:"其他"};
    this.tm_gjfl={1:"01类 化学原料",2:"02类 颜料油漆",3:"03类 日化用品",4:"04类 燃料油脂",5:"05类 医药",6:"06类 金属材料",7:"07类 机械设备",8:"08类 手工器械",9:"09类 科学仪器",
                  10:"10类 医疗器械",11:"11类 灯具空调",12:"12类 运输工具",13:"13类 军火烟火",14:"14类 珠宝钟表",15:"15类 乐器",16:"16类 办公用品",17:"17类 橡胶制品",18:"18类 皮革皮具",19:"19类 建筑材料",20:"20类 家具",21:"21类 厨房洁具",22:"22类 绳网袋蓬",23:"23类 纱线丝",24:"24类 布料床单",
                  25:"25类 服装鞋帽",26:"26类 钮扣拉链",27:"27类 地毯席垫",28:"28类 健身器材",29:"29类 食品",30:"30类 方便食品",31:"31类 农林生鲜",32:"32类 啤酒饮料",33:"33类 酒",34:"34类 烟草烟具",35:"35类 广告销售",36:"36类 金融物管",37:"37类 建筑修理",38:"38类 通讯服务",
                  39:"39类 运输贮藏",40:"40类 材料加工",41:"41类 教育娱乐",42:"42类 科技服务",43:"43类 餐饮住宿",44:"44类 医疗园艺",45:"45类 社会服务"};
  }
  convertDate(time){
    if(time==null){
      return "";
    }
    var date =  new Date(Number(time*1000));
    var y = 1900+date.getYear();
    var m = "0"+(date.getMonth()+1);
    var d = "0"+date.getDate();
    return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
 }
  //商标交易检索
  async tmTransactionSearch(query,obj){
      console.log("----------------------");
      console.log(obj);
      var result={rows:[],total:""};
      var sources=[];
      var codes=[];
      var keyword=obj.keyword;
      var tm_nclcode=obj.tm_nclcode;
      var price_min = obj.min;
      var price_max = obj.max;
      var tm_structure=obj.tm_structure;
      if(obj.tm_word == '1-2个字'){
        var tm_word = 2;
      }else if(obj.tm_word == '3个字'){
        var tm_word = 3;
      }else if(obj.tm_word == '4个字'){
        var tm_word = 4;
      }else if(obj.tm_word == '5个字'){
        var tm_word = 5;
      }else if(obj.tm_word == '5个字以上'){
        var tm_word = 6;
      }else{
        var tm_word ='';
      }
      var order_field='';
      if(obj.order == "价格"){
        order_field= "platform_quoted_price";
      }else if(obj.order == "时间"){
        order_field= "created_at";
      }
      var sort = obj.sort;
      var pagesize=obj.pagesize;
      var currentpage=obj.currentpage;
      var data={
        keyword:keyword,
        tm_nclcode:tm_nclcode,
        price_min:price_min,
        price_max:price_max,
        tm_structure:tm_structure,
        tm_word:tm_word,
        order_field:order_field,
        sort:sort,
        pagesize:pagesize,
        currentpage:currentpage
      };
      console.log("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzjjjjjjjjjjjjjjjjjj");
      console.log(data);
      var that = this;
      var tms =await this.utilstmTransactionSve.tmTransactionSearch(data);//获取查询结果
      // console.log(tms);
      if(tms.status==0){
        result.total=tms.total;
        tms.data.forEach(function(tm){
          var source={
               tm_name:tm.tm_name,//商标名称
               platform_quoted_price:tm.platform_quoted_price,//平台售价
               ncl_one_codes:tm.ncl_one_codes,//尼斯大类
               ncl_one_codes_name:that.tm_gjfl[tm.ncl_one_codes],//国际分类名称
               tm_regist_num:tm.tm_regist_num,//注册号
               pic_url:tm.pic_url,                          //图片url
               pic_url_user:tm.pic_url_user                //用户自己上传的图片url
             }
            sources.push(source)
        });
        result.rows=sources;
      }
      console.log("=====================+++++++++++++++++++++++++");
      // console.log(result);
      return System.getResult2(result,null);
  }
  async tmTransactionDetail(query,obj){//商标交易详情接口
    console.log(obj);
    var result={detail:{}};
    var sbzch=obj.sbzch;
    var gjfl=obj.gjfl;
    var data={
      sbzch:sbzch,
      gjfl:gjfl,
    };
    var that = this;
    var detailtms= await this.GsbByTmSearchApi.tradeMarkDetailapi(data);
    var ts= await this.utilstmTransactionSve.tmTransactionDetailsve(data);//获取查询结果
    var data2={
      reg_num:sbzch,
      nclone_code:gjfl
    }
    var qunzutms=await this.utilstmSve.getGroupNclInfo(data2);
    var spfwxmlist=[];
    var codelist=[];
    if(qunzutms.status==0){
      qunzutms.data.exist.forEach(function(c){
        if(spfwxmlist.findIndex(f => f == c.small_name) < 0){
          spfwxmlist.push(c.small_name)
        }
        if(codelist.findIndex(f => f ==c.code)<0){
          codelist.push(c.code)
        }
      });
    }
    var spfwxm=spfwxmlist.join(",");
    var codes=codelist.join(",");
    var sbmc="";
    var gjfl="";
    var gjflname="";
    var sbzch="";
    var sbzt="";
    var sqrq="";
    var csrq="";
    var zcrq="";
    var zcr="";
    var jzrq="";
    var yzcr="";
    var zcdz="";
    var dljg="";
    var logo="";
    var pic_url_user="";
    var platform_quoted_price="";
    var tm_introduction="";
    if(detailtms.status == 0 && detailtms.data.length>0){
      var tm=detailtms.data[0];
      sbmc=tm.tm_name;//商标名称
      gjfl=tm.ncl_one_codes;//国际分类
      gjflname=that.tm_gjfl[tm.ncl_one_codes];//国际分类名称
      sbzch=tm.tm_regist_num;//商标注册号
      sbzt=that.tm_status[tm.status];//商标状态
      sqrq=that.convertDate(tm.apply_day);//申请日期
      csrq=that.convertDate(tm.first_notice_day);//初审日期
      zcrq=that.convertDate(tm.original_regist_notice_day);//注册日期
      zcr=tm.applicant_cn;//申请人
      jzrq=that.convertDate(tm.tm_end_day) ;//截止日期
      yzcr=tm.original_applicant_cn;//原申请人
      zcdz=tm.applicant_cn_addr;//申请地址
      dljg=tm.tm_agency;//代理机构
      logo=tm.pic_url;//商标图样
    }
    if(ts.status == 0 && ts.data.length>0){
      var tm=ts.data[0];
      platform_quoted_price=tm.platform_quoted_price;//平台售价
      tm_introduction=tm.tm_introduction;//商标简介
      pic_url_user=tm.pic_url_user;      //用户自己上传的图片url
    }
    result.detail={
      sbmc:sbmc,//商标名称
      gjfl:gjfl,//国际分类
      gjflname:gjflname,//国际分类名称
      sbzch:sbzch,//商标注册号
      sbzt:sbzt,//商标状态
      sqrq:sqrq,//申请日期
      csrq:csrq,//初审日期
      zcrq:zcrq,//注册日期
      zcr:zcr,//申请人
      jzrq:jzrq,//截止日期
      yzcr:yzcr,//原申请人
      zcdz:zcdz,//申请地址
      dljg:dljg,//代理机构
      logo:logo,//商标图样
      spfwxm:spfwxm,//商品/服务项
      codes:codes,//群组
      pic_url_user:pic_url_user,     //用户自己上传的图片url
      platform_quoted_price:platform_quoted_price,//平台售价
      tm_introduction:tm_introduction//商标简介
    }
    console.log(result);
    return System.getResult2(result,null);
  }

}
module.exports=tmtransactionApi;
