const system = require("../../../system");
const Dao = require("../../dao.base");
class AppUserDao extends Dao {
  constructor() {
    super(Dao.getModelName(AppUserDao));
  }
  async getItemByChannelUserId(appKey) {
    return this.model.findOne({
      where: {
        uappKey: appKey
      },
      attributes: ["id",
        "app_id",           //  应用id                                                        
        "channelUserId",  //  渠道用户ID  
        "channelUserName",     //  渠道用户登录名   
        "uUserId",    //  平台用户Id                                                     
        "userMoblie",  //  用户手机号                                                     
        "nickname",   //  昵称                                             
        "orgName",        //  组织结构名称                                                    
        "orgPath",      //  组织结构路径                       
        "isEnabled"],
      raw: true
    });
  }
}
module.exports = AppUserDao;
