const system = require("../../../system");
const Dao = require("../../dao.base");
class CustomerInfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(CustomerInfoDao));
  }
  async findOneByCodeAndUserId(code, userId) {
    return this.model.findOne({
      where: {
        code: code,
        createuser_id: userId
      },
      attributes: ["id",
        "customerType",// ent:企业，person:个人 
        "customerTypeName",
        "identityCardPic",//身份证图片
        "businessLicensePic",//营业执照图片       
        "name",//公司名称或个人名称
        "code",//公司统一社会代码   
        "app_id",
        "deliveryOrderNo",
        "applyAddr",//申请地址
        "applyArea",//存储省市编码
        "province",//省
        "city",//市
        "identityCardNo",//身份证号
        "notes",//备注
        "zipCode",
        "identityCardPdf",
        "businessLicensePdf",
        "createuser_id",
        "updateuser_id",
        "owner_id"],
      raw: true
    });
  }
  async findOneByDeliveryOrderNo(deliveryOrderNo) {
    return this.model.findOne({
      where: {
        deliveryOrderNo: deliveryOrderNo
      },
      attributes: ["id",
        "customerType",// ent:企业，person:个人 
        "customerTypeName",
        "identityCardPic",//身份证图片
        "businessLicensePic",//营业执照图片       
        "name",//公司名称或个人名称
        "code",//公司统一社会代码   
        "app_id",
        "deliveryOrderNo",
        "applyAddr",//申请地址
        "applyArea",//存储省市编码
        "province",//省
        "city",//市
        "identityCardNo",//身份证号
        "notes",//备注
        "zipCode",
        "identityCardPdf",
        "businessLicensePdf",
        "createuser_id",
        "updateuser_id",
        "owner_id"],
      raw: true
    });
  }
}
module.exports = CustomerInfoDao;
