const system = require("../../../system");
const Dao = require("../../dao.base");
class PushBusinessDao extends Dao {
  constructor() {
    super(Dao.getModelName(PushBusinessDao));
  }
  async getItemByUappKey(uappKey, reqEnv) {
    return this.model.findOne({
      where: {
        uappKey: uappKey,
        reqEnv: reqEnv
      },
      attributes: ["id",
        "sourceCode",
        "sourceName",
        "uappKey",
        "aliAppkey",
        "aliSecret",
        "status",
        "pushSveUrl",
        "pushProductId",
        "sveProductId",
        "reqEnv",
        "notes"],
      raw: true
    });
  }
}
module.exports = PushBusinessDao;
