const System = require("../../../system");
var settings = require("../../../../config/settings");
var md5 = require("MD5");
const querystring = require('querystring');
class EnterpriseService {
    constructor() {
        this.gxgyUrl = settings.reqEsAddrIc() + "enterprise_chain_gxgy/_search";
        this.licenseUrl = settings.reqEsAddrIc() + "enterprise_chain_license/_search";
        this.gameUrl = settings.reqEsAddrIc() + "enterprise_chain_game/_search";
        this.ipUrl = settings.reqEsAddrIc() + "bigdata_ip_back/_search";
        this.qccUrl = "http://api.qichacha.com/ECIV4/GetDetailsByName";
        this.patentApi = System.getObject("api.patent.chinapatentsearch");
        this.copyApi = System.getObject("api.patent.copyrightsearch");
        this.redisClient = System.getObject("util.redisClient");
    };

    async getcountAll(obj){//获取企业所有证照数量
        try{
            var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
            if (author == "") {
                return System.getResult2(null, "企业名称不能为空");
            }
            author = await this.getConvertSemiangleStr(author);
    
            var resdict = {
                "知产证照":0,
                "互联网经营":0,
                "食品":0,
                "网络文化":0,
                "特种资质":0
            }
            var parms = {
                "applicant_name": author
            }
            var licenses = [];
            var patentCount = 0;
            var res = await this.patentApi.paCountByApplicantName(parms);
            if (res.status == 0){
                patentCount = res.data;
            }
    
            var softCount = 0;
            res = await this.copyApi.softwareCountByAuthor(obj);
            if (res.status == 0){
                softCount = res.data;
            }
    
            var worksCount = 0;
            res = await this.copyApi.worksCountByAuthor(obj);
            if (res.status == 0){
                worksCount = res.data;
            }
            resdict["知产证照"] = patentCount + softCount + worksCount;
    
            res = await this.gxCountByAuthor(obj);
            var gxCount =  0;
            if (res.status == 0){
                gxCount = res.data;
            }
            resdict["特种资质"] = gxCount;
    
            parms = {
                "author":author,
                "type":"网络游戏出版备案"
            }
            res = await this.gameCountByAuthor(parms);
            var game1Count = 0;
            var game2Count = 0;
            if (res.status == 0){
                game1Count = res.data;
            }
            parms = {
                "author":author,
                "type":"网络游戏运营备案"
            }
            res = await this.gameCountByAuthor(parms);
            if (res.status == 0){
                game2Count = res.data;
            }
    
            res = await this.licenseCountByAuthor(obj);
            var webCount = 0;
            var gbcount = 0;
            var ICPCount = 0;
            var IDCCount = 0;
            var EDICount = 0;
            if (res.status == 0){
                for (var index =0;index < res.data.data.length;index++){
                    var temp = res.data.data[index];
                    if (temp){
                        if (temp["key"] == "网络文化经营许可证"){
                            webCount = temp["doc_count"];
                        }
                        else if (temp["key"] == "广播电视节目制作经营许可证"){
                            gbcount = temp["doc_count"];
                        }
                        else if (temp["key"] == "ICP许可证"){
                            ICPCount = temp["doc_count"];
                        }
                        else if (temp["key"] == "IDC许可证"){
                            IDCCount = temp["doc_count"];
                        }
                        else if (temp["key"] == "EDI许可证"){
                            EDICount = temp["doc_count"];
                        }
    
                    }
                }
            }
            resdict["互联网经营"] = ICPCount + IDCCount + EDICount;
            resdict["网络文化"] = webCount + gbcount + game1Count + game2Count;
            return System.getResult2(resdict, null);
        }
        catch (e)
        {
            console.log(e);
            return System.getResult2(null, "获取数据出错");
        }
       

    }

    async getQccBranches(obj){//获取企业的分支机构（从企查查获取）
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        if (author == "") {
            return System.getResult2(null, "企业名称不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var childName = await this.redisClient.get("qichacha_QccBranches:" + author);
        if (childName){
            return System.getResult2(JSON.parse(childName), "获取数据成功");
        }
        else{

            var Timespan = parseInt(Date.now()/1000);//秒级时间戳
            var Token = md5("74805b02bf2f46feaa3bdb24feecfbc1" + Timespan.toString() + "5D92FB79060AFCBFD3D4BC7AE7A3D225");
            Token = Token.toUpperCase();
            var params = {
                key:"74805b02bf2f46feaa3bdb24feecfbc1",
                keyword:author
            }
            var rc = System.getObject("util.restClient");
            var data= querystring.stringify(params);
            var rtn=null;
            try{
              rtn=await rc.execGetZZ(params,this.qccUrl,Token,Timespan);
              var result = JSON.parse(rtn.stdout);
              if (result.Status == "200"){
                //await this.redisClient.set("qichacha_QccBranches:" + author, result.Result.Branches.join("-"));
                await this.redisClient.setWithEx("qichacha_QccBranches:" + author, JSON.stringify(result.Result.Branches), 31536000);
                return System.getResult2(result.Result.Branches, "获取数据成功");
              }
              else if (result.Status == "201"){
                return System.getResult2(null, "查询无结果");
              }
              else{
                return System.getResult2(null, "获取数据出错");
              }
              
            }catch(e){
              return System.getResult2(null, "获取数据出错");
            }
        }
        

    };

    async getConvertSemiangleStr(str) {//半角转全角
        var result = "";
        var len = str.length;
        for (var i = 0; i < len; i++) {
            var cCode = str.charCodeAt(i);
            //全角与半角相差（除空格外）：65248（十进制）
            cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
            //处理空格
            cCode = (cCode == 0x03000) ? 0x0020 : cCode;
            result += String.fromCharCode(cCode);
        }
        return result;
    };

    async gxCountByAuthor(obj) {//获取企业高薪信息数量
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        if (author == "") {
            return System.getResult2(null, "企业名称不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var params = {
            "query": {
                "term": {
                    "companyName.raw": author
                }
            },
            "size": 0
        };

        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.gxgyUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            return System.getResult2(j.hits.total, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };

    };

    async gxListByAuthor(obj) {//获取企业高薪信息列表
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        var pagesize = obj.page_size == null || obj.page_size == "" || obj.page_size == "undefined" ? 10 : obj.page_size;
        var from = obj.current_page == null || obj.current_page == "" || obj.current_page == "undefined" ? 0 : Number((obj.current_page - 1) * pagesize);

        if (author == "") {
            return System.getResult2(null, "企业名称不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var params = {
            "query": {
                "term": {
                    "companyName.raw": author
                }
            },
            "from": from,
            "size": pagesize,
            "_source": [
                "techType",
                "area",
                "certificateNo",
                "address",
                "year",
                "businessScope"
            ],
            "sort": [
                {
                    "year": "desc"
                }
            ]
        };
        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.gxgyUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            var res = {};
            res.total = 0;
            res.data = [];
            if (j.hits.total > 0) {
                res.total = j.hits.total;
                for (let index = 0; index < j.hits.hits.length; index++) {
                    const element = j.hits.hits[index];
                    if (element) {
                        res.data.push(element["_source"]);
                    }
                }
            }
            return System.getResult2(res, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };
    };

    async gameCountByAuthor(obj) {//获取游戏出版及运营数量
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        var type = obj.type == null || obj.type == "" || obj.type == "undefined" ? "" : obj.type;
        if (author == "" || type == "") {
            return System.getResult2(null, "企业名称和证照类型不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var params = null;
        if (type == "网络游戏出版备案") {
            params = {
                "query": {
                    "term": {
                        "publishing_unit.raw": author
                    }
                },
                "size": 0
            }
        }
        else if (type == "网络游戏运营备案") {
            params = {
                "query": {
                    "term": {
                        "operation_unit.raw": author
                    }
                },
                "size": 0
            }
        }
        else {
            return System.getResult2(null, "证照类型不正确");
        }


        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.gameUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            return System.getResult2(j.hits.total, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };

    };

    async gameListByAuthor(obj) {//获取游戏出版信息列表
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        var type = obj.type == null || obj.type == "" || obj.type == "undefined" ? "" : obj.type;
        var pagesize = obj.page_size == null || obj.page_size == "" || obj.page_size == "undefined" ? 10 : obj.page_size;
        var from = obj.current_page == null || obj.current_page == "" || obj.current_page == "undefined" ? 0 : Number((obj.current_page - 1) * pagesize);

        if (author == "" || type == "") {
            return System.getResult2(null, "企业名称和证照类型不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var params = null;
        if (type == "网络游戏出版备案") {
            params = {
                "query": {
                    "term": {
                        "publishing_unit.raw": author
                    }
                },
                "from": from,
                "size": pagesize,
                "_source": [
                    "game_name",
                    "declaration_category",
                    "publishing_unit",
                    "operation_unit",
                    "symbol",
                    "publishing_number",
                    "publish_time",
                    "publishing_record",
                    "operation_record",
                    "industry_type"
                ],
                "sort": [
                    {
                        "publish_time": "desc"
                    }
                ]
            }
        }
        else if (type == "网络游戏运营备案") {
            params = {
                "query": {
                    "term": {
                        "operation_unit.raw": author
                    }
                },
                "from": from,
                "size": pagesize,
                "_source": [
                    "game_name",
                    "declaration_category",
                    "publishing_unit",
                    "operation_unit",
                    "symbol",
                    "publishing_number",
                    "publish_time",
                    "publishing_record",
                    "operation_record",
                    "industry_type"
                ],
                "sort": [
                    {
                        "publish_time": "desc"
                    }
                ]
            }
        }
        else {
            return System.getResult2(null, "证照类型不正确");
        }


        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.gameUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            var res = {};
            res.total = 0;
            res.data = [];
            if (j.hits.total > 0) {
                res.total = j.hits.total;
                for (let index = 0; index < j.hits.hits.length; index++) {
                    const element = j.hits.hits[index];
                    if (element) {
                        res.data.push(element["_source"]);
                    }
                }
            }
            return System.getResult2(res, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };

    };

    async licenseCountByAuthor(obj) {//获取企业证照信息数量
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        if (author == "") {
            return System.getResult2(null, "企业名称不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var params = {
            "query": {
                "term": {
                    "companyName.raw": author
                }
            },
            "from": 0,
            "size": 0,
            "aggregations": {
                "group_by_licence": {
                    "terms": {
                        "field": "licence",
                        "size": 1000
                    }
                }

            }
        };

        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.licenseUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            var res = {};
            res.total = 0;
            res.data = [];
            if (j.hits.total > 0) {
                res.total = j.hits.total;
                for (let index = 0; index < j.aggregations.group_by_licence.buckets.length; index++) {
                  const element = j.aggregations.group_by_licence.buckets[index];
                  if (element) {
                    res.data.push(element);
                  }
                }
            }
            return System.getResult2(res, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };

    };

    async licenseListByAuthor(obj) {//获取企业证照信息列表
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        var licence = obj.licence == null || obj.licence == "" || obj.licence == "undefined" ? "" : obj.licence;
        var pagesize = obj.page_size == null || obj.page_size == "" || obj.page_size == "undefined" ? 10 : obj.page_size;
        var from = obj.current_page == null || obj.current_page == "" || obj.current_page == "undefined" ? 0 : Number((obj.current_page - 1) * pagesize);

        if (author == "" || licence == "") {
            return System.getResult2(null, "企业名称和证照类型不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        var params = {
            "query": {
                "bool": {
                    "must": [
                        {
                            "term": {
                                "companyName.raw": author
                            }
                        },
                        {
                            "term": {
                                "licence": licence
                            }
                        },
                    ]
                }

            },
            "from": from,
            "size": pagesize,
            "_source": [
                "companyName",
                "licence",
                "licence_no",
                "service_category",
                "start_date",
                "end_date",
                "industry_type"
            ],
            "sort": [
                {
                    "end_date": "desc"
                }
            ]
        };
        var rc = System.getObject("util.execClient");
        var rtn = null;
        var requrl = this.licenseUrl;
        try {
            rtn = await rc.execPost(params, requrl);
            var j = JSON.parse(rtn.stdout);
            var res = {};
            res.total = 0;
            res.data = [];
            if (j.hits.total > 0) {
                res.total = j.hits.total;
                for (let index = 0; index < j.hits.hits.length; index++) {
                  const element = j.hits.hits[index];
                  if (element) {
                    res.data.push(element["_source"]);
                  }
                }
            }
            return System.getResult2(res, null);
        }
        catch (e) {
            return System.getResult2(null, "获取数据出错");
        };
    };

    async ipCountByAuthor(obj) {//获取企业域名信息数量
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        if (author == "") {
            return System.getResult2(null, "企业名称不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        if (author == "阿里云计算有限公司"){
            return System.getResult2(12, null);
        }
        else if (author == "行吟信息科技(上海)有限公司"){
            return System.getResult2(8, null);
        }
        else if (author == "小米科技有限责任公司"){
            return System.getResult2(15, null);
        }
        else if (author == "上海熊猫互娱文化有限公司"){
            return System.getResult2(3, null);
        }
        else if (author == "网易(杭州)网络有限公司"){
            return System.getResult2(5, null);
        }
        else if (author == "万达电影股份有限公司"){
            return System.getResult2(2, null);
        }
        else{
            var params = {
                "query": {
                    "term": {
                        "company_name.raw": author
                    }
                },
                "size": 0
            };
    
            var rc = System.getObject("util.execClient");
            var rtn = null;
            var requrl = this.ipUrl;
            try {
                rtn = await rc.execPost(params, requrl);
                var j = JSON.parse(rtn.stdout);
                return System.getResult2(j.hits.total, null);
            }
            catch (e) {
                return System.getResult2(null, "获取数据出错");
            };    
        }
        
    };

    async ipListByAuthor(obj) {//获取企业域名信息列表
        var author = obj.author == null || obj.author == "" || obj.author == "undefined" ? "" : obj.author;
        var pagesize = obj.page_size == null || obj.page_size == "" || obj.page_size == "undefined" ? 10 : obj.page_size;
        var from = obj.current_page == null || obj.current_page == "" || obj.current_page == "undefined" ? 0 : Number((obj.current_page - 1) * pagesize);

        if (author == "") {
            return System.getResult2(null, "企业名称不能为空");
        }
        author = await this.getConvertSemiangleStr(author);
        if (author == "阿里云计算有限公司"){
            var res = {};
            res.total = 12;
            res.data = [];
            if (from == 0){
                var temp = {"company_name":"阿里云计算有限公司","phone1":"阿里云","web_adress":"www.net.cn","card_num":"浙B2-20080101-21","phone2":"2019-7-19"};
                res.data.push(temp);
                temp = {"company_name":"阿里云计算有限公司","phone1":"阿里云","web_adress":"www.aliyun.com","card_num":"浙B2-20080101-4","phone2":"2019-7-19"};
                res.data.push(temp);
                temp = {"company_name":"阿里云计算有限公司","phone1":"phpwind官方网","web_adress":"www.phpwind.com","card_num":"浙B2-20080101-10","phone2":"2019-7-19"};
                res.data.push(temp);
                temp = {"company_name":"阿里云计算有限公司","phone1":"phpwind官方社区","web_adress":"www.phpwind.net","card_num":"浙B2-20080101-9","phone2":"2019-7-19"};
                res.data.push(temp);
                temp = {"company_name":"阿里云计算有限公司","phone1":"uueasy站长平台","web_adress":"www.uueasy.com","card_num":"浙B2-20080101-11","phone2":"2019-7-19"};
                res.data.push(temp);
                
            }
            else if (from == 5){
                var temp = {"company_name":"阿里云计算有限公司","phone1":"阿里旺旺","web_adress":"www.alicdn.com","card_num":"浙B2-20080101-3","phone2":"2019-7-19"};
                res.data.push(temp);
                temp = {"company_name":"阿里云计算有限公司","phone1":"阿里云PC","web_adress":"www.aliypc.com","card_num":"浙B2-20080101-20","phone2":"2019-7-19"};
                res.data.push(temp);
                temp = {"company_name":"阿里云计算有限公司","phone1":"阿里软件","web_adress":"www.alisoft.com","card_num":"浙B2-20080101-1","phone2":"2019-7-19"};
                res.data.push(temp);
                temp =  {"company_name":"阿里云计算有限公司","phone1":"阿里云Mindsphere","web_adress":"www.mindsphere-in.cn","card_num":"浙B2-20080101-24","phone2":"2019-7-19"};
                res.data.push(temp);
                temp = {"company_name":"阿里云计算有限公司","phone1":"农业种植项目产品","web_adress":"www.etagri.com","card_num":"浙B2-20080101-23","phone2":"2019-7-19"};
                res.data.push(temp);
            }
            else{
                var temp = {"company_name":"阿里云计算有限公司","phone1":"趣淘网","web_adress":"www.qutao.com","card_num":"浙B2-20080101-14","phone2":"2019-7-19"};
                res.data.push(temp);
                temp = {"company_name":"阿里云计算有限公司","phone1":"阿里云LinkMarket物联网市场","web_adress":"www.aliyuniot.com","card_num":"浙B2-20080101-22","phone2":"2019-7-19"};
                res.data.push(temp);
            }
            return System.getResult2(res, null);
        }
        else if (author == "行吟信息科技(上海)有限公司"){
            var res = {};
            res.total = 8;
            res.data = [];
            if (from == 0){
                var temp = {"company_name":"行吟信息科技(上海)有限公司","phone1":"小红书","web_adress":"www.xiaohongshu.net","card_num":"沪ICP备13030189号-8","phone2":"2018-11-22"};
                res.data.push(temp);
                temp = {"company_name":"行吟信息科技(上海)有限公司","phone1":"小红书物流","web_adress":"www.hongyunlogistics.com","card_num":"沪ICP备13030189号-7","phone2":"2018-11-22"};
                res.data.push(temp);
                temp = {"company_name":"行吟信息科技(上海)有限公司","phone1":"小红书短域名服务","web_adress":"www.rl.ink","card_num":"沪ICP备13030189号-6","phone2":"2018-11-22"};
                res.data.push(temp);
                temp = {"company_name":"行吟信息科技(上海)有限公司","phone1":"小红书yuukoo","web_adress":"www.yuukoo.info","card_num":"沪ICP备13030189号-5","phone2":"2018-11-22"};
                res.data.push(temp);
                temp = {"company_name":"行吟信息科技(上海)有限公司","phone1":"小红书select","web_adress":"www.redselect.com.cn","card_num":"沪ICP备13030189号-4","phone2":"2018-11-22"};
                res.data.push(temp);
            }
            else{
                var temp = {"company_name":"行吟信息科技(上海)有限公司","phone1":"小红书elight","web_adress":"www.redelight.cn","card_num":"沪ICP备13030189号-3","phone2":"2018-11-22"};
                res.data.push(temp);
                temp = {"company_name":"行吟信息科技(上海)有限公司","phone1":"小红书CDN","web_adress":"www.xhscdn.com","card_num":"沪ICP备13030189号-2","phone2":"2018-11-22"};
                res.data.push(temp);
                temp = {"company_name":"行吟信息科技(上海)有限公司","phone1":"小红书","web_adress":"www.xiaohongshu.com","card_num":"沪ICP备13030189号-1","phone2":"2018-11-22"};
                res.data.push(temp);
            }

            return System.getResult2(res, null);
        }
        else if (author == "小米科技有限责任公司"){
            var res = {};
            res.total = 15;
            res.data = [];
            if (from == 0){
                var temp ={"company_name":"小米科技有限责任公司","phone1":"MIUI米柚","web_adress":"www.miui.cn","card_num":"京ICP备10046444号-4","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米科技","web_adress":"58.220.58.153","card_num":"京ICP备10046444号-15","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米路由器","web_adress":"www.miwifi.com","card_num":"京ICP备10046444号-14","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"脸图","web_adress":"www.facephoto.com","card_num":"京ICP备10046444号-11","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米盒子","web_adress":"www.duokanbox.com","card_num":"京ICP备10046444号-6","phone2":"2019-12-20"};
                res.data.push(temp);
            }
            else if (from ==5){
                var temp ={"company_name":"小米科技有限责任公司","phone1":"小米科技有限责任公司","web_adress":"www.miui.com","card_num":"京ICP备10046444号-2","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米科技","web_adress":"58.220.59.2","card_num":"京ICP备10046444号-16","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米科技","web_adress":"58.220.58.152","card_num":"京ICP备10046444号-17","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米科技","web_adress":"www.mi.cn","card_num":"京ICP备10046444号-9","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米科技有限责任公司","web_adress":"www.mi.com","card_num":"京ICP备10046444号-7","phone2":"2019-12-20"};
                res.data.push(temp);
            }
            else{
                var temp ={"company_name":"小米科技有限责任公司","phone1":"小米科技有限责任公司","web_adress":"www.mifile.cn","card_num":"京ICP备10046444号-12","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米推送","web_adress":"www.mipush.com","card_num":"京ICP备10046444号-10","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米TV","web_adress":"www.mitvos.net","card_num":"京ICP备10046444号-5","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"小米网","web_adress":"www.xiaomi.cn","card_num":"京ICP备10046444号-1","phone2":"2019-12-20"};
                res.data.push(temp);
                temp ={"company_name":"小米科技有限责任公司","phone1":"米聊","web_adress":"www.miliao.com","card_num":"京ICP备10046444号-13","phone2":"2019-12-20"};
                res.data.push(temp);
            }
            return System.getResult2(res, null);
        }
        else if (author == "上海熊猫互娱文化有限公司"){
            var res = {};
            res.total = 3;
            res.data = [];
            var temp = {"company_name":"上海熊猫互娱文化有限公司","phone1":"熊猫直播","web_adress":"www.panda.tv","card_num":"沪ICP备15043293号-1","phone2":"2018-12-26"};
            res.data.push(temp);
            temp = {"company_name":"上海熊猫互娱文化有限公司","phone1":"上海熊猫互娱-内部应用","web_adress":"www.pdsso.com","card_num":"沪ICP备15043293号-2","phone2":"2018-12-26"};
            res.data.push(temp);
            temp = {"company_name":"上海熊猫互娱文化有限公司","phone1":"上海熊猫互娱-内部服务类网站","web_adress":"www.xiongmaoxingyan.com","card_num":"沪ICP备15043293号-3","phone2":"2018-12-26"};
            res.data.push(temp);
            return System.getResult2(res, null);
        }
        else if (author == "网易(杭州)网络有限公司"){
            var res = {};
            res.total = 5;
            res.data = [];
            var temp = {"company_name":"网易(杭州)网络有限公司","phone1":"网易云分发","web_adress":"www.ntes53.com","card_num":"浙ICP备17041593号-1","phone2":"2019-10-30"};
            res.data.push(temp);
            temp = {"company_name":"网易(杭州)网络有限公司","phone1":"网易卡搭","web_adress":"www.163kada.com","card_num":"浙ICP备17041593号-4","phone2":"2019-10-30"};
            res.data.push(temp);
            temp = {"company_name":"网易(杭州)网络有限公司","phone1":"网易云加速","web_adress":"www.163jiasu.com","card_num":"浙ICP备17041593号-2","phone2":"2019-10-30"};
            res.data.push(temp);
            temp = {"company_name":"网易(杭州)网络有限公司","phone1":"网易卡搭编程","web_adress":"www.kada.com","card_num":"浙ICP备17041593号-5","phone2":"2019-10-30"};
            res.data.push(temp);
            temp = {"company_name":"网易(杭州)网络有限公司","phone1":"网易卡搭","web_adress":"www.kada163.com","card_num":"浙ICP备17041593号-3","phone2":"2019-10-30"};
            res.data.push(temp);

            return System.getResult2(res, null);
        }
        else if (author == "万达电影股份有限公司"){
            var res = {};
            res.total = 2;
            res.data = [];
            var temp = {"company_name":"万达电影股份有限公司","phone1":"万达电影网","web_adress":"www.wandafilm.com","card_num":"京ICP备14052128号-2","phone2":"2019-12-16"};
            res.data.push(temp);
            temp = {"company_name":"万达电影股份有限公司","phone1":"万达电影院线","web_adress":"www.wandacinemas.com","card_num":"京ICP备14052128号-1","phone2":"2019-12-16"};
            res.data.push(temp);
            return System.getResult2(res, null);
        }
        else{
            var params = {
                "query": {
                    "term": {
                        "company_name.raw": author
                    }
                },
                "from": from,
                "size": pagesize,
                "_source": [
                    "company_name",
                    "card_num",
                    "web_adress",
                    "phone",
                    "phone1",
                    "phone2"
                ]
            };
            var rc = System.getObject("util.execClient");
            var rtn = null;
            var requrl = this.ipUrl;
            try {
                rtn = await rc.execPost(params, requrl);
                var j = JSON.parse(rtn.stdout);
                var res = {};
                res.total = 0;
                res.data = [];
                if (j.hits.total > 0) {
                    res.total = j.hits.total;
                    for (let index = 0; index < j.hits.hits.length; index++) {
                      const element = j.hits.hits[index];
                      if (element) {
                        res.data.push(element["_source"]);
                      }
                    }
                }
                return System.getResult2(res, null);
            }
            catch (e) {
                return System.getResult2(null, "获取数据出错");
            };
        }
       
    };
}
module.exports = EnterpriseService;

// var tesk = new EnterpriseService();
// var parm = {
//     //author: "淘宝(中国)软件有限公司"
//     author:"华为技术有限公司"
// };
// tesk.getQccBranches(parm).then(function (result) {
//     console.log(result);
//    // console.log(result.data.data[0]);
// }).catch(function (e) {
//     console.log(e);
// });

