var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.common.oplogCtl");

class MerchantUserCtl extends CtlBase {
    constructor() {
        super();
        this.merchantSve = system.getObject("service.merchant.merchantSve");
    }


    async merchantOfList(params, pobj2, req) {
        try {
            return await this.merchantSve.merchantOfList(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    async addModifyMerchants(params, pobj2, req) {
        try {
            return await this.merchantSve.addModifyMerchants(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    async merchantSuggest(params, pobj2, req) {
        try {
            return await this.merchantSve.merchantSuggest(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    async auditMerchant(params, pobj2, req) {
        try {
            return await this.merchantSve.auditMerchant(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

}

module.exports = MerchantUserCtl;
