var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.common.oplogCtl");

class MerchantUserCtl extends CtlBase {
    constructor() {
        super();
        this.merchantSve = system.getObject("service.merchant.merchantSve");
    }


    async merchanttradesOfList(params, pobj2, req) {
        try {
            return await this.merchantSve.merchanttradesOfList(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    async addMerchanttrades(params, pobj2, req) {
        try {
            return await this.merchantSve.addMerchanttrades(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    async auditMerchanttrade(params, pobj2, req) {
        try {
            return await this.merchantSve.auditMerchanttrade(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    async merchanttradesOfListAll(params, pobj2, req) {
        try {
            return await this.merchantSve.merchanttradesOfListAll(params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }


}

module.exports = MerchantUserCtl;
