var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const validation = system.getObject("util.validation");

class MerchantUserCtl extends CtlBase {
  constructor() {
    super();
    this.userSve = system.getObject("service.uc.userSve");
  }

  async save(params, pobj2, req) {
    try {
      params.uctype_id = this.trim(params.uctype_id);
      params.real_name = this.trim(params.real_name);
      params.password = this.trim(params.password);
      params.ucname = this.trim(params.ucname);
      params.mobile = this.trim(params.mobile);

      if (!params.uctype_id) {
        return system.getResult(null, "请选择商户");
      }
      if (!params.real_name) {
        return system.getResult(null, "请选择商户");
      }
      if (!params.ucname) {
        return system.getResult(null, "请选择商户");
      }
      if (!params.mobile) {
        return system.getResult(null, "请选择商户");
      }
      validation.check(params, "real_name", {name: "姓名", is_require: true});
      validation.check(params, "mobile", {name: "联系电话", is_require: true});
      validation.check(params, "ucname", {name: "用户名", is_require: true});

      return await this.userSve.saveMerchantUser(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error.name}`);
    }
  }

  async info(params, pobj2, req) {
    try {
      params.id = Number(params.id || 0);
      return await this.userSve.info(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async page(params, pobj2, req) {
    try {
      params.utype = 2;
      params.uctype_id = this.trim(params.merchant_id);
      let res = await this.userSve.page(params);
      if (res.status === 0 && res.data && res.data.rows) {
        for (let item of res.data.rows) {
          item.merchant = {id:"todo", name: "todo"};
        }
      }
      return res;
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


  /**
   * 启用禁用
   * @param {*} params
   * @param {*} pobj2
   * @param {*} req
   */
  async enabled(params, pobj2, req) {
    try {
      params.id = Number(params.id || 0);
      params.is_enabled = Number(params.is_enabled || 0);
      return await this.userSve.enabled(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


}

module.exports = MerchantUserCtl;