var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");

class OrderCtl extends CtlBase {
    constructor() {
        super();
        this.userSve = system.getObject("service.uc.userSve");
        this.orderSve = system.getObject("service.order.orderSve");
        // this.redisClient = system.getObject("util.redisClient");
    }

    /**
     * fn:保存订单
     * 如果是单价商品 product_type=1  product_id =xxx  product_ids =[] product_unit_price=1
     * 如果是组合产品 product_type=2 product_id=xxx   product_ids=['xxx','xxxx'] product_unit_price=-1
     * ps:需要对金额单位进行转化
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<void>}
     */
    async saveEorder(pobj, pobj2, req, res) {
        try{
            //TODO:首先拿到商户的账号信息 (拿到合同ID 合同名称 )

            // TODO:需要去调用商户钱包 扣钱

            if(!pobj.contract_url){
                return system.getResult(null, `参数错误 业务合同不能为空`);
            }
            if(!pobj.live_start){
                return system.getResult(null, `参数错误 生效时间不能为空`);
            }
            if(!pobj.live_end){
                return system.getResult(null, `参数错误 结束时间不能为空`);
            }
            //保存
            let res = await this.orderSve.saveEorder(pobj);
            return system.getResult(res);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn:审核订单
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<{msg: string, data: (*|null), bizmsg: string, status: number}>}
     */
    async auditEorder(pobj, pobj2, req, res) {
        try{
            if(!pobj.id){
                return system.getResult(null, `订单【${pobj.id}】不存在`);
            }
            if(!pobj.audit_status){
                return system.getResult(null, `参数错误 审核状态不能为空`);
            }

            let res = await this.orderSve.auditEorder(pobj);
            //TODO:审核订单成功之后
            if(res.status==0){
                pushMerchantTrade(pobj);
            }
            return system.getResult(res);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn:推送商户流水
     * @param params
     */
    async pushMerchantTrade(params){
        let orderBean = await this.orderSve.getEorderById({id: this.trim(id)});
        if(!orderBean){
            console.log(`推送流水失败 订单信息获取异常`);
        }
        if(params.audit_status=='20'){ //订单审核成功

        }
        if(params.audit_status=='30'){ //订单审核失败

        }
    }


    /**
     * fn:查看订单(根据ID查询)
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<{msg: string, data: (*|null), bizmsg: string, status: number}>}
     */
    async getEorderById(pobj, pobj2, req, res) {
        try{
            if(!pobj.id){
                return system.getResult(null, `订单【${pobj.id}】不存在`);
            }
            let res = await this.orderSve.getEorderById(pobj);
            return system.getResult(res);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn:查看订单列表(分页)
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<{msg: string, data: (*|null), bizmsg: string, status: number}>}
     */
    async pageEorder(pobj, pobj2, req, res) {
        try{
            let res = await this.orderSve.pageEorder(pobj);
            return system.getResult(res);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn:更改订单状态
     * ps:可以修改的订单的状态 支付状态 审核状态 生效状态  状态code 依次 10 20 30 待xx 完成 失败
     *    每次只能修改一个状态 （这里只能修改状态没有 状态标记注释 如果修改订单审核状态为失败请调用 “auditEorder” 接口）
     *    TODO:可能考虑修改生效状态需要加到 延迟消息队列中 用来处理过期失效的订单
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<void>}
     */
    async updEorderStatus(pobj, pobj2, req, res){
        if(!pobj.id){
            return system.getResult(null, `参数错误 订单ID不能为空`);
        }
        try{
            //TODO:需要添加商户信息 （merchant_id）

            return await this.orderSve.updEorderStatus(pobj);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }
}

module.exports = ProductCtl;