var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const moment = require('moment');
class OrderCtl extends CtlBase {
    constructor() {
        super();
        this.userSve = system.getObject("service.uc.userSve");
        this.orderauthlogSve = system.getObject("service.order.orderauthlogSve");
    }


    /**
     * fn:保存身份认证日志
     * ps:测试开发中开放 ,此接口不向外暴露， 认证引擎异步回调将此次操作插入到表中
     * @param pobj  1.spendedBegin消费的开始时间  2.spendedEnd消费的结束时间
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<void>}
     */
    async saveEorderAuthLog(pobj, pobj2, req, res){
        if(!pobj.order_id){
            return system.getResult(null, `参数错误 订单ID不能为空`);
        }
        if(!pobj.product_id){
            return system.getResult(null, `参数错误 产品ID不能为空`);
        }
        if(!pobj.user_name){
            return system.getResult(null, `参数错误 使用方不能为空`);
        }
        if(!pobj.platform_name){
            return system.getResult(null, `参数错误 平台名称不能为空`);
        }
        if(!pobj.actual_spend_name){
            return system.getResult(null, `参数错误 实际使用方不能为空`);
        }
        pobj.engine_trade_id = this.trim(pobj.engine_trade_id) ||'';
        pobj.spended_num = Number(pobj.spended_num || 0);
        pobj.spended_at = pobj.spended_at?pobj.spended_at:new Date();
        pobj.pass=pobj.pass?pobj.pass:0;  //是否通过 默认是不通过
        try{
            return await this.orderauthlogSve.saveEorderAuthLog(pobj);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn:身份认证日志列表
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<void>}
     */
    async pageEorderAuthLog(pobj, pobj2, req, res){
        //如果存在时间筛选 时间格式 2020-05
        if(pobj.spendedDate){
            let dateRes = formatDate(pobj.spendedDate);
            pobj.spendedBegin = dateRes.spendedBegin;
            pobj.spendedEnd = dateRes.spendedEnd;
        }
        try{
            //TODO:需要获取当前商户信息 （商户ID）
            pobj.merchant_id = "xxx";

            return await this.orderauthlogSve.pageEorderAuthLog(pobj);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn：格式化日期
     * @param params
     */
    formatDate(params){
        if(!params){return;}
        let date = moment(params);
        let spendedBegin=date.format("YYYY-MM-DD HH:mm:ss");
        let tempMonth = date.month()+1;
        tempMonth=tempMonth<10?'0'+tempMonth:tempMonth;
        let tempDay = date.daysInMonth();
        tempDay=tempDay<10?'0'+tempDay:tempDay;
        let spendedEnd = date.year() + "-" + tempMonth + '-' + tempDay + " 23:59:59";
        return { spendedBegin,spendedEnd };
    }
}

module.exports = ProductCtl;