var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");

class OrderCtl extends CtlBase {
    constructor() {
        super();
        this.userSve = system.getObject("service.uc.userSve");
        this.orderproductSve = system.getObject("service.order.orderproductSve");
    }


    /**
     * fn:根据产品ID查询最早创建的订单
     * ps:当前商户下如果存在 单个商品和组合商品 都包涵 同样的子产品 ，在实际消费的时候 应该扣除最先创建订单的子产品(订单的状态 生效中)
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<void>}
     */
    async listEorderProduct(pobj, pobj2, req, res){
        if(!pobj.product_id){
            return system.getResult(null, `参数错误 产品ID不能为空`);
        }
        try{
            //TODO:需要获取当前商户信息 （商户ID）
            pobj.merchant_id = "xxx";

            return await this.orderproductSve.listEorderProduct(pobj);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn:查看当前商户下所有的订单相关的产品（没有分页）
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<{msg: string, data: (*|null), bizmsg: string, status: number}|void|*>}
     */
    async listEorderProductByMerchantId(pobj, pobj2, req, res){
        if(!pobj.product_id){
            return system.getResult(null, `参数错误 产品ID不能为空`);
        }
        try{
            if(!pobj.merchant_id){
                return system.getResult(null, `获取数据错误`);
            }
            return await this.orderproductSve.listEorderProductByMerchantId(pobj);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }
}

module.exports = ProductCtl;