var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const moment = require('moment');
class OrderCtl extends CtlBase {
    constructor() {
        super();
        this.userSve = system.getObject("service.uc.userSve");
        this.ordersignlogSve = system.getObject("service.order.ordersignlogSve");
    }

    /**
     * fn:保存签约日志
     * ps:测试开发中开放 ,此接口不向外暴露， 认证引擎异步回调将此次操作插入到表中
     * @param pobj  1.spendedBegin消费的开始时间  2.spendedEnd消费的结束时间
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<void>}
     */
    async saveEorderSignLog(pobj, pobj2, req, res){
        if(!params.order_id){
            return system.getResult(null, `参数错误 订单ID不能为空`);
        }
        if(!params.product_id){
            return system.getResult(null, `参数错误 产品ID不能为空`);
        }
        if(!params.engine_contract_name){
            return system.getResult(null, `参数错误 签署任务名称不能为空`);
        }
        if(!params.engine_contract_id){
            return system.getResult(null, `参数错误 签署ID不能为空`);
        }
        if(!params.actual_spend_name){
            return system.getResult(null, `参数错误 实际使用方不能为空`);
        }
        params.spended_num = Number(params.spended_num || 0);
        params.spended_at = params.spended_at?params.spended_at:new Date();
        params.platform_id=params.platform_id?params.platform_id:'';
        try{
            return await this.ordersignlogSve.saveEorderSignLog(pobj);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn:签约日志列表（分页）
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<void>}
     */
    async pageEorderSignLog(pobj, pobj2, req, res){
        //如果存在时间筛选 时间格式 2020-05
        if(pobj.spendedDate){
            let dateRes = formatDate(pobj.spendedDate);
            pobj.spendedBegin = dateRes.spendedBegin;
            pobj.spendedEnd = dateRes.spendedEnd;
        }
        try{
            return await this.ordersignlogSve.pageEorderSignLog(pobj);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn：格式化日期
     * @param params
     */
    formatDate(params){
        if(!params){return;}
        let date = moment(params);
        let spendedBegin=date.format("YYYY-MM-DD HH:mm:ss");
        let tempMonth = date.month()+1;
        tempMonth=tempMonth<10?'0'+tempMonth:tempMonth;
        let tempDay = date.daysInMonth();
        tempDay=tempDay<10?'0'+tempDay:tempDay;
        let spendedEnd = date.year() + "-" + tempMonth + '-' + tempDay + " 23:59:59";
        return { spendedBegin,spendedEnd };
    }
}

module.exports = ProductCtl;