module.exports={
  "bizName":"tmstock",
  "list":{
    columnMetaData:[
      {"width":"200","label":"注册号","prop":"code","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"项目类型","prop":"itemTypeName","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"商标名称","prop":"name","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"发布者","prop":"authorOnlyCode","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"是否推荐","prop":"isRecommendName","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"是否发布","prop":"isPubed","isShowTip":true,"isTmpl":false},
      {"width":"200","label":"排序","prop":"sort","isShowTip":true,"isTmpl":false},
      {"width":"null","label":"操作","name":"null","isShowTip":false,"isTmpl":true,"isBtns":"true"},
    ]
  },
  "form":[
    {
       "title":"项目类型",
       "validProp":"itemType",
       "rule": [
            { "required": true, "message": '请选择类型', "trigger": 'blur' },
        ],
        "ctls":[
          {"type":"select","dicKey":"productCata","prop":"itemType","labelField":"label","valueField":"value","style":""},
        ]
    },
    {
      "title":"商标注册号",
      "validProp":"code",
      "rule": [
           { "required": true, "message": '请输入商标注册号', "trigger": 'blur' },
       ],
       "ctls":[
         {"type":"input","label":"商标注册号","prop":"code","placeHolder":"请输入商标注册号","style":""},
       ]
    },
    {
      "title":"商标名称",
      "validProp":"name",
      "rule": [
           { "required": true, "message": '请输入商标名称', "trigger": 'blur' },
       ],
       "ctls":[
         {"type":"input","label":"商标名称","prop":"name","placeHolder":"请输入商标名称","style":""},
       ]
    },
    {
      "title":"商标图样",
       "ctls":[
         {"type":"upload","label":"商标图样","prop":"mobilePic","placeHolder":"请上传商标图样","style":""},
       ]
    },
    {
      "title":"尼斯大类",
       "ctls":[
         {"type":"input","label":"尼斯大类","prop":"nclOneCodes","placeHolder":"尼斯大类","style":""},
       ]
    },
    {
      "title":"价格区间最小值",
      "validProp":"priceRangeMin",
      "rule": [
           { "required": true, "message": '请输入价格区间最小值', "trigger": 'blur' },
           { "type": 'number', "message": '价格区间最大值必须为数字值'}
       ],
       "ctls":[
         {"type":"number","label":"项目服务费","prop":"priceRangeMin","disabled":false,"placeHolder":"请输入项目服务费","style":""},
       ]
    },
    {
      "title":"价格区间最大值",
      "validProp":"priceRangeMax",
      "rule": [
           { "required": true, "message": '请输入价格区间最大值', "trigger": 'blur' },
           { "type": 'number', "message": '价格区间最大值必须为数字值'}
       ],
       "ctls":[
         {"type":"number","label":"价格区间最大值","prop":"priceRangeMax","disabled":false,"placeHolder":"请输入价格区间最大值","style":""},
       ]
    },
    {
      "title":"商标到期时间",
       "ctls":[
         {"type":"datetime","label":"商标到期时间","prop":"tmExpirationDate","placeHolder":"商标到期时间","style":""},
       ]
    },
    {
      "title":"商标简介",
       "ctls":[
         {"type":"textarea","label":"商标简介","prop":"shortDesc","placeHolder":"请输入商标简介","style":""},
       ]
    },
    {
      "title":"发布者",
       "ctls":[
         {"type":"input","label":"发布者","prop":"authorName","placeHolder":"发布者","style":""},
       ]
    },
    {
      "title":"发布者电话",
       "ctls":[
         {"type":"input","label":"发布者电话","prop":"authorMobile","placeHolder":"发布者电话","style":""},
       ]
    },
    {
      "title":"申请人",
       "ctls":[
         {"type":"input","label":"申请人","prop":"applyName","placeHolder":"申请人","style":""},
       ]
    },
    {
        "title":"是否推荐",
        "validProp":"isRecommend",
        "rule": [
             { "required": true, "message": '请选择类型', "trigger": 'blur' },
         ],
         "ctls":[
           {"type":"select","dicKey":"isRecommend","prop":"isRecommend","labelField":"label","valueField":"value","style":""},
         ]
    },
    {
      "title":"排序",
      "validProp":"sort",
      "rule": [
           { "required": true, "message": '请输入排序，越小越靠前显示，可以为负数', "trigger": 'blur' },
           { "type": 'number', "message": '排序必须为数字值'}
       ],
       "ctls":[
         {"type":"number","label":"排序","prop":"sort","disabled":false,"placeHolder":"请输入排序，越小越靠前显示，可以为负数","style":""},
       ]
    },
    {
      "title":"咨询电话",
      "validProp":"hotline",
      "rule": [
           { "required": true, "message": '请输入咨询电话', "trigger": 'blur' },
           { "validator":"validatex","trigger": 'blur' },
       ],
      "ctls":[
         {"type":"input","label":"项目操作码","prop":"hotline","placeHolder":"请输入咨询电话","style":""},
       ]
    },

    {
      "title":"",
       "ctls":[
          {"type":"switch","prop":"isPubed","acText":"发布","inactText":"不发布","placeHolder":" ","style":""},
       ]
    },
  ],
  "search":[
    {
      "title":"商标注册号",
       ctls:[
         {"type":"input","label":"商标注册号","prop":"code","placeHolder":"请输入商标注册号","style":""},
       ]
    },
    {
      "title":"商标名称",
       ctls:[
         {"type":"input","label":"商标名称","prop":"name","placeHolder":"请输入商标名称","style":""},
       ]
    },
    {
      "title":"项目类型",
      ctls:[
        {"type":"select","dicKey":"productCata","prop":"itemType","labelField":"label","valueField":"value","style":""},
      ]
    },
    {
      "title":"是否推荐",
      ctls:[
        {"type":"select","dicKey":"isRecommend","prop":"isRecommend","labelField":"label","valueField":"value","style":""},
      ]
    },
  ],
  "auth":{
    "add":[
      {"icon":"el-icon-plus","title":"新增","type":"default","key":"new","isOnGrid":true},
      {"icon":"el-icon-save","title":"保存","type":"default","key":"save","isOnForm":true},
    ],
    "edit":[
      {"icon":"el-icon-edit","title":"修改","type":"default","key":"edit","isInRow":true},
    ],
    "delete":[
      // {"icon":"el-icon-remove","title":"删除","type":"default","key":"delete","isInRow":true},
    ],
    "common":[
      {"icon":"el-icon-cancel","title":"取消","type":"default","key":"cancel","isOnForm":true},
    ],
  }
}
