{
    template: '${tmpl}',
        data: function() {
            var validateAddr = (rule, value, callback) => {
                var x = /(([省])|([中][国])|([中][华][人][民][共][和][国])|([北][京][市])|([上][海][市])|([天][津][市])|([重][庆][市])|([内][蒙][古])|([广][西])|([宁][夏])|([新][疆])|([西][藏])|([内][蒙][古][自][治][区])|([新][疆][维][吾][尔][自][治][区])|([广][西][壮][族][自][治][区])|([宁][夏][回][族][自][治][区])|([西][藏][自][治][区]))/g.test(value);
                if (!x) {
                    callback(new Error('请核对地址，必须写所在省份名称！'));
                } else {
                    callback();
                }
            };
            var mobileValidator = (rule, value, callback) => {
                var x = /((\d{11})|^((\d{7,8})|(\d{4}|\d{3})-(\d{7,8})|(\d{4}|\d{3})-(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1})|(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1}))$)/g.test(value);
                if (!x) {
                    callback(new Error('联系电话格式错误！'));
                } else {
                    callback();
                }
            };
            var emailValidator = (rule, value, callback) => {
                var x = /^([a-zA-Z0-9._-])+@([a-zA-Z0-9_-])+(\.[a-zA-Z0-9_-])+/.test(value);
                if (!x) {
                    callback(new Error('电子邮箱格式错误！'));
                } else {
                    callback();
                }
            };
            var colorizedtm = (rule, value, callback) => {
                if ((this.form.tmFormType == "7" || this.form.tmFormType == "6") && value == "") {
                    callback(new Error('请上传彩色商标图样'));
                } else {
                    callback();
                }
            };
            var validateIdCard = (rule, value, callback) => {
                if (this.form.type == "person") {
                    if (value == "") {
                        callback(new Error('请输入身份证号码'));
                    } else {
                        var x = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value);
                        if (!x) {
                            callback(new Error('身份证格式错误'));
                        } else {
                            callback();
                        }
                    }
                } else {
                    callback();
                }
            };
            var validateSFZ = (rule, value, callback) => {
                if (this.apply.customerType == "person" && value == "") {
                    callback(new Error('身份证明不能为空'));
                } else {
                    callback();
                }
            };
            var code = (rule, value, callback) => {
                if (this.apply.customerType == "ent" && !this.apply.code) {
                    callback(new Error('请输入信用代码'));
                } else {
                    callback();
                }
            };
            return {

                /*注册副本 */
                announcementsImgType: false,
                announcementsType: false,
                nclSearchLoading: false,
                updatePriceType: false,
                loading: false,
                loading1: false,
                loading2: false,
                loading3: false,
                loadingKey: 0,
                tm_form_type: { "1": "立体", "3": "文字图标", "4": "图形商标", "5": "图形及文字商标", "6": "颜色", "7": "彩色" },
                showSelectedNclList: false,
                fkey: 0,
                isIndeterminate: false,
                checkAll: false,
                checkedNcl: [],
                ncl: ["01", "02", "03", "04", "05", "06", "07", "08", "09",
                    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24",
                    "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38",
                    "39", "40", "41", "42", "43", "44", "45"
                ],
                nclOptions: ["01", "02", "03", "04", "05", "06", "07", "08", "09",
                    "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24",
                    "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38",
                    "39", "40", "41", "42", "43", "44", "45"
                ],
                isIndeterminate: false,

                itemPrice: 0,
                refbizcode: '',
                bizCode: '',
                filterText: '',
                status: "",
                data2: [{
                    id: 1,
                    label: '一级 1',
                    children: []
                }],
                ppnclArr: null,
                ncldata: [
                    { code: "01", name: "化学原料", type: 1 }, { code: "02", name: "颜料油漆", type: 1 }, { code: "03", name: "日化用品", type: 1 }, { code: "04", name: "燃料油脂", type: 1 }, { code: "05", name: "医药", type: 1 },
                    { code: "06", name: "金属材料", type: 1 }, { code: "07", name: "机械设备", type: 1 }, { code: "08", name: "手工器械", type: 1 }, { code: "09", name: "科学仪器", type: 1 }, { code: "10", name: "医疗器械", type: 1 },
                    { code: "11", name: "灯具空调", type: 1 }, { code: "12", name: "运输工具", type: 1 }, { code: "13", name: "军火烟火", type: 1 }, { code: "14", name: "珠宝钟表", type: 1 }, { code: "15", name: "乐器", type: 1 },
                    { code: "16", name: "办公用品", type: 1 }, { code: "17", name: "橡胶制品", type: 1 }, { code: "18", name: "皮革皮具", type: 1 }, { code: "19", name: "建筑材料", type: 1 }, { code: "20", name: "家具", type: 1 },
                    { code: "21", name: "厨房洁具", type: 1 }, { code: "22", name: "绳网袋篷", type: 1 }, { code: "23", name: "纱线丝", type: 1 }, { code: "24", name: "布料床单", type: 1 }, { code: "25", name: "服装鞋帽", type: 1 },
                    { code: "26", name: "纽扣拉链", type: 1 }, { code: "27", name: "地毯席垫", type: 1 }, { code: "28", name: "健身器材", type: 1 }, { code: "29", name: "食品", type: 1 }, { code: "30", name: "方便食品", type: 1 },
                    { code: "31", name: "饲料种籽", type: 1 }, { code: "32", name: "啤酒饮料", type: 1 }, { code: "33", name: "酒", type: 1 }, { code: "34", name: "烟草烟具", type: 1 }, { code: "35", name: "广告销售", type: 1 },
                    { code: "36", name: "金融物管", type: 1 }, { code: "37", name: "建筑修理", type: 1 }, { code: "38", name: "通讯服务", type: 1 }, { code: "39", name: "运输贮藏", type: 1 }, { code: "40", name: "材料加工", type: 1 },
                    { code: "41", name: "教育娱乐", type: 1 }, { code: "42", name: "网站服务", type: 1 }, { code: "43", name: "餐饮住宿", type: 1 }, { code: "44", name: "医疗园艺", type: 1 }, { code: "45", name: "社会服务", type: 1 }
                ],
                bigtype: [{
                    value: '人工智能', label: '人工智能',
                    children: [{ value: '技术研究', label: '技术研究', }, { value: '智能办公', label: '智能办公', }, { value: '智能驾驶', label: '智能驾驶', }, { value: '智能教育', label: '智能教育', }, { value: '智能穿戴', label: '智能穿戴', }]
                },
                {
                    value: '文教娱|传媒、教育、文化、娱乐', label: '文教娱|传媒、教育、文化、娱乐',
                    children: [{ value: '影视', label: '影视', }, { value: '教育培训', label: '教育培训', }, { value: '文化娱乐', label: '文化娱乐', }, { value: '旅游服务', label: '旅游服务', }]
                },
                {
                    value: '服务业|餐饮、修理安装', label: '服务业|餐饮、修理安装',
                    children: [{ value: '餐饮', label: '餐饮', }, { value: '修理安装', label: '修理安装', }]
                },
                {
                    value: '商业服务|广告、金融、法律财务人力服务', label: '商业服务|广告、金融、法律财务人力服务',
                    children: [{ value: '广告、会展', label: '广告、会展', }, { value: '人力资源', label: '人力资源', }, { value: '创业孵化器', label: '创业孵化器', }, { value: '金融财务', label: '金融财务', }, { value: '商业咨询', label: '商业咨询', }, { value: '法律服务', label: '法律服务', }]
                },
                {
                    value: '房产建材|建筑工程监理物管', label: '房产建材|建筑工程监理物管',
                    children: [{ value: '装饰装潢', label: '装饰装潢', }, { value: '家具家居', label: '家具家居', }, { value: '建材', label: '建材', }, { value: '建筑、监理', label: '建筑、监理', }]
                },
                {
                    value: '交通物流|运输、仓储、物流、快递、车辆养护', label: '交通物流|运输、仓储、物流、快递、车辆养护',
                    children: [{ value: '物流运输、快递', label: '物流运输、快递', }, { value: '车辆养护、维修', label: '车辆养护、维修', }, { value: '物流仓储', label: '物流仓储', }]
                },
                {
                    value: '医药保健化工能源', label: '医药保健化工能源',
                    children: [{ value: '化工能源', label: '化工能源', }, { value: '眼镜面罩', label: '眼镜面罩', }, { value: '医疗保健', label: '医疗保健', }, { value: '医疗器械', label: '医疗器械', }, { value: '药品', label: '药品', }, { value: '医疗服务', label: '医疗服务', }]
                },
                {
                    value: '食品饮料|生鲜、保健产品、烟酒糖茶', label: '食品饮料|生鲜、保健产品、烟酒糖茶',
                    children: [{ value: '烟酒糖茶、饮料', label: '烟酒糖茶、饮料', }, { value: '营养产品', label: '营养产品', }, { value: '生鲜食品、糕点', label: '生鲜食品、糕点', }, { value: '珠宝钟表', label: '珠宝钟表', }, { value: '美容、化妆品', label: '美容、化妆品', }, { value: '服装、配饰', label: '服装、配饰', }]
                },
                {
                    value: 'IT、互联网||通信、电子、互联网', label: 'IT、互联网||通信、电子、互联网',
                    children: [{ value: '在线服务', label: '在线服务', }, { value: '游戏', label: '游戏', }, { value: '社交、论坛', label: '社交、论坛', }, { value: '电商平台', label: '电商平台', }, { value: '软件开发运营', label: '软件开发运营', }, { value: '家电产品', label: '家电产品', }, { value: '计算机及周边', label: '计算机及周边', }, { value: '通信', label: '通信', }]
                },
                {
                    value: '农业|农、林、牧、渔等', label: '农业|农、林、牧、渔等',
                    children: [{ value: '化肥、饲料', label: '化肥、饲料', }, { value: '农产品加工', label: '农产品加工', }]
                },
                {
                    value: '机械制造|机械车辆五金工具', label: '机械制造|机械车辆五金工具',
                    children: [{ value: '五金器械', label: '五金器械', }, { value: '车船航空器制造', label: '车船航空器制造', }, { value: '机械、加工制造', label: '机械、加工制造', }]
                },

                ],
                selectedOptions: [],
                defaultProps: {
                    children: 'children',
                    label: function (data, node) {
                        if (data.code == null || data.code == null) {
                            return data.name;
                        } else {
                            return data.code + " " + data.name;
                        }
                    }
                },
                form: {
                    tmFormType: 3,
                    tmName: "",
                    picUrl: "",
                    colorizedPicUrl: "",
                    selecttype: "自主选择",
                    totalPublicExpense: 0,
                    totalTaxes: 0,
                    totalSum: 0,
                    totalDiscounts: 0,
                    totalServiceCharge: 0,
                    totalProfitSum: 0,
                    remark: "",
                    sveItemRateConfig: "",
                },
                apply: {
                    customerType: "ent",
                    name: "",
                    code: "",
                    identityCardNo: "",
                    applyAddr: "",
                    applyArea: "",
                    zipCode: "",
                    contacts: "",
                    mobile: "",
                    email: "",
                    tel: "",
                    fax: "",
                    businessLicensePic: "",
                    businessLicensePdf: "",
                    identityCardPic: "",
                    gzwtsUrl: "",
                    smwjUrl: "",
                    notes: "",
                },
                rules: {
                    tmName: [
                        { required: true, message: '请输入商标名称' }
                    ],
                    picUrl: [
                        { required: true, message: '请上传商标图样' }
                    ],
                    colorizedPicUrl: [
                        { validator: colorizedtm, trigger: 'blur' }
                    ],
                    tmFormType: [
                        { required: true, message: '请选择商标类型' }
                    ],
                },
                nclOne: [],
                d: {},
                action: "",
                invoiceTaxRate: 10,
                step: "1",
                isRead: false,
                steps: [
                    { title: "填写基本信息" },
                    { title: "填写申请人信息" },
                    { title: "确认提交订单" },
                    { title: "支付订单" }
                ],
                beforeapply: {},
                applyrules: {
                    customerType: [
                        { type: 'string', required: true, message: '请选择申请类型', trigger: 'change' }
                    ],
                    name: [
                        { required: true, message: '请输入公司/申请人名称' }
                    ],
                    code: [
                        { required: true, message: '请输入信用代码' },
                        { validator: code, trigger: 'blur' }
                    ],
                    identityCardNo: [
                        { required: true, message: '请输入身份证号码' },
                        { validator: validateIdCard, trigger: 'blur' }
                    ],
                    zipCode: [
                        { required: true, message: '请输入邮政编码' }
                    ],
                    applyAddr: [
                        { required: true, message: '请输入执照详细地址' },
                        { validator: validateAddr, trigger: 'blur' }
                    ],
                    contacts: [
                        { required: true, message: '请输入客户联系人' }
                    ],
                    mobile: [
                        { required: true, message: '请输入联系电话' },
                        { validator: mobileValidator, trigger: 'blur' }
                    ],
                    email: [
                        { required: true, message: '请输入电子邮箱' },
                        { validator: emailValidator, trigger: 'blur' }
                    ],
                },
                order: {},
                qrcode: "",
                qrCodeJumpUrl: "",
                pay: {
                    offlinePayDocument: "",
                    paymentPlatformType: "wx"
                },
                payconfirm: false,
                tradeKey: "",
                interval: null,
                itemCode: "",
                totalDiscountsRate: 0,
                serviceCharge: 0,
                publicExpense: 0,
                company: {},
                serviceitem: {},
                floatBoxDemo: false,
                toViewImgKey: null,
                toViewImgType: false,
                toViewImgSrc: null,
                /**订单图片 */
                imageUrl: '',
                /*当前状态 */
                active: 1,
                /*弹窗标题*/
                headerInfo: '',
                dialogTableVisible: false,
                innerVisible: false,
                /**订单编号 */
                deliveryOrderNo: '',
                deliveryInfo: { 'colorizedPicUrl': "" },
                applyInfo: {},
                nclInfo: [],
                /* */
                orderFlow: {},
                currentStep: null,
                channelUserId: "",
                itemName: '',
                deliveryStatus: "",
                /*大类下标 */
                nclIndex: "",
                editNcl: {},
                editDeliveryInfo: {},
                editApply: {},
                message: {
                    info: "",
                    show: false,
                },
                listPath: {
                    path: '/1688/jdindentlist',
                    query: {
                        channelUserId: this.$route.query.channelUserId,
                        deliveryOrderNo: this.deliveryOrderNo,
                    }
                },
                showConfrim: false,
                agree: false,
                brandType: "",
                /*修改验证 对应表单的值 */
                popupValue: "",
                /**订单付款信息 */
                receiptVoucher: {},
            }
        },
    mounted: function() {
        var that = this;
        console.log(this.$route.query.channelUserId, this.deliveryOrderNo, 'ggggggggggggggggggggggggggggggggggg');
        var obj = this.$root.copyParams("", "getOssConfig", "/action/tmTools/springBoard");
        this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then(function (d) {
            that.d["key"] = "key";
            that.d["Bucket"] = d.data.Bucket;
            that.d["OSSAccessKeyId"] = d.data.OSSAccessKeyId;
            that.d["Signature"] = d.data.Signature;
            that.d["policy"] = d.data.policy;
            that.d["success_action_status"] = d.data.success_action_status;
            that.action = d.data.url;
        });
        console.log(this.$route.query, '11111111111', this.form.tmFormType);
        if (this.$route.query.deliveryOrderNo != "" && this.$route.query.channelUserId != "") {
            this.deliveryOrderNo = this.$route.query.deliveryOrderNo;
            this.channelUserId = this.$root.channelUserId = this.$route.query.channelUserId;

            this.initIndent();
        }
        if (this.$route.query.deliveryStatus != "") {
            this.deliveryStatus = this.$route.query.deliveryStatus;
            console.log(this.deliveryStatus, this.currentStep, `llllllllllllllllllll`);
            switch (this.deliveryStatus) {
                case "dsccl":
                    this.currentStep = 0;
                    break;
                case "dqrfa":
                    this.currentStep = 0;
                    break;
                case "dsh":
                    this.currentStep = 1;
                    break;
                case "ddj":
                    this.currentStep = 2;
                    break;
                case "ydj":
                    this.currentStep = 3;
                    break;
                case "ywc":
                    this.currentStep = 4;
                    break;
                default:
                    break;
            }

        }

    },
    created: function() {
        if (this.$route.query.channelUserId != "") {
            this.$root.channelUserId = this.$route.query.channelUserId;
            console.log(this.$route.query.channelUserId, "11111111111");
        }
    },
    computed: {

    },
    watch: {
        nclOne: {
            handler(newVal, oldVal){
                if (newVal.length > 0) {
                    if (newVal.length > 1) {
                        if (this.$refs.tree) {
                            this.$refs.tree.setChecked(newVal[1], false);
                            this.$refs.tree.setChecked(newVal[1].nclThree[0], false);
                            newVal.pop();
                            this.message.show = !this.message.show;
                            this.message.info = "只能选择同一个类别";
                            var timer = setTimeout(() => {
                                this.message.show = false;
                                clearTimeout(timer);
                            }, 2000);
                        }
                    };
                    if (newVal[0].nclThree.length > 10) {
                        this.$refs.tree.setChecked(newVal[0].nclThree[10], false);
                        newVal[0].nclThree.pop();
                        console.log(newVal, newVal[0].nclThree, `xxxxxxxxxxxxxxxxxxxxxxxxxxxxx`);

                        this.message.show = !this.message.show;
                        this.message.info = "最多只能选择10项";
                        var timer2 = setTimeout(() => {
                            this.message.show = false;
                            clearTimeout(timer2);
                        }, 2000);
                    }

                }

            },
            deep: true
        }

    },
    methods: {

        /*初始化订单数据 */
        initIndent(){
            var deliveryObj = this.$root.copyParams({ "deliveryOrderNo": this.deliveryOrderNo, "channelUserId": this.$route.query.channelUserId }, "getTmOrderInfo", "/action/tmOrder/springBoard");
            var applyObj = this.$root.copyParams({ "deliveryOrderNo": this.deliveryOrderNo, "channelUserId": this.$route.query.channelUserId }, "getTmApplyInfo", "/action/tmOrder/springBoard");
            var nclObj = this.$root.copyParams({ "deliveryOrderNo": this.deliveryOrderNo, "channelUserId": this.$route.query.channelUserId }, "getTmNclList", "/action/tmOrder/springBoard");
            let [loadingA, loadingB, loadingC] = [1, 1, 1];
            this.$root.loading = true;
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", deliveryObj).then((d) => {
                loadingA = 0;
                if (d.status == 0 && d.data) {
                    console.log(d, `deliveryInfo`);
                    this.deliveryInfo = d.data.tm;
                    this.form = JSON.parse(JSON.stringify(this.deliveryInfo));
                    this.editDeliveryInfo = JSON.parse(JSON.stringify(this.deliveryInfo));
                    this.form.tmFormType = Number(this.form.tmFormType);
                    if (d.data.receiptVoucher.length > 0) {
                        this.receiptVoucher = d.data.receiptVoucher[0];
                    }
                    switch (this.form.tmFormType) {
                        case 3:
                            this.brandType = "文字";
                            break;
                        case 4:
                            this.brandType = "图形";
                            break;
                        case 5:
                            this.brandType = "文字及图形";
                            break;
                        default:
                            break;
                    }
                    this.itemCode = d.data.tm.itemCode == 'zzsbzc' ? true : false;
                    console.log(this.form, "lllllllllllllllllllllllllllllll");
                    this.orderFlow = d.data.orderFlow;
                    this.orderFlow.map((item, index) => {
                        item.createDate = new Date(item.createDate).toLocaleString('chinese', { hour12: false });
                    })
                }
            }).then(() => {
                if (loadingA == 0 && loadingB == 0 && loadingC == 0) {
                    this.$root.loading = false;
                }
            });
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", applyObj).then((d) => {
                loadingB = 0;
                console.log(d, `applyObj`);
                if (d.status == 0 && d.data) {
                    this.applyInfo = d.data;
                    this.apply = JSON.parse(JSON.stringify(this.applyInfo));
                    this.editApply = JSON.parse(JSON.stringify(this.apply));
                    console.log(this.editApply,"bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
                }
            }).then(() => {
                if (loadingA == 0 && loadingB == 0 && loadingC == 0) {
                    this.$root.loading = false;
                }
            });
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", nclObj).then((d) => {
                loadingC = 0;
                console.log(d.data, `nclObj`);
                if (d.status == 0 && d.data) {
                    this.nclInfo = d.data;
                    this.nclInfo.map((item, index) => {
                        item.nclSmallCodes = JSON.parse(item.nclSmallCodes);
                        /* 
                        console.log(item, item.nclSmallCodes, "////////////////////////////////");
                        */
                        item.code = item.nclOneCodes;
                        item.name = this.ncldata[item.nclOneCodes.replace(/\b(0+)/gi, "") - 1].name;
                        item.nclThree = item.nclSmallCodes;
                        this.nclOne.push(item);
                    });
                    this.ncl = JSON.parse(JSON.stringify(this.nclInfo));
                }
            }).then(() => {
                if (loadingA == 0 && loadingB == 0 && loadingC == 0) {
                    this.$root.loading = false;
                }
            });
        },
        showDialog(from, index){
            this.nclIndex = index;
            console.log(this.nclIndex, from);
            this.dialogTableVisible = true;
            switch (from) {
                case 1:
                    this.headerInfo = "商标信息";
                    this.popupValue = "form";

                    break;
                case 2:
                    this.headerInfo = "商标类别";
                    break;
                case 3:
                    this.headerInfo = "交官文件";
                    this.popupValue = "apply";
                    break;
                case 4:
                    this.headerInfo = "申请人信息";
                    this.popupValue = "apply";
                    break;
                case 5:
                    this.headerInfo = "订单联系人";
                    this.popupValue = "apply";
                    break;
                case 6:
                    this.headerInfo = "付款信息";
                    break;
                default:
                    break;
            }

        },
        pointsRuleColor(i) {
            if (i < parseInt(this.step)) {
                return 'color: #FFFFFF;'
            } else if (i == parseInt(this.step)) {
                return 'color: #FFFFFF;'
            } else if (i > parseInt(this.step)) {
                return 'color: #666666;'
            }
        },
        pointsRuleBackColor(i) {
            if (i < parseInt(this.step)) {
                return 'background: #0989C5; z-index: ' + Math.abs(i - 5)
            } else if (i == parseInt(this.step)) {
                return 'background: #0989C5;z-index: ' + Math.abs(i - 5)
            } else if (i > parseInt(this.step)) {
                return 'background: #EFF1F9;z-index: ' + Math.abs(i - 5)
            }
        },
        toViewImg(src) {
            this.toViewImgSrc = src;
            this.toViewImgType = true
        },
        mouseOverDemo(v, k) {
            if (v == 99) {
                this.floatBoxDemo = true
            } else {
                if (k) {
                    this.toViewImgKey = k
                } else {
                    this.toViewImgKey = v
                }
            }
        },
        mouseLeaveDemo(v) {
            this.floatBoxDemo = false;
            this.toViewImgKey = null
        },
        userBeforeApply: function() {
            this.apply = this.beforeapply;
        },
        gotoorder: function() {

        },
        searchInputBlur(){
            var text = this.filterText;
            if (text == "" || text == null) {
                this.initNclData();
            }
        },
        nclSearch(){
            var that = this;
            var text = this.filterText;
            if (text == "" || text == null) {
                this.initNclData();
            } else {
                this.nclSearchLoading = true;
                console.log(this.checkedNcl, "ncls..............................");
                var getNclByLikeNameAndNcl = { "name": text, "ncls": this.checkedNcl };
                var getNclByLikeNameAndNcl = this.$root.copyParams(getNclByLikeNameAndNcl, "getNclByLikeNameAndNcl", "/action/tmTools/springBoard");
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", getNclByLikeNameAndNcl).then(function (d) {
                    if (d.status == 0) {
                        that.ncldata = d.data;
                    }
                    that.nclSearchLoading = false;
                }).catch(function (e) {
                    that.nclSearchLoading = false;
                });
            }

        },
        initNclData(){
            this.ncldata = [
                { code: "01", name: "化学原料" }, { code: "02", name: "颜料油漆" }, { code: "03", name: "日化用品" }, { code: "04", name: "燃料油脂" }, { code: "05", name: "医药" },
                { code: "06", name: "金属材料" }, { code: "07", name: "机械设备" }, { code: "08", name: "手工器械" }, { code: "09", name: "科学仪器" }, { code: "10", name: "医疗器械" },
                { code: "11", name: "灯具空调" }, { code: "12", name: "运输工具" }, { code: "13", name: "军火烟火" }, { code: "14", name: "珠宝钟表" }, { code: "15", name: "乐器" },
                { code: "16", name: "办公用品" }, { code: "17", name: "橡胶制品" }, { code: "18", name: "皮革皮具" }, { code: "19", name: "建筑材料" }, { code: "20", name: "家具" },
                { code: "21", name: "厨房洁具" }, { code: "22", name: "绳网袋篷" }, { code: "23", name: "纱线丝" }, { code: "24", name: "布料床单" }, { code: "25", name: "服装鞋帽" },
                { code: "26", name: "纽扣拉链" }, { code: "27", name: "地毯席垫" }, { code: "28", name: "健身器材" }, { code: "29", name: "食品" }, { code: "30", name: "方便食品" },
                { code: "31", name: "饲料种籽" }, { code: "32", name: "啤酒饮料" }, { code: "33", name: "酒" }, { code: "34", name: "烟草烟具" }, { code: "35", name: "广告销售" },
                { code: "36", name: "金融物管" }, { code: "37", name: "建筑修理" }, { code: "38", name: "通讯服务" }, { code: "39", name: "运输贮藏" }, { code: "40", name: "材料加工" },
                { code: "41", name: "教育娱乐" }, { code: "42", name: "网站服务" }, { code: "43", name: "餐饮住宿" }, { code: "44", name: "医疗园艺" }, { code: "45", name: "社会服务" }
            ];
        },
        error(err){
            this.$message.warning(`上传失败，请重新上传`);
            console.log(err);
        },
        uploadsuccess2(result, obj){
            if (obj.flag == "zfpz") {
                this.pay.offlinePayDocument = result;
            }
        },
        uploadsuccess(obj){
            var that = this;
            if (this.loadingKey == 1) {
                that.loading1 = true;
            } else if (this.loadingKey == 2) {
                that.loading2 = true;
            } else if (this.loadingKey == 3) {
                that.loading3 = true;
            } else if (this.loadingKey == 0) {
                that.loading = true;
            }
            if (obj.flag == "picUrl") {
                console.log("黑白图样------调整宽高", obj);
                var uploadStandardTm = { "key": obj.result };
                var uploadStandardTm = this.$root.copyParams(uploadStandardTm, "uploadStandardTm", "/action/tmTools/springBoard");
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", uploadStandardTm).then(function (d) {
                    console.log(d);
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    if (d.status == 0) {
                        that.form.picUrl = d.data.url2;
                        that.form.colorizedPicUrl = d.data.url;
                    } else {
                        that.form.picUrl = "";
                        that.form.colorizedPicUrl = "";
                        that.$message.warning(`上传失败请重新上传`);
                        return false;
                    }
                }).catch(function () {
                    that.form.picUrl = "";
                    that.form.colorizedPicUrl = "";
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    that.$message.warning(`上传失败请重新上传`);
                    return false;
                });
            }
            if (obj.flag == "colorizedPicUrl") {
                this.$root.getReq("/web/toolCtl/adjustTMSize", { "key": obj.key }).then(function (d) {
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    if (d.status == 0) {
                        that.form.colorizedPicUrl = d.data.url;
                        return
                    } else {
                        that.form.colorizedPicUrl = "";
                        that.$message.warning(`上传失败请重新上传`);
                        return false;
                    }
                }).catch(function () {
                    that.form.colorizedPicUrl = "";
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    that.$message.warning(`上传失败请重新上传`);
                    return false;
                });

            }
            if (obj.flag == "yyzz") {
                console.log(obj, "oooooooooooooooooooooooooooooooo");
                var pic2pdf = { "key": obj.result };
                var pic2pdf = this.$root.copyParams(pic2pdf, "pic2pdf", "/action/tmTools/springBoard");
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", pic2pdf).then(function (d) {
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    if (d.status == 0) {
                        that.editApply.businessLicensePic = obj.result;
                        that.editApply["businessLicensePdf"] = d.data.url;
                        return
                    } else {
                        that.apply.businessLicensePdf = "";
                        that.$message.warning(`上传失败请重新上传`);
                        return false;
                    }
                }).catch(function (e) {
                    that.apply.businessLicensePdf = "";
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    that.$message.warning(`上传失败请重新上传`);
                    return false;
                })
            }
            if (obj.flag == "sfz") {
                var sfz = { "key": obj.result };
                var sfz = this.$root.copyParams(sfz, "pic2pdf", "/action/tmTools/springBoard");
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", sfz).then(function (d) {
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    if (d.status == 0) {
                        that.editApply.identityCardPic = obj.result;
                        that.editApply["identityCardPdf"] = d.data.url;
                        return;
                    } else {
                        that.apply.identityCardPdf = "";
                        that.$message.warning(`上传失败请重新上传`);
                        return false;
                    }
                }).catch(function (e) {
                    that.apply.identityCardPdf = "";
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    that.$message.warning(`上传失败请重新上传`);
                    return false;
                })
            }
            if (obj.flag == "wts") {
                var adjustWTSSize = { "key": obj.result };
                that.editDeliveryOrderNo = JSON.parse(JSON.stringify(that.apply));
                var adjustWTSSize = this.$root.copyParams(adjustWTSSize, "adjustWTSSize", "/action/tmTools/springBoard");
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", adjustWTSSize).then(function (d) {
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    if (d.status == 0) {
                        that.editDeliveryInfo.gzwtsUrl = obj.result;
                        
                        return;
                    } else {
                        that.$refs[obj.flag][0].result = "";
                        that.$message.warning(`上传失败请重新上传`);
                        return false;
                    }

                }).catch(function () {
                    that.$refs[obj.flag][0].result = "";
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                    that.$message.warning(`上传失败请重新上传`);
                    return false;
                });
            }
            if (obj.flag == "yxq") {
                console.log(obj);
                that.editDeliveryInfo.smwjUrl = obj.result;
                console.log(that.editDeliveryInfo, `mmmmmmmmmmmmmmmmmmmmmmmmmmmmm`);
                /**that.apply["smwjUrl"] = obj.result; */
                setTimeout(() => {
                    that.loading1 = false;
                    that.loading2 = false;
                    that.loading3 = false;
                    that.loading = false;
                }, 1000);
                return
            }
        },

        beforeUpload(file){
            var that = this;
            var isSize = false;
            var img = new Image();
            var _URL = window.URL || window.webkitURL;
            img.onload = function () {

                if (img.width == img.height) {
                    isSize = true;
                    that.$refs.ys_upload.ifupload = true;
                } else {
                    isSize = false;
                    that.$message.warning('上传的图片宽高必须相等');
                    that.$refs.ys_upload.$refs.upload.abort(file);
                }
            };
            img.src = window.URL.createObjectURL(file);
        },
        showUrl(url){
            window.open(url);
        },
        closeTag(nclThree, index, index2){
            if (this.form.status == 2) {
                this.$message.warning("已生成订单，不可修改");
                return false;
            }
            var publicExpense = this.serviceitem.publicExpense || 0;
            publicExpense = Number(publicExpense);
            var nclSmallPrice = publicExpense / 10;
            nclSmallPrice = Number(nclSmallPrice.toFixed(2));
            this.$refs.tree.setChecked(nclThree, false);
            this.nclOne[index].nclThree.splice(index2, 1);
            if (this.nclOne[index].nclThree.length > 10) {
                this.nclOne[index].price = Number(publicExpense + (this.nclOne[index].nclThree.length - 10) * nclSmallPrice);
            } else if (this.nclOne[index].nclThree.length > 0 && this.nclOne[index].nclThree.length <= 10) {
                this.nclOne[index].price = publicExpense;
            } else if (this.nclOne[index].nclThree.length == 0) {
                this.nclOne[index].price = 0;
                this.nclOne.splice(index, 1);
            }
            this.updatePriceType = false;

            var json = { json: this.nclOne };
            var jsonStr = JSON.stringify(json);
        },
        /*清除全部*/
        removeAll() {
            if (this.nclOne.length == 0) {
                return;
            }
            let dataRecieve = this.$refs.tree.getCheckedNodes();
            this.$confirm('确定清空所有已选商品/服务项吗？', '提示', {
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                type: 'warning'
            }).then(() => {
                dataRecieve.forEach((item, index) => {
                    this.$refs.tree.setChecked(item, false, true);
                });
                this.nclOne = [];
                this.$message({
                    type: 'success',
                    message: '删除成功!'
                });
            }).catch(() => {
                this.$message({
                    type: 'info',
                    message: '已取消删除'
                });
            })
        },
        removeNclOne(index, nclone){
            if (this.form.status == 2) {
                this.$message.warning("已生成订单，不可修改");
                return false;
            }
            this.$confirm('确定清除当前选项吗？', '提示', {
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                type: 'warning'
            }).then(() => {
                this.ppnclArr = nclone;
                this.$refs.tree.setChecked(nclone, false, true);
                let dataRecieve = this.$refs.tree.getCheckedNodes();
                if (dataRecieve.length == 0) {
                    this.nclOne.splice(index, 1);
                }
                this.updatePriceType = false;

                this.$message({
                    type: 'success',
                    message: '删除成功!'
                });
            }).catch(() => {
                this.$message({
                    type: 'info',
                    message: '已取消删除'
                });
            })
        },
        handleCheckChange(obj, a, b) {
            let dataRecieve = this.$refs.tree.getCheckedNodes();
            console.log(obj, a, b, '1233333333333333333333344444444444444444444', dataRecieve, this.checkedNcl);
            if (obj.type) {
                return
            }
            /*let ppncl = this.ppnclArr;*/
            let ppncl = this.$refs.tree.getNode(obj).parent.parent.data;
            let key = (dataRecieve.length - 1);
            let eData = null;

            if (dataRecieve.length != 0 && !obj.type) {
                if (dataRecieve.length == 1) {
                    eData = dataRecieve[key];
                } else {
                    eData = obj;
                }
                var nclThree = [eData];
                var publicExpense = this.publicExpense || 0;
                publicExpense = Number(publicExpense);
                var nclSmallPrice = publicExpense / 10;
                nclSmallPrice = Number(nclSmallPrice.toFixed(2));
                var result = this.nclOneIsExist(ppncl.code);
                if (a) {
                    if (result.result) {
                        var nclThree = this.nclOne[result.index].nclThree;
                        var hasNclThree = this.nclThreeIsExist(eData.name, nclThree);
                        if (!hasNclThree.result && a) {
                            this.nclOne[result.index].nclThree.push(eData);
                            if (this.nclOne[result.index].nclThree.length > 10) {
                                this.nclOne[result.index].price = Number(publicExpense + (this.nclOne[result.index].nclThree.length - 10) * nclSmallPrice);
                            }
                        }
                    } else {
                        var data = {
                            code: ppncl.code,
                            name: ppncl.name,
                            price: publicExpense,
                            nclThree: nclThree,
                        };
                        this.nclOne.push(data);
                    }
                } else {
                    this.nclOne.forEach((item, index) => {
                        if (item.name == ppncl.name) {
                            this.nclOne[index].nclThree.forEach((list, key) => {
                                if (list.name == obj.name) {
                                    this.closeTag(item, index, key)
                                }
                            })
                        }
                    })
                }
                this.updatePriceType = false;
            } else if (this.nclOne.length != 0 && !a) {
                this.nclOne.forEach((item, index) => {
                    if (item.name == ppncl.name) {
                        this.nclOne[index].nclThree.forEach((list, key) => {
                            if (list.name == obj.name) {
                                this.closeTag(item, index, key)
                            }
                        })
                    }
                })
            }
        },
        nodeClick(obj, e, a){
            console.log(obj, e, a);
            if (e.level == 1) {
                this.ppnclArr = obj;
            }
            var that = this;
            if (this.form.status == 2) {
                this.$message.warning("已生成订单，不可修改");
                return false;
            }
            if (e.level < 3 && e.childNodes.length == 0) {
                this.nclSearchLoading = true;
                var getNcl = {
                    nclcode: obj.code,
                };
                var getNcl = this.$root.copyParams(getNcl, "getNcl", "/action/tmTools/springBoard");
                this.$root.postReq("/web/trademark/tmqueryCtl/doPost", getNcl).then(function (d) {
                    var data = d.data.rows;
                    e.childNodes = [];
                    for (var i = 0; i < data.length; i++) {
                        that.appendNode(data[i], e);
                        if (e.level == 1) {
                            data[i]['type'] = 1;
                            that.nclSearchLoading = false;
                        }
                    }
                    if (e.level == 2) {
                        that.nclSearchLoading = false;
                        that.nclOne.forEach((item, index) => {
                            if (item.name == e.parent.data.name) {
                                that.nclOne[index].nclThree.forEach((list, key) => {
                                    that.$refs.tree.setChecked(list, true);
                                });
                            }
                        });
                    }

                });
            }

            if (e.level == 3) {
                this.$refs.tree.setChecked(e.data, true);
                return;

                this.CCtype = false;
                var ppncl = e.parent.parent.data;
                var nclThree = [e.data];
                var publicExpense = this.publicExpense || 0;
                publicExpense = Number(publicExpense);
                var nclSmallPrice = publicExpense / 10;
                nclSmallPrice = Number(nclSmallPrice.toFixed(2));
                var result = this.nclOneIsExist(ppncl.code);
                if (result.result) {
                    var nclThree = this.nclOne[result.index].nclThree;
                    var hasNclThree = this.nclThreeIsExist(e.data.name, nclThree);
                    if (!hasNclThree.result) {
                        this.nclOne[result.index].nclThree.push(e.data);

                        if (this.nclOne[result.index].nclThree.length > 10) {
                            this.nclOne[result.index].price = Number(publicExpense + (this.nclOne[result.index].nclThree.length - 10) * nclSmallPrice);
                        }

                    }
                } else {
                    var data = {
                        code: ppncl.code,
                        name: ppncl.name,
                        price: publicExpense,
                        nclThree: nclThree,
                    };
                    this.nclOne.push(data);
                }

            }
        },
        nclThreeIsExist(name, nclThree){
            if (nclThree.length < 1) {
                return { result: false, index: 0 };
            } else {
                for (var i = 0; i < nclThree.length; i++) {
                    if (nclThree[i].name == name) {
                        return { result: true, index: i };
                    }
                }
                return { result: false, index: 0 };
            }
        },
        nclOneIsExist(nclOneCode){
            if (this.nclOne.length < 1) {
                return { result: false, index: 0 };
            } else {
                for (var i = 0; i < this.nclOne.length; i++) {
                    if (this.nclOne[i].code == nclOneCode) {
                        return { result: true, index: i };
                    }
                }
                return { result: false, index: 0 };
            }
        },
        word2pic(){
            if (this.form.tmName == "" || this.form.tmName == null) {
                this.loading = true;
                this.loading = false;
                return false;
            }
            var that = this;
            this.loading = true;
            var word2pic = { "word": this.form.tmName };
            console.log(word2pic, `xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx`);
            var word2pic = this.$root.copyParams(word2pic, "word2pic", "/action/tmTools/springBoard");
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", word2pic).then(function (d) {
                if (d.status == 0) {
                    that.form.picUrl = d.data.url;
                    that.form.colorizedPicUrl = d.data.url;

                    that.loading = false;
                } else {
                    that.form.picUrl = "";
                    that.form.colorizedPicUrl = "";
                    that.loading = false;
                    that.$message.warning(`上传失败请重新生成`);
                    return false;
                }

            }).catch(function () {
                that.form.picUrl = "";
                that.loading = false;
                that.$message.warning(`上传失败请重新生成`);
                return false;
            });
        },

        appendNode(data, pnode) {
            this.$refs.tree.append(data, pnode);
            this.nclOne.forEach((item, index) => {
                if (item.name == this.ppnclArr.name) {
                    this.nclOne[index].nclThree.forEach((list, key) => {
                        this.$refs.tree.setChecked(list, true);
                    })
                }
            });
        },
        filterNode(value, data) {
            if (!value) return true;
            return data.label.indexOf(value) !== -1;
        },

        aiadive(){

            if (this.selectedOptions.length == 0) {
                this.$message.warning(`请选择行业`);
                return false;
            }
            var publicExpense = this.serviceitem.publicExpense || 0;
            publicExpense = Number(publicExpense);
            var nclSmallPrice = publicExpense / 10;
            nclSmallPrice = Number(nclSmallPrice.toFixed(2));
            this.$root.getReq("/web/orderCtl/aiadive", { seltype: this.selectedOptions }).then(d => {
                var ncl = JSON.parse(d.data);
                var data = ncl.ncl;
                if (data) {
                    for (var i = 0; i < data.length; i++) {
                        var price = publicExpense;
                        if (data[i].nclThree.length > 10) {
                            price = price + (data[i].nclThree.length - 10) * nclSmallPrice;
                        }
                        data[i].price = price;
                    }
                    this.nclOne = data;
                }

            });
        },
        selfclear(){
            this.nclOne = [];
        },

        savehistory(){
            var entobj = {
                regLocation: this.apply.applyAddr, entName: this.apply.name, domainEntName: this.apply.name, creditCode: this.apply.code,
                businessLicensePic: this.apply.businessLicensePic, customerType: this.apply.customerType, identityCardNo: this.apply.identityCardNo,
                identityCardPic: this.apply.identityCardPic
            };
            if (this.apply.customerType == "ent") {
                var entData = localStorage.getItem("historyentlist");
                var o = "";
                if (entData) {
                    entData = JSON.parse(entData);
                    var entList = entData.data;
                    if (entList && entList.length > 0) {
                        for (var i = 0; i < entList.length; i++) {
                            if (entList[i].creditCode == this.apply.code || !this.apply.code) {
                                return;
                            }
                        }
                        if (entList.length >= 20) {
                            entList.shift();
                        }
                        entList.push(entobj);
                        o = { data: entList };
                    } else {
                        o = { data: [entobj] };
                    }
                } else {
                    o = { data: [entobj] };
                }
                var ostring = JSON.stringify(o);
                localStorage.setItem("historyentlist", ostring);
            }
            if (this.apply.customerType == "person") {
                var personData = localStorage.getItem("historypersonlist");
                var o = "";
                if (personData) {
                    personData = JSON.parse(personData);
                    var personList = personData.data;
                    if (personList && personList.length > 0) {
                        for (var i = 0; i < personList.length; i++) {
                            if (personList[i].creditCode == this.apply.code || !this.apply.code) {
                                return;
                            }
                        }
                        if (personList.length >= 20) {
                            personList.shift();
                        }
                        personList.push(entobj);
                        o = { data: personList };
                    } else {
                        o = { data: [entobj] };
                    }
                } else {
                    o = { data: [entobj] };
                }
                var ostring = JSON.stringify(o);
                localStorage.setItem("historypersonlist", ostring);
            }
        },
        historyapplierchange(d){
            if (d) {
                this.editApply.name = d.entName || "";
                this.editApply.applyAddr = d.regLocation || "";
                this.editApply.code = d.creditCode || "";
                this.editApply.businessLicensePic = d.businessLicensePic || "";
                this.editApply.identityCardNo = d.identityCardNo || "";
                this.editApply.identityCardPic = d.identityCardPic || "";

            }
        },
        selectpersoninput(v){
            if (v != this.apply.name) {
                this.apply.name = v;
                this.apply.applyAddr = "";
                this.apply.code = "";
                this.apply.businessLicensePic = "";
                this.apply.identityCardNo = "";
                this.apply.identityCardPic = "";
            }
        },
        applierChange(v){
            obj = { companyName: this.apply.name };
            var obj = this.$root.copyParams(obj, "getEntregistryByCompanyName", "/action/tmTools/springBoard");
            this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then(d => {
                console.log(d, "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
                if (d.creditCode && d.creditCode != "") {
                    this.apply.applyAddr = d.businessAddress;
                    this.apply.code = d.creditCode;
                }
            });
        },

        setKey(name, flag){
            name = name.substring(name.length - 5);
            var myDate = new Date();
            var key = "zc_" + flag + Math.round(Math.random() * 10000) + myDate.getTime() + myDate.getFullYear() + myDate.getMonth() + myDate.getDate() + ".jpg";

            this.$refs[flag].d.key = key;
        },
        tobefore(){
            this.toTop();
            this.step = Number(this.step) - 1;
            this.step = this.step.toString();
        },
        wxPay: function() {

        },
        closePayConfirm(){

        },
        checkPayState(){

        },
        orderUpdate(){

        },
        createWTS: function() {
            var that = this;
            if (!this.apply.customerType) {
                that.$message.warning("请选择申请人类型");
                return;
            } else if (!this.apply.name) {
                that.$message.warning("请填写公司名称");
                return;
            } else if (this.apply.customerType == "person" && !this.apply.identityCardNo) {
                that.$message.warning("请填写身份证号码");
                return;
            } else if (!this.apply.applyAddr) {
                that.$message.warning("请填写执照详细地址");
                return;
            }
            if (!this.company || !this.company.contact) {
                that.$message.warning("代理信息为空，生成委托书失败");
                return;
            }
            if (!this.company) {
                that.$message.warning("代理信息为空，生成委托书失败");
                return;
            }
            var params = null;
            var company = this.$root.currentCompany;
            if (!this.apply.zipCode) {
                that.$message.warning("请填写邮政编码");
                return;
            }
            if (company && company.companyType == "self") {
                if (!this.apply.contacts) {
                    that.$message.warning("请填写客户联系人");
                    return;
                }
                if (!this.apply.mobile) {
                    that.$message.warning("请填写联系电话");
                    return;
                }
                params = this.apply.customerType + ";" + this.apply.name + ";" + this.apply.identityCardNo + ";" + this.form.tmFormType
                    + ";" + this.form.colorizedPicUrl + ";" + this.form.picUrl + ";" + this.apply.applyAddr;
                params = params + ";" + this.apply.contacts + ";" + this.apply.mobile + ";" + this.apply.zipCode + ";" + this.company.name;
                params = encodeURIComponent(params);

            } else {
                params = this.apply.customerType + ";" + this.apply.name + ";" + this.apply.identityCardNo + ";" + this.form.tmFormType
                    + ";" + this.form.colorizedPicUrl + ";" + this.form.picUrl + ";" + this.apply.applyAddr;
                params = params + ";" + this.company.contact + ";" + this.company.contactmobile + ";" + this.apply.zipCode + ";" + this.company.name;
                params = encodeURIComponent(params);

            }
            this.$confirm('是否确定生成委托书?', '提示', {
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                type: 'warning'
            }).then(() => {
                that.$root.showMask();
                var url = window.location.href.split("#")[0] + "wts?" + "params=" + params;
                this.$root.getReq("/web/trademark/tmqueryCtl/createWTS", { "url": url }).then(function (d) {
                    console.log(d);
                    if (d.data.url != "" && d.data.url != null) {
                        window.open(d.data.url);
                    } else {
                        that.$message.warning(`操作失败`);
                    }
                    that.$root.hideMask();
                }).catch(function (e) {
                    that.$root.hideMask();
                    that.$message.warning(`操作失败`);
                });
            }).catch(() => {
                this.$message({
                    type: 'info',
                    message: '已取消'
                });
            });

        },
        toTop(){
            $('#app').animate({ scrollTop: 0 }, 10);
        },

        checkClick(){

            this.showSelectedNclList = true;
            this.fkey = 1;
        },
        checkConfirm(){
            this.showSelectedNclList = false;
            this.fkey = 0;

            this.nclSearch();
        },
        handleCheckAllChange(val)
        {
            this.checkedNcl = val ? this.nclOptions : [];
            this.isIndeterminate = false;
        },
        handleCheckedNclChange(value){
            let checkedCount = value.length;
            this.checkAll = checkedCount === this.ncl.length;
            this.isIndeterminate = checkedCount > 0 && checkedCount < this.ncl.length;
        },
        clearNclText(){
            this.filterText = "";
            this.checkedNcl = [];
            this.nclSearch();
        },
        openPdf(v){
            if (v) {
                window.open(v);
            } else {
                this.$message.warning("您还没有上传相关材料");
            }
        },
        submitEdit(v, agree){
            console.log(v);
            this.$nextTick(() => {
                if (v != "商标类别" && v != "交官文件" ) {
                    this.$refs[this.popupValue].validate(valid => {
                        if (valid) {
                            console.log(valid);
                            switch (v) {
                                case '商标信息':
                                    this.$root.loading = true;
                                    this.form.deliveryOrderNo = this.deliveryOrderNo;
                                    var obj = this.$root.copyParams(this.form, "updateTmInfo", "/action/tmOrder/springBoard", "yes", "yes");
                                    this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then((res) => {
                                        if (res.status == 0) {
                                            console.log(res);
                                            this.dialogTableVisible = false;
                                            this.$message({
                                                type: 'success',
                                                message: '修改成功!'
                                            });
                                            this.$root.loading = false;
                                            this.$router.go(0);
                                        } else {
                                            this.$message(res.msg);
                                            this.$root.loading = false;
                                        }
                                    }).catch((e) => {
                                        this.$message(e);
                                    });
                                    break;

                                case '申请人信息':
                                    this.$root.loading = true;
                                    this.editApply.deliveryOrderNo = this.deliveryOrderNo;
                                    var obj = this.$root.copyParams(this.editApply, "updateCustomerInfo", "/action/tmOrder/springBoard", "yes", "yes");
                                    this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then((res) => {
                                        if (res.status == 0) {
                                            console.log(res);
                                            this.dialogTableVisible = false;
                                            this.$message({
                                                type: 'success',
                                                message: '提交成功!'
                                            });
                                            this.$root.loading = false;
                                            this.$router.go(0);

                                        } else {
                                            this.$message(res.msg);
                                        }
                                    }).catch((e) => {
                                        this.$message(e);
                                    });
                                    break;
                                case '订单联系人':
                                    this.$root.loading = true;
                                    this.editApply.deliveryOrderNo = this.deliveryOrderNo;
                                    this.editApply.name = this.editApply.contacts;
                                    console.log(this.editApply, `zzzzzzzzzzzzzzzzzzzz`);
                                    var obj = this.$root.copyParams(this.editApply, "updateContacts", "/action/tmOrder/springBoard", "yes", "yes");
                                    this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then((res) => {
                                        if (res.status == 0) {
                                            console.log(res);
                                            this.dialogTableVisible = false;
                                            this.$message({
                                                type: 'success',
                                                message: '提交成功!'
                                            });
                                            this.$root.loading = false;
                                            this.$router.go(0);
                                        } else {
                                            this.$message(res.msg);
                                        }
                                    }).catch((e) => {
                                        this.$message(e);
                                    });
                                    break;
                                default:
                                    break;
                            }

                        } else {
                            console.log('error submit!!');
                            this.$message.warning("请核对您的信息");
                            return false;
                        }
                    });
                } else {
                    if (v == "交官文件") {
                        this.$root.loading = true;
                        this.editApply.deliveryOrderNo = this.deliveryOrderNo;
                        console.log(this.editApply,this.deliveryOrderNo,`mmmmmmmmmmmmmmmmmmmmmm`);
                        this.editApply.gzwtsUrl = this.editDeliveryInfo.gzwtsUrl;
                        this.editApply.smwjUrl = this.editDeliveryInfo.smwjUrl;
                        var obj = this.$root.copyParams(this.editApply, "updateOfficial", "/action/tmOrder/springBoard", "yes", "yes");
                        this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then((res) => {
                            if (res.status == 0) {
                                console.log(res);
                                this.dialogTableVisible = false;
                                this.$message({
                                    type: 'success',
                                    message: '提交成功!'
                                });
                                this.$root.loading = false;
                                this.$router.go(0);
                            } else {
                                this.$message(res.msg);
                            }
                        }).catch((e) => {
                            this.$message(e);
                        });
                    }
                    if (v == "商标类别") {
                        this.editNcl.deliveryOrderNo = this.deliveryOrderNo;
                        this.editNcl.tbCode = this.nclInfo[this.nclIndex].tbCode;
                        this.editNcl.nclOneCodes = this.nclOne[0].code;
                        this.editNcl.nclSmallCodes = this.nclOne[0].nclThree;
                        console.log(this.nclInfo, this.nclOne, this.editNcl, `xxxxxxxxxxxxxxxxxxxxxxxx`);
                        if (this.nclOne.length > 0) {
                            if (this.nclOne[0].nclThree.length < 10) {
                                this.nclSelected = this.nclOne[0].nclThree.length;
                                this.showConfrim = true;
                                if (agree) {
                                    this.agree = agree;
                                    this.showConfrim = false;
                                    this.$root.loading = true;
                                } else {
                                    return;
                                }
                            }
                        }
                        var obj = this.$root.copyParams(this.editNcl, "updateNclInfo", "/action/tmOrder/springBoard", "yes", "yes");
                        this.$root.postReq("/web/trademark/tmqueryCtl/doPost", obj).then((res) => {
                            if (res.status == 0) {
                                console.log(res);
                                this.dialogTableVisible = false;
                                this.$message({
                                    type: 'success',
                                    message: '修改成功!'
                                });
                                this.$root.loading = false;
                                this.$router.go(0);

                            } else {
                                this.$message(res.msg);
                            }
                        }).catch((e) => {
                            this.$message(e);
                        });
                    }




                }

            });

        },
        closeConfrim(){
            this.showConfrim = false;
        },


    },
    vname: "gsb-jdindentdetail"
}
