var System = require("../../system");
var settings = require("../../../config/settings");
const querystring = require('querystring');
const ApiBase = require("../api.base");

class ChinaPatentSearchApi extends ApiBase {
  constructor() {
    super();
    this.patentUrl = settings.reqEsAddrIc() + "bigdata_patent_op/_search";
  };
  buildDate(date) {
    var date = new Date(date);
    var time = Date.parse(date);
    time = time / 1000;
    return time;
  };
  async ObtainChinaPatentInfo(obj) {
    console.log("----------------api-ObtainChinaPatentInfo----------------");
    console.log(obj);
    var data = await this.checkKey(obj.appKey);
    if (data && data.status && data.status == -1) {
      return data;
    }
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
    };
    var applynum = obj.applynum == null ? "" : obj.applynum;//专利申请号
    if (applynum != null && applynum != "") {
      var param = {
        "term": {
          "filing_no": applynum
        }
      }
      params.query.bool.must.push(param)
    }
    var publishnum = obj.publishnum == null ? "" : obj.publishnum;//专利公开号
    if (publishnum != null && publishnum != "") {
      var arr = publishnum.split("");
      if (arr[arr.length - 1] == "A") {
        var param = {
          "term": {
            "pub_no": publishnum
          }
        };
      } else {
        var param = {
          "term": {
            "gr_no": publishnum
          }
        };
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits.hits
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null
      };
    }

  };

  async CommomSearchbyTitle(obj) {//根据标题查询聚合
    console.log("--------CommomSearchbyTitle----------");
    console.log(obj);
    var data = await this.checkKey(obj.appKey);
    if (data && data.status && data.status == -1) {
      return data;
    }

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var title = obj.title == null ? "" : obj.title;
    if (title == "") {
      return { status: -1, msg: "传入标题信息为空", data: null, buckets: null };
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "match": {
        "filing_name": title
      }
    }
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CommomSearchbyFilingno(obj) {//根据申请号查询聚合
    var data = await this.checkKey(obj.appKey);
    if (data && data.status && data.status == -1) {
      return data;
    }

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var filingno = obj.filingno == null ? "" : obj.filingno;
    if (filingno == "") {
      return { status: -1, msg: "传入的申请号信息为空", data: null, buckets: null };
    }
    else {
      filingno = filingno.replace("CN", "").replace("cn", "").replace(".", "");
      if (filingno.length == 13) {
        filingno = filingno.substr(0, 12);
      }
      else if (filingno.length == 9) {
        filingno = filingno.substr(0, 8);
      }
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "wildcard": {
        "filing_no": "*" + filingno + "*"
      }
    }
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CommomSearchbyPubno(obj) {//根据公开号查询聚合
    var data = await this.checkKey(obj.appKey);
    if (data && data.status && data.status == -1) {
      return data;
    }

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var pubno = obj.pubno == null ? "" : obj.pubno;
    if (pubno == "") {
      return { status: -1, msg: "传入的公开号信息为空", data: null, buckets: null };
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "bool": {
        "should": [
        ]
      }
    }

    var parr = {
      "wildcard": {
        "pub_no": "*" + pubno + "*"
      }
    }
    param.bool.should.push(parr)

    parr = {
      "wildcard": {
        "gr_no": "*" + pubno + "*"
      }
    }
    param.bool.should.push(parr)
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CommomSearchbyApplicant(obj) {//根据申请人查询聚合
    var data = await this.checkKey(obj.appKey);
    if (data && data.status && data.status == -1) {
      return data;
    }

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var applicant = obj.applicant == null ? "" : obj.applicant;
    if (applicant == "") {
      return { status: -1, msg: "传入的申请人信息为空", data: null, buckets: null };
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "query_string": {
        "default_field": "applicant_name",
        "query": "\"" + applicant + "\""
      }
    }
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async CommomSearchbyInventor(obj) {//根据发明人查询聚合
    var data = await this.checkKey(obj.appKey);
    if (data && data.status && data.status == -1) {
      return data;
    }

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var inventor = obj.inventor == null ? "" : obj.inventor;
    if (inventor == "") {
      return { status: -1, msg: "传入的发明人信息为空", data: null, buckets: null };
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ],
      "aggregations": {
        "group_by_pub_type": {
          "terms": {
            "field": "pub_type",
            "size": 1000
          }
        },
        "group_by_pub_status": {
          "terms": {
            "field": "pub_status",
            "size": 1000
          }
        },
        "group_by_filing_year": {
          "terms": {
            "field": "filing_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        },
        "group_by_pub_year": {
          "terms": {
            "field": "pub_year",
            "size": 1000,
            "order": { "_term": "desc" }
          }
        }
      }
    };

    var param = {
      "query_string": {
        "default_field": "inventor_name",
        "query": "\"" + inventor + "\""
      }
    }
    params.query.bool.must.push(param);

    var pubtype = obj.pubtype == null ? "" : obj.pubtype;//专利类型
    if (pubtype != null && pubtype != "") {
      param = {
        "term": {
          "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubstatus = obj.pubstatus == null ? "" : obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != "") {
      param = {
        "term": {
          "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear == null ? "" : obj.filingyear;//申请年份
    if (filingyear != null && filingyear != "") {
      param = {
        "term": {
          "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear == null ? "" : obj.pubyear;//公开年份
    if (pubyear != null && pubyear != "") {
      param = {
        "term": {
          "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async seniorSearch(obj) {//高级检索，根据用户输入的不同多条件进行检索
    var data = await this.checkKey(obj.appKey);
    if (data && data.status && data.status == -1) {
      return data;
    }

    var pagesize = obj.pagesize == null ? 10 : obj.pagesize;
    if (obj.page == null) {
      var from = 0;
    } else {
      var from = Number((obj.page - 1) * obj.pagesize);
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "filing_time",
        "pub_no",
        "pub_time",
        "gr_no",
        "gr_time",
        "pub_type",
        "applicant_name",
        "inventor_name",
        "filing_name",
        "pub_status"
      ]
    };

    var param = null;
    //对关键词
    var title = obj.title == null ? "" : obj.title;
    if (title != null && title != "") {
      param = {
        "match": {
          "filing_name": title
        }
      }
      params.query.bool.must.push(param)
    }

    var abstr = obj.abstr == null ? "" : obj.abstr;
    if (abstr != null && abstr != "") {
      param = {
        "match": {
          "abstr_text": abstr
        }
      }
      params.query.bool.must.push(param)
    }

    var filingno = obj.filingno == null ? "" : obj.filingno;
    if (filingno != null && filingno != "") {
      filingno = filingno.replace("CN", "").replace("cn", "").replace(".", "");
      if (filingno.length == 13) {
        filingno = filingno.substr(0, 12);
      }
      else if (filingno.length == 9) {
        filingno = filingno.substr(0, 8);
      }

      param = {
        "term": {
          "filing_no": filingno
        }
      }
      params.query.bool.must.push(param)
    }

    var pubno = obj.pubno == null ? "" : obj.pubno;
    if (pubno != null && pubno != "") {
      param = {
        "bool": {
          "should": [
          ]
        }
      }

      var parr = {
        "term": {
          "pub_no": pubno
        }
      }
      param.bool.should.push(parr)

      parr = {
        "term": {
          "gr_no": pubno
        }
      }
      param.bool.should.push(parr)
      params.query.bool.must.push(param);
    }

    var priorno = obj.priorno == null ? "" : obj.priorno;
    if (priorno != null && priorno != "") {
      param = {
        "nested": {
          "path": "prior_info",
          "query": {
            "bool": {
              "must": [
                { "term": { "prior_info.pri_no": priorno } }
              ]
            }
          }
        }
      };
      params.query.bool.must.push(param)
    }

    var appl = obj.applname == null ? "" : obj.applname;
    if (appl != null && appl != "") {
      param = {
        "term": {
          "applicant_name.raw": appl
        }
      }
      params.query.bool.must.push(param)
    }
    var inv = obj.invname == null ? "" : obj.invname;
    if (inv != null && inv != "") {
      param = {
        "term": {
          "inventor_name.raw": inv
        }
      }
      params.query.bool.must.push(param)
    }
    var ipc = obj.ipcno == null ? "" : obj.ipcno;
    if (ipc != null && ipc != "") {
      var param = {
        "term": {
          "other_ipc": ipc
        }
      }
      params.query.bool.must.push(param)
    }

    if (obj.filingdate1 != null && obj.filingdate1 != "") {
      var filingdate1 = obj.filingdate1;
    }
    else {
      var filingdate1 = "";
    }
    if (obj.filingdate2 != null && obj.filingdate2 != "") {
      var filingdate2 = obj.filingdate2;
    }
    else {
      var filingdate2 = "";
    }
    if (filingdate1 != "" || filingdate2 != "") {
      param = {
        "range": {
          "filing_time": {
          }
        }
      };
      if (filingdate1 != "") {
        param.range.filing_time["gte"] = filingdate1;
      }
      if (filingdate2 != "") {
        param.range.filing_time["lte"] = filingdate2;
      }
      params.query.bool.must.push(param);
    }

    if (obj.pubdate1 != null && obj.pubdate1 != "") {
      var pubdate1 = obj.pubdate1;
    }
    else {
      var pubdate1 = "";
    }
    if (obj.pubdate2 != null && obj.pubdate2 != "") {
      var pubdate2 = obj.pubdate2;
    }
    else {
      var pubdate2 = "";
    }
    if (pubdate1 != "" || pubdate2 != "") {
      param = {
        "range": {
          "pub_time": {

          }
        }
      };
      if (pubdate1 != "") {
        param.range.pub_time["gte"] = pubdate1;
      }
      if (pubdate2 != "") {
        param.range.pub_time["lte"] = pubdate2;
      }
      params.query.bool.must.push(param);
    }

    if (obj.grdate1 != null && obj.grdate1 != "") {
      var grdate1 = obj.grdate1;
    }
    else {
      var grdate1 = "";
    }
    if (obj.grdate2 != null && obj.grdate2 != "") {
      var grdate2 = obj.grdate2;
    }
    else {
      var grdate2 = "";
    }
    if (grdate1 != "" || grdate2 != "") {
      param = {
        "range": {
          "gr_time": {

          }
        }
      };
      if (grdate1 != "") {
        param.range.gr_time["gte"] = grdate1;
      }
      if (grdate2 != "") {
        param.range.gr_time["lte"] = grdate2;
      }
      params.query.bool.must.push(param);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return System.getResult2(j.hits, null);
    } catch (e) {
      return rtn = System.getResult2(null, null);
    }
  };

  async patentSearch(obj) {//根据条件检索
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1000,
    };
    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    };

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {

      rtn = await rc.execPost(params, requrl);
   //   console.log("jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjj" + rtn.stdout);
      var j = JSON.parse(rtn.stdout);
      
      if (j.hits.hits.length > 0){
        return rtn = {
          status: 0,
          msg: "操作成功",
          data: j.hits.hits
        };
      }
      else{
        return rtn = {
          status: -1,
          msg: "检索结果为空",
          data: null
        };
      }
     
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null
      };
    }

  };
}
module.exports = ChinaPatentSearchApi;
