var System = require("../../system");
var settings = require("../../../config/settings");
const querystring = require('querystring');
const ApiBase = require("../api.base");

class CPatentAggregationsApi extends ApiBase {
  constructor() {
    super();
    this.patentUrl = settings.reqEsAddrIc() + "bigdata_patent_op/_search";
  };
  buildDate(date) {
    var date = new Date(date);
    var time = Date.parse(date);
    time = time / 1000;
    return time;
  };

  async ApplicantAggs(obj) {//申请人排名聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppCountryAggs(obj) {//申请人归属国聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "country_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async filingyearAggs(obj) {//申请年份聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "filing_year",
            "size": 20,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async PubTypeAggs(obj) {//专利类型聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "pub_type",
            "size": 20,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async PubstatusAggs(obj) {//法律状态聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 20,
      "aggregations": {
        "types": {
          "terms": {
            "field": "pub_status",
            "size": 20,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async PubstatusnowAggs(obj) {//当前法律状态聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "pub_status_now",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async pubyearAggs(obj) {//公开年份聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "pub_year",
            "size": 20,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async pubmonthAggs(obj) {//公开月份聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "pub_month",
            "size": 12,
            "order": {
              "_term": "asc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async filingmonthAggs(obj) {//申请月份聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "filing_month",
            "size": 12,
            "order": {
              "_term": "asc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async grmonthAggs(obj) {//授权月份聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "gr_month",
            "size": 12,
            "order": {
              "_term": "asc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async FmpubyearAggs(obj) {//发明公开年份聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {"bool": {"must_not":{"exists" : { "field" : "gr_no" }}}}
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "pub_year",
            "size": 20,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async GryearAggs(obj) {//授权年份年份聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {"exists" : { "field" : "gr_no" }}
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "gr_year",
            "size": 20,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AgencyAggs(obj) {//代理机构聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "agency_name.raw",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async TitleAggs(obj) {//标题聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "filing_name.raw",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async KeyWordAggs(obj) {//关键词聚合聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "key_word",
            "size": 40,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CategoryNameAggs(obj) {//行业分类-门类聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "category_name",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async BroadNameAggs(obj) {//行业分类-大类聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "broad_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async MiddleNameAggs(obj) {//行业分类-中类聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "middle_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async SmallNameAggs(obj) {//行业分类-小类聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "middle_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AgentAggs(obj) {//代理人聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "agent_name1",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpclcAggs(obj) {//Ipc大类聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "large class",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpclcMutiAggs(obj) {//申请人Ipc大类聚合//Ipc小类聚合申请人Ipc大类聚合,业务逻辑，先查询申请排名前十的申请人，再加上前十申请人的条件查询排名前十的大类，再加上前十申请人条件和前十大类条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large class",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpcscAggs(obj) {//Ipc小类聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "sub_class",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpcscMutiAggs(obj) {//Ipc小类聚合申请人Ipc小类聚合,业务逻辑，先查询申请排名前十的申请人，再加上前十申请人的条件查询排名前十的小类，再加上前十申请人条件和前十小类条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "sub_class",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async ApplKeywordAggs(obj) {//申请人关键词双重聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_keyword": {
              "terms": {
                "field": "key_word",
                "size": 20,
                "order": {
                  "_count": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpclgAggs(obj) {//Ipc大组聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "large_group",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpclgMutiAggs(obj) {//申请人Ipc大组聚合,业务逻辑，先查询申请排名前十的申请人，再加上前十申请人的条件查询排名前十的大组，再加上前十申请人条件和前十大组条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large_group",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpcAggs(obj) {//Ipc聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "main_ipc",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpcMutiAggs(obj) {//申请人Ipc直属聚合,业务逻辑，先查询申请排名前十的申请人，再加上前十申请人的条件查询排名前十的IPC，再加上前十申请人条件和前十IPC条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "main_ipc",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };


  async AppPubtypeAggs(obj) {//申请人专利类型聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_pubtype": {
              "terms": {
                "field": "pub_type",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppPubstatusAggs(obj) {//申请人专利法律效力聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_pubstatus": {
              "terms": {
                "field": "pub_status",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppfilingyearAggs(obj) {//申请人申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_filingyear": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppfmsqAggs(obj) {//申请人发明授权聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {"exists" : { "field" : "gr_no" }}
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 20,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async InventorAggs(obj) {//发明人排名聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async InvIpcMutiAggs(obj) {//发明人Ipc直属聚合,业务逻辑，先查询申请排名前十的发明人，再加上前十发明人的条件查询排名前十的IPC，再加上前十发明人条件和前十IPC条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_inv": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "main_ipc",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async InvPubtypeAggs(obj) {//发明人专利类型聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_inv": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_pubtype": {
              "terms": {
                "field": "pub_type",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async InvPubstatusAggs(obj) {//发明人专利法律效力聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_inv": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_pubstatus": {
              "terms": {
                "field": "pub_status",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async InvfilingyearAggs(obj) {//发明人申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_inv": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_filingyear": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async InvPubyearAggs(obj) {//发明人公开趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_inv": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_pubyear": {
              "terms": {
                "field": "pub_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async ProvinceAggs(obj) {//省份聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {"exists" : { "field" : "province_name" }}
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "province_name",
            "size": 50,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async cityAggs(obj) {//二级地市聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {"exists" : { "field" : "city_name" }}
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "city_name",
            "size": 50,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async countyAggs(obj) {//三级县市聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {"exists" : { "field" : "county_name" }}
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "county_name",
            "size": 50,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async ForeignCountryAggs(obj) {//外国在华申请聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                "must_not": {
                  "term": {
                    "country_name": "中国"
                  }
                }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "country_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async ForeignIpcAggs(obj) {//外国在华IPC聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                "must_not": {
                  "term": {
                    "country_name": "中国"
                  }
                }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "country_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "main_ipc",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async ForeignLcAggs(obj) {//外国在华大类聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                "must_not": {
                  "term": {
                    "country_name": "中国"
                  }
                }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "country_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large class",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async ForeignScAggs(obj) {//外国在华小类聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                "must_not": {
                  "term": {
                    "country_name": "中国"
                  }
                }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "country_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "sub_class",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async ForeignLgAggs(obj) {//外国在华大组聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                "must_not": {
                  "term": {
                    "country_name": "中国"
                  }
                }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "country_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large_group",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async IpcFilingyearAggs(obj) {//IPC申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_ipc": {
          "terms": {
            "field": "main_ipc",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async IpcLgFilingyearAggs(obj) {//IPC大组申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_ipc": {
          "terms": {
            "field": "large_group",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async IpcLcFilingyearAggs(obj) {//IPC大类申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_ipc": {
          "terms": {
            "field": "large class",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async IpcScFilingyearAggs(obj) {//IPC小类申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_ipc": {
          "terms": {
            "field": "sub_class",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async pubtypeFilingyearAggs(obj) {//专利类型申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_type": {
          "terms": {
            "field": "pub_type",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async pubtypePubyearAggs(obj) {//专利类型公开趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_type": {
          "terms": {
            "field": "pub_type",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "pub_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async AgencyPubtypeAggs(obj) {//代理机构类型趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_agency": {
          "terms": {
            "field": "agency_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_type": {
              "terms": {
                "field": "pub_type",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async AgencyFilingyearAggs(obj) {//代理机构申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_agency": {
          "terms": {
            "field": "agency_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async AgencyPubyearAggs(obj) {//代理机构公开趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_agency": {
          "terms": {
            "field": "agency_name.raw",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "pub_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async AgencyIpcAggs(obj) {//代理机构IPC趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_agency": {
          "terms": {
            "field": "agency_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "main_ipc",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async AgencyLcAggs(obj) {//代理机构大类趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_agency": {
          "terms": {
            "field": "agency_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large class",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };
  async AgencyfmsqAggs(obj) {//代理机构发明授权聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {"exists" : { "field" : "gr_no" }}
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "agency_name.raw",
            "size": 10,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async AgencyScAggs(obj) {//代理机构小类趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_agency": {
          "terms": {
            "field": "agency_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "sub_class",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async AgencyLgAggs(obj) {//代理机构大组趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_agency": {
          "terms": {
            "field": "agency_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large_group",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async AgentPubtypeAggs(obj) {//代理人类型趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_agency": {
          "terms": {
            "field": "agent_name1",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_type": {
              "terms": {
                "field": "pub_type",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async provincePubstatusAggs(obj,areaname,type) {//根据传的省|市|县信息不同类型聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "province_name",
            "size": 50,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }
    if(type==2){
      if(areaname=='北京市' || areaname=='天津市' ||areaname=='重庆市' ||areaname=='上海市')
      {
        params.aggregations.group_by_country.terms.field="county_name";
      }
      else{
        params.aggregations.group_by_country.terms.field="city_name";
      }
    }
    else if (type ==3 || type == 4){
      params.aggregations.group_by_country.terms.field="county_name";
    }
    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

}
module.exports = CPatentAggregationsApi;
