var System=require("../../system");
var settings=require("../../../config/settings");
const querystring = require('querystring');
const ApiBase =require("../api.base");

class CPatentSearchApi extends ApiBase{
  constructor(){
    super();
    this.patentUrl = settings.reqEsAddrIc()+"bigdata_patent_op/_search";
  };
  buildDate(date){
    var date = new Date(date);
    var time = Date.parse(date);
    time=time / 1000;
    return time;
  };

  async TitleCommomSearch(obj){//根据标题查询
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var pagesize = obj.pagesize==null?10:obj.pagesize;
    if(obj.page==null){
      var from = 0;
    }else{
      var from = Number((obj.page-1)*obj.pagesize);
    }

    var title = obj.title==null?"":obj.title;
    if(title==""){
        return {status:-1,msg:"传入标题信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "pub_type",
        "filing_date",
        "pub_date",
        "pub_no",
        "gr_date",
        "gr_no",
        "applicant_name",
        "inventor_name",
        "agent_name1",
        "agent_name2",
        "agency_code",
        "agency_name",
        "country_code",
        "appl_zip",
        "appl_address",
        "filing_name",
        "pub_status",
        "pub_status_now",
        "abstr_text",
        "main_ipc",
        "ipc_version",
        "other_ipc",
        "prior_info",
        "pct_info",
        "pub_year",
        "pub_time",
        "filing_time",
        "gr_time",
        "gr_year",
        "filing_year",
        "claim_text"
      ]
    };

    var param = {
      "term": {
        "filing_name": title
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResult2(j.hits,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async FilingnoCommomSearch(obj){//根据申请号查询
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var pagesize = obj.pagesize==null?10:obj.pagesize;
    if(obj.page==null){
      var from = 0;
    }else{
      var from = Number((obj.page-1)*obj.pagesize);
    }

    var filingno = obj.filingno==null?"":obj.filingno;
    if(filingno==""){
        return {status:-1,msg:"传入的申请号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "pub_type",
        "filing_date",
        "pub_date",
        "pub_no",
        "gr_date",
        "gr_no",
        "applicant_name",
        "inventor_name",
        "agent_name1",
        "agent_name2",
        "agency_code",
        "agency_name",
        "country_code",
        "appl_zip",
        "appl_address",
        "filing_name",
        "pub_status",
        "pub_status_now",
        "abstr_text",
        "main_ipc",
        "ipc_version",
        "other_ipc",
        "prior_info",
        "pct_info",
        "pub_year",
        "pub_time",
        "filing_time",
        "gr_time",
        "gr_year",
        "filing_year",
        "claim_text"
      ]
    };

    var param = {
      "term": {
        "filing_no": filingno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResult2(j.hits,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async PubnoCommomSearch(obj){//根据公开号查询
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var pagesize = obj.pagesize==null?10:obj.pagesize;
    if(obj.page==null){
      var from = 0;
    }else{
      var from = Number((obj.page-1)*obj.pagesize);
    }

    var pubno = obj.pubno==null?"":obj.pubno;
    if(pubno==""){
        return {status:-1,msg:"传入的公开号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "pub_type",
        "filing_date",
        "pub_date",
        "pub_no",
        "gr_date",
        "gr_no",
        "applicant_name",
        "inventor_name",
        "agent_name1",
        "agent_name2",
        "agency_code",
        "agency_name",
        "country_code",
        "appl_zip",
        "appl_address",
        "filing_name",
        "pub_status",
        "pub_status_now",
        "abstr_text",
        "main_ipc",
        "ipc_version",
        "other_ipc",
        "prior_info",
        "pct_info",
        "pub_year",
        "pub_time",
        "filing_time",
        "gr_time",
        "gr_year",
        "filing_year",
        "claim_text"
      ]
    };

    var param = {
      "term": {
        "pub_no": pubno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResult2(j.hits,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async ApplicantCommomSearch(obj){//根据申请人查询
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var pagesize = obj.pagesize==null?10:obj.pagesize;
    if(obj.page==null){
      var from = 0;
    }else{
      var from = Number((obj.page-1)*obj.pagesize);
    }

    var applicant = obj.applicant==null?"":obj.applicant;
    if(applicant==""){
        return {status:-1,msg:"传入的申请人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "pub_type",
        "filing_date",
        "pub_date",
        "pub_no",
        "gr_date",
        "gr_no",
        "applicant_name",
        "inventor_name",
        "agent_name1",
        "agent_name2",
        "agency_code",
        "agency_name",
        "country_code",
        "appl_zip",
        "appl_address",
        "filing_name",
        "pub_status",
        "pub_status_now",
        "abstr_text",
        "main_ipc",
        "ipc_version",
        "other_ipc",
        "prior_info",
        "pct_info",
        "pub_year",
        "pub_time",
        "filing_time",
        "gr_time",
        "gr_year",
        "filing_year",
        "claim_text"
      ]
    };

    var param = {
      "term": {
        "applicant_name": applicant
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResult2(j.hits,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async InventorCommomSearch(obj){//根据发明人查询
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var pagesize = obj.pagesize==null?10:obj.pagesize;
    if(obj.page==null){
      var from = 0;
    }else{
      var from = Number((obj.page-1)*obj.pagesize);
    }

    var inventor = obj.inventor==null?"":obj.inventor;
    if(inventor==""){
        return {status:-1,msg:"传入的发明人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "pub_type",
        "filing_date",
        "pub_date",
        "pub_no",
        "gr_date",
        "gr_no",
        "applicant_name",
        "inventor_name",
        "agent_name1",
        "agent_name2",
        "agency_code",
        "agency_name",
        "country_code",
        "appl_zip",
        "appl_address",
        "filing_name",
        "pub_status",
        "pub_status_now",
        "abstr_text",
        "main_ipc",
        "ipc_version",
        "other_ipc",
        "prior_info",
        "pct_info",
        "pub_year",
        "pub_time",
        "filing_time",
        "gr_time",
        "gr_year",
        "filing_year",
        "claim_text"
      ]
    };

    var param = {
      "term": {
        "inventor_name": inventor
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResult2(j.hits,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

}
module.exports = CPatentSearchApi;
