var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class RegionalpatentmonitoringCtl {
  //区域专利监控
  constructor() {
    this.patentycSve = system.getObject("service.patentycSve");
    this.gsbIcSearchApi = system.getObject("api.gsbicsearch");
    this.cacheManager=system.getObject("db.cacheManager");
  }
  
  async aliIpc(obj,req) {//区域专利监控-专利IPC分布
    var type=obj.type;
    var areaname = obj.areaname;
    var year = obj.year;
    if(!type){
      return {code:-1,msg:"type参数错误"};
    }
    if(type && (type == "2" || type == "3") &&!areaname){
      return {code:-2,msg:"areaname参数错误"};
    }
    try {
      var key="aliIpc_"+type+"_"+areaname+"_"+year;
      var dataCatch=await this.cacheManager["RegionalpatentmonitoringCache"].get(key);
      if(dataCatch){
        var ddd = JSON.parse(dataCatch);
        return ddd;
      }
      var dataList = await this.patentycSve.aliIpc(obj);
      var result=[];
      for(var i=0;i<dataList.length;i++){
        var data = dataList[i].data;
        var xdata=[];
        var ydata=[];
        for(var j=0;j<data.length;j++){
          var dd= data[j];
          xdata.push(dd.code);
          ydata.push(dd.num);
        }
        var barobj={xdata:xdata,ydata:ydata,data:data,analyse:dataList[i].analyse};
        result.push(barobj)
      }
      await this.cacheManager["RegionalpatentmonitoringCache"].set({code:1,data:result},key);
      return {code:1,data:result};
    } catch (error) {
      return {code:-100,msg:"操作失败"};
    }
  }; 
  async aliApplicant(obj,req) {//区域专利监控-申请人分布详情
    var type=obj.type;
    var areaname = obj.areaname;
    var year = obj.year;
    if(!type){
      return {code:-1,msg:"type参数错误"};
    }
    if(type && type=="2" && !areaname){
      return {code:-2,msg:"areaname参数错误"};
    }
    try {
      var key="aliApplicant_"+type+"_"+areaname+"_"+year;
      var dataCatch=await this.cacheManager["RegionalpatentmonitoringCache"].get(key);
      if(dataCatch){
        var ddd = JSON.parse(dataCatch);
        return ddd;
      }
      var dataList = await this.patentycSve.aliApplicant(obj);
      var result=[];
      for(var i=0;i<dataList.length;i++){
        var data = dataList[i].data;
        var xdata=[];
        var ydata=[];
        for(var j=0;j<data.length;j++){
          var dd= data[j];
          xdata.push(dd.entname);
          ydata.push(dd.num);
        }
        var barobj={xdata:xdata,ydata:ydata,data:data,analyse:dataList[i].analyse};
        result.push(barobj)
      }
      await this.cacheManager["RegionalpatentmonitoringCache"].set({code:1,data:result},key);
      return {code:1,data:result};
    } catch (error) {
      return {code:-100,msg:"操作失败"};
    }
  };
  async aliPubstatusnow(obj,req){//区域专利监控-法律状态分布详情 ++++
    var type=obj.type;
    var areaname = obj.areaname;
    var year = obj.year;
    if(!type){
      return {code:-1,msg:"type参数错误"};
    }
    if(type && type=="2" && !areaname){
      return {code:-2,msg:"areaname参数错误"};
    }
    try {
      var key="aliPubstatusnow_"+type+"_"+areaname+"_"+year;
      var dataCatch=await this.cacheManager["RegionalpatentmonitoringCache"].get(key);
      if(dataCatch){
        var ddd = JSON.parse(dataCatch);
        return ddd;
      }
      var dataList = await this.patentycSve.aliPubstatusnow(obj);
      var result=[];
      var data = dataList.data;
      var xdata=[];
      var ydata=[];
      for(var j=0;j<data.length;j++){
        var dd= data[j];
        xdata.push(dd.statusname);
        ydata.push(dd.num);
      }
      var barobj={xdata:xdata,ydata:ydata,data:data,analyse:dataList.analyse};
      result.push(barobj);
      await this.cacheManager["RegionalpatentmonitoringCache"].set({code:1,data:result},key);
      
      return {code:1,data:result};
    } catch (error) {
      console.log(error);
      return {code:-100,msg:"操作失败"};
    }
  }
  async aliTrend(obj){//区域专利监控首页 - 趋势详情
    var type=obj.type;
    var areaname = obj.areaname;
    var year = obj.year;
    if(!type){
      return {code:-1,msg:"type参数错误"};
    }
    if(type && type=="2" && !areaname){
      return {code:-2,msg:"areaname参数错误"};
    }
    try {
      var key="aliTrend_"+type+"_"+areaname+"_"+year;
      var dataCatch=await this.cacheManager["RegionalpatentmonitoringCache"].get(key);
      if(dataCatch){
        var ddd = JSON.parse(dataCatch);
        return ddd;
      }
      var dataList = await this.patentycSve.aliTrend(obj);
      var result=[];
      for(var i=0;i<dataList.length;i++){
        var data = dataList[i].data;
        var xdata=[];
        var ydata=[];
        for(var j=0;j<data.length;j++){
          var dd= data[j];
          xdata.push(dd.year);
          ydata.push(dd.num);
        }
        var barobj={xdata:xdata,ydata:ydata,data:data,analyse:dataList[i].analyse};
        result.push(barobj)
      }
      await this.cacheManager["RegionalpatentmonitoringCache"].set({code:1,data:result},key);
      return {code:1,data:result};
    } catch (error) {
      console.log(error);
      return {code:-100,msg:"操作失败"};
    }
  }
  async aliAgency(obj){//区域专利监控首页 - 代理机构排名详情
    var type=obj.type;
    var areaname = obj.areaname;
    var year = obj.year;
    if(!type){
      return {code:-1,msg:"type参数错误"};
    }
    if(type && type=="2" && !areaname){
      return {code:-2,msg:"areaname参数错误"};
    }
    try {
      var key="aliAgency_"+type+"_"+areaname+"_"+year;
      var dataCatch=await this.cacheManager["RegionalpatentmonitoringCache"].get(key);
      if(dataCatch){
        var ddd = JSON.parse(dataCatch);
        return ddd;
      }
      var dataList = await this.patentycSve.aliAgency(obj);
      var result=[];
      for(var i=0;i<dataList.length;i++){
        var data = dataList[i].data;
        var xdata=[];
        var ydata=[];
        for(var j=0;j<data.length;j++){
          var dd= data[j];
          xdata.push(dd.agencyname);
          ydata.push(dd.num);
        }
        var barobj={xdata:xdata,ydata:ydata,data:data,analyse:dataList[i].analyse};
        result.push(barobj)
      }
      await this.cacheManager["RegionalpatentmonitoringCache"].set({code:1,data:result},key);
      return {code:1,data:result};
    } catch (error) {
      console.log(error);
      return {code:-100,msg:"操作失败"};
    }
  }
  async aliplace(obj){//阿里区域申请人
    var type=obj.type;
    var areaname = obj.areaname;
    var year = obj.year;
    if(!type){
      return {code:-1,msg:"type参数错误"};
    }
    if(type && (type=="2"||type == "3" || type == "4") && !areaname){
      return {code:-2,msg:"areaname参数错误"};
    }
    try {
      var key="aliplace_"+type+"_"+areaname+"_"+year;
      var dataCatch=await this.cacheManager["RegionalpatentmonitoringCache"].get(key);
      if(dataCatch){
        var ddd = JSON.parse(dataCatch);
        return ddd;
      }
      var result = await this.patentycSve.aliplace(obj);
      // allsum:申请量  sqsum:有效注册量 jdata:地图中的数据
      var tdata= result.tdata;
      var jdata= result.jdata;
      var detail=[];//详情页数据 数组下标 0 申请数据 1 授权数据
      var x_tdata = [];//首页x轴数据
      var y_tdata = [];//首页y轴数据
      var x_jdata_apply = [];
      var y_jdata_apply = [];
      var x_jdata_valid = [];
      var y_jdata_valid = [];
      var mapdata_apply=[];//地图数据——申请数据
      var mapdata_valid=[];//地图数据——授权数据
      for(var i=0;i<tdata.length;i++){
        var data = tdata[i];
        x_tdata.push(data.areaname);
        y_tdata.push(data.y_percent);
      }
      for(var i=0;i<jdata.length;i++){
        var data = jdata[i];
        x_jdata_apply.push(data.areaname);
        y_jdata_apply.push(data.y_applynum);
        x_jdata_valid.push(data.areaname);
        y_jdata_valid.push(data.y_registnum);
        var map={name:data.areaname,value:data.y_applynum};
        mapdata_apply.push(map);
        var map2={name:data.areaname,value:data.y_registnum};
        mapdata_valid.push(map2);
      }
      var detailObj={xdata:x_jdata_apply,ydata:y_jdata_apply,data:jdata,analyse:result.analyse};
      detail.push(detailObj);
      var detailObj2={xdata:x_jdata_valid,ydata:y_jdata_valid,data:jdata,analyse:result.analysesq};
      detail.push(detailObj2);
      result["x_tdata"]=x_tdata;
      result["y_tdata"]=y_tdata;
      result["detail"]=detail;
      result["mapdata_apply"]=mapdata_apply;
      result["mapdata_valid"]=mapdata_valid;

      await this.cacheManager["RegionalpatentmonitoringCache"].set({code:1,data:result},key);
      return {code:1,data:result};
    } catch (error) {
      console.log(error);
      return {code:-100,msg:"操作失败"};
    }
  }

  async aliCategory(obj){//门类
    var type=obj.type;
    var areaname = obj.areaname;
    var year = obj.year;
    if (type && type != "4"){
      return {code:-1,msg:"type参数错误"};
    }
    try {
      var key="aliplace_"+type+"_"+areaname+"_"+year;
      var dataCatch=await this.cacheManager["RegionalpatentmonitoringCache"].get(key);
      if(dataCatch){
        var ddd = JSON.parse(dataCatch);
        return ddd;
      }
      var result = await this.patentycSve.aliCategory(obj);
      // allsum:申请量  sqsum:有效注册量 jdata:地图中的数据
      var tdata= result.tdata;
      var jdata= result.jdata;
      var detail=[];//详情页数据 数组下标 0 申请数据 1 授权数据
      var x_tdata = [];//首页x轴数据
      var y_tdata = [];//首页y轴数据
      var x_jdata_apply = [];
      var y_jdata_apply = [];
      var x_jdata_valid = [];
      var y_jdata_valid = [];
      var mapdata_apply=[];//地图数据——申请数据
      var mapdata_valid=[];//地图数据——授权数据
      for(var i=0;i<tdata.length;i++){
        var data = tdata[i];
        x_tdata.push(data.areaname);
        y_tdata.push(data.y_percent);
      }
      for(var i=0;i<jdata.length;i++){
        var data = jdata[i];
        x_jdata_apply.push(data.areaname);
        y_jdata_apply.push(data.y_applynum);
        x_jdata_valid.push(data.areaname);
        y_jdata_valid.push(data.y_registnum);
        var map={name:data.areaname,value:data.y_applynum};
        mapdata_apply.push(map);
        var map2={name:data.areaname,value:data.y_registnum};
        mapdata_valid.push(map2);
      }
      var detailObj={xdata:x_jdata_apply,ydata:y_jdata_apply,data:jdata,analyse:result.analyse};
      detail.push(detailObj);
      var detailObj2={xdata:x_jdata_valid,ydata:y_jdata_valid,data:jdata,analyse:result.analysesq};
      detail.push(detailObj2);
      result["x_tdata"]=x_tdata;
      result["y_tdata"]=y_tdata;
      result["detail"]=detail;
      result["mapdata_apply"]=mapdata_apply;
      result["mapdata_valid"]=mapdata_valid;

      await this.cacheManager["RegionalpatentmonitoringCache"].set({code:1,data:result},key);
      return {code:1,data:result};
    } catch (error) {
      console.log(error);
      return {code:-100,msg:"操作失败"};
    }
    
  }

  async aliGaode(obj){//高德地图鼠标事件
    try {
      var result = await this.patentycSve.aliGaode(obj);
      return {code:1,data:result};
    }
    catch (error) {
      return {code:-100,msg:"操作失败"};
    }


  }
  async aliBusinessDecision(obj){//企业智慧管理
    var entName = obj.entName;
    var year = obj.year;
    if(!entName){
      return {code:-1,msg:"entName参数错误"};
    }
    try {
      var key="aliBusinessDecision_"+entName+"_"+year;
      var dataCatch=await this.cacheManager["RegionalpatentmonitoringCache"].get(key);
      if(dataCatch){
        var ddd = JSON.parse(dataCatch);
        return ddd;
      }
      var result = await this.patentycSve.aliBusinessDecision(obj);
      await this.cacheManager["RegionalpatentmonitoringCache"].set({code:1,data:result},key);
      return {code:1,data:result};
    } catch (error) {
      console.log(error);
      return {code:-100,msg:"操作失败"};
    }
  } 
  async getCompanyInfoByLikeName(oo, o, req) {
    var appkey = this.appKeyStr;
    var data = {
      appKey: appkey,
      pagesize: 5,
      page: 0,
      companyName: o.likestr,
    };
    var company = await this.gsbIcSearchApi.companynamesearch(data);
    if (company.status == 0) {
      return { data: company.data.list };
    } else {
      return {};
    }

  }
}
module.exports = RegionalpatentmonitoringCtl;
