const CacheBase=require("../cache.base");
const system=require("../../system");

class RegionalpatentmonitoringCache extends CacheBase{
   constructor(){
     super();
     this.prefix="regionalpatentmonitoringCache";
   }
   async get(k){
     var key = this.prefix+"_"+k;
     var data = await this.redisClient.get(key);
     if(data){
       data = JSON.parse(data);
       var date = new Date();
       var endDate = new Date(data.endDate);
       if(date<=endDate){
         return data.data;
       }else{
         await this.del(k);
         return "";
       }
     }
     return "";
   }
   fun_date(aa){
      var date1 = new Date(),
      time1=date1.getFullYear()+"-"+(date1.getMonth()+1)+"-"+date1.getDate();//time1表示当前时间
      var date2 = new Date(date1);
      date2.setDate(date1.getDate()+aa);
      return date2;
   }
   async set(data,k){
     var key = this.prefix+"_"+k;
     var date = this.fun_date(3);
     if(data && date){
       var datastring = JSON.stringify(data);
       var obj={endDate:date,data:datastring};
       var data = JSON.stringify(obj);
       await this.redisClient.set(key,data);
     }
     
   }
   async del(k){
     var key = this.prefix+"_"+k;
     await this.redisClient.delete(key);
   }
}
module.exports=RegionalpatentmonitoringCache;
