const pmgnode=require("../subsys/pmg.js");
const toolCenter=require("../subsys/toolCenter.js");

module.exports = {
    "appid": "wx76a324c5d201d1a4",
    "label": "知识产权运营平台",
    "config": {
        "rstree": {
            "code": "toolroot",
            "label": "工具箱",
            "children": [
                pmgnode,
                // toolCenter,
                 {
                    "code": "home",
                    "istop":true,
                    "icon": "fa fa-home",
                    "isMenu": true,
                    "label": "首页",
                    "bizCode": "register",
                    "bizConfig": null,
                    "path": "",
                },
                {
                  "code": "patentsimplesearch",
                  "label": "专眼查普通检索",
                  "bizCode": "patentsimplesearch",
                  "bizConfig": null,
                  "path": ""
                },
                {
                  "code": "patentdetail",
                  "label": "专眼查专利详情",
                  "bizCode": "patentdetail",
                  "bizConfig": null,
                  "path": ""
                },
                {
                  "code": "patentadvancedsearch",
                  "icon": "fa fa-search",
                  "label": "专眼查高级检索",
                  "bizCode": "patentadvancedsearch",
                  "bizConfig": null,
                  "path": ""
                },
                {
                    "code": "patentanalysis",
                    "icon": "fa fa-search",
                    "label": "专利分析",
                    "bizCode": "patentanalysis",
                    "bizConfig": null,
                    "path": "",
                },
                {
                  "code": "patentreport",
                  "label": "专利报告",
                  "bizCode": "patentreport",
                  "bizConfig": null,
                  "path": ""
                },
                {
                    "code": "register",
                    "icon": "fa fa-home",
                    "isMenu": false,
                    "label": "注册",
                    "bizCode": "register",
                    "bizConfig": null,
                    "path": "",
                },
                {
                    "code": "login",
                    "icon": "fa fa-home",
                    "path":"login",
                    "isMenu": false,
                    "label": "登录",
                    "bizCode": "login",
                    "bizConfig": null,
                    "path": "",
                    "istop":true
                },
                {
                  "code": "regionalpatentmonitoring",
                  "icon": "fa fa-search",
                  "label": "区域专利监控",
                  "bizCode": "regionalpatentmonitoring",
                  "bizConfig": null,
                  "path": ""
                },
                {
                  "code": "regionalpatentmonitoringdetails",
                  "icon": "fa fa-search",
                  "label": "区域专利监控详情",
                  "bizCode": "regionalpatentmonitoringdetails",
                  "bizConfig": null,
                  "path": ""
                },
                {
                  "code": "businessdecisions",
                  "icon": "fa fa-search",
                  "label": "企业智慧管理",
                  "bizCode": "businessdecisions",
                  "bizConfig": null,
                  "path": ""
                },
                {
                  "code": "businessdecisionsresult",
                  "icon": "fa fa-search",
                  "label": "企业智慧管理查询结果",
                  "bizCode": "businessdecisionsresult",
                  "bizConfig": null,
                  "path": ""
                },
                {
                  "code": "iframehtml",
                  "icon": "fa fa-search",
                  "label": "网页嵌入",
                  "bizCode": "iframehtml",
                  "bizConfig": null,
                  "path": ""
                },
                {
                  "code": "competitiveanalysis",
                  "icon": "fa fa-search",
                  "label": "竞争企业分析",
                  "bizCode": "competitiveanalysis",
                  "bizConfig": null,
                  "path": ""
                },
                {
                  "code": "enterprisecontrast",
                  "icon": "fa fa-search",
                  "label": "竞争企业分析",
                  "bizCode": "enterprisecontrast",
                  "bizConfig": null,
                  "path": ""
                }
            ],
        },
        "bizs": {
            "iframehtml": {"title": "网页嵌入", "config": null, "path": "/iframehtml", "comname": "iframehtml"},
            "competitiveanalysis": {"title": "竞争企业分析", "config": null, "path": "/competitiveanalysis", "comname": "competitiveanalysis"},
            "enterprisecontrast": {"title": "竞争企业分析", "config": null, "path": "/enterprisecontrast", "comname": "enterprisecontrast"},
            "home": {"title": "首页", "config": null, "path": "/", "comname": "home"},
            "regionalpatentmonitoring": {"title": "监控", "config": null, "path": "/regionalpatentmonitoring", "comname": "regionalpatentmonitoring"},
            "regionalpatentmonitoringdetails": {"title": "监控详情", "config": null, "path": "/regionalpatentmonitoringdetails", "comname": "regionalpatentmonitoringdetails"},
            "businessdecisions": {"title": "决策", "config": null, "path": "/businessdecisions", "comname": "businessdecisions"},
            "businessdecisionsresult": {"title": "决策结果", "config": null, "path": "/businessdecisionsresult", "comname": "businessdecisionsresult"},
            "register": {"title": "注册", "config": null, "path": "/register", "comname": "register"},
            "login": {"title": "登录", "config": null, "path": "/login", "comname": "login"},
            "newschannel": {"title": "频道发布", "config": null, "path": "/newschannel", "comname": "newschannel"},
            "article": {"title": "文章发布", "config": null, "path": "/article", "comname": "article"},
            "loopplay": {"title": "轮播发布", "config": null, "path": "/loopplay", "comname": "loopplay"},
            "articledetail": {"title": "文章查看", "config": null, "path": "/articledetail/:id", "comname": "articledetail"},
            "channelquery": {"title": "按频道查看", "config": null, "path": "/channelquery/:id", "comname": "channelquery"},
            "users": {"title": "用户管理", "config": null, "path": "/users", "comname": "users"},
            "roles": {"title": "角色管理", "config": null, "path": "/roles", "comname": "roles"},
            "patentsimplesearch":{
                "title": "专眼查普通检索",
                "config": null,
                "isDynamicRoute": false,
                "path": "/patentsimplesearch",
                "comname": "patentsimplesearch"
              },
              "patentadvancedsearch":{
                "title": "专眼查高级检索",
                "config": null,
                "isDynamicRoute": false,
                "path": "/patentadvancedsearch",
                "comname": "patentadvancedsearch"
              },
              "patentdetail":{
                "title": "专眼查专利详情",
                "config": null,
                "isDynamicRoute": false,
                "path": "/patentdetail",
                "comname": "patentdetail"
              },
              "patentreport":{
                  "title": "专利报告",
                  "config": null,
                  "isDynamicRoute": false,
                  "path": "/patentreport",
                  "comname": "patentreport"
              },
              "patentanalysis":{
                  "title": "专利分析",
                  "config": null,
                  "isDynamicRoute": false,
                  "path": "/patentanalysis",
                  "comname": "patentanalysis"
              },
              "regionalpatentmonitoring":{
                  "title": "区域专利监控",
                  "config": null,
                  "isDynamicRoute": false,
                  "path": "/regionalpatentmonitoring",
                  "comname": "regionalpatentmonitoring"
              },
              "regionalpatentmonitoringdetails":{
                "title": "区域专利监控详情",
                "config": null,
                "isDynamicRoute": false,
                "path": "/regionalpatentmonitoringdetails",
                "comname": "regionalpatentmonitoringdetails"
            },
              "businessdecisions":{
                  "title": "企业智慧管理",
                  "config": null,
                  "isDynamicRoute": false,
                  "path": "/businessdecisions",
                  "comname": "businessdecisions"
              },
              "businessdecisionsresult":{
                  "title": "企业智慧管理查询结果",
                  "config": null,
                  "isDynamicRoute": false,
                  "path": "/businessdecisionsresult",
                  "comname": "businessdecisionsresult"
              },
              "competitiveanalysis":{
                "title": "竞争企业分析",
                "config": null,
                "isDynamicRoute": false,
                "path": "/competitiveanalysis",
                "comname": "competitiveanalysis"
              },
              "enterprisecontrast":{
                "title": "竞争企业分析",
                "config": null,
                "isDynamicRoute": false,
                "path": "/enterprisecontrast",
                "comname": "enterprisecontrast"
              },
        },
        "pauths": [
            "add", "edit", "delete", "export", "show"
        ],
        "pdict": {
            "tmCompanyAuditStatus": {"0":"待审核","1":"审核通过","2":"审核驳回", "3":"已过期"},
            "businessallowstatus": {"1":"待接单","2":"已接单","4":"拒接","8":"成功","16":"失败"},
            "noticeType": {"sms": "短信", "email": "邮件","wechat":"微信"},
            "eflowstatus": {0:"草稿", 1: "签署中", 2: "已完成", 3: "已撤销", 4: "已终止", 5: "已过期", 6: "已删除", 7: "已拒签"},
            "authType": {"add": "新增", "edit": "编辑","delete":"删除","export":"导出","show":"查看"},
            "mediaType": {"vd": "视频", "ad": "音频","qt":"其它"},
            "usageType": {"kt": "课堂","taxkt":"财税课堂", "qt": "其它"},
            "opstatus": {"0": "失败", "1": "成功"},
            "sex": {"male": "男", "female": "女"},
            "configType": {"price": "宝币兑换率", "initGift": "初次赠送"},
            "productCata": {"ip": "商标", "ic": "版权", "pa": "专利", "iso": "海外业务", "common": "增值服务", "icbc": "工商注册",
                            "zscq": "知识产权", "cwfw": "财务服务", "hyzz": "行业资质", "gqzr": "股权转让", "xzsp": "行政审批"},
            //"productCata": {"ip": "商标", "ic": "版权", "tax": "财税", "pa": "专利", "common": "常用"},
            "funcCata": {"clueDig": "商机挖掘", "query": "常见查询", "prof": "专用工具","cp": "版权工具", "common": "常用工具","pat":"专利工具"},
            "logLevel": {"debug": 0, "info": 1, "warn": 2, "error": 3, "fatal": 4},
            "tradeType": {"fill": "充值宝币", "consume": "消费宝币", "gift": "赠送宝币", "giftMoney": "红包", "refund": "退款","payment":"付款",
                          "orderTrade": "订单交易", "orderRefund": "订单退款", "orderPersonFee": "订单个人分润","orderPlatformFee": "订单平台分润",
                          "recommendFee": "推荐分润", "tmSubDeductCoin": "商标提报宝币扣除","cashWithdrawal": "现金提现","platUseFee":"平台使用费",
                          "publicExpense":"官费","invoiceTaxes":"税费","subPublicExpense":"上缴官费","returnPublicExpense":"官费退回"},
            "tradeStatus": {"unSettle": "未结算", "settled": "已结算"},
            "tmNclOne": {
                "1": "第01类 化学原料", "2": "第02类 颜料油漆", "3": "第03类 日化用品", "4": "第04类 燃料油脂", "5": "第05类 医药",
                "6": "第06类 金属材料", "7": "第07类 机械设备", "8": "第08类 手工器械", "9": "第09类 科学仪器", "10": "第10类 医疗器械",
                "11": "第11类 灯具空调", "12": "第12类 运输工具", "13": "第13类 军火烟火", "14": "第14类 珠宝钟表", "15": "第15类 乐器",
                "16": "第16类 办公用品", "17": "第17类 橡胶制品", "18": "第18类 皮革皮具", "19": "第19类 建筑材料", "20": "第20类 家具",
                "21": "第21类 厨房洁具", "22": "第22类 绳网袋篷", "23": "第23类 纱线丝", "24": "第24类 布料床单", "25": "第25类 服装鞋帽",
                "26": "第26类 纽扣拉链", "27": "第27类 地毯席垫", "28": "第28类 健身器材", "29": "第29类 食品", "30": "第30类 方便食品",
                "31": "第31类 饲料种籽", "32": "第32类 啤酒饮料", "33": "第33类 酒", "34": "第34类 烟草烟具", "35": "第35类 广告销售",
                "36": "第36类 金融物管", "37": "第37类 建筑修理", "38": "第38类 通讯服务", "39": "第39类 运输贮藏", "40": "第40类 材料加工",
                "41": "第41类 教育娱乐", "42": "第42类 网站服务", "43": "第43类 餐饮住宿", "44": "第44类 医疗园艺", "45": "第45类 社会服务"
            },
            "chineseSearchOption": {"py": "查拼音", "tyz": "同音字", "xsz": "形似字", "ywty": "英文同义"},
            "partnerinfoSkill":{"tm":"商标","pa":"专利","sc":"软件著作权"},
            "englishSearchOption": {"zwty": "中文同义", "tyhz": "同音汉字"},
            "tm_status": {"dsz": "待审中", "ycs": "已初审", "yxzc": "有效注册", "ybh": "已驳回", "yxw": "已销亡"},
            "tm_form_type":{1:"立体",3:"字",4:"图",5:"字图",6:"颜色",7:"彩色"},
            "tm_type":{"p":"普通商标","j":"集体商标","z":"证明商标","t":"特殊商标"},
            "ncl_calc_status":{1:"未创建订单",2:"已创建订单"},
            "copyright_status":{1:"未关联订单",2:"已关联订单"},
            "ncl_calc_calcType":{1:"自主创建",2:"商标特殊处理"},
            "product_unit":{0:"人民币",1:"美元"},
            "order_type":{1:"提报单订单",2:"自主订单",4:"批量导入",8:"商标特殊处理",16:"代客下单"},
            "order_source_type":{1:"PC",2:"移动商城",4:"渠道方",8:"beehive渠道"},
            "payType":{"wx":"微信","zfb":"支付宝","yh":"银行卡"},
            "payResult":{"Fail":"失败","Success":"成功"},
            "tmSourceType":{1:"PC",2:"移动端",4:"渠道",8:"beehive"},
            "user_show_order_status":{1:"显示",2:"用户删除",4:"系统过期删除"},
            "order_status":{"1":"未付款","2":"订单取消","4":"付款成功","8":"退款处理中","16":"已退款","32":"已提报","64":"审核中"},
            "msg_notice_type":{"friend":"朋友","boss":"老板"},
            "tm_apply_type":{"ent":"企业","person":"个人"},
            "tm_apply_types":{"ent":"企业"},
            "op_type":{"applying":"申请中","issued":"已发放","issueError":"发放异常"},
            "tmFirstOrder":{0:"否",1:"是"},
            "partnerStatus":{0:"禁用",1:"启用"},
            "invoice_type":{"pt":"电子普通发票","zy":"纸质普通发票","zs":"纸质专用发票"},
            "invoice_status":{"submitted":"已提交","processing":"处理中","processed":"已完成"},
            "invoiceapply":{"notapply":"未申请","applied":"已申请"},
            "copyright_type":{"rjzz":"软件著作权","zpzz":"作品著作权"},
            "composition_type":{"wz":"文字","ks":"口述","yl":"音乐","xj":"戏剧","qy":"曲艺","wd":"舞蹈","zjys":"杂技艺术","ms":"美术","jz":"建筑","sy":"摄影","dy":"电影和类似摄制电影方法创作的作品",
            "tx":"图形","mj":"模型","qt":"其他" },
            "statusProgress_status":{"AWAITCHECK":"未提交","WAITARTIFICIALEXAMINE":"等待人工审核","AUDITFAIL":"审核不通过","TRECVED":"受理中","NOTRECVED":"不予受理","PASSED":"审核通过","UPLOADAPPLYDOCUMENT":"已上传申请表","FINISH":"完成","DISCARDED":"废弃"},
            "patents_type":{"fm":"发明专利","wg":"外观专利","syxx":"实用新型"},
            "applicantrequire_type":{"fyjh":"费用减缓","yqyxq":"要求优先权","qqtqgk":"请求提前公开","szsc":"实质审查","qlyqcx":"权力要求超项","bmsc":"保密审查"},
            "source_type":{1:"PC",2:"移动商城",4:"渠道方"},
          // "tm_submit_status":{"0":"资料准备","1":"资料齐全","2":"待提交","3":"人工已提交","4":"已收提交","5":"已受理","6":"部分驳回","7":"全部驳回","8":"商家异议",
            "statisticsCodeType":{"yddhzxtj":"创知电话咨询","ydfxtj":"创知店铺分享","ydzftj":"创知店铺转发","ydtsdh":"创知投诉电话","yddpfk":"移动店铺访客","ywkhxx":"业务端客户消息","ywfpxx":"业务端发票消息",
                                  "bossfpxx":"boss端发票消息","bosstsfwg":"boss端投诉服务官信息"},//暂时去掉了，不使用
            // "tm_submit_status":{"0":"资料准备","1":"资料齐全","2":"待提交","3":"人工已提交","4":"已收提交","5":"已受理","6":"部分驳回","7":"全部驳回","8":"商家异议",
            //   "9":"机器人已提交","10":"已通过","11":"填报异常","12":"交文清单","13":"不予受理","14":"信封正反面","15":"补证通知","16":"初步审定公告","17":"裁定通知",
            //   "18":"不予核准","19":"核准通知","20":"同日申请协商","21":"同日申请补送证据"},
            "tm_submit_status":{"READY":"资料准备","DOCFINISH":"资料齐全","AWAITCHECK":"等待审核","WAITARTIFICIALEXAMINE":"等待人工审核","WAITCOMMIT":"待提交","COMMITED":"人工已提交","RECVCOMMIT":"已收提交","RECVED":"已受理",
              "PARTREJECT":"部分驳回","ALLREJECT":"全部驳回","FIRSTPUB":"商家异议","ROBOT":"已提交","PASSED":"已通过","FILLEXCEPTION":"填报异常","FILELIST":"交文清单",
              "NOTRECVED":"不予受理","ENVLOPE":"信封正反面","ADDTIONALPROOF":"补证通知","DECLARE":"初步审定公告","SENTENCE":"裁定通知","NOTAPPROVAL":"不予核准",
              "APPROVAL":"核准通知","SAMEDAYCORP":"同日申请协商","SAMEDAYADDTIONALPROOF":"同日申请补送证据","DISCARDED":"废弃"},
            "opType":{"person":"人工","machine":"机器人"},
            "caseType":{"sbzc":"商标注册","sbbg":"商标变更"},
            "msgType":{"sys":"系统","single":"单点","multi":"群发","mryzSingle":"每日易照单点","mryzLicense":"群发",},
            "log_type":{"orderlog":"订单日志","tmlog":"商标流程日志"},
            "tm_tscl_type":{"NOTRECVED":"不予受理","FILLEXCEPTION":"填报异常"},
            "chance_type":{"tmReg":"商标注册"},
            "chance_status":{"1":"待服务","2":"跟进中","4":"成功","8":"失败"},
            "platform_chance_type":{"common":"普通"},
            "service_evaluation":{"0":"差评","5":"一般","10":"好评"},
            "account_log_type":{"platform":"平台","user":"用户"},
            "profitRatioType":{"platformWork":"委托作业","selfWork":"自助作业"},
            "totalType":{"zxbxl":"店铺咨询变现率","kdl":"合伙人开店率","yhfll":"合伙人分裂率"},
            //cms_servicesitem项目服务表，渠道类型
            "channelType":{"hhr":"合伙人端","boss":"boss端","wssy":"微商水印"},
            //b_customer_roll_pic图片资源表，图片类型
            "picType":{"roll":"滚动图片","placard":"海报图片"},
            //b_customer_roll_pic图片资源表，图片分类
            "picCategory":{"ip": "商标", "ic": "版权", "pa": "专利", "common": "增值"},
            //h_business_chance需求表，商机类型
            "chanceType": {"ip": "商标", "ic": "版权", "pa": "专利", "iso": "海外业务", "common": "增值服务", "icbc": "工商注册",
                            "zscq": "知识产权", "cwfw": "财务服务", "hyzz": "行业资质", "gqzr": "股权转让", "xzsp": "行政审批"},
            //cms_servicesitem  项目小类
            "serviceSmallClassType":{"sbzc":"商标注册","sbxxbg":"商标信息变更","hjsbza":"化解商标障碍","yytrsb":"异议他人商标","hwsbzc":"海外商标注册","bqdjyw":"版权登记业务",
                                    "bqqtyw":"版权其他业务","zlsqyw":"专利申请业务"},
            //h_icbc_info工商表，工商类型
            "icbcType": {"hongkong": "香港", "gn": "国内", "gnjssqs": "国内江苏省宿迁市"},
            //h_icbc_info工商表，货币类型
            "regCapitalUnitsType": {"RMB": "万人民币", "HKD": "万港币", "USD": "万美元", "GBP": "万英镑", "JPY": "万日元"},
            "isRecommend": {"0": "否", "1": "是"},
            "paymentPlatformType": {"wx": "微信", "offline": "线下"},
            "sellStatus": {"1": "待售", "2": "已售"},
            "channelProfitType": {1: "比例分成", 2: "每单分成"},
            "taxType":{"gzxj":"工资薪金"},
            "iit_status":{"0":"未提交","1":"已提交"},
            "customer_channel_type":{"yjs":"友金所"},
            "companyProperty":{1:"小规模",2:"一般"},
            "invoiceVersion":{1:"十万版",2:"万元版",2:"百万版"},
            "changeService":{1:"包变更",2:"买家变更"},
            "publishedSources":{1:"公司",2:"个人"},
            "registeredCapital":{1:"小于100万",2:"100-500万",4:"501-1000万",8:"1001-5000万",16:"大于1000万"},
            "trackType":{1:"收藏",2:"访问"},
        }
    }
}
