const system=require("../system");
class ServiceBase{
  constructor(daoName){
     //this.dbf=system.getObject("db.connection");
     this.db=system.getObject("db.connection").getCon();
     this.cacheManager=system.getObject("db.cacheManager");
     this.daoName=daoName;
     this.dao=system.getObject("db."+daoName);
  }
  static getDaoName(ClassObj){
    return ClassObj["name"].substring(0,ClassObj["name"].lastIndexOf("Service")).toLowerCase()+"Dao";
  }
  async findAll(obj){
    const objs=await this.dao.model.findAll();
    return objs;
 }
  async findAndCountAll(obj){
     const apps=await this.dao.findAndCountAll(obj);
     return apps;
  }
  async refQuery(qobj){
    return this.dao.refQuery(qobj);
  }
  async bulkDelete(ids){
    var en= await this.dao.bulkDelete(ids);
    return en;
  }
  async delete(qobj){
    return  this.dao.delete(qobj);
  }
  async create(qobj){
    return this.dao.create(qobj);
  }
  async update(qobj,tm=null){
    return this.dao.update(qobj,tm);
  }
  async updateByWhere(setObj,whereObj,t){
      return this.dao.updateByWhere(setObj,whereObj,t);
  }
  async customExecAddOrPutSql(sql,paras=null){
    return this.dao.customExecAddOrPutSql(sql,paras);
  }
  async customQuery(sql,paras,t){
    return this.dao.customQuery(sql,paras,t);
  }
  async findCount(whereObj=null){
    return this.dao.findCount(whereObj);
  }
  async findSum(fieldName,whereObj=null){
    return this.dao.findSum(fieldName,whereObj);
  }
  async getPageList(pageIndex,pageSize,whereObj=null,orderObj=null,attributesObj=null,includeObj=null){
    return this.dao.getPageList(pageIndex,pageSize,whereObj,orderObj,attributesObj,includeObj);
  }
  async findOne(obj){
    return this.dao.findOne(obj);
  }
  async findById(oid){
    return this.dao.findById(oid);
  }
  async getUidInfo(len, radix) {
      var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
      var uuid = [], i;
      radix = radix || chars.length;
      if (len) {
        for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random()*radix];
      } else {
        var r;
        uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
        uuid[14] = '4';
        for (i = 0; i < 36; i++) {
          if (!uuid[i]) {
            r = 0 | Math.random()*16;
            uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
          }
        }
      }
      return uuid.join('');
  }
}
module.exports=ServiceBase;
