{
    template:'${tmpl}',
    data:function(){
        return {
            loading:false,
            data:{},
            year:"",
            entName:"",
            companyPatentEchartdata:{
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {      
                        type : 'shadow' 
                    }
                },
                grid: {
                    top:'8%',
                    left: '3%',
                    right: '4%',
                    bottom: '10%',
                    containLabel: true
                },
                xAxis: {
                    data: [],
                    axisLabel: {
                        textStyle: {
                            color: '#999'
                        }
                    },
                    axisLine:{
                        show:false
                    }
                },
                yAxis: {
                    axisLine:{
                        show:false
                    },
                    splitLine:{
                        show:false
                    },
                    axisLabel: {
                        textStyle: {
                            color: '#999'
                        }
                    }
                },
                series: [
                    {
                        type: 'bar',
                        itemStyle: {
                            normal: {
                                color: '#303E8C',
                                barBorderRadius:[10, 10, 10, 10]
                            }
                        },
                        barGap:'-100%',
                        barCategoryGap:'80%',
                        data: [],
                        animation: false
                    },
                    {
                        type: 'bar',
                        itemStyle: {
                            normal: {
                                label:{
                                    show:false,
                                    position:'top',
                                    textStyle:{color:"#fff"}
                                },
                                barBorderRadius:[10, 10, 10, 10],
                                color: new echarts.graphic.LinearGradient(
                                    0, 0, 0, 1,
                                    [
                                        {offset: 0, color: '#83bff6'},
                                        {offset: 0.5, color: '#188df0'},
                                        {offset: 1, color: '#188df0'}
                                    ]
                                )
                            },
                            emphasis: {
                                color: new echarts.graphic.LinearGradient(
                                    0, 0, 0, 1,
                                    [
                                        {offset: 0, color: '#2378f7'},
                                        {offset: 0.7, color: '#2378f7'},
                                        {offset: 1, color: '#83bff6'}
                                    ]
                                )
                            }
                        },
                        data: []
                    }
                ]
            },
            companyPatentStatusEchartdata:{
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {      
                        type : 'shadow' 
                    }
                },
                grid: {
                    top:'5%',
                    left: '3%',
                    right: '4%',
                    bottom: '8%',
                    containLabel: true
                },
                xAxis : [
                    {
                        type : 'category',
                        data : [],
                        axisLabel: {
                            textStyle: {
                                color: '#52FFFF'
                            }
                        },
                        axisTick: {
                            show: false
                        },
                        axisLine:{
                        lineStyle:{
                            color:"#708ACC"
                        }
                        }
                    }
                ],
                yAxis : [
                    {
                        type : 'value',
                        axisLabel: {
                            textStyle: {
                                color: '#52FFFF'
                            }
                        },
                        axisTick: {
                            show: false
                        },
                        splitLine:{
                            lineStyle:{
                                color:"#0F0C3F"
                            }
                        },
                        axisLine:{
                        lineStyle:{
                            color:"#708ACC"
                        }
                        }
                    }
                ],
                series : [
                    {
                        name:'专利数量',
                        type:'bar',
                        barWidth: '40%',
                        itemStyle: {
                            normal: {
                                color: new echarts.graphic.LinearGradient(
                                    0, 0, 0, 1,
                                    [
                                        {offset: 0, color: '#83bff6'},
                                        {offset: 0.5, color: '#188df0'},
                                        {offset: 1, color: '#188df0'}
                                    ]
                                )
                            }
                        },
                        data:[]
                    }
                ]
            },
            patentIndustryEchartdata:{
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                calculable : true,
                color:['#0ed145','#83e1f6','#dc9913','#ee1515','#ec1ea4','#28ec1e','#361eec','#e58b8b','#f1d6a0','#83f6a3',],
                series : [
                    {
                        name:'产业分布',
                        type:'pie',
                        minAngle: 0,
                        avoidLabelOverlap: true,
                        radius : [10, 65],
                        center : ['50%', '50%'],
                        roseType : 'radius',
                        data:[],
                        label:{
                            align: 'left',
                            normal:{
                                formatter(v) {
                                    let text = v.name;
                                    if(text.length <= 8)
                                    {
                                        return text;
                                    }else if(text.length > 8 && text.length <= 16){
                                        return text = `${text.slice(0,8)}\n${text.slice(8)}`
                                    }else if(text.length > 16 && text.length <= 24){
                                        return text = `${text.slice(0,8)}\n${text.slice(8,16)}\n${text.slice(16)}`
                                    }else if(text.length > 24 && text.length <= 30){
                                        return text = `${text.slice(0,8)}\n${text.slice(8,16)}\n${text.slice(16,24)}\n${text.slice(24)}`
                                    }else if(text.length > 30){
                                        return text = `${text.slice(0,8)}\n${text.slice(8,16)}\n${text.slice(16,24)}\n${text.slice(24,30)}\n${text.slice(30)}`
                                    }
                                },
                                textStyle : {
                                    fontSize : 14
                                }
                            }
                        }
                    }
                ]
            },
            patentTechnologyEchartdata:{
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {      
                        type : 'shadow' 
                    }
                },
                grid: {
                    top:'5%',
                    left: '3%',
                    right: '4%',
                    bottom: '8%',
                    containLabel: true
                },
                xAxis : [
                    {
                        type : 'category',
                        data : [],
                        axisLabel: {
                            textStyle: {
                                color: '#52FFFF'
                            }
                        },
                        axisTick: {
                            show: false
                        },
                        axisLine:{
                        lineStyle:{
                            color:"#708ACC"
                        }
                        }
                    }
                ],
                yAxis : [
                    {
                        type : 'value',
                        axisLabel: {
                            textStyle: {
                                color: '#52FFFF'
                            }
                        },
                        axisTick: {
                            show: false
                        },
                        splitLine:{
                            lineStyle:{
                                color:"#0F0C3F"
                            }
                        },
                        axisLine:{
                        lineStyle:{
                            color:"#708ACC"
                        }
                        }
                    }
                ],
                series : [
                    {
                        name:'专利数量',
                        type:'bar',
                        barWidth: '40%',
                        itemStyle: {
                            normal: {
                                color: new echarts.graphic.LinearGradient(
                                    0, 0, 0, 1,
                                    [
                                        {offset: 0, color: '#83bff6'},
                                        {offset: 0.5, color: '#188df0'},
                                        {offset: 1, color: '#188df0'}
                                    ]
                                )
                            }
                        },
                        data:[]
                    }
                ]
            },
            patentApplyEchartdata:{
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {      
                        type : 'shadow' 
                    }
                },
                grid: {
                    top:'5%',
                    left: '3%',
                    right: '4%',
                    bottom: '8%',
                    containLabel: true
                },
                xAxis : [
                    {
                        type : 'category',
                        data : [
                            
                        ],
                        axisLabel: {
                            textStyle: {
                                color: '#9A9DB0'
                            }
                        },
                        axisTick: {
                            show: false
                        },
                        axisLine:{
                            lineStyle: { 
                                color: 'rgba(255,255,255,.2)'
                            }
                        }
                    }
                ],
                yAxis : [
                    {
                        type : 'value',
                        axisLabel: {
                            textStyle: {
                                color: '#9A9DB0'
                            }
                        },
                        axisTick: {
                            show: false
                        },
                        splitLine: {
                            lineStyle: {
                                 color: 'rgba(255,255,255,.1)'
                            }
                        },
                        axisLine:{
                          show:false
                        }
                    },
                    {
                        type : 'value',
                        axisLabel: {
                            textStyle: {
                                color: '#9A9DB0'
                            }
                        },
                        axisTick: {
                            show: false
                        },
                        splitLine: {
                            lineStyle: {
                                 color: '#2A97EC'
                            }
                        },
                        axisLine:{
                          show:false
                        }
                    }
                ],
                series : [
                    {
                        name:'发明专利申请数量',
                        type:'line',
                        symbol: 'circle',
                        barWidth: '40%',
                        itemStyle: {
                            normal: {
                                color: "#BF86FB"
                            }
                        },
                        areaStyle: {
                            normal: {
                                color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                                    offset: 0,
                                    color: 'rgba(1, 132, 213, 0.4)'
                                }, {
                                    offset: 0.8,
                                    color: 'rgba(1, 132, 213, 0.1)'
                                }], false),
                                shadowColor: 'rgba(0, 0, 0, 0.1)',
                            }
                        },
                        data:[]
                    },
                    {
                        name:'专利授权数量',
                        type:'line',
                        symbol: 'circle',
                        barWidth: '40%',
                        itemStyle: {
                            normal: {
                                color: "#2A97EC"
                            }
                        },
                        areaStyle: {
                            normal: {
                                color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                                    offset: 0,
                                    color: 'rgba(1, 132, 213, 0.4)'
                                }, {
                                    offset: 0.8,
                                    color: 'rgba(1, 132, 213, 0.1)'
                                }], false),
                                shadowColor: 'rgba(0, 0, 0, 0.1)',
                            }
                        },
                        data:[]
                    }
                ]
            },
            patentMainWordsEchartdata:{
                tooltip: {
                    show: true
                },
                series: [{
                    name: '企业专利',
                    type: 'wordCloud',
                    size: ['100%', '100%'],
                    sizeRange: [12, 32],
                    textRotation : [-45, 0, 45, 90],
                    textPadding: 0,
                    textStyle: {
                        normal: {
                            color: function() {
                                return 'rgb(' +
                                        Math.round(Math.random() * 255) +
                                        ', ' + Math.round(Math.random() * 255) +
                                        ', ' + Math.round(Math.random() * 255) + ')'
                            }
                        }
                    },
                    data: []
                }]
            },
            /* */
            enterprisePatentEchartdata:{
                tooltip: {
                    trigger: 'item',
                    formatter: "{a} <br/>{b}: {c} ({d}%)"
                },
                grid: {
                    top:'5%',
                    left: '3%',
                    right: '4%',
                    bottom: '8%',
                    containLabel: true
                },
                legend: {
                    orient: 'vertical',
                    default: '#fff',
                    x: 'left',
                    data:[{name:'发明专利',textStyle: {color: '#fff'}},{name:'实用新型专利',textStyle: {color: '#fff'}},{name:'外观专利',textStyle: {color: '#fff'}}]
                },
                color:['#A859FF','#FF9745','#34ABFF'],

                series: [
                    {
                        name:'专利类型',
                        type:'pie',
                        radius: ['50%', '70%'],
                        avoidLabelOverlap: false,
                        label: {
                            normal: {
                                show: false,
                                position: 'center'
                            },
                            emphasis: {
                                show: true,
                                textStyle: {
                                    fontSize: '14',
                                    fontWeight: 'bold'
                                }
                            }
                        },
                        labelLine: {
                            normal: {
                                show: false
                            }
                        },
                        data:[
                           
                        ]
                    }
                ]
            }

        }
    },
    created(){
        /** this.showLoading();*/
        this.entName=this.$router.history.current.query.entName || "";
        this.year=this.$router.history.current.query.year || "";
        if(!this.entName){
            this.$root.pushx(
                { name:'/businessdecisions',title:"企业智慧管理"}
            );
            return ;
        }
        this.aliBusinessDecision();
    },
    mounted:function(){
        
        /** var d = window.localStorage.getItem("aliBusinessDecision");
        if(d){
            var dd = JSON.parse(d);
            this.data = dd.data;
            this.initParams();
        }else{
            this.$root.pushx(
                { name:'/businessdecisions',title:"企业智慧管理"}
            );
            return ;
        }*/
        
    },
    methods:{
        fanhui () {
            this.$root.pushx({
                name:"/businessdecisions"
            });
        },
        showLoading(){
            var that=this;
            this.loading = true;
            setTimeout(()=>{
                that.loading = false;
            },3000);
        },
        yearChange(){
            /** this.showLoading();*/
            console.log(this.year);
            this.aliBusinessDecision();
        },
        aliBusinessDecision(){
            var obj={entName:"",year:""};
            if(this.year && this.year!="全部年份" ){
                obj.year=this.year;
            }
            if(this.entName ){
                obj.entName=this.entName;
            }else{
                return ;
            }
            this.$root.showMask();
            this.$root.getReq("/web/regionalpatentmonitoringCtl/aliBusinessDecision",obj).then(d=>{
                if(d && d.code==1){
                    this.data = d.data;
                    console.log(d.data);
                    this.initParams();
                }
                this.$root.hideMask();
            }).catch(e=>{
                this.$root.hideMask();
            })
        },
        initParams(){
            var data = this.data;
            console.log(data);
            if(data){
                var cped = data.profile;
                if(cped){
                    companyPatentEchartdata_x = ["总量","公开量","有效量","无效量"];
                    companyPatentEchartdata_y =[cped.sum ,cped.pubnum,cped.validnum,cped.unvalidnum];
                    var echarts = this.$refs.companyPatentRef.getEchartObj();
                    this.companyPatentEchartdata.xAxis.data =companyPatentEchartdata_x;
                    this.companyPatentEchartdata.series[1].data = companyPatentEchartdata_y;
                    echarts.setOption(this.companyPatentEchartdata);
                    window.addEventListener("resize",function(){
                        echarts.resize();
                    });
                    this.$forceUpdate();
                }
                if(data.title){
                    
                    this.patentMainWordsEchartdata.series[0].data=data.title;
                    var echarts2 = this.$refs.patentMainWordsRef.getEchartObj();
                    echarts2.setOption(this.patentMainWordsEchartdata);
                    window.addEventListener("resize",function(){
                        echarts2.resize();
                    });
                    this.$forceUpdate();
                }
                
                if(data.statestatistic && data.statestatistic.length>0){
                    var x=[];
                    var y=[];
                    for(var i=0;i<data.statestatistic.length;i++){
                        var o=data.statestatistic[i];
                        x.push(o.statename);
                        y.push(o.value);
                    }
                    var echarts3 = this.$refs.companyPatentStatusRef.getEchartObj();
                    this.companyPatentStatusEchartdata.xAxis[0].data=x;
                    this.companyPatentStatusEchartdata.series[0].data=y;
                    echarts3.setOption(this.companyPatentStatusEchartdata);
                    window.addEventListener("resize",function(){
                        echarts3.resize();
                    });
                    this.$forceUpdate();
                }
                if(data.applytrend){
                    var x=[];
                    var y1=[];
                    var y2=[];
                    for(var i=0;i<data.applytrend.apply.length;i++){
                        var o=data.applytrend.apply[i];
                        var o2 = data.applytrend.empower[i];
                        x.push(o.data);
                        y1.push(o.value);
                        y2.push(o2.value);
                    }
                    var echarts4 = this.$refs.patentApplyRef.getEchartObj();
                    this.patentApplyEchartdata.xAxis[0].data=x;
                    this.patentApplyEchartdata.series[0].data=y1;
                    this.patentApplyEchartdata.series[1].data=y2;
                    echarts4.setOption(this.patentApplyEchartdata);
                    window.addEventListener("resize",function(){
                        echarts4.resize();
                    });
                    this.$forceUpdate();
                }
                if(data.typestatistic && data.typestatistic.length>0){
                    var ddd=[];
                    for(var i=0;i<data.typestatistic.length;i++){
                        var o=data.typestatistic[i];
                        var obj={name:o.typename,value:o.value};
                        ddd.push(obj);
                    }
                    var echarts5 = this.$refs.enterprisePatentRef.getEchartObj();
                    this.enterprisePatentEchartdata.series[0].data=ddd;
                    var this_ = this;
                    this_.enterprisePatentEchartdata.legend.data = [];
                    ddd.forEach(row =>{
                        var map = {};
                        map['name'] = row.name;
                        map['textStyle'] = {color: '#fff'};
                        this_.enterprisePatentEchartdata.legend.data.push(map);
                    });
                    echarts5.setOption(this.enterprisePatentEchartdata);
                    window.addEventListener("resize",function(){
                        echarts5.resize();
                    });
                    this.$forceUpdate();
                }
                if(data.ipc && data.ipc.length>0){
                    var x=[];
                    var y=[];
                    for(var i=0;i<data.ipc.length;i++){
                        var o=data.ipc[i];
                        x.push(o.code);
                        y.push(o.num);
                    }
                    var echarts6 = this.$refs.patentTechnologyRef.getEchartObj();
                    this.patentTechnologyEchartdata.xAxis[0].data=x;
                    this.patentTechnologyEchartdata.series[0].data=y;
                    echarts6.setOption(this.patentTechnologyEchartdata);
                    window.addEventListener("resize",function(){
                        echarts6.resize();
                    });
                    this.$forceUpdate();
                }

                if(data.distribution && data.distribution.length>0){
                    var patentIndustryEchartdata = [];
                    for(var i=0;i<data.distribution.length;i++){
                        var patentIndustryEchartObj={name:data.distribution[i].industryname,value:data.distribution[i].value};
                        patentIndustryEchartdata.push(patentIndustryEchartObj);
                    }
                    var echarts7 = this.$refs.patentIndustryRef.getEchartObj();
                    this.patentIndustryEchartdata.series[0].data=patentIndustryEchartdata;
                    echarts7.setOption(this.patentIndustryEchartdata);
                    window.addEventListener("resize",function(){
                        echarts7.resize();
                    });
                    this.$forceUpdate();
                }
                
            }
        }
    },
    vname:"gsb-businessdecisionsresult"
}