{
    template:'${tmpl}',
    data:function(){
        return {
            typeradio:"专利公开量",
            data:{},
            analyse:"",
            year:'',
            province:'',
            detailtype:0,
            tableColumnList:[
              [{name:"地区",code:"areaname"},{name:"专利公开量",code:"y_applynum"},{name:"专利授权量",code:"y_registnum"}],
              [{name:"分类号",code:"code"},{name:"专利数量",code:"num"}],
              [{name:"申请人名称",code:"entname"},{name:"专利数量",code:"num"}],
              [{name:"年份",code:"year"},{name:"专利数量",code:"num"}],
              [{name:"类型",code:"statusname"},{name:"专利数量",code:"num"}],
              [{name:"代理机构名称",code:"agencyname"},{name:"专利数量",code:"num"}]
            ],
            tableColumn:[
              {name:"地区",code:"areaname"},
              {name:"专利公开量",code:"y_applynum"},{name:"专利授权量",code:"y_registnum"}
            ],
            tableData: [
              
            ],
            bardata:{
              tooltip : {
                  trigger: 'axis',
                  axisPointer : {            
                      type : 'shadow'       
                  }
              },
              grid: {
                  left: '3%',
                  right: '4%',
                  bottom: '8%',
                  containLabel: true
              },
              xAxis : [
                  {
                      type : 'category',
                      data : [],
                      axisTick: {
                          alignWithLabel: true
                      },
                      axisLine:{
                        lineStyle:{
                          color:"#CACACA"
                        }
                      }
                  }
              ],
              yAxis : [
                  {
                      type : 'value',
                      axisLine:{
                        lineStyle:{
                          color:"#FFFFFF"
                        }
                      },
                      splitLine:{
                        lineStyle:{
                          color:"#0F0C3F"
                        }
                      }
                  }
              ],
              series : [
                {
                  type: 'bar',
                  itemStyle:{
                    normal:{
                        color:'#3E83D3'
                    }
                  },
                  data: []
                }
              ]
            },
            /*initializationProvinceConfigurationList:[
              {"title":"专利地区分布详情","bartitle":"各省、自治区、直辖市专利分布柱状图","tabletitle":"各省、自治区、直辖市专利分布表"},
              {"title":"专利IPC分布详情","bartitle":"各省、自治区、直辖市IPC分布柱状图","tabletitle":"各省、自治区、直辖市IPC分布表"},
              {"title":"申请人分布详情","bartitle":"各省、自治区、直辖市申请人专利排名柱状图","tabletitle":"各省、自治区、直辖市申请人专利排名列表"},
              {"title":"申请趋势详情","bartitle":"各省、自治区、直辖市专利申请趋势柱状图","tabletitle":"各省、自治区、直辖市专利申请趋势列表"},
              {"title":"法律状态分布详情","bartitle":"各省、自治区、直辖市专利法律状态分布柱状图","tabletitle":"各省、自治区、直辖市专利法律状态分布表"},
              {"title":"代理机构排名详情","bartitle":"各省、自治区、直辖市代理机构排名柱状图","tabletitle":"各省、自治区、直辖市代理机构排名列表"},
            ],*/
            initializationConfigurationList:[
              {"title":"专利地区分布详情","bartitle":"专利分布柱状图","tabletitle":"专利分布表"},
              {"title":"专利IPC分布详情","bartitle":"IPC分布柱状图","tabletitle":"IPC分布表"},
              {"title":"申请人分布详情","bartitle":"申请人专利排名柱状图","tabletitle":"申请人专利排名列表"},
              {"title":"申请趋势详情","bartitle":"专利申请趋势柱状图","tabletitle":"专利申请趋势列表"},
              {"title":"法律状态分布详情","bartitle":"专利法律状态分布柱状图","tabletitle":"专利法律状态分布表"},
              {"title":"代理机构排名详情","bartitle":"代理机构排名柱状图","tabletitle":"代理机构排名列表"},
            ],
            initializationConfiguration:{"title":"专利地区分布详情","bartitle":"各省、自治区、直辖市专利分布柱状图","tabletitle":"各省、自治区、直辖市专利分布表"},
        }
    },
    mounted:function(){
      var detailtype = this.$router.history.current.query.detailtype;
      /* 0:地区分布详情 1：IPC 2:申请人 3：趋势 4：法律状态 5：代理机构*/
      if(detailtype==null || detailtype==undefined){
        this.$root.pushx({
          name:"/regionalpatentmonitoring",
        });
      }else{
        this.detailtype=detailtype;
        this.tableColumn = this.tableColumnList[detailtype];
        this.initializationConfiguration=this.initializationConfigurationList[detailtype];
        this.initParams();
      }
    },
    methods:{
      initParams(){
        /** var flag=null;
        var detailtype=this.detailtype;*/
        /* 0:地区分布详情 1：IPC 2:申请人 3：趋势 4：法律状态 5：代理机构*/
        /**if(detailtype==0){
          flag="aliplace";
        }else if(detailtype==1){
          flag="aliIpc"
        }else if(detailtype==2){
          flag="aliApplicant"
        }else if(detailtype==3){
          flag="aliTrend"
        }else if(detailtype==4){
          flag="aliPubstatusnow"
        }else if(detailtype==5){
          flag="aliAgency"
        } */
        this.year=window.localStorage.getItem("year") || ""; 
        this.province=window.localStorage.getItem("provinceName") || ""; 
        
        var data = window.localStorage.getItem("regionalpatentmonitoringdetaildata"); 
        if(data){
          data = JSON.parse(data);
          this.data=data;
          this.tableData=this.data.data[0].data;
          this.analyse = data.data[0].analyse;
          var echarts = this.$refs.detailbar.getEchartObj();
          this.bardata.xAxis[0].data = data.data[0].xdata;
          this.bardata.series[0].data = data.data[0].ydata;
          echarts.setOption(this.bardata);
        }else{
          this.$root.pushx({
            name:"/regionalpatentmonitoring",
          });
        }
      },
      tomain(name){
        this.$root.pushx(
          { name:'/regionalpatentmonitoring',title:"区域专利监控",params:{name:name}}
        )
      },
      qiehuan(v){
        this.typeradio = v;
        if(v=="专利授权量"){
          this.tableData=this.data.data[1].data;
          this.analyse = this.data.data[1].analyse;
          var echarts = this.$refs.detailbar.getEchartObj();
          this.bardata.xAxis[0].data = this.data.data[1].xdata;
          this.bardata.series[0].data = this.data.data[1].ydata;
          echarts.setOption(this.bardata);
        }else if(v=="专利公开量"){
          this.tableData=this.data.data[0].data;
          this.analyse = this.data.data[0].analyse;
          var echarts = this.$refs.detailbar.getEchartObj();
          this.bardata.xAxis[0].data = this.data.data[0].xdata;
          this.bardata.series[0].data = this.data.data[0].ydata;
          echarts.setOption(this.bardata);
        }
      }
    },
    vname:"gsb-regionalpatentmonitoringdetails"
}