const APIBase = require("../../api.base");
const system = require("../../../system");
/**
 * 媒体聚合页项目-移动端调用相关接口
 */
class Mediaaggregation extends APIBase {
    constructor() {
        super();
        this.needinfoSve = system.getObject("service.media.needinfoSve");
        this.mediaaggregationSve = system.getObject("service.mediaaggregation.mediaaggregationSve");
        this.launchchannelSve = system.getObject("service.configmag.launchchannelSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        var self = this;
        pobj.xctx = req.xctx;
        pobj.clientIp = req.clientIp;
        // if (pobj.company_id) {
        //     pobj["actionBody"]["company_id"] = pobj.company_id || "10";
        // }
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess("测试接口");
                break;
            case "submitNeed"://提交需求/线索
                opResult = this.needinfoSve.submitNeed(pobj);
                break;
            case "addbrowsingrecord"://添加页面访问记录
                opResult = this.needinfoSve.addbrowsingrecord(pobj);
                break;
            case "getSourceChannelInfo"://获取来源渠道信息
                opResult = this.launchchannelSve.getSourceChannelInfo(pobj);
                break;
            case "getAllProductType"://获取所有渠道信息
                opResult = this.needinfoSve.getAllProductType(pobj);
                break;
            case "productList"://服务列表
                opResult = await this.mediaaggregationSve.productList(pobj);
                break;
            case "rotationChartList"://首页轮播图
                opResult = await this.mediaaggregationSve.rotationChartList(pobj);
                break;
            case "tablePicList"://列表头图
                opResult = await this.mediaaggregationSve.tablePicList(pobj);
                break;
            case "needProductList"://留资表单产品
                opResult = await this.mediaaggregationSve.needProductList(pobj);
                break;
            case "popularRecommendationList"://热门推荐列表
                opResult = await this.mediaaggregationSve.popularRecommendationList(pobj);
                break;
            case "productTypeFirst"://产品分类列表
                opResult = await this.mediaaggregationSve.productTypeFirst(pobj);
                break;
            case "productTypeSecend"://产品分类列表
                opResult = await this.mediaaggregationSve.productTypeSecend(pobj);
                break;
            case "productDetail"://产品详情页
                opResult = await this.mediaaggregationSve.productDetail(pobj);
                break;
            case "bottomMenuConfig"://吸底菜单
                opResult = await this.mediaaggregationSve.bottomMenuConfig(pobj);
                break;
            case "cycleProduct"://周期产品
                opResult = await this.mediaaggregationSve.cycleProduct(pobj);
                break;
            case "secondLevelNeedConfig"://二级留资页
                opResult = await this.mediaaggregationSve.secondLevelNeedConfig(pobj);
                break;
            case "clueMaintenance"://二类产品资质选项(选取数据线索的数据)、留资表单产品列表(我需要)
                opResult = await this.mediaaggregationSve.clueMaintenance(pobj);
                break;
            case "cycleProductSecend"://周期产品二类
                opResult = await this.mediaaggregationSve.cycleProductSecend(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    async submitNeed(pobj, qobj, req){
        var opResult = await this.needinfoSve.submitNeed(pobj);
        return opResult;
    }
    async getSourceChannelInfo(pobj, qobj, req){
        var opResult = await this.launchchannelSve.getSourceChannelInfo(pobj);
        return opResult;
    }
    async getAllProductType(pobj, qobj, req){
        var opResult = await this.needinfoSve.getAllProductType(pobj);
        return opResult;
    }
    async productList(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.productList(pobj);
        return opResult;
    }
    async rotationChartList(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.rotationChartList(pobj);
        return opResult;
    }
    async tablePicList(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.tablePicList(pobj);
        return opResult;
    }
    async needProductList(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.needProductList(pobj);
        return opResult;
    }
    async popularRecommendationList(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.popularRecommendationList(pobj);
        return opResult;
    }
    async productTypeFirst(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.productTypeFirst(pobj);
        return opResult;
    }
    async productTypeSecend(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.productTypeSecend(pobj);
        return opResult;
    }
    async productDetail(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.productDetail(pobj);
        return opResult;
    }
    async bottomMenuConfig(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.bottomMenuConfig(pobj);
        return opResult;
    }
    async cycleProduct(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.cycleProduct(pobj);
        return opResult;
    }
    async secondLevelNeedConfig(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.secondLevelNeedConfig(pobj);
        return opResult;
    }
    async clueMaintenance(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.clueMaintenance(pobj);
        return opResult;
    }
    async cycleProductSecend(pobj, qobj, req){
        var opResult = await this.mediaaggregationSve.cycleProductSecend(pobj);
        return opResult;
    }
}
module.exports = Mediaaggregation;
