var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const uuidv4 = require('uuid/v4');
class CachSearchesCtl extends CtlBase {
  constructor() {
    super("common", CtlBase.getServiceName(CachSearchesCtl));
  }
  async initNewInstance(queryobj, qobj) {
    return system.getResultSuccess({});
  }
  async findAndCountAll(pobj, gobj, req) {
    pobj.opCacheUrl = req.session.app.opCacheUrl;
    pobj.appid = req.appid;
    return await this.service.findAndCountAllCache(pobj);
  }
  async delCache(queryobj, qobj, req) {
    var param = { key: queryobj.key, appid: req.appid, opCacheUrl: req.session.app.opCacheUrl };
    return await this.service.delCache(param);
  }
  async clearAllCache(queryobj, qobj, req) {
    var param = { appid: req.appid, opCacheUrl: req.session.app.opCacheUrl };
    return await this.service.clearAllCache(param);
  }
}
module.exports = CachSearchesCtl;
