const system = require("../../../system");
const Dao = require("../../dao.base");

class MediaaggregationDao extends Dao {
  constructor() {
    super(Dao.getModelName(MediaaggregationDao));
  }

  /**
   * 产品列表
   */
  async productList(req) {
    var params = {
      product_type_code: req.actionBody.product_type_code
    };
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount from mc_product  where deleted_at is null and product_type_code = :product_type_code and is_enabled = 1 ";
    var sql = "select product_type_code,product_type_name,code,name,selling_point,price_type,price,original_price,sales_volume,product_detail_url,list_thumbnail_url,is_recommend,service_Introduction_info from mc_product  where deleted_at is null and product_type_code = :product_type_code and is_enabled = 1 order by sequence desc";
    var list = await this.customQuery(sql, params);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount, params);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }

  /**
   * 轮播图
   */
  async rotationChartList(req) {
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount from mc_rotation_chart where deleted_at is null and pic_type = 2  and is_enabled = 1 ";
    var sql = "select pic_type_name,name,pic_url,jump_link_type,jump_link from mc_rotation_chart where deleted_at is null and pic_type = 2 and is_enabled = 1  order by sequence desc";
    var list = await this.customQuery(sql);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }

  /**
   * 列表头图
   */
  async tablePicList(req) {
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };

    var dataCount = "select count(1) as dataCount from mc_rotation_chart where deleted_at is null and pic_type = 1  and is_enabled = 1";
    var sql = "select pic_type_name,name,pic_url,jump_link_type,jump_link from mc_rotation_chart where deleted_at is null and pic_type = 1 and is_enabled = 1  order by sequence desc";
    var list = await this.customQuery(sql);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }

  /**
   * 留资表单产品
   */
  async needProductList(req) {
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount from mc_second_level_need_config where deleted_at is null  ";
    var sql = "select code,name,link_url,top_pic_url,recommend_product_quantity,recommend_product from mc_second_level_need_config where deleted_at is null  ";
    var list = await this.customQuery(sql);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }

  /**
   * 热门推荐
   */
  async popularRecommendationList(req) {
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount from mc_popular_recommendation where deleted_at is null and  is_enabled = 1  ";
    var sql = "select pic_position_name,pic_describe,pic_url,jump_link_type,jump_link from mc_popular_recommendation where deleted_at is null  and  is_enabled = 1 ";
    var list = await this.customQuery(sql);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }

  /**
   * 产品分类一类
   */
  async productTypeFirst(req) {
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount from mc_product_type  where deleted_at is null and p_id = 0 ";
    var sql = "select  p_id,p_code,p_name,jump_link_type,code,name,pic_url,jump_link from mc_product_type  where deleted_at is null and p_id = 0  order by sequence asc";
    var list = await this.customQuery(sql);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }

  /**
   * 产品分类二类
   */
  async productTypeSecend(req) {
    var params = {
      p_code: req.actionBody.p_code
    };
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount from mc_product_type where  deleted_at is null and  p_code = :p_code ";
    var sql = "select p_id,p_code,p_name,code,name,pic_url,jump_link_type,jump_link from  mc_product_type where  deleted_at is null and p_code = :p_code  order by sequence desc";
    var list = await this.customQuery(sql, params);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount, params);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;

    return returnRes;
  }
  /**
   * 获取产品详情
   */
  async productDetail(req) {
    var params = {
      code: req.actionBody.code
    };
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount from mc_product where  deleted_at is null  and is_enabled = 1 and  code = :code  ";
    var sql = "select product_type_name,price_type,code,name,selling_point,price,original_price,sales_volume,product_detail_url,list_thumbnail_url,is_recommend,service_Introduction_info,process_flow_info,information_required_info,can_get_info,our_advantage_info,p_product_type_id,p_product_type_code,p_product_type_name from mc_product where deleted_at is null and is_enabled = 1 and  code = :code  ";
    var list = await this.customQuery(sql, params);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount, params);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }

  /**
  * 吸底菜单
  */
  async bottomMenuConfig(req) {
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount  from mc_bottom_menu_config  where deleted_at is null ";
    var sql = "select name,button_position,button_type,else_button_type,is_distinguishtime,strategy_date,strategy_time_start,strategy_time_end,button_name,call_number,else_button_name,else_call_number from mc_bottom_menu_config  where deleted_at is null ";
    var list = await this.customQuery(sql);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }

  /**
   * 周期产品
   */
  async cycleProduct(req) {
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount  from mc_cycle_product  where deleted_at is null ";
    var sql = "select cycle_type,cycle_type_name,pic_describe,pic_url,jump_link_type,jump_link from mc_cycle_product  where deleted_at is null  order by sequence desc";
    var list = await this.customQuery(sql);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }


  /**
     * 二级留资页热门推荐
     */
  async secondLevelNeedConfig(req) {
    var params = {
      code: req.actionBody.code
    };
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount  from mc_second_level_need_config  where deleted_at is null and code = :code ";
    var sql = "select code,name,link_url,top_pic_url,recommend_product_quantity,recommend_product from mc_second_level_need_config  where deleted_at is null and code = :code";
    var list = await this.customQuery(sql, params);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount, params);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }


  /**
   * 二类产品资质选项(选取数据线索的数据)、留资表单产品列表(我需要)
   */
  async clueMaintenance(req) {
    var params = {
      code: req.actionBody.code,
    };
    var apiType = req.actionBody.apiType;
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    if (apiType && apiType == '1') {//二类产品资质选项(选取数据线索的数据)
      var dataCount = "select count(1) as dataCount  from mc_clue_maintenance  where deleted_at is null";
      var sql = "select clue_info from mc_clue_maintenance  where deleted_at is null";
    }
    if (apiType && apiType == '2') {//留资表单产品列表(我需要)
      var dataCount = "select count(1) as dataCount  from mc_clue_maintenance  where deleted_at is null and code = :code ";
      var sql = "select clue_info from mc_clue_maintenance  where deleted_at is null and code = :code ";
    }
    var list = await this.customQuery(sql, params);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount, params);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }


  /**
   *周期产品二类 
   */
  async cycleProductSecend(req) {
    var params = {
      cycle_type: req.actionBody.cycle_type
    };
    var returnRes = {
      total: 0,//总记录条数
      rows: []
    };
    var dataCount = "select count(1) as dataCount from mc_cycle_product where deleted_at is null and cycle_type = :cycle_type ";
    var sql = "select code,cycle_type,cycle_type_name,pic_describe,pic_url,jump_link_type,jump_link from mc_cycle_product where deleted_at is null and cycle_type = :cycle_type";
    var list = await this.customQuery(sql, params);
    returnRes.rows = list;
    var tmpResultCount = await this.customQuery(dataCount, params);
    returnRes.total = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return returnRes;
  }
}
module.exports = MediaaggregationDao;