module.exports = (sequelize, DataType) => {
  return sequelize.define("marketingsubject", {
    code: DataType.STRING(100),
    name: DataType.STRING(100),
    notes: DataType.STRING(255),
    user_name: DataType.STRING(100),
    user_id: DataType.STRING(100),
    company_id: DataType.INTEGER,
  }, {
      // 不添加时间戳属性 (updatedAt, createdAt)
      timestamps: true,

      // 不删除数据库条目，但将新添加的属性deletedAt设置为当前日期（删除完成时）。 
      // paranoid 只有在启用时间戳时才能工作
      paranoid: true,

      // 将自动设置所有属性的字段选项为下划线命名方式。
      // 不会覆盖已经定义的字段选项
      underscored: true,

      // 禁用修改表名; 默认情况下，sequelize将自动将所有传递的模型名称（define的第一个参数）转换为复数。 如果你不想这样，请设置以下内容
      freezeTableName: true,

      // 定义表的名称
      tableName: 'c_marketing_subject',

      // 启用乐观锁定。 启用时，sequelize将向模型添加版本计数属性，
      // 并在保存过时的实例时引发OptimisticLockingError错误。
      // 设置为true或具有要用于启用的属性名称的字符串。
      version: true
    });
};