const system = require("../../../system");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
const submit_type={"1":"页面","2":"弹窗"};
/**
 * 表单信息表
 */
module.exports = (db, DataTypes) => {
    return db.define("needinfo", {
        product_type_code:DataTypes.STRING,//产品类型编码
        product_type_name:DataTypes.STRING,//产品类型名称			
        submit_type_name:DataTypes.STRING,//提交方式名称
        submit_type:{
            type: DataTypes.STRING(60),
            set: function (val) {
              this.setDataValue("submit_type", val);
              this.setDataValue("submit_type_name",submit_type[val]);
            }
        },
        channel_only_code:DataTypes.STRING,//渠道编码
        channel_code:DataTypes.STRING,//渠道编码
        channel_name:DataTypes.STRING,//渠道名称
        page_code:DataTypes.STRING,//页面编码
        page_name:DataTypes.STRING,//页面名称
        contact_mobile:DataTypes.STRING,//联系电话
        contact_name:DataTypes.STRING,//联系人
        original_need:DataTypes.STRING,//原始需求
        region:DataTypes.STRING,//地区
        business_id:DataTypes.STRING,//云服产品id
        push_status:DataTypes.INTEGER,
        notes: DataTypes.STRING
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        tableName: 'mc_need_info',
        validate: {},
        indexes: [

        ]
    });
}

