const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class ImginfoService extends ServiceBase {
  constructor() {
    super("configmag", ServiceBase.getDaoName(ImginfoService));
  }
  async getImgList(pobj) {
    let res = await this.dao.findAndCountAll(pobj);
    return system.getResultSuccess(res);
  }
  async createImginfo(pobj) {
    let code = await this.getBusUid("img");
    pobj.imginfo.code = code;
    if (pobj.imginfo.company_id === undefined) {
      pobj.imginfo.company_id = 10;
    }
    let res = await this.dao.create(pobj.imginfo);
    return system.getResultSuccess(res);
  }
  async create(pobj) {
    let code = await this.getBusUid("img");
    pobj.code = code;
    if (!pobj.pic_url) {
      return system.getResultFail(-123, "图片不能为空");
    }
    return system.getResultSuccess(this.dao.create(pobj));
  }


  async update(pobj) {
    let whereParams = {
      id: pobj.id
    }
    let res = await this.dao.findOne(whereParams,[]);
    
    if(!pobj.id){
      return system.getResultFail(-124, "未知图片信息");
    }
    if(!pobj.pic_url){
      pobj.pic_url = res.pic_url;
    }
    if(!pobj.pic_size){
      pobj.pic_size = res.pic_size;
    }
    if(!pobj.name){
      pobj.name = res.name;
    }
    return system.getResultSuccess(this.dao.update(pobj));
  }
}
module.exports = ImginfoService;