var system = require("../../../system");
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const moment = require("moment");
class BizbatchCtl extends CtlBase {
    constructor() {
        super("bizchance", CtlBase.getServiceName(BizbatchCtl));
    }
    async create(pobj, qobj, req) {
        try {
            if (!pobj.batchArray || !Array.isArray(pobj.batchArray) || pobj.batchArray.length > 20 || pobj.batchArray.length <= 0) {
                throw new Error("参数错误");
            }
            const rs = await this.service.create(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)

        }
    }
    async detail(pobj, qobj, re) {
        try {
            if (!pobj.id) {
                throw new Error("参数错误");
            }
            const rs = await this.service.detail(pobj);
            return system.getResult(rs);
        } catch (err) {
            return system.getResult(null, err.message)

        }
    }
}
module.exports = BizbatchCtl;
