/**
 * 服务单
 * @param db
 * @param DataTypes
 * @returns {Model|void|*}
 */
module.exports = (db, DataTypes) => {
    return db.define("servicebill", {
        bizId: { // 服务单id
            allowNull: false,
            type: DataTypes.INTEGER
        },
        orderNo: {
            allowNull: false,
            type: DataTypes.INTEGER
        },
        contactName: { //联系人名称
            allowNull: true,
            type: DataTypes.STRING
        },
        contactMobile: { //联系人电话
            allowNull: false,
            type: DataTypes.STRING
        },
        timeUnit: { //时间单位年：year
            allowNull: false,
            type: DataTypes.STRING
        },
        quantity: { //数量
            allowNull: true,
            type: DataTypes.INTEGER
        },
        note: { //备注
            allowNull: true,
            type: DataTypes.STRING
        },
        companyInfo: { //公司信息
            allowNull: false,
            type: DataTypes.JSON
        },
        orderNo: { //订单号
            allowNull: true,
            type: DataTypes.STRING
        },
        status: { //服务单状态
            allowNull: false,
            type: DataTypes.STRING,
            defaultValue: 0,
        },
        feedback_notes: { //服务单状态审核描述
            allowNull: true,
            type: DataTypes.STRING
        },
        accountantEmployeeId: { //所属会计ID
            allowNull: true,
            type: DataTypes.INTEGER
        },
        accountantEmployeeName: { //所属会计姓名
            allowNull: true,
            type: DataTypes.INTEGER
        },
        accountantAgentAccountId: { //所属会计易代账ID
            allowNull: true,
            type: DataTypes.INTEGER
        }

        // companyInfo: { // 对象
        //     corpName // 公司名称
        //     taxpayerTypeEnum // 纳税性质 NORMAL_TAXPAYER 一般纳税人； SMALL_TAXPAYER 小规模纳税人
        //     acctgSystemId // 会计制度 10001=2013 小企业会计准 则；10002=2007 企业会计准 则；10003=民间非营利组织会 计制度； 10004=工会会计制度
        //     enterpriseFormEnum // 企业形式：CORPORATION 公司；PARTNERSHIP_OR_SOLE 合伙企业/个独/个体工商户；OTHERS 其他企业"
        //     taxIndustryId //所属行业
        //     taxNo // 税号
        //     taxiationArea // 公司区域
        //     serviceTypeEnum //"服务类型：枚举型，包括ACCOUTING-记账服务、INDUSTRY_COMMERCE-工商服务、BOTH-记账与工商服务"
        //     taxClaimMethodEnum //申报方式：TAX_DECLARATION-税款申报；ZERO_DECLARATION-零申报；
        // }

    }, {
        paranoid: false, //假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        tableName: 'service_bill',
        validate: {},
        indexes: []
    });
}