const vatClient = require("./vatClient")
const wangwenClient = require("./wangwenClient")
const pannongClient = require("./pannongClient")
const guangboClient = require("./guangboClient")
const gongshangClient = require("./gongshangClient")


const system = require("../../system");


/**
 * 根据产品类型选择不同的方法
 * @param {*} type 
 */
function getClientByType(type) {
    switch (type) {
        case system.SERVICECODE.ICP:
        case system.SERVICECODE.EDI:
            return vatClient.getInstance();
        case system.SERVICECODE.WANGWEN:
            return wangwenClient.getInstance();
        case system.SERVICECODE.PANNONG:
            return pannongClient.getInstance();
        case system.SERVICECODE.GUANGBO:
            return guangboClient.getInstance();
        case system.SERVICECODE.COMPANYCASE:
        case system.SERVICECODE.OPENBANKACCOUNTCASE:
        case system.SERVICECODE.TAXCASE:
        case system.SERVICECODE.REGADDRCASE1:
        case system.SERVICECODE.AGENTCASE1:
            return gongshangClient.getInstance();
        default:
            throw new Error("无此产品类型");
    }
}

module.exports = {
    getClientByType
}