<a name="menu" href="/doc">返回主目录</a>

1. [用户获取订单列表](#GetOrderList)
1. [用户获取资质订单列表](#GetQcOrderList)
1. [用户查看订单详情](#GetOrderDetail)
1. [用户获取业务主体信息列表](#GetApplyListByUserAndType)
1. [用户获取业务主体详情](#GetApplyAndSolutionInfo)
1. [商城询价接口](#GetPriceDetail)
1. [用户获取概览数据](#GetOverviewInfoByUser)
1. [立即购买](#SubmitGoodsInfo)
1. [需求提交](#SubmitNeed)
1. [需求列表](#GetNeedList)
1. [需求详情](#GetNeedDetail)
1. [根据交付状态获取订单列表](#GetOrderListByStatus)
1. [关闭需求](#RefuseSolution)
1. [我的资质证照列表](#GetQualificationCertificateListByUserAndType)
1. [我的资质证照详情](#GetQualificationCertificateDetail)

## **<a name="GetOrderList"> 用户获取订单列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeOrderList
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| ProductType  | 是 |  string   | 产品类型  |
| RegisteredType  | 否 |  string   | 注册类型，productType为 "/ic/cpreg/"时有效 |
| PageNumber  | 否 |  int   | 当前页，默认1,原CurrentPage  |
| PageSize  | 否 |  int   | 条数，默认10  |
| DeliveryStatus  | 否 |  int   | 订单交付状态 1: "已付款", 20: "已接单", 30: "已交付", 70: "收集材料中", 80: "递交材料中", 90: "工信部处理中", 100: "收集工商注册材料", 110: "上传注册材料", 120: "园区入驻审核", 130: "工商审核环节", 140: "刻章环节", 150: "证件邮寄环节", 160: "您已签收", 170: "已完成", 179: "即将到期", 180: "已到期", 190: "关闭交付", 200: "未申报", 210: "已申报", 310: "部分已退款", 320: "已退款", 330: "已作废" |
| CompanyProperties  | 否 |  string   | 公司性质，productType为 "/ic/gsreg/"时有效   |
| TaxpayerType  | 否 |  string   | 纳税人类型  |
| SortItem  | 否 |  string   | 排序项,不传默认按修改时间排序,payTime:购买时间，updatedAt:修改时间,endTime:到期时间  |
| SortType  | 否 |  string   | 排序方式，(asc、desc),不传默认倒序  |

#### 参数示例
``` javascript
{
        "PageNumber": 1,
        "PageSize": 2,
        "ProductType": "/ic/kzfw/",
        "Action": "DescribeOrderList"
}
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "OrderNum": "1593653938980",
                "RegionName": "温州",
                "RegionId": "330300",
                "TotalSum": 13800,
                "DeliveryStatus": 20,
                "PayTime": "2017-08-29T12:59:15.000Z",
                "EndTime": null,
                "TimeSpan": null,
                "TimeUnit": null,
                "UpdatedAt": "2020-07-02T01:40:43.000Z",
                "OrderSnapshot": "{\"userName\":\"婷亭婷\",\"serviceArea\":\"温州\",\"serviceCode\":\"330300\",\"contactsName\":\"\",\"contactsPhone\":\"19139640302\",\"verificationCode\":\"811637\"}"
            },
            {
                "OrderNum": "1593614192181",
                "RegionName": "上海园区",
                "RegionId": "310100",
                "TotalSum": 13800,
                "DeliveryStatus": 20,
                "PayTime": "2017-08-29T12:59:15.000Z",
                "EndTime": null,
                "TimeSpan": null,
                "TimeUnit": null,
                "UpdatedAt": "2020-07-01T14:36:33.000Z",
                "OrderSnapshot": "{\"userName\":\"婷亭婷\",\"serviceArea\":\"上海园区\",\"serviceCode\":\"310100\",\"contactsName\":\"test-20200701-2235\",\"contactsPhone\":\"18738988150\",\"verificationCode\":\"247172\"}"
            }
        ],
        "TotalCount": 23,
        "RequestId": "016c3270-c27d-11ea-a3ed-1527eeea4b9b"
    }
}

```
#### 参数修改
CurrentPage->PageNumber,
DataCount->TotalCount,


## **<a name="GetQcOrderList"> 用户获取资质订单列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeQualificationCertificateOrderList
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| PoductType  | 否 |  string   | 产品类型  |
| CompanyName  | 否 |  string   | 公司名称  |
| PageNumber  | 否 |  int   | 当前页，默认1  |
| PageSize  | 否 |  int   | 条数，默认10  |
| DeliveryStatus  | 否 |  int   | 订单交付状态 1: "已付款", 20: "已接单", 30: "已交付", 70: "收集材料中", 80: "递交材料中", 90: "工信部处理中", 100: "收集工商注册材料", 110: "上传注册材料", 120: "园区入驻审核", 130: "工商审核环节", 140: "刻章环节", 150: "证件邮寄环节", 160: "您已签收", 170: "已完成", 179: "即将到期", 180: "已到期", 190: "关闭交付", 200: "未申报", 210: "已申报", 310: "部分已退款", 320: "已退款", 330: "已作废" |
| SortItem  | 否 |  string   | 排序项,不传默认按修改时间排序,payTime:购买时间，updatedAt:修改时间,endTime:到期时间  |
| SortType  | 否 |  string   | 排序方式，(asc、desc),不传默认倒序  |

#### 参数示例
``` javascript
{
        "PageNumber": 1,
        "PageSize": 1,
        "Action": "DescribeQualificationCertificateOrderList"
}       
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "ProductType": "/qcfw/edi/",
                "OrderNum": "1593501648642",
                "DeliveryStatus": 70,
                "UpdatedAt": "2020-06-30T07:21:52.000Z",
                "OrderSnapshot": "{\"address\":\"辽宁省\",\"company\":\"来啊造作啊\",\"needNum\":\"N202006301415CL3nzW1\",\"addressCode\":\"210000\",\"serviceArea\":\"辽宁省\",\"serviceCode\":\"210000\",\"solutionNum\":\"NS_202006301449DbF4g\",\"contactsName\":\"\",\"annual_report\":true,\"contactsPhone\":\"13222222222\"}",
                "DeliverContent": "{\"clerkId\":15,\"regInfo\":{},\"skuCode\":\"sv_vat_shareholder_edidomestic4060\",\"baseInfo\":{\"clerkName\":\"j2\",\"isAdviser\":\"已分配\",\"payStatus\":\"待交付\",\"clerkPhone\":\"13381139520\",\"txOrderNum\":1593501648642,\"companyName\":\"来啊造作啊\",\"serviceName\":\"辽宁省\",\"annualReport\":true,\"contactsName\":\"\",\"contactsPhone\":\"13222222222\"},\"cacheInfo\":{\"cmpContactInfo\":{\"contactsPhone\":\"13222222222\"},\"cmpDeliverInfo\":{\"address\":\"辽宁省\",\"company\":\"来啊造作啊\",\"addressCode\":\"210000\",\"companyName\":\"来啊造作啊\",\"serviceArea\":\"210000\",\"annual_report\":true,\"serviceAreaName\":\"辽宁省\"}},\"clerkName\":\"j2\",\"costPrice\":0,\"clerkPhone\":\"13381139520\",\"txOrderNum\":1593501648642,\"clerkOpcode\":\"root/ic\",\"companyInfo\":{\"companyName\":\"来啊造作啊\"},\"serviceCode\":\"210000\",\"serviceName\":\"辽宁省\",\"businessMode\":\"N202006301415CL3nzW1\",\"businessName\":\"edi\",\"businessType\":\"EDI\",\"express_info\":{},\"positionInfo\":{},\"schemeNumber\":\"NS_202006301449DbF4g\",\"sellingPrice\":1000,\"servicerCode\":10,\"servicerName\":\"公司宝\",\"channelNumber\":\"1111111\",\"channelSource\":\"tencentCloud\",\"deliverNumber\":1593501648642,\"deliverStatus\":\"received\",\"registeredInfo\":{}}"
            }
        ],
        "TotalCount": 4,
        "RequestId": "6e12fc60-c27d-11ea-a3ed-1527eeea4b9b"
    }
}

```

## **<a name="GetOrderDetail"> 用户查看订单详情</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeOrderDetail
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| OrderNum  | 是 |  string   | 订单号  |

#### 参数示例
``` javascript
    {
        "Action": "DescribeOrderDetail",
        "OrderNum":"1111115"
    }       
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "OrderNum": "1111115",
            "MainOrdersNum": "1111115",
            "NeedNum": "202006100012",
            "UserName": "张三",
            "Quantity": 1,
            "TotalSum": 300,
            "DiscountAmount": 0,
            "PayTotalSum": 300,
            "RefundSum": 0,
            "PayTime": null,
            "OrderStatus": 1,
            "Notes": "第一单",
            "CreatedAt": "2020-06-03T10:17:28.000Z",
            "UpdatedAt": null,
            "OrderDeliveryInfo": "{\"deliver_content\":{\"agent\":\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) snap Chromium/83.0.4103.61 Chrome/83.0.4103.61 Safari/537.36\",\"userid\":\"13\",\"bizpath\":\"/deliverManage/cmpBizDeliverCase\",\"baseInfo\":{\"isVirtual\":\"否\",\"isWhether\":\"是\",\"payStatus\":\"已交付\",\"contactsName\":\"wangyongfei1122\",\"contactsPhone\":\"23456789\"},\"clientIp\":\"192.168.1.199\",\"username\":\"wangyongfei\",\"classname\":\"bizchance.deliverybillCtl\",\"company_id\":\"11\",\"companyInfo\":{\"spareName\":[\"兴业1\",\"兴业2\",\"兴业3\"],\"spareName1\":\"兴业1\",\"spareNames\":[{\"value\":\"兴业2\",\"status\":1},{\"value\":\"兴业3\",\"status\":1}],\"addressType\":\"practical\",\"companyName\":\"兴业有限公司\",\"fullAddress\":\"发发地方\",\"serviceArea\":\"shanghai\",\"taxpayerType\":\"generalTaxpayer\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示；舞台美术、工艺美术品、包装装璜设计、制作。\",\"registeredDate\":\"2020-06-16\",\"engagedIndustry\":\"culturalMedia\",\"operatingPeriod\":\"发到付\",\"companyProperties\":\"limitedLiabilityCompany\",\"registeredCapital\":80,\"reserveProportion\":79},\"deliverInfo\":{\"isVirtual\":\"否\",\"isWhether\":\"是\",\"payStatus\":\"已交付\",\"contactsName\":\"张三\",\"contactsPhone\":\"13800138000\"},\"contactsInfo\":{\"contactsName\":\"wangyongfei1122\",\"contactsPhone\":\"23456789\"},\"positionInfo\":{\"positionData\":[{\"fixedPhone\":\"2345678\",\"mailboxInfo\":\"2839273\",\"mobilePhone\":\"45678\",\"persionName\":\"附近的酸辣粉\",\"functionInfo\":\"发链接\",\"houseAddress\":\"的激发了肯德基\"}]},\"deliverNumber\":\"1111115\",\"registeredInfo\":{\"registeredDate\":\"2020-06-16\",\"registeredCapital\":80,\"reserveProportion\":79},\"contributionInfo\":{\"contributionData\":[{\"phoneNumber\":\"1234567\",\"contactAddress\":\"房间爱老师肯定放假啦\",\"hareholderName\":\"兴业\",\"contributionAmount\":\"80\",\"IdentificationNumber\":\"2345678\",\"contributionProportion\":\"10\"}]}},\"created_at\":\"2020-06-12T16:19:53.000Z\",\"updated_at\":\"2020-06-17T08:16:34.000Z\",\"delivery_status\":130,\"delivery_status_name\":\"工商审核环节\"}",
            "OrderProductInfo": "{\"time_span\":null,\"time_unit\":null,\"end_time\":null}"
        },
        "RequestId": "16c9d3d0-b43a-11ea-9bcc-11a1d3415630"
    }
}

```


## **<a name="GetApplyListByUserAndType"> 用户获取业务主体信息列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeApplyListByUserAndType
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| ApplyType  | 是 |  int   | 申请实体类型，1：企业 2：个体户  |
| PageNumber  | 否 |  int   | 当前页，默认1  |
| PageSize  | 否 |  int   | 条数，默认10  |
| ApplyName  | 否 |  string   | 公司/个体户名称  |
| Domicile  | 否 |  string   | 住所  |

#### 参数示例
``` javascript
   {
        "Action": "DescribeApplyListByUserAndType",
        "ApplyType":"1",
            "PageNumber":2,
            "PageSize":2,
            "ApplyName":"",
            "Domicile":""
    }           
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "ApplyName": "上海易销贸易有限公司",
                "CreditCode": "91310113MA1GKPDY1K",
                "ApplyType": 1,
                "Operator": "张惠国",
                "RegistCapital": "200.000万人民币",
                "BusinessTerm": "2016-07-19 至 2036-07-18",
                "EstablishTime": "2016-07-19",
                "Domicile": "上海市宝山区虎林路58号1幢611-10室"
            },
            {
                "ApplyName": "北京凝毅文化有限公司",
                "CreditCode": "91110105MA00AER958",
                "ApplyType": 1,
                "Operator": "",
                "RegistCapital": "0.000",
                "BusinessTerm": null,
                "EstablishTime": "2016-12-14",
                "Domicile": null
            }
        ],
        "TotalCount": 5,
        "RequestId": "e5294890-c27d-11ea-a3ed-1527eeea4b9b"
    }
}

```

## **<a name="GetApplyAndSolutionInfo"> 用户获取业务主体详情</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeApplyAndSolutionInfo
#### 参数说明

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| CreditCode  | 是 |  string   | 社会统一信用代码  |


#### 参数示例
``` javascript
   {
        "Action": "DescribeApplyAndSolutionInfo",
        "CreditCode":"1234349555556"
    }           
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "ApplyInfo": "{\"user_id\":\"1\",\"apply_name\":\"公司名詞\",\"credit_code\":\"1234349555556\",\"apply_type\":1,\"operator\":\"\",\"regist_capital\":\"100萬\",\"business_term\":\"200\",\"establish_time\":\"2009年\",\"domicile\":\"北京市\",\"ent_type\":\"有限責任公司\",\"business_scope\":\"歲的哥哥和繪畫\"}",
            "ProductList": "[{\"order_num\":\"1111113\",\"product_type_name\":\"/工商服务/代理记账/\",\"product_type\":\"/ic/dljz/\",\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":\"2020-06-19T08:07:18.000Z\",\"order_snapshot\":{\"contactsName\":\"123\"}},{\"order_num\":\"1111114\",\"product_type_name\":\"/工商服务/注册地址/\",\"product_type\":\"/ic/regaddr/\",\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":{\"memoInfo\":\"11111111111111111111\",\"isWhether\":true,\"addressType\":true,\"companyName\":\"breijinhg\",\"fullAddress\":\"\",\"serviceArea\":\"北京\",\"serviceCode\":\"110100\",\"businessType\":\"公司注册\",\"contactsName\":\"111111\",\"taxpayerType\":\"小规模纳税人\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"contactsPhone\":\"18738988150\",\"engagedIndustry\":\"文化传媒类\",\"companyProperties\":\"有限责任公司\"}},{\"order_num\":\"1111117\",\"product_type_name\":\"/工商服务/工商年报/\",\"product_type\":\"/ic/gsnb/\",\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":{\"memoInfo\":\"11111111111111111111\",\"isWhether\":true,\"addressType\":true,\"companyName\":\"breijinhg\",\"fullAddress\":\"\",\"serviceArea\":\"北京\",\"serviceCode\":\"110100\",\"businessType\":\"公司注册\",\"contactsName\":\"111111\",\"taxpayerType\":\"小规模纳税人\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"contactsPhone\":\"18738988150\",\"engagedIndustry\":\"文化传媒类\",\"companyProperties\":\"有限责任公司\"}},{\"order_num\":\"1111118\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111119\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111120\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111121\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111122\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111123\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null}]"
        },
        "RequestId": "f437a070-b29c-11ea-97f7-efd638e57201"
    }
}

```

## **<a name="GetOverviewInfoByUser"> 用户获取概览数据</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeOverviewInfoByUser
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| ProductTypeOne  | 是 |  string   | 产品大类编码 ic:工商服务 qcfw:资质证照  |


#### 参数示例
``` javascript
   {
        "Action": "DescribeOverviewInfoByUser",
        "ProductTypeOne":"qcfw"
    }              
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "InternetContentProviderCount": 1,
            "WaitConfirmCount": 0,
            "ElectronicDataInterchangeCount": 1,
            "WaitReceiveFileOrderCount": 0
        },
        "RequestId": "12bbd250-b29d-11ea-97f7-efd638e57201"
    }
}
```

## **<a name="GetPriceDetail"> 商城询价接口</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribePriceDetail
#### 参数说明
1、公司注册： /ic/gsreg/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| CompanyProperties  | 是 |  string   | 公司类型  |

2.云上公司注册  /ic/cpreg/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| RegisteredType  | 是 |  string   | 注册类型  |

3.刻章服务  /ic/kzfw/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| WhetherType  | 是 |  string   | 刻章类型  |

<!-- 4.银行开户  /ic/bankopen/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| userId  | 是 |  string   | 用户id  |
| regionId  | 是 |  string   | 地区代码  |
| regionName  | 是 |  string   | 地区拼音  |
| pathCode  | 是 |  string   | 产品类型  | -->

4.工商变更  /ic/gschangs/

  税控申请  /ic/sksq/

  社保开户   /ic/sbopen/

  银行开户   /ic/bankopen/

  税控申请   /ic/sksq/ 

  税务报道   /ic/swbd/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |


6.icp  /qcfw/icp/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| Period  | 是 |  string   | 办理周期  |

7.edi  /qcfw/edi/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| Period  | 是 |  string   | 办理周期  |

8.icp年报  /qcfw/icpannals/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |

9.edi年报  /qcfw/ediannals/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |

10.刻章服务  /ic/dljz/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| RegisteredType  | 是 |  string   | 公司类型  |




#### 参数示例
``` javascript
   {
        "Action": "DescribePriceDetail",
        "RegionId":"1",
        "PathCode":"/ic/gsreg/",
        "WhetherType":"公司章",
        "RegionName":"shanghai"
        
    }         
```

#### 返回结果
```javascript
    {
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "TotalCost": 58000,
            "RealTotalCost": 37700,
            "Product": "{\"productIcon\":null,\"productType\":\"/ic/kzfw/\",\"productTypeName\":\"/工商服务/刻章服务/\",\"servicerCode\":null,\"servicerName\":null}",
            "ProductSnapshot": "{\"timeSpan\":\"1\",\"timeUnit\":\"p\",\"pid\":\"1003952\",\"productCode\":\"p_business_registration\",\"goodsSubType\":\"sp_business_registration_chapter\",\"subProductCode\":\"sp_business_registration_chapter\",\"qifuzidingyi\":\"shanghai\",\"sv_business_registration_type_fivechapter\":\"1\"}"
        },
        "RequestId": "c994bb40-b2d4-11ea-b81b-89b08281dc19"
    }
}
```

## **<a name="SubmitGoodsInfo"> 立即购买</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：SubmitGoodsInfo
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| VerificationCode  | 否 |  string   | 验证码  |
| Info  | 是 |  string   | 产品信息  支持多个产品提交 数组格式 |
| Info[0].productSnapshot  | 是 |  string   | tx产品快照 |
| Info[0].product  | 是 |  string   | 产品快照 |
| Info[0].showInfo  | 是 |  string   | 核对页展示信息 |
| Info[0].formInfo  | 是 |  string   | 表单信息 |
| Info[0].formInfo.Email  | 否 |  string   | 邮箱  |
| Info[0].formInfo.WechatNo  | 否 |  string   | 微信号  |



#### 参数示例
``` javascript
   {
	"Action": "SubmitGoodsInfo",
    "VerificationCode": "564264",
    "Info":"[{\"product\":{\"productIcon\":null,\"productType\":\"/ic/kzfw/\",\"productTypeName\":\"/工商服务/刻章服务/\",\"servicerCode\":\"测试服务商\"},\"productSnapshot\":{\"timeSpan\":\"1\",\"timeUnit\":\"p\",\"pid\":1003952,\"productCode\":\"p_business_registration\",\"goodsSubType\":\"sp_business_registration_chapter\",\"subProductCode\":\"sp_business_registration_chapter\",\"qifuzidingyi\":\"beijing\",\"sv_business_registration_type_fivechapter\":\"1\"},\"showInfo\":[{\"name\":\"公司名称\",\"value\":\"公司宝\"},{\"name\":\"公司名称\",\"value\":\"公司宝\"}],\"formInfo\":{}}]"
	
}
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "Url": "https://buy.cloud.tencent.com/order/check",
            "Param": "{\"itemDetails\":{\"raw_goodsData\":[{\"goodsCategoryId\":100114,\"regionId\":1,\"projectId\":0,\"zoneId\":100001,\"goodsNum\":1,\"payMode\":1,\"goodsDetail\":{\"timeSpan\":\"1\",\"timeUnit\":\"p\",\"pid\":1003952,\"productCode\":\"p_business_registration\",\"goodsSubType\":\"sp_business_registration_chapter\",\"subProductCode\":\"sp_business_registration_chapter\",\"qifuzidingyi\":\"beijing\",\"sv_business_registration_type_fivechapter\":\"1\",\"product\":{\"productIcon\":null,\"productType\":\"/ic/kzfw/\",\"productTypeName\":\"/工商服务/刻章服务/\",\"servicerCode\":\"测试服务商\"},\"productInfo\":[{\"name\":\"公司名称\",\"value\":\"公司宝\"},{\"name\":\"公司名称\",\"value\":\"公司宝\"}],\"formInfo\":{}}}]}}"
        },
        "RequestId": "a4f61720-b2d9-11ea-bcc3-65805920fb58"
    }
}
```

## **<a name="SubmitNeed"> 创建需求</a>**
[返回到目录](#menu)
##### URL
[/api/action/need/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：CreateNeed
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserName  | 是 |  string   | 用户名称  |
| ContactsMobile  | 是 |  string   | 联系人电话  |
| ContactsName  | 否 |  string   | 联系人名称  |
| RegionId  | 是 |  string   | 地区id  |
| RegionName  | 是 |  string   | 地区名称  |
| VerificationCode  | 是 |  string   | 验证码  |
| Notes  | 否 |  string   | 备注  |
| ConsultType  | 是 |  string   | 产品类型  |
| ConsultTypeName  | 是 |  string   | 产品类型名称  |
| CompanyName  | 否 |  string   | 公司名称  |
| CompanyName  | 否 |  string   | 公司名称  |
| Email  | 否 |  string   | 邮箱  |
| WechatNo  | 否 |  string   | 微信号  |



#### 参数示例
``` javascript
   {
        "Action": "CreateNeed",
        "UserName": "011",
        "ContactsMobile":"17610163852",
        "ContactsName":"wdy",
        "RegionId":"110100",
        "RegionName":"北京",
        "ConsultType":"/ic/gsreg/",
        "ConsultTypeName":"/工商服务/公司注册/",
    }           
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": "",
        "RequestId": "ee2b7450-b2c8-11ea-8e5e-ed12303f5d17"
    }
}
```

## **<a name="GetNeedList"> 需求列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/need/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeNeedList
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| PageNumber  | 否 |  string   | 页码  |
| PageSize  | 否 |  string   | 页面大小  |
| Status  | 否 |  string   | 状态  |
| ConsultType  | 是 |  string   | 需求类型  |
| Sort  | 否 |  string   | 排序  |
| Sort.key  | 是 |  string   | 字段名称  |
| Sort.value  | 是 |  string   | 排序方式  desc  asc  |


#### 参数示例
``` javascript
   {
        "Action": "DescribeNeedList",
        "UserId": "011",
        "PageNumber":"1",
        "PageSize":"10",
        "Status":"1",
        "RegionName":"北京",
        "ConsultType":"/ic/",
        "Sort":"{\"key\":\"created_at\",\"value\":\"desc\"}"
        
    }            
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "TotalCount": 8,
            "DataSet": "[{\"id\":103,\"need_num\":\"N202006201537aL6MrDE\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"wdy\",\"contacts_mobile\":\"17610163852\",\"region_id\":\"320100\",\"region_name\":\"南京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"svlhusghsjhvseiluhuvuivfhi\",\"need_info\":null,\"servicer_code\":\"GSB\",\"servicer_name\":null,\"created_at\":\"2020-06-20T07:37:44.000Z\",\"updated_at\":\"2020-06-20T07:37:44.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":102,\"need_num\":\"N202006201142FJdqXPC\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"wdy\",\"contacts_mobile\":\"17610163852\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"svlhusghsjhvseiluhuvuivfhi\",\"need_info\":null,\"servicer_code\":\"S_202006201007FI8tuF\",\"servicer_name\":\"网易云\",\"created_at\":\"2020-06-20T03:42:37.000Z\",\"updated_at\":\"2020-06-20T03:42:37.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":100,\"need_num\":\"N202006201129Qba19e2\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"wdy\",\"contacts_mobile\":\"17610163852\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"svlhusghsjhvseiluhuvuivfhi\",\"need_info\":null,\"servicer_code\":\"S_202006201007FI8tuF\",\"servicer_name\":\"网易云\",\"created_at\":\"2020-06-20T03:29:33.000Z\",\"updated_at\":\"2020-06-20T03:29:33.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":67,\"need_num\":\"N202006161642ODMRsRW\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"\",\"contacts_mobile\":\"18735397229\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":null,\"created_at\":\"2020-06-16T08:42:14.000Z\",\"updated_at\":\"2020-06-16T08:42:14.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":68,\"need_num\":\"N202006161642nBRBToJ\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"\",\"contacts_mobile\":\"18735397229\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":null,\"created_at\":\"2020-06-16T08:42:14.000Z\",\"updated_at\":\"2020-06-16T08:42:14.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":69,\"need_num\":\"N202006161642dtAo81x\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"\",\"contacts_mobile\":\"18735397229\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":null,\"created_at\":\"2020-06-16T08:42:14.000Z\",\"updated_at\":\"2020-06-16T08:42:14.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":70,\"need_num\":\"N202006161642AjjLIsr\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"\",\"contacts_mobile\":\"18735397229\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":null,\"created_at\":\"2020-06-16T08:42:14.000Z\",\"updated_at\":\"2020-06-16T08:42:14.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":61,\"need_num\":\"N202006141134GQ7HV3a\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"北京\",\"contacts_mobile\":\"18262855372\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"00000000000000000\",\"need_info\":null,\"servicer_code\":\"S_202006051002UE4Lse\",\"servicer_name\":\"测试服务商\",\"created_at\":\"2020-06-14T03:34:50.000Z\",\"updated_at\":\"2020-06-14T03:34:50.000Z\",\"deleted_at\":null,\"version\":0}]"
        },
        "RequestId": "af0cf310-b2ce-11ea-9dd5-03e6b499c7e6"
    }
}
```

## **<a name="GetNeedDetail"> 需求详情</a>**
[返回到目录](#menu)
##### URL
[/api/action/need/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeNeedDetail
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| NeedNum  | 是 |  string   | 需求号  |


#### 参数示例
``` javascript
   {
        "Action": "DescribeNeedDetail",
        "NeedNum": "202006100003"
    }           
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "NeedInfo": "{\"id\":20,\"need_num\":\"N202006130012\",\"user_id\":\"1\",\"user_name\":\"张三\",\"contacts_name\":\"张三\",\"contacts_mobile\":\"13075556693\",\"region_id\":\"1\",\"region_name\":\"北京\",\"consult_type\":\"/qcfw/icp/\",\"consult_type_name\":\"/资质证照/icp/\",\"status\":2,\"status_name\":\"待用户确认\",\"notes\":\"测试数据勿删\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":\"公司宝\",\"created_at\":\"2020-06-03T16:04:45.000Z\",\"updated_at\":\"2020-06-20T08:58:06.000Z\",\"deleted_at\":null,\"version\":null}",
            "SolutionInfo": "{\"id\":17,\"need_num\":\"N202006130012\",\"solution_num\":\"NS_202006130920sregN\",\"user_id\":\"1\",\"user_name\":\"张三\",\"solution_content\":{\"id\":26,\"bizopt_id\":32,\"clerkName\":\"小三\",\"clerkPhone\":\"4567800\",\"updated_at\":\"2020-06-02 20:32:14\",\"remark_info\":\"77777777777777777777777\",\"scheme_info\":{\"address\":\"hangzhou\",\"company\":\"77777777777777\",\"annual_report\":true},\"businessType\":\"/qcfw/icp/\",\"servicerCode\":\"1\",\"servicerName\":\"公司宝\",\"salesman_name\":\"小三\",\"facilitator_id\":\"test\",\"salesman_phone\":\"199299949424\",\"refusal_content\":\"\",\"facilitator_name\":\"测试服务商\"},\"is_refusal\":1,\"refusal_notes\":\"测试修改方案\",\"created_at\":\"2020-06-13T01:20:30.000Z\",\"deleted_at\":null,\"version\":0}"
        },
        "RequestId": "626a5c90-b2d4-11ea-b81b-89b08281dc19"
    }
}
```

## **<a name="GetOrderListByStatus"> 根据交付状态获取订单列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeOrderListByStatus
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| Status  | 是 |  string   | 状态码，"150":"证件邮寄环节"  |


#### 参数示例
``` javascript
  {
        "Action": "DescribeOrderListByStatus",
         "Status":130
    }             
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "OrderNum": "1593614115278",
                "MainOrdersNum": "1593614115278",
                "NeedNum": "",
                "UserName": "婷亭婷",
                "UserId": "100000013569",
                "UpdatedAt": "2020-07-04T15:01:37.000Z",
                "TotalSum": 13800,
                "RefundSum": null,
                "PayTime": "2017-08-29T12:59:15.000Z",
                "OrderStatus": 1,
                "OrderStatusName": "已付款",
                "ServicerCode": "S_202006201810vrHKgE",
                "ServicerName": "公司宝",
                "ProductType": "/ic/gsreg/",
                "ProductTypeName": "/工商服务/公司注册/",
                "OrderSnapshot": "{\"memoInfo\":\"test-20200701-2233\",\"userName\":\"婷亭婷\",\"isWhether\":true,\"addressType\":true,\"companyName\":\"test-20200701-2232\",\"fullAddress\":\"have nothing\",\"serviceArea\":\"北京\",\"serviceCode\":\"110100\",\"businessType\":\"公司注册\",\"contactsName\":\"test-20200701-2233\",\"taxpayerType\":\"小规模纳税人\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"contactsPhone\":\"19139640302\",\"engagedIndustry\":\"文化传媒类\",\"verificationCode\":\"128216\",\"companyProperties\":\"有限责任公司\"}",
                "EndTime": null,
                "TimeSpan": null,
                "TimeUnit": null,
                "RegionId": "110100",
                "RegionName": "北京",
                "DeliveryStatus": 130,
                "DeliveryStatusName": "工商审核环节",
                "DeliverContent": "{\"clerkId\":15,\"regInfo\":{\"uploadList\":[{\"name\":\"1.jpg\",\"title\":\"产权证\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/a9576a50-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"1909275708.jpg\",\"title\":\"法人股东证件\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/ab5906b0-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"2118268909.jpg\",\"title\":\"执行董事证件\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/ad17a6a0-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"stefanie.jpg\",\"title\":\"经理证件\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/b132ad20-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"stefanie.jpg\",\"title\":\"监事证件\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/b61fd0b0-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"stefanie.jpg\",\"title\":\"购票人\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/b8b7e0b0-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"stefanie.jpg\",\"title\":\"办税人\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/bd370030-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"1909275708.jpg\",\"title\":\"财务负责人\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/bf517bc0-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"2118268909.jpg\",\"title\":\"秘书联系人\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/c16e4140-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"1.jpg\",\"title\":\"社保缴费经办人证件\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/c414d030-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"stefanie.jpg\",\"title\":\"公积金缴费经办人\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/c6a936b0-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"stefanie.jpg\",\"title\":\"自然人股东证件\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/cb3faec0-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"1.jpg\",\"title\":\"自然人股东证件1\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/ce5441c0-bc2d-11ea-b064-972948a03328.jpg\"},{\"name\":\"stefanie.jpg\",\"title\":\"自然人股东证件2\",\"viewUrl\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/d1a25b50-bc2d-11ea-b064-972948a03328.jpg\"}]},\"skuCode\":\"sv_business_registration_category_limited1\",\"baseInfo\":{\"memoInfo\":\"test-20200701-2233\",\"clerkName\":\"j2\",\"isAdviser\":\"已分配\",\"isWhether\":\"yes\",\"payStatus\":\"已交付\",\"clerkPhone\":\"13381139520\",\"txOrderNum\":1593614115278,\"addressType\":\"practical\",\"companyName\":\"test-20200701-2232\",\"companyType\":\"limitedLiabilityCompany\",\"serviceName\":\"北京\",\"annualReport\":false,\"contactsName\":\"test-20200701-2233\",\"officialSeal\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/3f1daf60-be07-11ea-8964-e389a8086788.jpg\",\"taxpayerName\":\"小规模纳税人\",\"taxpayerType\":\"smallScaleTaxpayer\",\"contactsPhone\":\"13800138000\",\"businessLicense\":\"http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/42488980-be07-11ea-8964-e389a8086788.jpg\",\"companyProperties\":\"limitedLiabilityCompany\"},\"cacheInfo\":{\"cmpContactInfo\":{\"contactsName\":\"test-20200701-2233\",\"contactsPhone\":\"19139640302\"},\"cmpDeliverInfo\":{\"memoInfo\":\"test-20200701-2233\",\"isWhether\":\"yes\",\"addressType\":\"practical\",\"companyName\":\"test-20200701-2232\",\"fullAddress\":\"have nothing\",\"serviceArea\":\"110100\",\"taxpayerName\":\"小规模纳税人\",\"taxpayerType\":\"smallScaleTaxpayer\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"engagedIndName\":\"文化传媒类\",\"engagedIndustry\":\"culturalMedia\",\"serviceAreaName\":\"北京\",\"residenceAddress\":\"have nothing\",\"companyProperties\":\"limitedLiabilityCompany\"}},\"clerkName\":\"j2\",\"costPrice\":0,\"clerkPhone\":\"13381139520\",\"txOrderNum\":1593614115278,\"clerkOpcode\":\"root/ic/j2\",\"companyInfo\":{\"spareName\":[\"张建铜1\",\"张建铜2\",\"张建铜3\"],\"spareName1\":\"张建铜1\",\"spareNames\":[{\"value\":\"张建铜2\",\"status\":1},{\"value\":\"张建铜3\",\"status\":1}],\"addressType\":\"practical\",\"companyName\":\"test-20200701-2232\",\"fullAddress\":\"have nothing\",\"serviceArea\":\"110100\",\"taxpayerType\":\"smallScaleTaxpayer\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"registeredDate\":\"2020-07-02\",\"engagedIndustry\":\"culturalMedia\",\"operatingPeriod\":\"50年\",\"companyProperties\":\"limitedLiabilityCompany\",\"registeredCapital\":50,\"reserveProportion\":12},\"serviceCode\":\"110100\",\"serviceName\":\"北京\",\"businessName\":\"公司注册\",\"businessType\":\"companyCase\",\"contactsInfo\":{\"contactsName\":\"test-20200701-2233\",\"contactsPhone\":\"13800138000\"},\"express_info\":{},\"positionInfo\":{\"positionData\":[{\"fixedPhone\":\"01023456789\",\"mailboxInfo\":\"1@1.com\",\"mobilePhone\":\"13800138000\",\"persionName\":\"张三\",\"functionInfo\":\"董事长\",\"houseAddress\":\"北京市海淀区\"},{\"fixedPhone\":\"01023456789\",\"mailboxInfo\":\"1@1.com\",\"mobilePhone\":\"13800138000\",\"persionName\":\"张三\",\"functionInfo\":\"总经理\",\"houseAddress\":\"北京市海淀区\"}]},\"schemeNumber\":\"\",\"sellingPrice\":1000,\"servicerCode\":10,\"servicerName\":\"公司宝\",\"channelNumber\":\"1111111\",\"channelSource\":\"tencentCloud\",\"deliverNumber\":\"1593614115278\",\"deliverStatus\":\"received\",\"registeredInfo\":{\"registeredDate\":\"2020-07-02\",\"registeredCapital\":50,\"reserveProportion\":12},\"contributionInfo\":{\"contributionData\":[{\"phoneNumber\":\"13800138000\",\"contactAddress\":\"北京市海淀区\",\"hareholderName\":\"张三\",\"contributionAmount\":\"25\",\"IdentificationNumber\":\"412702198506273455\",\"contributionProportion\":\"50\"},{\"phoneNumber\":\"13800138000\",\"contactAddress\":\"北京市海淀区\",\"hareholderName\":\"张二\",\"contributionAmount\":\"25\",\"IdentificationNumber\":\"412702198506273455\",\"contributionProportion\":\"50\"}]}}"
            }
        ],
        "RequestId": "2fe1b390-c27e-11ea-a3ed-1527eeea4b9b"
    }
}

```

## **<a name="RefuseSolution"> 关闭需求推送到服务商</a>**
[返回到目录](#menu)
##### URL
[/api/receive/needApi/springBoard]
 
#### 参数格式  `JSON`人
#### HTTP请求方式 `POST`
#### 渠道执行的类型 Action：ModifySolution

参数名 |  必须 | 字段类型 | 长度限制 | 说明
-|-|-|-|-
NeedNum | Y | string | 100 | 需求号
SolutionNum | Y | string | 100 | 方案号
RefusalContent | Y | string | 100 | 备注信息

#### 参数示例
``` javascript
{
    "Action": "ModifySolution",
    "NeedNum":"",
    "SolutionNum":"",
    "RefusalContent":""  //描述
} 

```
#### 返回结果
```javascript

{"Response":{"Status":1,"InstanceSet":"","RequestId":"27f65f50-b2d4-11ea-b81b-89b08281dc19"}}

```

## **<a name="GetQualificationCertificateListByUserAndType"> 我的资质证照列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeQualificationCertificateListByUserAndType
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| PageNumber  | 否 |  string   | 页码 默认1 |
| PageSize  | 否 |  string   | 页面大小 默认10 |
| LicenseType  | 是 |  int   | 资质类型 1：icp  2:edi  |
| CompanyName  | 否 |  string   | 公司名称  |
| SortType  | 否 |  string   | 按截止时间排序方式,asc:正序 desc:倒序  |


#### 参数示例
``` javascript
    {
        "Action": "DescribeQualificationCertificateListByUserAndType",
        "PageSize":2,
        "PageNumber":1,
        "LicenseType":2
    }  

```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "UserId": "100000013569",
                "UserName": "婷亭婷",
                "ServicerCode": "S_202006201810vrHKgE",
                "ServicerName": "公司宝",
                "CertificateNo": "28999229JDJD",
                "CompanyName": "大连欣龙腾商贸有限公司",
                "BusinessCoverage": "啥都干",
                "IssueDate": "2020-06-01T00:00:00.000Z",
                "ExpirationDate": "2020-06-30T00:00:00.000Z",
                "BusinessType": "都能办",
                "ServiceItem": "啥都干",
                "CertificateFile": "http://test-1258715722.cos.ap-beijing.myqcloud.com/materials/zc_18351593165593323202026175953323.jpeg",
                "LicenseType": 2,
                "LicenseTypeName": "EDI资质"
            }
        ],
        "TotalCount": 1,
        "RequestId": "0bf5ba70-c27f-11ea-a3ed-1527eeea4b9b"
    }
}

```

## **<a name="GetQualificationCertificateDetail"> 我的资质证照详情</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：DescribeQualificationCertificateDetail
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| CertificateNo  | 是 |  string   | 证照编号 |


#### 参数示例
``` javascript
    {
        "Action": "DescribeQualificationCertificateDetail",
        "CertificateNo":"d"
    }         

```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "QualificationCertificate": "{\"user_id\":\"1\",\"certificate_no\":\"d\",\"company_name\":null,\"business_coverage\":\"d\",\"issue_date\":\"2020-06-09T00:00:00.000Z\",\"expiration_date\":\"2020-06-23T00:00:00.000Z\",\"business_type\":\"d\",\"service_item\":\"d\",\"certificate_file\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_422515919726637762020122237437769592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\",\"license_type\":2,\"license_type_name\":\"EDI资质\"}",
            "BusinessLicenseInfo": "{\"tx_orders_num\":\"O202006130014\",\"businessLicense\":{\"name\":\"公司宝\",\"type\":\"有限责任公司(法人独资)\",\"address\":\"北京市海淀区北清路164号17-27号院813号\",\"createdAt\":\"2014-02-25\",\"businessTerm\":\"2014-08-07 至 2034-08-06\",\"scopeBusiness\":\"技术开发、技术推广、技术转让、技术咨询、技术服务；计算机系统服务；数据处理(数据处理中的银行卡中心、PUE值在1.5以上的云计算数据中心除外)；基础软件服务；应用软件服务；软件开发；软件咨询；产品设计；模型设计；包装装潢设计；教育咨询；经济贸易咨询；文化咨询；体育咨询；公共关系服务；会议服务；工艺美术设计；电脑动画设计；企业策划；设计、制作、代理、发布广告；市场调查；企业管理咨询；组织文化艺术交流活动(不含营业性演出)；文艺创作；承办展览展示活动；影视策划；翻译服务；商标转让；商标代理；版权转让、版权代理；财务咨询(不得开展审计、验资、查帐、评估、会计咨询、代理记账等需经专项审批的业务,不得出具相应的审计报告、验资报告、查帐报告、评估报告等文字材料)；销售自行开发后的产品、机械设备、计算机、软件及辅助设备、通讯设备、电子产品、日用品、文化用品、工艺品；出租办公用房；机动车公共停车场服务；物业管理；健康咨询（须经审批的诊疗活动除外）；代理记账；人力资源服务。（企业依法自主选择经营项目，开展经营活动；代理记账、人力资源服务以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。）\",\"enterpriseCode\":\"911101083066224948\",\"registeredCapital\":1000000,\"legalRepresentative\":\"李丽\"}}",
            "AnnualReportList": "[{\"annualReportList\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_13151591685846571202091457265719592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\",\"name\":\"jjjjjddd\"},\"year\":2020,\"status\":\"declaresuccess\",\"updated_at\":\"2020-09-01\"},{\"file\":null,\"year\":2021,\"status\":\"waitdeclare\",\"updated_at\":\"2020-09-01\"},{\"file\":null,\"year\":2022,\"status\":\"waitdeclare\",\"updated_at\":\"2020-09-01\"},{\"file\":null,\"year\":2023,\"status\":\"waitdeclare\",\"updated_at\":\"2020-09-01\"}]}]"
        },
        "RequestId": "d609e110-b29e-11ea-a776-bf0f0e09cf0b"
    }
}

```