var APIBase = require("../../api.base");
var system = require("../../../system");
const os = require("os")
class ProductAPI extends APIBase {
  constructor() {
    super();
    this.productSve = system.getObject("service.product.productSve")
  }

  async etag (pobj, qobj, req) {
    if (!pobj.action_type) {
      return system.getResult(null, "action_type参数不能为空")
    }
    let result
    switch (pobj.action_type) {
      case 'getPage':
        result = await this.productSve.getPage(pobj.action_body.page, pobj.action_body.limit, 
          pobj.action_body.types, pobj.action_body.keywords)
        return system.getResultSuccess(result)
      case 'createOrUpdate':
        if (pobj.action_body.product_type == 1 && pobj.action_body.items) {
          return system.getResult(null, '单产品不能有子产品')
        }
        if (pobj.action_body.product_type == 2 && (!pobj.action_body.items || pobj.action_body.items.length == 0)) {
          return system.getResult(null, '未选择子产品')
        }
        if (pobj.action_body.product_type == 2) {
          let checkRes = await this.productSve.checkSitem(pobj.action_body.items)
          if (!checkRes) {
            return system.getResult(null, '不能选择组合产品为子产品')
          }
        }
        result = await this.productSve.createOrUpdate(pobj.action_body)
        return system.getResultSuccess(result)
      case 'getAllDic':
        result = await this.productSve.getAllDic(pobj.action_body.types)
        return system.getResultSuccess(result)
      case 'getByIds':
        result = await this.productSve.getByIds(pobj.action_body.ids)
        return system.getResultSuccess(result)
      case 'getItems':
        result = await this.productSve.getItems(pobj.action_body.id)
        return system.getResultSuccess(result)
      default:
        break
    }
  }

  exam () {
    return `<pre><pre/>`;
  }
  classDesc () {
    return {
      groupName: "product",
      groupDesc: "产品引擎",
      name: "ProductApi",
      desc: "产品相关接口",
      exam: "",
    };
  }
  methodDescs () {
    return [
      {
        methodDesc: `<pre><pre/>`,
        methodName: "product",
        paramdescs: [
          {
            paramDesc: "请求的行为，传递如：sjb",
            paramName: "action_process",
            paramType: "string",
            defaultValue: null,
          },
          {
            paramDesc: "业务操作类型，详情见方法中的描述",
            paramName: "action_type",
            paramType: "string",
            defaultValue: null,
          },
          {
            paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
            paramName: "action_body",
            paramType: "json",
            defaultValue: null,
          }
        ],
        rtnTypeDesc: `<pre><pre/>`,
        rtnType: `<pre><pre/>`
      }
    ];
  }
}
module.exports = ProductAPI;