const Dao = require("../../dao.base");
class productItemDao extends Dao {
  constructor() {
    super(Dao.getModelName(productItemDao));
  }

  async getAll (params) {
    return await this.model.findAll(params)
  }

  async getById (id) {
    return await this.model.findOne(id)
  }

  async deleteById (id) {
    return await this.model.destroy({
      where: {
        id: id
      }
    })
  }

  async deleteByParentId (id) {
    return await this.model.destroy({
      where: {
        parent_id: id
      }
    })
  }

  async createMany (params) {
    return await this.model.bulkCreate(params)
  }

  async delete (params) {
    return await this.model.destroy({ where: params })
  }
}
module.exports = productItemDao;