module.exports = (db, DataTypes) => {
  return db.define("product", {
    source_id: DataTypes.BIGINT, // 产品来源 id
    product_name: DataTypes.STRING, // 产品名称 50字
    product_type: DataTypes.TINYINT, // 产品类型 1: 单产品, 2: 组合产品
    product_desc: DataTypes.STRING, // 产品描述
    price: DataTypes.BIGINT, // 价格
    cost: DataTypes.BIGINT, // 成本
  }, {
    paranoid: true,
    underscored: true,
    timestamps: true,
    tableName: 'e_product',
    version: true,
    freezeTableName: true
  }
  )
}