const system = require("../system");
const settings = require("../../config/settings");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
class APIBase {
    constructor() {
        this.logCtl = system.getObject("web.common.oplogCtl");
        this.oplogSve = system.getObject("service.common.oplogSve");
        this.opCacheUtilsSve = system.getObject("service.common.opCacheUtilsSve");
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    /**
     * 验证签名
     * @param {*} params 要验证的参数 
     * @param {*} app_key 应用的校验key
     */
    async verifySign(params, app_key) {
        if (!params) {
            return system.getResult(null, "请求参数为空");
        }
        if (!params.sign) {
            return system.getResult(null, "请求参数sign为空");
        }
        if (!params.timestamp) {
            return system.getResult(null, "请求参数timestamp为空");
        }
        var signArr = [];
        var keys = Object.keys(params).sort();
        if (keys.length == 0) {
            return system.getResult(null, "请求参数信息为空");
        }
        for (let k = 0; k < keys.length; k++) {
            const tKey = keys[k];
            if (tKey != "sign" && params[tKey]) {
                signArr.push(tKey + "=" + params[tKey]);
            }
        }
        if (signArr.length == 0) {
            return system.getResult(null, "请求参数组装签名参数信息为空");
        }
        var resultSignStr = signArr.join("&") + "&key=" + app_key;
        var resultTmpSign = md5(resultSignStr).toUpperCase();
        if (params.sign != resultTmpSign) {
            return system.getResult(null, "签名验证失败");
        }
        return system.getResultSuccess();
    }
    /**
 * 白名单验证
 * @param {*} gname 组名
 * @param {*} methodname 方法名
 */
    async isCheckWhiteList(gname, methodname) {
        var fullname = gname + "." + methodname;
        var lst = [
            "test.test",
            "auth.getToken"
        ];
        var x = lst.indexOf(fullname);
        return x >= 0;
    }
    async checkAcck(gname, methodname, pobj, query, req) {
        var uAppInfo = null;
        var selfAppInfo = null;
        var ispass = await this.isCheckWhiteList(gname, methodname);
        if (ispass) {
            return system.getResultSuccess();
        }//在白名单里面
        var token = req.headers["token"];
        if (!token) {
            return system.getResult(null, "token不能为空");
        }
        uAppInfo = await this.opCacheUtilsSve.getPlatformAppItem(token);
        if (!uAppInfo || (uAppInfo.status && uAppInfo.status != 0)) {
            return uAppInfo;
        }
        var selfAppInfo = await this.opCacheUtilsSve.getLongAppItem(uAppInfo.data.app.appkey);
        if (!selfAppInfo || (selfAppInfo.status && selfAppInfo.status != 0)) {
            return selfAppInfo;
        }
        // if (!appInfo) {
        //     return system.getResult(null, "通过token获取sign的密钥信息失败，请重新获取");
        // }
        // var signResult = await this.verifySign(pobj.action_body, appInfo.appSecret);
        // if (signResult.status != 0) {
        //     return system.getResultFail(system.signFail, signResult.msg);
        // }
        if (pobj.isUser && pobj.isUser == "yes") {
            var channelUserId = pobj.actionBody.channelUserId || "";
            if (!channelUserId && pobj.actionBody.channelUser) {
                channelUserId = pobj.actionBody.channelUser.channelUserId;
            }
            if (!channelUserId) {
                return system.getResult(null, "base verify channelUserId is not empty");
            }
            var userInfo = await this.opCacheUtilsSve.getUserItem(selfAppInfo, channelUserId, pobj.actionBody);
            if (!userInfo || (userInfo.status && userInfo.status != 0)) {
                return userInfo;
            }
            if (userInfo.data && userInfo.data.isEnabled && userInfo.data.isEnabled != 1) {
                return system.getResultFail(system.getUserInfoFail, "用户处于待审核等待启用状态");
            }
            req.user = userInfo.data;
            pobj.actionBody.channelUserId = channelUserId;
        }
        req.app = selfAppInfo.data;
        req.uApp = uAppInfo.data.app;
        return system.getResultSuccess();
    }
    async doexec(gname, methodname, pobj, query, req) {
        var requestid = this.getUUID();
        try {
            req.requestId = requestid;
            var rtn = await this[methodname](pobj, query, req);
            if (rtn && !rtn.requestId) {
                rtn.requestId = requestid;
            }
            this.oplogSve.createDb({
                requestId: requestid,
                op: req.classname + "/" + methodname,
                content: "参数：post:" + JSON.stringify(pobj) + "，query:" + JSON.stringify(query),
                resultInfo: JSON.stringify(rtn),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api服务调用",
            });
            return rtn;
        } catch (e) {
            console.log(e.stack, "api调用出现异常，请联系管理员..........");
            this.oplogSve.createDb({
                requestId: requestid,
                op: req.classname + "/" + methodname,
                content: "error:" + JSON.stringify(e.stack),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api服务调用异常——>gateway",
            });
            this.logCtl.error({
                requestId: requestid,
                op: pobj.classname + "/" + methodname,
                content: e.stack,
                clientIp: pobj.clientIp,
                agent: req.uagent,
                optitle: "api服务调用异常——>gateway",
            });
            var rtnerror = system.getResultFail(-200, "出现异常，error：");
            rtnerror.requestId = requestid;
            return rtnerror;
        }
    }
}
module.exports = APIBase;
