var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
const logCtl = system.getObject("service.common.oplogSve");
//商标查询操作
class UtilsNeedSve extends AppServiceBase {
  constructor() {
    super();
    this.execlient = system.getObject("util.execClient");
    this.channelApiUrl = settings.channelApiUrl();
    this.centerChannelUrl = settings.centerChannelUrl();
    this.appInfo = {
      pannong: { appkey: settings.pannongAppKey, secret: settings.pannongSecret }
    };
  }


  async getCenterToken() {
    var self = this;
    var reqTokenUrl = this.centerChannelUrl + "/api/opreceive/accessAuth/getAppTokenByAppKey";
    var reqParam = self.appInfo["pannong"];
    if (!reqParam.appkey || !reqParam.secret) {
      return system.getResult(null, "reqType类型有误，请求失败");
    }
    var param = {
      "actionType": "getAppTokenByAppKey",
      "actionBody": {
        "appkey": reqParam.appkey,
        "secret": reqParam.secret
      }
    };
    var rtn = await this.execlient.execPost(param, reqTokenUrl);
    if (!rtn.stdout) {
      return system.getResult(null, "获取token失败");
    }
    var tokenResult = JSON.parse(rtn.stdout);
    return tokenResult;
  }

  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }

  // 2020 1103 lin 新增 磐农2.1 创建服务单
  async submitService(pobj,heade) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return system.getResult(null, "submitService get token fail")
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    if (pobj.contactMobile) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          // 为什么2.1 有userId 但是不用 还要用mobile。因为模式不支持
          "channelUserId": pobj.contactMobile,
          "mobile": pobj.contactMobile,
          "userName": pobj.contactName ? pobj.contactName : pobj.contactMobile
        }
      };
      var url = settings.centerChannelUrl() + "/api/auth/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return system.getResult(null, "submitService get userpin fail")
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        return system.getResult(null, "submitService get userpin fail")
      }
    }

    // 2020 1104 lin 验签
    // 1.TODO:验证数据签名
    var sobj = {
      "actionType": "getAppInfoByAppKey",
      "actionBody": heade.appkey
    }
    url = settings.centerChannelUrl() + "/api/action/sign/springBoard";
    var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "getAppInfoByAppKey stdout fail")
    }
    var result = JSON.parse(rtn.stdout);
    if(!result || result.status!=0){
      return system.getResult(null, result.msg)
    }
    var appInfo = result.data;
		// 2.通过appsecret 验签
    pobj.sign = heade.sign;
    var verifyRes = await this.verifySign(pobj,appInfo.uapp_secret);
		if(!verifyRes || verifyRes.status!=0){
			return system.getResult(null, verifyRes.msg)
    }
      
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/service/springBoard";
    var sobj = {
      "actionType": "submitService",
      "actionBody": pobj
    }
    var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "submitService opreceive fail")
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return result;
    } else {
      return system.getResult(null, result.msg)
    }
  }

  /**
    * 验证签名
    * @param {*} params 要验证的参数 
    * @param {*} app_secret 应用的校验key
    */
  async verifySign(params, app_secret) {
    if (!params) {
      return system.getResult(null, "请求参数为空");
    }
    if (!params.sign) {
      return system.getResult(null, "请求参数sign为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResult(null, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey]) {
        let tmpKeyValue = params[tKey];
        if (tmpKeyValue instanceof Array || tmpKeyValue instanceof Object) {
          tmpKeyValue = JSON.stringify(tmpKeyValue);
        }
        signArr.push(tKey + "=" + tmpKeyValue);
      }
    }
    if (signArr.length == 0) {
      return system.getResult(null, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_secret;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    if (params.sign != resultTmpSign) {
      return system.getResult(null, "返回值签名验证失败");
    }
    return system.getResultSuccess();
  }

  // 2020 0926 lin 新增 阿里文网文 服务商侧提供接口2.2 关闭需求通知服务商
  async needCloseAliEsp(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    if (pobj.mobile) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.mobile,
          "mobile": pobj.mobile,
          "userName": pobj.userName ? pobj.userName : pobj.mobile
        }
      };
      var self = this;
      var url = settings.centerChannelUrl() + "/api/auth/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return {
        "requestId": result.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
  }

    // 2020 0927 lin 新增 阿里文网文 服务商侧提供接口2.3 服务单通知服务商
    async produceNoticeAliEsp(pobj) {
      var tokenInfo = await this.getCenterToken();
      if (tokenInfo.status != 0) {
        return {
          "requestId": this.getUUID(),
          "success": true,
          "errorMsg": "",
          "errorCode": "ok"
        };
      }
      var token = tokenInfo.data.token;
      var userpin = "";
      //带userpin请求
      var url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
      var sobj = {
        "actionType": pobj.action_type,
        "actionBody": pobj
      }
      var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
      if (!rtn || !rtn.stdout) {
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
      var result = JSON.parse(rtn.stdout);
      if (result.status == 0) {
        return {
          "requestId": result.requestId,
          "success": true,
          "errorMsg": "",
          "errorCode": "ok"
        };
      } else {
        return {
          "requestId": result.requestId,
          "success": false,
          "errorMsg": result.msg,
          "errorCode": "ok"
        };
      }
    }

  // 2020 0928 lin 新增 阿里文网文 服务商侧提供接口2.4 ⽤户⽅案反馈通知服务商
  async soulutionFeebackAliEsp(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    //带userpin请求
    var url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return {
        "requestId": result.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
  }
}
module.exports = UtilsNeedSve;
