const iz = require('iz')
const ErrorParamException = require('./exception/ErrorParamException');
const validators = require('iz/lib/validators');

iz.register(validators);
iz.register({
    required2: require('./required')
});

const Verify = function(){};

/**
 * 判断是否为 true
 */
Verify.isTrue = (bool,message)=>{
    if(!bool){
        throw new ErrorParamException(message);
    }
};

Verify.notNull = (data,message)=>{
    if(!iz(data).required2().valid){
        throw new ErrorParamException(message);
    }
};

Verify.notEmpty = (collections,message)=>{
    Verify.notNull(collections,message);
    if(iz(collections).empty().valid){
        throw new ErrorParamException(message);
    }
};

module.exports = {Verify,iz};