//工商注册
const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const regCfg = require("../../../api/impl/ic/regCfg");

class RegCenterOrderService extends AppServiceBase {
    constructor() {
        super();
        this.centerOrderUrl = settings.centerOrderUrl();
        this.execClient = system.getObject("util.execClient");
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
        this.opPushQueueUrl = settings.opPushQueueUrl();
        this.baiduclient = system.getObject("util.baiduClient");
        this.baiduRegClient = system.getObject("util.baiduRegClient");
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
        this.regDeliveryStatus = {
            701: 'RECEIVED',    //已接单
            702: 'COLLECTING',  //材料收集环节
            703: 'AUDITING',    //工商审核环节
            704: 'ENGRAVING',   //刻章环节
            705: 'SUCCESS',      //已完成 
            706: 'ACTIVE'         //服务中
          }
    };

    //调用center-order
    async reqCenterOrderApi(pobj, reqUrl) {
        var url = this.centerOrderUrl + "action/regapi/springBoard";
        if (reqUrl) {
            var url = this.centerOrderUrl + reqUrl;
        }
        var rtn = await this.execClient.execPost(pobj, url);
        var data = JSON.parse(rtn.stdout);
        return data;
    }


    //-----------接入百度reg-----start--------laolan---2020.12.17----------------------
    async getSolutionByChannelOrderNo(pobj, actionBody) {
        if (!actionBody.orderNo) {
            return system.getResult(null, "actionBody.orderNo can not be empty，100390");
        }
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var itemResult = await this.restPostUrl(pobj, reqUrl);
        return itemResult;
    }

    async regPaySuccess(pobj) {
        console.log('regPaySuccess++++pobj----', pobj)
        var sobj = {
            actionType: "getRegProducePrice",
            actionBody: {
                typeCode: pobj.actionBody.consultType,
                city: pobj.actionBody.area,
                taxpayerType: pobj.actionBody.taxpayerType,
                companyProperties: pobj.actionBody.companyProperties
            },
            appInfo: pobj.appInfo,
            actionProcess: pobj.actionProcess
        }
        console.log('regPaySuccess++++sobj----', sobj)
        var url = settings.centerAppUrl() + "action/opProduct/springBoard";
        var rtn = await this.execClient.execPost(sobj, url);
        if (!rtn || !rtn.stdout) {
            return system.getResultFail(-5010, "产品查询失败");
        }
        var data = JSON.parse(rtn.stdout);
        if (data.status != 0) {
            return system.getResultFail(-5010, "产品查询失败");
        }
        console.log('data----data----', data)
        // pobj.actionBody = data.data;
        // pobj.actionBody.orderNo = pobj.actionBody.bizId;
        pobj.actionBody.totalSum = data.data.price;
        pobj.actionBody.orderPrice = data.data.price;
        pobj.actionBody.payTotalSum = data.data.price;
        pobj.actionBody.payCode = data.data.payCode;
        pobj.actionBody.channelItemCode = data.data.channelItemCode;
        pobj.actionBody.channelNeedNo = data.data.channelNeedNo || data.data.bizId;
        pobj.actionBody.needNo = data.data.needNo;
        pobj.actionBody.quantity = 1;
        pobj.actionBody.channelOrder = {
            channelServiceNo: pobj.actionBody.orderNo,
            channelOrderNo: pobj.actionBody.orderNo,
            orderStatus: 2
        }
        console.log('pobj.actionBody------', pobj.actionBody)

        var orderrtn = await this.utilsOrderSve.addOrder(pobj, pobj.actionBody);
        console.log('orderrtn----', orderrtn)
        if (orderrtn.status != 0 && orderrtn.status != -1) {
            return system.getResultFail(-5012, "订单创建失败");
        }
        if (orderrtn.data) {
            pobj.actionBody.orderNo = orderrtn.data.orderNo;
        }
        pobj.actionBody.channelSolutionNo = pobj.actionBody.bizId;

        pobj.actionType = "regReceiveSolutionPayInfo";
        var url = settings.centerOrderUrl() + "action/regapi/springBoard";
        var solutionrtn = await this.execClient.execPost(pobj, url);
        if (!solutionrtn || !solutionrtn.stdout) {
            return system.getResultFail(-5011, "方案查询失败");
        }
        var solutiondata = JSON.parse(solutionrtn.stdout);
        console.log('solutiondata----', solutiondata)
        if (solutiondata.status != 0) {
            return system.getResultFail(-5011, "方案查询失败");
        }
        if (!solutiondata.data) {
            return system.getResultFail(-5012, "方案查询数据为空");
        }
        if (solutiondata.data && solutiondata.data.channelNeedNo) {
            pobj.actionBody.needId = solutiondata.data.channelNeedNo;
        }
        if (pobj.actionBody.channelItemCode) {
            pobj.actionBody.channelItemCode = regCfg.channelTypeCode[pobj.actionBody.channelItemCode];
        }
        var fqobj = {
            actionBody: {
                area: pobj.actionBody.province,
                idempotentSource: data.data.serviceBusinessCode,
                orderNo: pobj.actionBody.channelOrder.channelOrderNo,
                orderPrice: Number(pobj.actionBody.orderPrice / 100),
                phone: pobj.actionBody.publishMobile || pobj.actionBody.phone,//需求下方案获取方案中手机号
                needId: solutiondata.data.channelNeedNo,
                price_desc: pobj.actionBody.taxpayerType,
                additions_desc: pobj.actionBody.companyProperties,
                // companyName:solutiondata.data.solutionContent.CompanyName || ''
                //2021-1-21 laolan add new
                appName: pobj.appInfo.app_name || '',
                sku: data.data.service_code || ''
            },
            appInfo: pobj.appInfo
        }
        console.log('fqobj----', fqobj)
        var baiduPushRes = await this.utilsPushSve.business2Channel(fqobj, "pushOrderICPBusinessNew");
        var deliveryObj = {
            actionBody: {
                orderNo: orderrtn.data.orderNo,//pobj.actionBody.channelOrder.channelOrderNo,
                needsolution: solutiondata.data.solutionContent,
                channelNeedNo: solutiondata.data.channelNeedNo,
                channelSolutionNo: solutiondata.data.channelSolutionNo,
                skuCode: data.data.payCode,
                servicer: {
                    code: 'gsb',
                    name: '公司宝'
                }
            },
            appInfo: pobj.appInfo
        };
        if (pobj.actionBody.isDirectBuy && pobj.actionBody.isDirectBuy == 1) {//直接下单需执行添加订单业务员操作
            if (baiduPushRes && baiduPushRes.status == 0) {
                if (baiduPushRes.data && baiduPushRes.data.data) {
                    var resData = baiduPushRes.data.data;
                    var salesmanInfo = {
                        salesmanName: resData.orderList && resData.orderList.length > 0 ? resData.orderList[0].operatorName : "",
                        salesmanChannelId: resData.orderList && resData.orderList.length > 0 ? resData.orderList[0].operator : "",
                    };
                    var salesmanObj = {
                        appInfo: pobj.appInfo,
                        actionType: "addRegSalesmanInfo",//添加业务员信息
                        actionBody: { salesmanInfo: salesmanInfo, orderNo: orderrtn.data.orderNo }
                    };
                    var url = settings.centerOrderUrl() + "action/regapi/springBoard";
                    var addRes = await this.execClient.execPost(salesmanObj, url);
                    if (addRes && addRes.stdout) {
                        var salesmanRes = JSON.parse(addRes.stdout);
                        if (salesmanRes.status == 0) {
                            deliveryObj.actionBody.needsolution = salesmanRes.data;
                            await this.utilsPushSve.business2Channel(deliveryObj, "pushDeliveryOrder");
                        }
                    }

                }
            }
        } else {
            this.utilsPushSve.business2Channel(deliveryObj, "pushDeliveryOrder");
        }
        return system.getResultSuccess();
    }

    // channelNeedNo获取需求详情
    async selectNeedInfo(pobj) {
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var itemResult = await this.restPostUrl(pobj, reqUrl);
        return itemResult;
    }

    /**
     * 获取需求详情
     * @param {*} pobj
     * @param {*} actionBody bizId 渠道方案号
     */
    async getItemByChannelSolutionNo(pobj) {
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var itemResult = await this.restPostUrl(pobj, reqUrl);
        return itemResult;
    }

    /**
     * 提交需求
     * @param {*} pobj
     * @param {*} actionBody
     */
    async submitRegNeed(pobj, actionBody) {

        if (!actionBody.intentionBizId) {
            return system.getResult(null, "actionBody.intentionBizId can not be empty，100380");
        }
        var sobj = pobj;
        sobj.actionType = "getProductTypeInfo";
        var url = settings.centerAppUrl() + "action/opProduct/springBoard";
        var rtn = await this.execClient.execPost(sobj, url);
        if (!rtn || !rtn.stdout) {
            return system.getResultFail(-5015, "需求类型查询失败");
        }
        var data = JSON.parse(rtn.stdout);
        if (data.status != 0) {
            return system.getResultFail(-5016, "需求类型查询失败");
        }
        pobj.actionBody.service_product_id = data.data.service_product_id;
        pobj.actionBody.productId = data.data.service_product_id;
        pobj.actionBody.appName = pobj.appInfo.app_name;
        pobj.actionBody.type_code = data.data.type_code;
        pobj.actionBody.type_name = data.data.type_name;
        pobj.actionBody.channel_type_code = data.data.channel_type_code;
        pobj.actionBody.channel_type_name = data.data.channel_type_name;
        pobj.actionBody.idempotentId = pobj.actionBody.intentionBizId;
        pobj.actionBody.idempotentSourceName = pobj.appInfo.app_name;
        if (pobj.actionBody.channel_type_code) {
            pobj.actionBody.type = regCfg.channelTypeCode[pobj.actionBody.channel_type_code]
            pobj.actionBody.idempotentSource = "baidu_gsreg";
            if (pobj.actionBody.channel_type_code == 'QYJYTC1') {
                pobj.actionBody.idempotentSource = "baidu_qyjytc1";
            }
            if (pobj.actionBody.channel_type_code == 'QYJYTC2') {
                pobj.actionBody.idempotentSource = "baidu_qyjytc2";
            }
        }
        if (pobj.actionBody.description && pobj.actionBody.description.indexOf("备#") < 0) {
            pobj.actionBody.level = "A";
        } else {
            // var levelurl = "http://106.13.228.212:8000/recProbability";
            // var levelresult = await this.restPostUrl({ intentionBizId: pobj.actionBody.intentionBizId, type: pobj.actionBody.type, note: pobj.actionBody.description }, levelurl);
            // if (levelresult.status == 0) {
            //   pobj.actionBody.level = levelresult.data.level;
            //   pobj.actionBody.probability = levelresult.data.per;
            // } else {
            //   pobj.actionBody.level = "C"
            // }
            pobj.actionBody.level = "C"
        }

        if (pobj.actionBody.phone == "17319425791") {
            pobj.actionBody.level = "F";
        }

        pobj.actionType = "submitRegNeed";
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        if (result.status == 0) {
            pobj.actionBody.description = pobj.actionBody.description + "   成交概率：" + pobj.actionBody.level
            if (pobj.actionBody.probability) {
                pobj.actionBody.description = pobj.actionBody.description + "（" + pobj.actionBody.probability + "） "
            }
            pobj.actionBody.idempotentId = pobj.actionBody.intentionBizId;
            // pobj.actionBody.idempotentSource = pobj.actionBody.type;
            pobj.actionBody.customerName = pobj.actionBody.userName;
            this.utilsPushSve.business2Channel(pobj, "pushNeedICPBusinessNew");
        }
        return result;
    }

    //reg需求反馈 2.2
    async regFeedbackSubmit(pobj, reqUrl) {
        var url = this.centerOrderUrl + "action/regapi/springBoard";
        if (reqUrl) {
            var url = this.centerOrderUrl + reqUrl;
        }
        var self = this;
        pobj.actionType = "regFeedbackSubmit";
        if (pobj.actionBody && pobj.actionBody.intentionStatus) {
            pobj.intentionStatus = pobj.actionBody.intentionStatus;
        }
        var rtn = await this.execClient.execPost(pobj, url);

        if (pobj.intentionStatus) {
            // 如果需求当前字段为5（已关闭）则通知fq
            if (pobj.intentionStatus == 5) {
                self.utilsPushSve.business2Channel(pobj, "pushCloseICPNeed");
            }
        }
        var data = JSON.parse(rtn.stdout);
        return data;
    }

    //状态更新
    async regOrderStatus(pobj) {
        var actionBody = pobj.actionBody;
        var self = this;
        if (actionBody.isDirectBuy && actionBody.isDirectBuy == 1) {
            actionBody.bizId = actionBody.orderNo
        }
        if (!actionBody.bizId) {
            return system.getResult(null, "actionBody.bizId can not be empty，100495");
        }
        actionBody.BizId = actionBody.bizId;
        if (!actionBody.status) {
            return system.getResult(null, "actionBody.status can not be empty，100495");
        }
        pobj.actionType = "regOrderStatus";
        var url = settings.centerOrderUrl() + "action/regapi/springBoard";
        var rtn = await this.restPostUrl(pobj, url);
        console.log('公司宝--rtn---', rtn)
        if (actionBody.status == 2) {
            var deliveryObj = {
                actionBody: {
                    orderNo: rtn.data.orderNo,//pobj.actionBody.channelOrder.channelOrderNo,
                    needsolution: rtn.data.solutionContent,
                    channelNeedNo: rtn.data.channelNeedNo,
                    channelSolutionNo: rtn.data.channelSolutionNo,
                    servicer: {
                        code: 'gsb',
                        name: '公司宝'
                    }
                },
                appInfo: pobj.appInfo
            }
            this.utilsPushSve.business2Channel(deliveryObj, "pushDeliveryOrder");
        }
        if (rtn.status == 0 && actionBody.status != 1 && actionBody.status != 2 && rtn.data) {
            var tmpObj = {
                actionBody: {
                    orderNo: rtn.data.orderNo,
                    channelNeedNo: rtn.data.channelNeedNo,
                    needsolution: rtn.data.solutionContent
                },
                appInfo: pobj.appInfo
            }
            this.utilsPushSve.business2Channel(tmpObj, "pushDeliveryStatusNotify");
            pobj.actionBody.orderNo = rtn.data.orderNo;
            if (actionBody.status == 11) {
                var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
                if (orderrtn.status < 0) {
                    return system.getResultFail(-5022, "订单关闭失败");
                }
                tmpObj.actionBody.orderNo = rtn.data.channelSolutionNo;
                self.utilsPushSve.business2Channel(tmpObj, "pushOrderICPClose");
            }
        }//通知更新状态
        return rtn;
    }


    //关闭reg订单
    async regOrderClose(pobj) {
        // var actionBody = pobj.actionBody;
        var self = this;
        var url = settings.centerOrderUrl() + "action/regapi/springBoard";
        var rtn = await this.restPostUrl(pobj, url);
        if (rtn.status == 0 && rtn.data) {
            var channelOrderNo = pobj.actionBody.orderNo;
            // pobj.actionBody.orderNo = rtn.data.orderNo;
            // pobj.actionType="delOrder";
            // var orderrtn = await self.utilsOrderSve.delOrder(pobj, actionBody);
            // if (orderrtn.status < 0) {
            //   return system.getResultFail(-5022, "订单关闭失败");
            // }
            var tmpObj = {
                actionBody: {
                    orderNo: rtn.data.orderNo,
                    channelNeedNo: rtn.data.channelNeedNo,
                    needsolution: rtn.data.solutionContent
                },
                appInfo: pobj.appInfo
            }
            this.utilsPushSve.business2Channel(tmpObj, "pushDeliveryStatusNotify");
            // tmpObj.actionBody.orderNo = channelOrderNo;
            var tmpObj2 = {
                actionBody: {
                    orderNo: channelOrderNo,
                    channelNeedNo: rtn.data.channelNeedNo,
                    needsolution: rtn.data.solutionContent
                },
                appInfo: pobj.appInfo
            };
            self.utilsPushSve.business2Channel(tmpObj2, "pushOrderICPClose");
        }//通知更新状态
        return rtn;
    }

    //--------------3.
    //提交reg注册方案
    async regSubmitSolution(pobj) {
        console.log('reg ---  pobj -----', pobj)
        var s
        var subSnLength
        var res
        if (pobj.actionBody.solutionList) {
            subSnLength = pobj.actionBody.solutionList.length
            for (s = 0; s < subSnLength; s++) {
                if (!pobj.actionBody.solutionList[s].solutionContent.solution.channelSolutionNo) {
                    res = await this.reqCenterOrderApi(pobj, "action/regapi/springBoard");
                } else {
                    pobj.actionType = "updateSolution"
                    res = await this.reqCenterOrderApi(pobj, "action/regapi/springBoard");
                }
            }
        }
        if (res && res.status == 0 && res.data && res.data.needinfo && res.data.needsolutions) {
            console.log('reg ---  res -----', res)
            var needinfo = res.data.needinfo;//需求信息
            var needsolutions = res.data.needsolutions;//方案信息
            var self = this;
            var bizTypes;
            var solutionList = [];
            if (needinfo.uapp_id == regCfg.uappId.baidu) {
                //推送数据至baidu
                var i = 0;
                var needsolutionsLength = needsolutions.length;
                var channelSolutionNo;
                for (i = 0; i < needsolutionsLength; i++) {
                    bizTypes = needsolutions[i].solutionContent;
                    console.log('bizTypes-----', bizTypes)
                    console.log('bizTypes type-----', typeof (bizTypes))
                    if (typeof (bizTypes) == 'string') {
                        bizTypes = JSON.parse(bizTypes)
                    }
                    bizTypes.solution.area = regCfg.baiduAreaCode[bizTypes.solution.area]
                    bizTypes.solution.serviceArea = bizTypes.solution.area
                    bizTypes.solution.isWhether = true//是否刻章，必带刻章true
                    //根据前端传参channelSolutionNo判断是新建方案还是修改方案
                    if (pobj.actionBody.solutionList[i].solutionContent.solution.channelSolutionNo) {
                        channelSolutionNo = pobj.actionBody.solutionList[i].solutionContent.solution.channelSolutionNo
                        var list = {
                            bizId: channelSolutionNo,
                            gsbBizId: needsolutions[i].solutionNo,
                            bizType: bizTypes.solution.regType,
                            solutionContent: bizTypes.solution
                        }
                    } else {
                        var list = {
                            gsbBizId: needsolutions[i].solutionNo,
                            bizType: bizTypes.solution.regType,
                            solutionContent: bizTypes.solution
                        }
                    }
                    solutionList.push(list)
                }

                var pushObj = {
                    intentionBizId: needinfo.channelNeedNo,
                    solutionList: solutionList
                };
                console.log('pushObj---pushObj---', pushObj)
                var pushBaiduRegSolution = await this.pushBaiduRegSolution(pushObj, pobj.appInfo, self);
                console.log('pushBaiduRegSolution+++', pushBaiduRegSolution)
                if (pushBaiduRegSolution.status != 0) {
                    return system.getResultFail(-101, pushBaiduRegSolution.msg)
                }
            }
            this.logCtl.info({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "service/impl/common/regCenterOrderSve.js/submitSolution",
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(needinfo),
                optitle: "createSolution推送蜂擎获取的接口信息->aliBusiness2Delivery",
            });

            var reqParams = {
                actionBody: {
                    intentionBizId: needinfo.channelNeedNo,
                    status: "createSolution"
                },
                appInfo: pobj.appInfo
            }
            await this.utilsPushSve.business2Channel(reqParams, "updateChanceStatus");
        }
        return res;
    }

    //推送reg方案
    async pushBaiduRegSolution(pushObj, appInfo, self) {
        console.log('pushObj++baidu+++', pushObj)
        //推送方案信息
        var pushRes = await self.baiduRegClient.baiduReqbyget({
            path: "/v1/provider/demand?submitSolutions=",
            reqbody: pushObj
        });
        console.log("pushRes----", pushRes)
        if (pushRes && pushRes.status == 0 && pushRes.data && pushRes.data.data && pushRes.data.data.infos) {
            var reqObj2 = {
                actionType: "saveReginfo",
                appInfo: appInfo,
                actionBody: {
                    infos: pushRes.data.data.infos
                }
            };
            var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id,用户确认方案url
            console.log("保存渠道方案id,用户确认方案url aaaa++ ", a)
        }
        return pushRes.data;
    }

    //reg关闭需求
    async regNeedClose(pobj) {
        pobj.actionBody.intentionBizId = pobj.actionBody.channelNeedNo;
        pobj.actionType = "regNeedClose"
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        console.log('regNeedClose+++result', result)

        if (result && result.status == 0) {
            //推送交付系统
            var reqParams = {
                actionBody: {
                    intentionBizId: pobj.actionBody.channelNeedNo,
                    status: "closeNeed"
                },
                opType: "updateChanceStatus",
                appInfo: pobj.appInfo
            }
            this.utilsPushSve.business2Channel(reqParams, "updateChanceStatus");
            //日志记录
            this.logCtl.info({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "service/impl/common/regCenterOrderSve.js/regNeedClose",
                content: JSON.stringify(reqParams),
                resultInfo: "",
                optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
            });
            var pushObj = {
                intentionBizId: pobj.actionBody.channelNeedNo,
                note: pobj.actionBody.note
            }
            // 推送baidu
            var tmpResult = await this.baiduRegClient.baiduReqbyget({ path: "/v1/provider/demand?close=", reqbody: pushObj });
            //查看日志
            this.logCtl.info({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "service/impl/common/regCenterOrderSve.js/regNeedClose",
                content: JSON.stringify(pushObj),
                resultInfo: JSON.stringify(tmpResult),
                optitle: "推送baidu-reg关闭需求返回结果->closeNeed",
            });
            if (result.data && result.data.uapp_id == 44) {
                pobj.appInfo.uapp_id = 44
                if (pobj && pobj.actionBody && pobj.actionBody.note) {
                    pobj.actionBody['description'] = pobj.actionBody.note
                }
            }
            this.utilsPushSve.business2Channel(pobj, "pushCloseICPNeed");

        }
        return result;
    }


    //提交交付信息/修改订单状态
    async regUpdateOrderStatus(pobj) {
        var res = await this.reqCenterOrderApi(pobj, "action/regapi/springBoard");
        console.log('推送交付信息/修改订单状态res+++++', res)
        console.log('推送交付信息/修改订单状态++pobj+++', pobj)
        var deliverContent = {}
        var pushObj = {}
        if (res && res.status == 0 && res.data) {
            if (pobj.actionBody.deliverContent) {
                if (pobj.actionBody.deliverContent.companyInfo && pobj.actionBody.deliverContent.companyInfo.serviceArea) {
                    pobj.actionBody.deliverContent.companyInfo.serviceArea = regCfg.baiduAreaCode[pobj.actionBody.deliverContent.companyInfo.serviceArea]
                }
                deliverContent = {
                    applicationFormUrl: pobj.actionBody.deliverContent.applicationFormUrl || "",//公司注册申请登记表文件
                    registDocumentsUrl: pobj.actionBody.deliverContent.registDocumentsUrl || "",//注册文件
                    baseInfo: pobj.actionBody.deliverContent.baseInfo || {},//基本信息
                    companyInfo: pobj.actionBody.deliverContent.companyInfo || {}//公司信息
                }
            }
            if (res.data.uapp_id == regCfg.uappId.baidu) {
                //2021-5-18新增套餐公司注册与正常公司注册区分
                if (pobj.actionBody.consultType && pobj.actionBody.consultType == "GSREG") {
                    //推送正常公司注册数据至百度
                    pushObj = {
                        orderNo: res.data.bizId,
                        status: this.regDeliveryStatus[pobj.actionBody.status],
                        deliverContent: deliverContent,
                        consultType: pobj.actionBody.consultType
                    };
                }
                if (pobj.actionBody.consultType && pobj.actionBody.consultType == "QYJYTC1") {
                    //推送套餐1公司注册数据至百度
                    pushObj = {
                        orderNo: res.data.bizId,
                        status: res.data.deliveryContent[pobj.actionBody.productType].channelStatus,
                        deliverContent: deliverContent,
                        consultType: pobj.actionBody.consultType,    //需求类型： GSREG：正常原始公司注册； QYJYTC1：企业经营套餐1； QYJYTC2：企业经营套餐2；
                        productType: pobj.actionBody.productType    //套餐包含业的务类型： 不传为原始公司注册
                    };
                }
                if (pobj.actionBody.consultType && pobj.actionBody.consultType == "QYJYTC2") {
                    //推送套餐2公司注册数据至百度
                    //代理记账和地址服务需要单独的开始和结束时间
                    //地址服务:时间截止到天,  代理记账:时间截止到月,    时间字段都是秒
                    if (pobj.actionBody.productType == "DLJZ" || pobj.actionBody.productType == "DZFW") {
                        pushObj = {
                            orderNo: res.data.bizId,
                            status: res.data.deliveryContent[pobj.actionBody.productType].channelStatus,
                            deliverContent: deliverContent,
                            consultType: pobj.actionBody.consultType,    //需求类型： GSREG：正常原始公司注册； QYJYTC1：企业经营套餐1； QYJYTC2：企业经营套餐2；
                            productType: pobj.actionBody.productType,    //套餐包含业的务类型： 不传为原始公司注册
                            startTime: pobj.actionBody.startTime || null,        //开始时间
                            endTime: pobj.actionBody.endTime  || null            //结束时间
                        };
                    } else {
                        pushObj = {
                            orderNo: res.data.bizId,
                            status: res.data.deliveryContent[pobj.actionBody.productType].channelStatus,
                            deliverContent: deliverContent,
                            consultType: pobj.actionBody.consultType,    //需求类型： GSREG：正常原始公司注册； QYJYTC1：企业经营套餐1； QYJYTC2：企业经营套餐2；
                            productType: pobj.actionBody.productType    //套餐包含业的务类型： 不传为原始公司注册
                        };
                    }
                }
                var self = this;
                //推送交付信息/修改订单状态
                var baidu = await self.baiduRegClient.baiduReqbyget({ path: "/v1/provider/comreg", reqbody: pushObj });
                console.log('推送交付信息/修改订单状态baidu+++', baidu)
                console.log('推送交付信息/修改订单状态pushObj+++', pushObj)
                //todo 推送云服订单所有交付单状态为完成时订单状态为完成的判断
                // if(res.data.deliveryFlag && res.data.deliveryFlag2 && 200 == res.data.deliveryFlag == res.data.deliveryFlag2){
                //     await this.utilsPushSve.business2Channel("蜂擎参数", "更新订单完成状态的方法");
                // }
                return baidu.data
            }
            console.log('rsrsr++++------------++++', res)
        }
        return res
    }


    //reg回写沟通记录
    async regWriteCommunicationLog(pobj) {
        console.log('reg回写沟通记录---', pobj)
        var self = this;
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        console.log('reg回写沟通记录--result---', result)
        var pushObj = {}
        if (result && result.status == 0 && result.data) {
            pushObj = {
                intentionBizId: pobj.actionBody.intentionBizId,
                note: pobj.actionBody.note
            }
            if (result.data == regCfg.uappId.baidu) {
                var ress = await self.baiduRegClient.baiduReqbyget({
                    path: "/v1/provider/demand?addCommRecord=",
                    reqbody: pushObj
                });
                if (ress.data.status != 0) {
                    return system.getResultFail(ress.data.msg)
                }
                console.log("regWriteCommunicationLog---------", ress)
            }
        }

        //推送交付系统
        var reqParams = {
            actionBody: {
                intentionBizId: pobj.actionBody.intentionBizId,
                status: "followingUp"
            },
            opType: "updateChanceStatus",
            appInfo: pobj.appInfo
        }
        self.utilsPushSve.business2Channel(reqParams, "updateChanceStatus");
        var fqobj = {
            actionBody: {
                "bizId": pobj.actionBody.intentionBizId,
                "follow_date": (new Date()).toISOString(),
                "follow_content": pobj.actionBody.note
            },
            opType: "aliFollowup",
            appInfo: pobj.appInfo
        }
        self.utilsPushSve.business2Channel(fqobj, "aliFollowup");
        return result
    }

    //reg查询沟通记录
    async regQueryExpertCommunicationLogs(pobj) {
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        console.log('jilu+++result++++', result)
        if (result && result.status == 0 && result.data && result.data.uapp_id) {
            var pushObj = {};
            if (result.data.uapp_id == regCfg.uappId.baidu) {
                console.log("bbbbb++", pobj)
                pushObj = {
                    beginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
                    endTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
                    intentionBizId: pobj.actionBody.intentionBizId
                }
                var res = await this.baiduRegClient.baiduReqbyget({
                    path: "/v1/provider/demand?listCommRecords=", reqbody: pushObj
                });
                console.log('xxcc+++', res)
            }
        }

        if (res && res.data && res.data.infos) {
            res.data['Data'] = res.data.infos
        }
        return system.getResultSuccess(res);
    }


    //-----------接入百度reg------end----------------------------------

}

module.exports = RegCenterOrderService;