const system = require("../../../system");
var settings = require("../../../../config/settings");
class TmqueryService {
  constructor() {
    this.zcApiUrl = settings.reqZcApi();
    this.execClient = system.getObject("util.execClient");
  }
  async findTrademarkNameAccurate(queryobj, req) {//通过商标名来进行精准查询
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkNameAccurate";
    return await this.opReqResult(url, queryobj, req);
  }
  async findTrademarkNameIndex(queryobj, req) {//根据商标名称模糊查询,首次查询,
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkNameIndex";
    return await this.opReqResult(url, queryobj, req);
  }
  async findTrademarkName(queryobj, req) {//根据商标名称模糊查询
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkName";
    return await this.opReqResult(url, queryobj, req);
  }
  async findTrademarkzchAccurate(queryobj, req) {//通过商标号来进行精准查询
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkzchAccurate";
    return await this.opReqResult(url, queryobj, req);
  }
  async findTrademarkzcr(queryobj, req) {//通过注册人模糊查询
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkzcr";
    return await this.opReqResult(url, queryobj, req);
  }
  async imagequery(queryobj, req) {//图像检索
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/imagequery";
    return await this.opReqResult(url, queryobj, req);
  }
  async findImageSearch(queryobj, req) { //图像检索查询，
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findImageSearch";
    return await this.opReqResult(url, queryobj, req);
  }
  async tradeMarkDetail(queryobj, req) {//商标详情
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tradeMarkDetail";
    return await this.opReqResult(url, queryobj, req);
  }
  async sbzuixinsearch(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/sbzuixinsearch";
    return await this.opReqResult(url, queryobj, req);
  }
  async noticequeryTMZCSQ(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/noticequeryTMZCSQ";
    return await this.opReqResult(url, queryobj, req);
  }
  async noticequery(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/noticequery";
    return await this.opReqResult(url, queryobj, req);
  }
  async noticezcggsearch(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/noticezcggsearch";
    return await this.opReqResult(url, queryobj, req);
  }
  async noticesearch(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/noticesearch";
    return await this.opReqResult(url, queryobj, req);
  }
  async getCompanyInfoNoUser(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/getCompanyInfoNoUser";
    return await this.opReqResult(url, queryobj, req);
  }
  async getNclDetail(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/getNclDetail";
    return await this.opReqResult(url, queryobj, req);
  }
  async gettwoNcl(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/gettwoNcl";
    return await this.opReqResult(url, queryobj, req);
  }
  async nclFuwuSearch(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/nclFuwuSearch";
    return await this.opReqResult(url, queryobj, req);
  }

  //商标统计接口总量、有效、申请
  async tmstatistics(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tmstatistics";
    return await this.opReqResult(url, queryobj, req);
  }

  //商标统计接口公司总量
  async tmcompanystatistics(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tmcompanystatistics";
    return await this.opReqResult(url, queryobj, req);
  }

  //商标地区分布统计排名
  async tmaddrstatisticsrank(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tmaddrstatisticsrank";
    return await this.opReqResult(url, queryobj, req);
  }

  //商标企业分布统计排名
  async tmcompanystatisticsrank(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tmcompanystatisticsrank";
    return await this.opReqResult(url, queryobj, req);
  }

  //商标类别申请排名
  async tmnclstatisticsrank(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tmnclstatisticsrank";
    return await this.opReqResult(url, queryobj, req);
  }

  //商标申请及注册趋势
  async tmtrend(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tmtrend";
    return await this.opReqResult(url, queryobj, req);
  }

  //商标类别申请排名详情
  async tmnclrankdetail(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tmnclrankdetail";
    return await this.opReqResult(url, queryobj, req);
  }

  //商标企业分布统计详情
  async tmcompanyrank(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tmcompanyrank";
    return await this.opReqResult(url, queryobj, req);
  }

  //商标地区分布统计排名详情
  async tmaddressrankdetail(queryobj, req) {
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/tmaddressrankdetail";
    return await this.opReqResult(url, queryobj, req);
  }

  //通过商标名来进行精准查询,商标注册地域/大类分布
  async findTrademarkNameAccuratejuhe(queryobj,req){
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkNameAccuratejuhe";
    return await this.opReqResult(url, queryobj, req);
  }

  //根据商标名称模糊查询,商标注册地域/大类分布
  async findTrademarkNamejuhe(queryobj,req){
    var url = this.zcApiUrl + "api/trademark/tmqueryApi/findTrademarkNamejuhe";
    return await this.opReqResult(url, queryobj, req);
  }

  async tmreport(queryobj, pobj,req) {
    if (!queryobj.type) {
      return { code: -102, msg: "参数错误" }
    }
    if (!queryobj.receiverId) {
      return { code: -102, msg: "参数错误" }
    }
    if (queryobj.push_type == 1 && !queryobj.email) {
      return { code: -102, msg: "参数错误" }
    }
    if (queryobj.push_type == 2 && !queryobj.notifyUrl) {
      return { code: -102, msg: "参数错误" }
    }
    if(queryobj.type!=1){
      return { code: -101, msg: "功能开发中......" }
    }
    queryobj.wxuser_id = queryobj.receiverId;
    queryobj.appid =pobj.appInfo.id;
    var url = settings.igirlWeburl() + "web/toolCtl/createMonitoringReportH5p";
    return await this.opReqResult(url, queryobj, req);
  }

  //核名接口
  async checkName(queryobj,req){
    if(!queryobj.cityname){
        return system.getResult(-1,'cityname 不能为空！');
    }
    if(!queryobj.keyword){
      return system.getResult(-1,'keyword 不能为空！');
    }
    if(!queryobj.btname){
      return system.getResult(-1,'btname 不能为空！');
    }
    if(!queryobj.orgname){
      return system.getResult(-1,'orgname 不能为空！');
    }
    let data = {
      cityname:queryobj.cityname,
      keyword:queryobj.keyword,
      btname:queryobj.btname,
      orgname:queryobj.orgname,
      appkey:"5b29981785bd4272966b15ad8e8b9dd3"
    }
    let url = settings.icNameUrl() + 'openPlatform/ic/match'
    let result = await this.opReqResult(url, data, req);
    if (result.code!=200){
      return system.getResult(-1,result.message);
    }
    return system.getResult(result);
  }

  async opReqResult(reqUrl, queryobj, req) {
    var rtn = await this.execClient.execPushDataPost(queryobj, reqUrl, req.headers["token"] || null, req.headers["request-id"]);
    var data = JSON.parse(rtn.stdout);
    return data;
  }


  async test(pobj){
    let url = settings.centerOrderUrl() + 'notifyaction/internalCallsNotify/updateTmStatus';
    let result = await this.execClient.execPost(pobj.actionBody,url);
    return result;
  }

}
module.exports = TmqueryService;
