var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
/**
 * tm通知接口
 * 庄冰 2021.03.18
 */
class Order extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }

    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    getResultSuccess(requestId) {
        return {
        "status": 0,
        "msg": "success",
        "data":null,
        "requestId": requestId
        };
    }
    getResultFail(errmsg) {
        var self = this;
        return {
        "status":-1,
        "msg": errmsg,
        "requestId": self.getUUID(),
        "data":null,
        "bizmsg":"empty"
        };
    }

    
    //状态变更
    async notify(pobj,obj,req) {
        var self = this;
        if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
            return self.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.bizId) {
            return self.getResultFail("bizId不能为空");
        }
        if (!pobj.status) {
            return self.getResultFail("status不能为空");
        }
        pobj.action_type = "tmStatusNotify";
        var param = {
            requestId: req.requestId || self.getUUID(),
            requestUrl: pobj.appInfo.app_code+"/tm/status/notify",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "tmStatusNotify",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await self.gatewaypushlogSve.create(param);
        return self.getResultSuccess(param.requestId);
    }

}
module.exports = Order;