var WEBBase = require("../../web.base");
var system = require("../../../system");

class diagnosisNeedBus extends WEBBase {
  constructor () {
    super();
    this.unSve = system.getObject('service.utilsSve.utilsNdbSve')
  }

  async springBoard (pobj, qobj, req) {
    var result = await this.opActionProcess(pobj, pobj.actionType, req);
    return result;
  }

  async opActionProcess (pobj, action_type, req) {
    var opResult = null;
    switch (action_type) {
      case "test"://测试
        opResult = system.getResultSuccess(null, "测试成功");
        break;
      case "getDnList":// 获取人工列表
        pobj.actionBody.diagnosis_mode = 'rg'
        if (Object.keys(pobj.actionBody).length < 1) {
          return system.getResult(null, `参数不能为空`)
        }
        opResult = await this.unSve.getList(pobj);
        break;
      case 'getDnListPending': // 获取待处理列表
        pobj.actionBody.status = 'dcl';
        pobj.actionBody.diagnosis_mode = 'rg'
        opResult = await this.unSve.getList(pobj);
        break;
      case "getDnListAll":// 获取人工列表
        if (Object.keys(pobj.actionBody).length < 1) {
          return system.getResult(null, `参数不能为空`)
        }
        opResult = await this.unSve.getList(pobj);
        break;
      case 'getDnDetail': // 获取详情
        if (!pobj.actionBody.id) {
          return system.getResult(null, `id不能为空`)
        }
        opResult = await this.unSve.getDetail(pobj);
        break;
      case 'doDnEAV': //认证
        if (!pobj.actionBody.id) {
          return system.getResult(null, `id不能为空`)
        }
        if (!pobj.actionBody.diagnosisResult) {
          return system.getResult(null, `诊断结果不能为空`)
        }
        opResult = await this.unSve.doEAV(pobj);
        break;
      case 'getDnNeedList': //获取需求列表
        opResult = await this.unSve.getNeedList(pobj);
        break;
      case 'getDnNeedDetail': //获取需求详情
        if (!pobj.actionBody.needNo) {
          return system.getResult(null, `needNo不能为空`)
        }
        opResult = await this.unSve.getNeedDetail(pobj);
        break;
      case 'licenseCompare':
        opResult = await this.unSve.licenseCompare(pobj.actionBody);
        break
      case 'addDnCase':
        opResult = await this.unSve.addCase(pobj)
        break
      default:
        opResult = system.getResult(null, "actionType参数错误");
        break;
    }
    return opResult;
  }
}

module.exports = diagnosisNeedBus;