const CacheBase=require("../cache.base");
const system=require("../../system");
// const OpenplatformWxop =  require("../../wxop/impl/openplatformWxop");
/**
 * 飞书小程序--UserAccessTokenCache缓存--有效时间7100s
 */
class feishuUserAccessTokenCache extends CacheBase{
   constructor(){
     super();
     this.restClient = system.getObject("util.restClient");
     this.prefix="feishu_userAccessToken_9e28dcb1d637100d";
   }
    desc() {
        return "应用UI配置缓存";
    }
    prefix() {
        return "feishu_userAccessToken_9e28dcb1d637100d";
    }
   async get(openid){
      var key = this.prefix+"_"+openid;
      var result = await this.redisClient.get(key);
      var obj = null;
      if(result){
         obj = JSON.parse(result);
      }
      if(obj && obj.access_token){
         return obj;
      }
      return null;
   }
   async set(obj,openid){
      var expire = 7100;
      if(obj.expires_in){
         var time = obj.expires_in;
         var now = Date.parse(new Date())/1000;
         if(now<time){
            expire = time - now;
         }else{
            return null;
         }
      }
      var key = this.prefix+"_"+openid;
      if(obj && obj.access_token){
         var stringobj = JSON.stringify(obj);
         await this.redisClient.setWithEx(key,stringobj,expire);
         return obj;
      }
      return null;
   }
}
module.exports=feishuUserAccessTokenCache;