//工商注册
const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const regCfg = require("../../../api/impl/ic/regCfg");

class RegCenterOrderService extends AppServiceBase {
    constructor() {
        super();
        this.execClientNew = system.getObject("util.execClientNew");
        this.centerOrderUrl = settings.centerOrderUrl();
        this.execClient = system.getObject("util.execClient");
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
        this.opPushQueueUrl = settings.opPushQueueUrl();
        this.baiduclient = system.getObject("util.baiduClient");
        this.baiduRegClient = system.getObject("util.baiduRegClient");
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
        this.regDeliveryStatus = {
            701: 'RECEIVED',    //已接单
            702: 'COLLECTING',  //材料收集环节
            703: 'AUDITING',    //工商审核环节
            704: 'ENGRAVING',   //刻章环节
            705: 'SUCCESS',      //已完成 
            706: 'ACTIVE'         //服务中
        }
    };

    //调用center-order
    async reqCenterOrderApi(pobj, reqUrl) {
        var url = this.centerOrderUrl + "action/regapi/springBoard";
        if (reqUrl) {
            var url = this.centerOrderUrl + reqUrl;
        }
        var rtn = await this.execClient.execPost(pobj, url);
        var data = JSON.parse(rtn.stdout);
        return data;
    }


    //-----------接入百度reg-----start--------laolan---2020.12.17----------------------
    async getSolutionByChannelOrderNo(pobj, actionBody) {
        if (!actionBody.orderNo) {
            return system.getResult(null, "actionBody.orderNo can not be empty，100390");
        }
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var itemResult = await this.restPostUrl(pobj, reqUrl);
        return itemResult;
    }

    async regPaySuccess(pobj) {
        var sobj = {
            actionType: "getRegProducePrice",
            actionBody: {
                typeCode: pobj.actionBody.consultType,
                city: pobj.actionBody.area,
                taxpayerType: pobj.actionBody.taxpayerType,
                companyProperties: pobj.actionBody.companyProperties
            },
            appInfo: pobj.appInfo,
            actionProcess: pobj.actionProcess
        }
        var url = settings.centerAppUrl() + "action/opProduct/springBoard";
        var rtn = await this.execClient.execPost(sobj, url);
        if (!rtn || !rtn.stdout) {
            return system.getResultFail(-5010, "产品查询失败");
        }
        var data = JSON.parse(rtn.stdout);
        if (data.status != 0) {
            return system.getResultFail(-5010, "产品查询失败");
        }
        pobj.actionBody.totalSum = data.data.price;
        pobj.actionBody.orderPrice = data.data.price;
        pobj.actionBody.payTotalSum = data.data.price;
        pobj.actionBody.payCode = data.data.payCode;
        pobj.actionBody.productPriceId = data.data.productPriceId;
        pobj.actionBody.channelItemCode = data.data.channelItemCode;
        pobj.actionBody.channelNeedNo = data.data.channelNeedNo || data.data.bizId;
        pobj.actionBody.needNo = data.data.needNo;
        pobj.actionBody.quantity = 1;
        pobj.actionBody.channelOrder = {
            channelServiceNo: pobj.actionBody.orderNo,
            channelOrderNo: pobj.actionBody.orderNo,
            orderStatus: 2
        }
        var orderrtn = await this.utilsOrderSve.addOrder(pobj, pobj.actionBody);
        this.execClientNew.execLogs(`regOrderStatusRegPaySuccess`, pobj, "center-channel-regCenterOrderSve-regPaySuccess", orderrtn, null);
        if (orderrtn.status != 0 && orderrtn.status != -1) {
            return system.getResultFail(-5012, "订单创建失败");
        }
        if (orderrtn.data) {
            pobj.actionBody.orderNo = orderrtn.data.orderNo;
        }
        pobj.actionBody.channelSolutionNo = pobj.actionBody.bizId;

        pobj.actionType = "regReceiveSolutionPayInfo";
        var url = settings.centerOrderUrl() + "action/regapi/springBoard";
        var solutionrtn = await this.execClient.execPost(pobj, url);
        if (!solutionrtn || !solutionrtn.stdout) {
            return system.getResultFail(-5011, "方案查询失败");
        }
        var solutiondata = JSON.parse(solutionrtn.stdout);
        if (solutiondata.status != 0) {
            return system.getResultFail(-5011, "方案查询失败");
        }
        if (!solutiondata.data) {
            return system.getResultFail(-5012, "方案查询数据为空");
        }
        if (solutiondata.data && solutiondata.data.channelNeedNo) {
            pobj.actionBody.needId = solutiondata.data.channelNeedNo;
        }
        if (pobj.actionBody.channelItemCode) {
            pobj.actionBody.channelItemCode = regCfg.channelTypeCode[pobj.actionBody.channelItemCode];
        }
        var fqobj = {
            actionBody: {
                area: pobj.actionBody.province,
                idempotentSource: data.data.serviceBusinessCode,
                orderNo: pobj.actionBody.channelOrder.channelOrderNo,
                orderPrice: Number(pobj.actionBody.orderPrice / 100),
                phone: pobj.actionBody.publishMobile || pobj.actionBody.phone,//需求下方案获取方案中手机号
                needId: solutiondata.data.channelNeedNo,
                price_desc: pobj.actionBody.taxpayerType,
                additions_desc: pobj.actionBody.companyProperties,
                // companyName:solutiondata.data.solutionContent.CompanyName || ''
                //2021-1-21 laolan add new
                appName: pobj.appInfo.app_name || '',
                sku: data.data.service_code || ''
            },
            appInfo: pobj.appInfo
        }
        //往云服推送订单
        let yunfuRes = await this.utilsPushSve.business2Channel(fqobj, "pushOrderICPBusinessNew");

        var deliveryObj = {
            actionBody: {
                orderNo: orderrtn.data.orderNo,//pobj.actionBody.channelOrder.channelOrderNo,
                needsolution: solutiondata.data.solutionContent,
                channelNeedNo: solutiondata.data.channelNeedNo,
                channelSolutionNo: solutiondata.data.channelSolutionNo,
                skuCode: data.data.payCode,
                servicer: {
                    code: 'gsb',
                    name: '公司宝'
                }
            },
            appInfo: pobj.appInfo
        };
        //往资质宝推送订单
        if (pobj.actionBody.isDirectBuy && pobj.actionBody.isDirectBuy == 1) {//直接下单需执行添加订单业务员操作
            if (yunfuRes && yunfuRes.status == 0) {
                if (yunfuRes.data && yunfuRes.data.data) {
                    var resData = yunfuRes.data.data;
                    var salesmanInfo = {
                        salesmanName: resData.orderList && resData.orderList.length > 0 ? resData.orderList[0].operatorName : "",
                        salesmanChannelId: resData.orderList && resData.orderList.length > 0 ? resData.orderList[0].operator : "",
                    };
                    var salesmanObj = {
                        appInfo: pobj.appInfo,
                        actionType: "addRegSalesmanInfo",//添加业务员信息
                        actionBody: {salesmanInfo: salesmanInfo, orderNo: orderrtn.data.orderNo}
                    };
                    var url = settings.centerOrderUrl() + "action/regapi/springBoard";
                    var addRes = await this.execClient.execPost(salesmanObj, url);
                    if (addRes && addRes.stdout) {
                        var salesmanRes = JSON.parse(addRes.stdout);
                        if (salesmanRes.status == 0) {
                            deliveryObj.actionBody.needsolution = salesmanRes.data;
                            await this.utilsPushSve.business2Channel(deliveryObj, "pushDeliveryOrder");
                        }
                    }

                }
            }
        } else {
            this.utilsPushSve.business2Channel(deliveryObj, "pushDeliveryOrder");
        }
        return system.getResultSuccess();
    }

    // channelNeedNo获取需求详情
    async selectNeedInfo(pobj) {
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var itemResult = await this.restPostUrl(pobj, reqUrl);
        return itemResult;
    }

    /**
     * 获取需求详情
     * @param {*} pobj
     * @param {*} actionBody bizId 渠道方案号
     */
    async getItemByChannelSolutionNo(pobj) {
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var itemResult = await this.restPostUrl(pobj, reqUrl);
        return itemResult;
    }

    /**
     * 提交需求
     * @param {*} pobj
     * @param {*} actionBody
     */
    async submitRegNeed(pobj, actionBody) {

        if (!actionBody.intentionBizId) {
            return system.getResult(null, "actionBody.intentionBizId can not be empty，100380");
        }
        var sobj = pobj;
        sobj.actionType = "getProductTypeInfo";
        var url = settings.centerAppUrl() + "action/opProduct/springBoard";
        var rtn = await this.execClient.execPost(sobj, url);
        if (!rtn || !rtn.stdout) {
            return system.getResultFail(-5015, "需求类型查询失败");
        }
        var data = JSON.parse(rtn.stdout);
        if (data.status != 0) {
            return system.getResultFail(-5016, "需求类型查询失败");
        }
        pobj.actionBody.service_product_id = data.data.service_product_id;
        pobj.actionBody.productId = data.data.service_product_id;
        pobj.actionBody.appName = pobj.appInfo.app_name;
        pobj.actionBody.type_code = data.data.type_code;
        pobj.actionBody.type_name = data.data.type_name;
        pobj.actionBody.channel_type_code = data.data.channel_type_code;
        pobj.actionBody.channel_type_name = data.data.channel_type_name;
        pobj.actionBody.idempotentId = pobj.actionBody.intentionBizId;
        pobj.actionBody.idempotentSourceName = pobj.appInfo.app_name;
        if (pobj.actionBody.channel_type_code) {
            pobj.actionBody.type = regCfg.channelTypeCode[pobj.actionBody.channel_type_code]
            pobj.actionBody.idempotentSource = "baidu_gsreg";
            if (pobj.actionBody.channel_type_code == 'QYJYTC1') {
                pobj.actionBody.idempotentSource = "baidu_qyjytc1";
            }
            if (pobj.actionBody.channel_type_code == 'QYJYTC2') {
                pobj.actionBody.idempotentSource = "baidu_qyjytc2";
            }
            if (pobj.actionBody.channel_type_code == 'QYJYTC3') {
                pobj.actionBody.idempotentSource = "baidu_qyjytc3";
            }
            if (pobj.actionBody.channel_type_code == 'QYJYTC4') {
                pobj.actionBody.idempotentSource = "baidu_qyjytc4";
            }
            if (pobj.actionBody.channel_type_code == 'QYJYTC5') {
                pobj.actionBody.idempotentSource = "baidu_qyjytc5";
            }
        }
        if (pobj.actionBody.description && pobj.actionBody.description.indexOf("备#") < 0) {
            pobj.actionBody.level = "A";
        } else {
            // var levelurl = "http://106.13.228.212:8000/recProbability";
            // var levelresult = await this.restPostUrl({ intentionBizId: pobj.actionBody.intentionBizId, type: pobj.actionBody.type, note: pobj.actionBody.description }, levelurl);
            // if (levelresult.status == 0) {
            //   pobj.actionBody.level = levelresult.data.level;
            //   pobj.actionBody.probability = levelresult.data.per;
            // } else {
            //   pobj.actionBody.level = "C"
            // }
            pobj.actionBody.level = "C"
        }

        if (pobj.actionBody.phone == "17319425791") {
            pobj.actionBody.level = "F";
        }

        pobj.actionType = "submitRegNeed";
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        //往云服推送需求
        if (result.status == 0) {
            pobj.actionBody.description = pobj.actionBody.description + "   成交概率：" + pobj.actionBody.level
            if (pobj.actionBody.probability) {
                pobj.actionBody.description = pobj.actionBody.description + "（" + pobj.actionBody.probability + "） "
            }
            pobj.actionBody.idempotentId = pobj.actionBody.intentionBizId;
            // pobj.actionBody.idempotentSource = pobj.actionBody.type;
            pobj.actionBody.customerName = pobj.actionBody.userName;
            this.utilsPushSve.business2Channel(pobj, "pushNeedICPBusinessNew");
        }
        return result;
    }

    //reg需求反馈 2.2
    async regFeedbackSubmit(pobj, reqUrl) {
        var url = this.centerOrderUrl + "action/regapi/springBoard";
        if (reqUrl) {
            var url = this.centerOrderUrl + reqUrl;
        }
        var self = this;
        pobj.actionType = "regFeedbackSubmit";
        if (pobj.actionBody && pobj.actionBody.intentionStatus) {
            pobj.intentionStatus = pobj.actionBody.intentionStatus;
        }
        var rtn = await this.execClient.execPost(pobj, url);

        if (pobj.intentionStatus) {
            // 如果需求当前字段为5（已关闭）则通知fq
            if (pobj.intentionStatus == 5) {
                self.utilsPushSve.business2Channel(pobj, "pushCloseICPNeed");
            }
        }
        var data = JSON.parse(rtn.stdout);
        return data;
    }

    /***
     * 状态更新
     * @param pobj
     * @returns {Promise<{msg: *, data: *, status: *}|{msg: *, data, bizmsg: *|string, status: number}|any>}
     * status:
         1：用户已支付
         2：用户已上传(客户上传材料)
         3：为资料未确认(暂时不用做处理)
         4：用户已确认
         11：方案已关闭
     */
    async regOrderStatus(pobj) {
        var actionBody = pobj.actionBody;
        var self = this;
        if (actionBody.isDirectBuy && actionBody.isDirectBuy == 1) {
            actionBody.bizId = actionBody.orderNo
        }//直购
        if (!actionBody.bizId) {
            return system.getResult(null, "actionBody.bizId can not be empty，100495");
        }
        actionBody.BizId = actionBody.bizId;
        if (!actionBody.status) {
            return system.getResult(null, "actionBody.status can not be empty，100496");
        }
        pobj.actionType = "regOrderStatus";
        var url = settings.centerOrderUrl() + "action/regapi/springBoard";
        var rtn = await this.restPostUrl(pobj, url);
        this.execClientNew.execLogs(`regOrderStatusUpdate`, pobj, "center-channel-regCenterOrderSve-reqCenterOrder-regOrderStatus", rtn, null);
        if (actionBody.status == 2) {
            var deliveryObj = {
                actionBody: {
                    orderNo: rtn.data.orderNo,//pobj.actionBody.channelOrder.channelOrderNo,
                    needsolution: rtn.data.solutionContent,
                    channelNeedNo: rtn.data.channelNeedNo,
                    channelSolutionNo: rtn.data.channelSolutionNo,
                    servicer: {
                        code: 'gsb',
                        name: '公司宝'
                    }
                },
                appInfo: pobj.appInfo
            }
            this.utilsPushSve.business2Channel(deliveryObj, "pushDeliveryOrder");
        }//往资质宝推送
        if (rtn.status == 0 && actionBody.status != 1 && actionBody.status != 2 && rtn.data) {
            var tmpObj = {
                actionBody: {
                    orderNo: rtn.data.orderNo,
                    channelNeedNo: rtn.data.channelNeedNo,
                    needsolution: rtn.data.solutionContent
                },
                appInfo: pobj.appInfo
            }
            this.utilsPushSve.business2Channel(tmpObj, "pushDeliveryStatusNotify");
            pobj.actionBody.orderNo = rtn.data.orderNo;
            if (actionBody.status == 11) {
                var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
                if (orderrtn.status < 0) {
                    return system.getResultFail(-5022, "订单关闭失败");
                }
                tmpObj.actionBody.orderNo = rtn.data.channelSolutionNo;
                self.utilsPushSve.business2Channel(tmpObj, "pushOrderICPClose");
            }
        }//往资质宝推送更新状态
        return rtn;
    }


    //关闭reg订单
    async regOrderClose(pobj) {
        // var actionBody = pobj.actionBody;
        var self = this;
        var url = settings.centerOrderUrl() + "action/regapi/springBoard";
        var rtn = await this.restPostUrl(pobj, url);
        if (rtn.status == 0 && rtn.data) {
            var channelOrderNo = pobj.actionBody.orderNo;
            // pobj.actionBody.orderNo = rtn.data.orderNo;
            // pobj.actionType="delOrder";
            // var orderrtn = await self.utilsOrderSve.delOrder(pobj, actionBody);
            // if (orderrtn.status < 0) {
            //   return system.getResultFail(-5022, "订单关闭失败");
            // }
            var tmpObj = {
                actionBody: {
                    orderNo: rtn.data.orderNo,
                    channelNeedNo: rtn.data.channelNeedNo,
                    needsolution: rtn.data.solutionContent
                },
                appInfo: pobj.appInfo
            }
            this.utilsPushSve.business2Channel(tmpObj, "pushDeliveryStatusNotify");
            // tmpObj.actionBody.orderNo = channelOrderNo;
            var tmpObj2 = {
                actionBody: {
                    orderNo: channelOrderNo,
                    channelNeedNo: rtn.data.channelNeedNo,
                    needsolution: rtn.data.solutionContent
                },
                appInfo: pobj.appInfo
            };
            self.utilsPushSve.business2Channel(tmpObj2, "pushOrderICPClose");
        }//通知更新状态
        return rtn;
    }

    //--------------3.
    //提交reg注册方案
    async regSubmitSolution(pobj) {
        console.log('reg ---  pobj -----', pobj)
        var s
        var subSnLength
        var res
        if (pobj.actionBody.solutionList) {
            subSnLength = pobj.actionBody.solutionList.length
            for (s = 0; s < subSnLength; s++) {
                if (!pobj.actionBody.solutionList[s].solutionContent.solution.channelSolutionNo) {
                    res = await this.reqCenterOrderApi(pobj, "action/regapi/springBoard");
                } else {
                    pobj.actionType = "updateSolution"
                    res = await this.reqCenterOrderApi(pobj, "action/regapi/springBoard");
                }
            }
        }
        if (res && res.status == 0 && res.data && res.data.needinfo && res.data.needsolutions) {
            console.log('reg ---  res -----', res)
            var needinfo = res.data.needinfo;//需求信息
            var needsolutions = res.data.needsolutions;//方案信息
            var self = this;
            var bizTypes;
            var solutionList = [];
            if (needinfo.uapp_id == regCfg.uappId.baidu) {
                //推送数据至baidu
                var i = 0;
                var needsolutionsLength = needsolutions.length;
                var channelSolutionNo;
                for (i = 0; i < needsolutionsLength; i++) {
                    bizTypes = needsolutions[i].solutionContent;
                    console.log('bizTypes-----', bizTypes)
                    console.log('bizTypes type-----', typeof (bizTypes))
                    if (typeof (bizTypes) == 'string') {
                        bizTypes = JSON.parse(bizTypes)
                    }
                    bizTypes.solution.area = regCfg.baiduAreaCode[bizTypes.solution.area]
                    bizTypes.solution.serviceArea = bizTypes.solution.area
                    bizTypes.solution.isWhether = true//是否刻章，必带刻章true
                    //根据前端传参channelSolutionNo判断是新建方案还是修改方案
                    if (pobj.actionBody.solutionList[i].solutionContent.solution.channelSolutionNo) {
                        channelSolutionNo = pobj.actionBody.solutionList[i].solutionContent.solution.channelSolutionNo
                        var list = {
                            bizId: channelSolutionNo,
                            gsbBizId: needsolutions[i].solutionNo,
                            bizType: bizTypes.solution.regType,
                            solutionContent: bizTypes.solution
                        }
                    } else {
                        var list = {
                            gsbBizId: needsolutions[i].solutionNo,
                            bizType: bizTypes.solution.regType,
                            solutionContent: bizTypes.solution
                        }
                    }
                    solutionList.push(list)
                }

                var pushObj = {
                    intentionBizId: needinfo.channelNeedNo,
                    solutionList: solutionList
                };
                console.log('pushObj---pushObj---', pushObj)
                var pushBaiduRegSolution = await this.pushBaiduRegSolution(pushObj, pobj.appInfo, self);
                console.log('pushBaiduRegSolution+++', pushBaiduRegSolution)
                if (pushBaiduRegSolution.status != 0) {
                    return system.getResultFail(-101, pushBaiduRegSolution.msg)
                }
            }
            if (needinfo.uapp_id == regCfg.uappId.zhogxiaowei) {
                // 2021 1103 lin 等待推送方案地址。确定返回值是什么
                var result = await this.restPostUrl(res.data.needsolutions[0], 'http://zhongxiaowei.com/createSolutions');
                if (pushBaiduRegSolution.status != 0) {
                    return system.getResultFail(-101, pushBaiduRegSolution.msg)
                }
            }
            this.logCtl.info({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "service/impl/common/regCenterOrderSve.js/submitSolution",
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(needinfo),
                optitle: "createSolution推送蜂擎获取的接口信息->aliBusiness2Delivery",
            });

            var reqParams = {
                actionBody: {
                    intentionBizId: needinfo.channelNeedNo,
                    status: "createSolution"
                },
                appInfo: pobj.appInfo
            }
            await this.utilsPushSve.business2Channel(reqParams, "updateChanceStatus");
        }
        return res;
    }

    //推送reg方案
    async pushBaiduRegSolution(pushObj, appInfo, self) {
        console.log('pushObj++baidu+++', pushObj)
        //推送方案信息
        var pushRes = await self.baiduRegClient.baiduReqbyget({
            path: "/v1/provider/demand?submitSolutions=",
            reqbody: pushObj
        });
        console.log("pushRes----", pushRes)
        if (pushRes && pushRes.status == 0 && pushRes.data && pushRes.data.data && pushRes.data.data.infos) {
            var reqObj2 = {
                actionType: "saveReginfo",
                appInfo: appInfo,
                actionBody: {
                    infos: pushRes.data.data.infos
                }
            };
            var a = await self.reqCenterOrderApi(reqObj2);//保存渠道方案id,用户确认方案url
            console.log("保存渠道方案id,用户确认方案url aaaa++ ", a)
        }
        return pushRes.data;
    }

    //reg关闭需求
    async regNeedClose(pobj) {
        pobj.actionBody.intentionBizId = pobj.actionBody.channelNeedNo;
        pobj.actionType = "regNeedClose"
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        console.log('regNeedClose+++result', result)

        if (result && result.status == 0) {
            //推送交付系统
            var reqParams = {
                actionBody: {
                    intentionBizId: pobj.actionBody.channelNeedNo,
                    status: "closeNeed"
                },
                opType: "updateChanceStatus",
                appInfo: pobj.appInfo
            }
            this.utilsPushSve.business2Channel(reqParams, "updateChanceStatus");
            //日志记录
            this.logCtl.info({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "service/impl/common/regCenterOrderSve.js/regNeedClose",
                content: JSON.stringify(reqParams),
                resultInfo: "",
                optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
            });
            var pushObj = {
                intentionBizId: pobj.actionBody.channelNeedNo,
                note: pobj.actionBody.note
            }
            // 推送baidu
            var tmpResult = await this.baiduRegClient.baiduReqbyget({
                path: "/v1/provider/demand?close=",
                reqbody: pushObj
            });
            //查看日志
            this.logCtl.info({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                op: "service/impl/common/regCenterOrderSve.js/regNeedClose",
                content: JSON.stringify(pushObj),
                resultInfo: JSON.stringify(tmpResult),
                optitle: "推送baidu-reg关闭需求返回结果->closeNeed",
            });
            if (result.data && result.data.uapp_id == 44) {
                pobj.appInfo.uapp_id = 44
                if (pobj && pobj.actionBody && pobj.actionBody.note) {
                    pobj.actionBody['description'] = pobj.actionBody.note
                }
            }
            this.utilsPushSve.business2Channel(pobj, "pushCloseICPNeed");

        }
        return result;
    }

    /**
     * 百度工商注册新流程接口：供应商获取工商注册信息详情
     *
     * @param {*} pobj
     */
    async getGongshangMaterial(pobj) {
        let self = this;
        const deliveryId = pobj.actionBody.deliveryId
        const serviceId = pobj.actionBody.serviceId
        this.execClientNew.execLogs("getGongshangMaterial-开始:", pobj, "center-channel-getGongshangMaterial", null, null);
        console.log(`>>>>【百度工商注册新流程接口：供应商获取工商注册信息详情 ${deliveryId}】getGongshangMaterial方法开始`, JSON.stringify(pobj))
        let baiduParams = {path: `/v1/com/application-material/${serviceId}`}
        console.log(`>>>>【百度工商注册新流程接口：供应商获取工商注册信息详情 交付单id:${deliveryId}】getGongshangMaterial方法`)
        // 同步刻章信息给百度
        let baiduRes = await self.baiduRegClient.baiduReqbyGet1(baiduParams);
        console.log(`>>>>【百度工商注册新流程接口：供应商获取工商注册信息详情 交付单id:${deliveryId}】getGongshangMaterial方法,接口响应:`, JSON.stringify(baiduRes))
        this.execClientNew.execLogs("submitGongshangEngraving-baiduReqbyget:", pobj, "center-channel-getGongshangMaterial", baiduParams, baiduRes);
        return baiduRes;
    }

    /**
     * 百度工商注册新流程接口：刻章环节，供应商使用此接口同步刻章信息
     * 
     * @param {*} pobj 
     */
    async submitGongshangEngraving(pobj) {
        let self = this;
        const deliveryId = pobj.actionBody.deliveryId
        this.execClientNew.execLogs("submitGongshangEngraving-开始:", pobj, "center-channel-submitGongshangEngraving", null, null);
        console.log(`>>>>【百度工商注册新流程接口：刻章环节，供应商使用此接口同步刻章信息 ${deliveryId}】submitGongshangEngraving方法开始`, pobj)
        // 组装请求参数
        let pushObj = {
            who :{
                accountId: pobj.actionBody.who.accountId,
                serviceId: pobj.actionBody.who.serviceId,
            },
            content: pobj.actionBody.content? pobj.actionBody.content: "公章、财务章、合同章",
            status: pobj.actionBody.status,
            expressNum: pobj.actionBody.expressNum
        };
        let baiduParams = {path: "/v1/com/engraving", reqbody: pushObj}
        console.log(`>>>>【百度工商注册新流程接口：刻章环节，供应商使用此接口同步刻章信息 交付单id:${deliveryId}】submitGongshangEngraving方法,接口请求参数:`, pushObj)
        // 同步刻章信息给百度
        let baiduRes = await self.baiduRegClient.baiduReqbyget(baiduParams);
        console.log(`>>>>【百度工商注册新流程接口：刻章环节，供应商使用此接口同步刻章信息 交付单id:${deliveryId}】submitGongshangEngraving方法,接口响应:`, baiduRes)
        this.execClientNew.execLogs("submitGongshangEngraving-baiduReqbyget:", pobj, "center-channel-submitGongshangEngraving", baiduParams, baiduRes);
        return baiduRes;
    }

    /**
     * 百度工商注册新流程接口：公司注册完成后，供应商将营业执照回传百度云
     * 
     * @param {*} pobj 
     */
    async submitGongshangLicense(pobj) {
        let self = this;
        const deliveryId = pobj.actionBody.deliveryId
        console.log(`>>>>【百度工商注册新流程接口：公司注册完成后，供应商将营业执照回传百度云 ${deliveryId}】submitGongshangLicense方法开始`, pobj)
        this.execClientNew.execLogs("submitGongshangLicense-开始:", pobj, "center-channel-submitGongshangLicense", null, null);
        
        // 组装请求参数
        let pushObj = {
            who :{
                accountId: pobj.actionBody.who.accountId,
                serviceId: pobj.actionBody.who.serviceId,
            },
            licenseUrl: pobj.actionBody.licenseUrl
        };
        let baiduParams = {path: "/v1/com/license", reqbody: pushObj}
        console.log(`>>>>【百度工商注册新流程接口：公司注册完成后，供应商将营业执照回传百度云 交付单id:${deliveryId}】submitGongshangLicense方法,接口请求参数:`, pushObj)
        // 回传营业执照给百度
        let baiduRes = await self.baiduRegClient.baiduReqbyget(baiduParams);
        console.log(`>>>>【百度工商注册新流程接口：公司注册完成后，供应商将营业执照回传百度云 交付单id:${deliveryId}】submitGongshangLicense方法,接口响应:`, baiduRes)

        this.execClientNew.execLogs("submitGongshangLicense-baiduReqbyget:", pobj, "center-channel-submitGongshangLicense", baiduParams, baiduRes);
        return baiduRes;
    }

     /**
     * 百度工商注册新流程接口：将工商注册流程状态更新给百度
     * 
     * @param {*} pobj 
     */
      async updateGongshangRegStatus(pobj) {
         let self = this;
         const deliveryId = pobj.actionBody.deliveryId
        console.log(`>>>>【百度工商注册新流程接口：将工商注册流程状态更新给百度 ${deliveryId}】updateGongshangRegStatus方法开始`, JSON.stringify(pobj))

        this.execClientNew.execLogs("updateGongshangRegStatus-开始:", JSON.stringify(pobj), "center-channel-updateGongshangRegStatus", null, null);
        
        // 组装请求参数
        let pushObj = {
            who :{
                accountId: pobj.actionBody.who.accountId,
                serviceId: pobj.actionBody.who.serviceId,
            },
            status: pobj.actionBody.status,
            msg: null,
            detail: null
        };
        let baiduParams = {path: "/v1/com/status", reqbody: pushObj}
        console.log(`>>>>【百度工商注册新流程接口：将工商注册流程状态更新给百度 交付单id:${deliveryId}】updateGongshangRegStatus方法,接口请求参数:`, JSON.stringify(pushObj))
        // 同步工商注册流程最新状态给百度
        let baiduRes = await self.baiduRegClient.baiduReqbyput(baiduParams);
        console.log(`>>>>【百度工商注册新流程接口：将工商注册流程状态更新给百度 交付单id:${deliveryId}】updateGongshangRegStatus方法,接口响应:`, JSON.stringify(baiduRes))
        this.execClientNew.execLogs("updateGongshangRegStatus-baiduReqbyput:", pobj, "center-channel-updateGongshangRegStatus", baiduParams, baiduRes);
        return baiduRes;
    }

    /**
     * 供应商变更用户申请材料
     * @param {*} pobj 
     */
    async submitGongshangMaterial(pobj){
        let self = this;
        const deliveryId = pobj.actionBody.deliveryId
        console.log(`>>>>【百度工商注册新流程接口：供应商变更用户申请材料 ${deliveryId}】submitGongshangMaterial`, pobj)
        this.execClientNew.execLogs("submitGongshangMaterial-开始:", pobj, "center-channel-submitGongshangMaterial", null, null);

        // 移出com结构下的type、taxerType
        delete pobj.actionBody.deliverContent.com.type
        delete pobj.actionBody.deliverContent.com.taxerType

        // if(pobj.actionBody.deliverContent.com.addr){
        //     delete pobj.actionBody.deliverContent.com.addr.urls;
        // }

        // if(pobj.actionBody.deliverContent.shareholders){
        //     if(pobj.actionBody.deliverContent.shareholders.naturalPersons){
        //         for(let obj of pobj.actionBody.deliverContent.shareholders.naturalPersons){
        //             delete obj.idCardFrontPicUrl
        //             delete obj.idCardBackPicUrl
        //         }
        //     }
        //     if(pobj.actionBody.deliverContent.shareholders.legalPersons){
        //         for(let obj of pobj.actionBody.deliverContent.shareholders.legalPersons){
        //             delete obj.comLicensePicUrl
        //             delete obj.rptIdCardFrontPicUrl
        //             delete obj.rptIdCardBackPicUrl
        //         }
        //     }
        // }

        // if(pobj.actionBody.deliverContent.members){
        //     for(let obj of pobj.actionBody.deliverContent.members){
        //         delete obj.idCardBackPicUrl
        //         delete obj.idCardFrontPicUrl
        //     }
        // }

        // 移出addr结构
        if(pobj.actionBody.deliverContent.com.addr &&(pobj.actionBody.deliverContent.com.addr.type ==null||pobj.actionBody.deliverContent.com.addr.type == '') ){
            delete pobj.actionBody.deliverContent.com.addr;
        }

        // 移出members下的capital
        for(let member of pobj.actionBody.deliverContent.members){
            delete member.capital
        }

        // 组装请求参数
        let pushObj = {
            who: pobj.actionBody.deliverContent.who,  // 目标
            com: pobj.actionBody.deliverContent.com, // 公司基本信息
            receiver: pobj.actionBody.deliverContent.receiver, // 邮寄地址
            shareholders: pobj.actionBody.deliverContent.shareholders, // 股东信息
            members:pobj.actionBody.deliverContent.members // 主要人员信息
        };
        let baiduParams = {path: "/v1/com/application-material", reqbody: pushObj}
        console.log(`>>>>【百度工商注册新流程接口：供应商变更用户申请材料 交付单id:${deliveryId}】submitGongshangLicense方法,接口请求参数:`, pushObj)
        // 推送交付信息
        let baiduRes = await self.baiduRegClient.baiduReqbyput(baiduParams);
        console.log(`>>>>【百度工商注册新流程接口：供应商变更用户申请材料 交付单id:${deliveryId}】submitGongshangLicense方法,接口响应:`, baiduRes)

        this.execClientNew.execLogs("submitGongshangMaterial-baiduReqbyput:", pobj, "center-channel-submitGongshangMaterial", baiduParams, baiduRes);
        return baiduRes;
    }

    //提交交付信息/修改订单状态
    async regUpdateOrderStatus(pobj) {
        let self = this;
        let res = await this.reqCenterOrderApi(pobj, "action/regapi/springBoard");
        this.execClientNew.execLogs("regUpdateOrderStatus-reqCenterOrderApi:", pobj, "center-channel-regUpdateOrderStatus", res, null);
        let deliverContent = {}
        let pushObj = {}
        if (res && res.status == 0 && res.data) {
            if (pobj.actionBody.deliverContent) {
                if (pobj.actionBody.deliverContent.companyInfo && pobj.actionBody.deliverContent.companyInfo.serviceArea) {
                    pobj.actionBody.deliverContent.companyInfo.serviceArea = regCfg.baiduAreaCode[pobj.actionBody.deliverContent.companyInfo.serviceArea]
                }
                deliverContent = {
                    applicationFormUrl: pobj.actionBody.deliverContent.applicationFormUrl || "",//公司注册申请登记表文件
                    registDocumentsUrl: pobj.actionBody.deliverContent.registDocumentsUrl || "",//注册文件
                    baseInfo: pobj.actionBody.deliverContent.baseInfo || {},//基本信息
                    companyInfo: pobj.actionBody.deliverContent.companyInfo || {}//公司信息
                }
            }
            if (res.data.uapp_id == regCfg.uappId.baidu) {
                //2021-5-18新增套餐公司注册与正常公司注册区分
                if (pobj.actionBody.consultType && pobj.actionBody.consultType == "GSREG") {
                    // if(pobj.actionBody.deliverContent.comapnyInfo && pobj.actionBody.deliverContent.comapnyInfo.channelMaterials && pobj.actionBody.deliverContent.comapnyInfo.channelMaterials.who){
                    //     // 20220425 如果传过来的交付内容中包含who，说明是要调百度新工商注册流程接口
                    //     console.log('调用百度新工商注册流程接口更新材料信息')
                    //     pushObj = {
                    //         who: pobj.actionBody.deliverContent.companyInfo.channelMaterials.who,  // 目标
                    //         com: pobj.actionBody.deliverContent.companyInfo.channelMaterials.com, // 公司基本信息
                    //         receiver: pobj.actionBody.deliverContent.companyInfo.channelMaterials.receiver, // 邮寄地址
                    //         shareholders: pobj.actionBody.deliverContent.companyInfo.channelMaterials.shareholders, // 股东信息
                    //         members:pobj.actionBody.deliverContent.companyInfo.channelMaterials.members // 主要人员信息
                    //     }
    
                    //     let baiduParams = {path: "/v1/com/application-material", reqbody: pushObj}
                    //     //推送交付信息/修改订单状态
                    //     let baidu = await self.baiduRegClient.baiduReqbyput(baiduParams);
                    //     this.execClientNew.execLogs("regUpdateOrderStatus-baiduReqbyput:", baiduParams, "center-channel-regUpdateOrderStatus-application-material", baidu, null);
                    //     return baidu 
                    // }
    
                    //推送正常公司注册数据至百度
                    pushObj = {
                        orderNo: res.data.bizId,
                        status: this.regDeliveryStatus[pobj.actionBody.status],
                        deliverContent: deliverContent,
                        consultType: pobj.actionBody.consultType
                    };
                }
                if (pobj.actionBody.consultType && pobj.actionBody.consultType == "QYJYTC1") {
                    //推送套餐1公司注册数据至百度
                    pushObj = {
                        orderNo: res.data.bizId,
                        status: res.data.deliveryContent[pobj.actionBody.productType].channelStatus,
                        deliverContent: deliverContent,
                        consultType: pobj.actionBody.consultType,    //需求类型： GSREG：正常原始公司注册； QYJYTC1：企业经营套餐1； QYJYTC2：企业经营套餐2；
                        productType: pobj.actionBody.productType    //套餐包含业的务类型： 不传为原始公司注册
                    };
                }
                if (pobj.actionBody.consultType && (pobj.actionBody.consultType == "QYJYTC2" || pobj.actionBody.consultType == "QYJYTC3" || pobj.actionBody.consultType == "QYJYTC4" || pobj.actionBody.consultType == "QYJYTC5")) {
                    //推送套餐2公司注册数据至百度
                    //代理记账和地址服务需要单独的开始和结束时间
                    //地址服务:时间截止到天,  代理记账:时间截止到月,    时间字段都是秒
                    if (pobj.actionBody.productType == "DLJZ" || pobj.actionBody.productType == "DZFW") {
                        pushObj = {
                            orderNo: res.data.bizId,
                            status: res.data.deliveryContent[pobj.actionBody.productType].channelStatus,
                            deliverContent: deliverContent,
                            consultType: pobj.actionBody.consultType,    //需求类型： GSREG：正常原始公司注册； QYJYTC1：企业经营套餐1； QYJYTC2：企业经营套餐2；
                            productType: pobj.actionBody.productType,    //套餐包含业的务类型： 不传为原始公司注册
                            startTime: pobj.actionBody.startTime || null,        //开始时间
                            endTime: pobj.actionBody.endTime || null            //结束时间
                        };
                    } else {
                        pushObj = {
                            orderNo: res.data.bizId,
                            status: res.data.deliveryContent[pobj.actionBody.productType].channelStatus,
                            deliverContent: deliverContent,
                            consultType: pobj.actionBody.consultType,    //需求类型： GSREG：正常原始公司注册； QYJYTC1：企业经营套餐1； QYJYTC2：企业经营套餐2；
                            productType: pobj.actionBody.productType    //套餐包含业的务类型： 不传为原始公司注册
                        };
                    }
                }
                let baiduParams = {path: "/v1/provider/comreg", reqbody: pushObj}
                //推送交付信息/修改订单状态
                let baidu = await self.baiduRegClient.baiduReqbyget(baiduParams);
                this.execClientNew.execLogs("regUpdateOrderStatus-baiduReqbyget:", baiduParams, "center-channel-regUpdateOrderStatus", baidu, null);
                //todo 推送云服订单所有交付单状态为完成时订单状态为完成的判断
                // if(res.data.deliveryFlag && res.data.deliveryFlag2 && 200 == res.data.deliveryFlag == res.data.deliveryFlag2){
                //     await this.utilsPushSve.business2Channel("蜂擎参数", "更新订单完成状态的方法");
                // }
                return baidu.data
            }
        }
        return res
    }


    //reg回写沟通记录
    async regWriteCommunicationLog(pobj) {
        console.log('reg回写沟通记录---', pobj)
        var self = this;
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        console.log('reg回写沟通记录--result---', result)
        var pushObj = {}
        if (result && result.status == 0 && result.data) {
            pushObj = {
                intentionBizId: pobj.actionBody.intentionBizId,
                note: pobj.actionBody.note
            }
            if (result.data == regCfg.uappId.baidu) {
                var ress = await self.baiduRegClient.baiduReqbyget({
                    path: "/v1/provider/demand?addCommRecord=",
                    reqbody: pushObj
                });
                if (ress.data.status != 0) {
                    return system.getResultFail(-1, ress.data.msg)
                }
                console.log("regWriteCommunicationLog---------", ress)
            }
        }

        //推送交付系统
        var reqParams = {
            actionBody: {
                intentionBizId: pobj.actionBody.intentionBizId,
                status: "followingUp"
            },
            opType: "updateChanceStatus",
            appInfo: pobj.appInfo
        }
        self.utilsPushSve.business2Channel(reqParams, "updateChanceStatus");
        var fqobj = {
            actionBody: {
                "bizId": pobj.actionBody.intentionBizId,
                "follow_date": (new Date()).toISOString(),
                "follow_content": pobj.actionBody.note
            },
            opType: "aliFollowup",
            appInfo: pobj.appInfo
        }
        self.utilsPushSve.business2Channel(fqobj, "aliFollowup");
        return result
    }

    //reg查询沟通记录
    async regQueryExpertCommunicationLogs(pobj) {
        var reqUrl = this.centerOrderUrl + "action/regapi/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        console.log('jilu+++result++++', result)
        if (result && result.status == 0 && result.data && result.data.uapp_id) {
            var pushObj = {};
            if (result.data.uapp_id == regCfg.uappId.baidu) {
                console.log("bbbbb++", pobj)
                pushObj = {
                    beginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
                    endTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
                    intentionBizId: pobj.actionBody.intentionBizId
                }
                var res = await this.baiduRegClient.baiduReqbyget({
                    path: "/v1/provider/demand?listCommRecords=", reqbody: pushObj
                });
                console.log('xxcc+++', res)
            }
        }

        if (res && res.data && res.data.infos) {
            res.data['Data'] = res.data.infos
        }
        return system.getResultSuccess(res);
    }


    //-----------接入百度reg------end----------------------------------

}

module.exports = RegCenterOrderService;