const AppServiceBase = require("../../app.base");
var settings = require("../../../../config/settings");
const system = require("../../../system");

class UtilsAliyunInfoService extends AppServiceBase {
    constructor() {
        super();
    }

    async sendAliyunInfoByNeedId(pobj) {
        let verifyResult = await this.opAliyunRpcVerifyParam(pobj);
        if (verifyResult.status != 0) {
            return verifyResult;
        }
        let interface_params = verifyResult.data;
        let params = {
            action: interface_params.action,
            reqbody: pobj.reqbody,
            rpcParam: {}
        }
        if (interface_params.accessKeyId) {
            params.rpcParam.accessKeyId = interface_params.accessKeyId;
        }
        if (interface_params.accessKeySecret) {
            params.rpcParam.accessKeySecret = interface_params.accessKeySecret;
        }
        if (interface_params.endpoint) {
            params.rpcParam.endpoint = interface_params.endpoint;
        }
        if (interface_params.apiVersion) {
            params.rpcParam.apiVersion = interface_params.apiVersion;
        }
        let aliResult = await this.opAliyunRpcReq(pobj, params);
        return await this.disposePushResult(pobj, aliResult, "ali->sendAliyunInfoByNeedId->aliResult", this.pushlogFailType.FQ);
    }
}

module.exports = UtilsAliyunInfoService;
